// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplacecatalog

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/marketplacecatalog/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides the list of entities of a given type.
func (c *Client) ListEntities(ctx context.Context, params *ListEntitiesInput, optFns ...func(*Options)) (*ListEntitiesOutput, error) {
	if params == nil {
		params = &ListEntitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEntities", params, optFns, c.addOperationListEntitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEntitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEntitiesInput struct {

	// The catalog related to the request. Fixed value: AWSMarketplace
	//
	// This member is required.
	Catalog *string

	// The type of entities to retrieve. Valid values are: AmiProduct ,
	// ContainerProduct , DataProduct , SaaSProduct , ProcurementPolicy , Experience ,
	// Audience , BrandingSettings , Offer , Seller , ResaleAuthorization .
	//
	// This member is required.
	EntityType *string

	// A Union object containing filter shapes for all EntityType s. Each
	// EntityTypeFilter shape will have filters applicable for that EntityType that
	// can be used to search or filter entities.
	EntityTypeFilters types.EntityTypeFilters

	// A Union object containing Sort shapes for all EntityType s. Each EntityTypeSort
	// shape will have SortBy and SortOrder applicable for fields on that EntityType .
	// This can be used to sort the results of the filter query.
	EntityTypeSort types.EntityTypeSort

	// An array of filter objects. Each filter object contains two attributes,
	// filterName and filterValues .
	FilterList []types.Filter

	// Specifies the upper limit of the elements on a single page. If a value isn't
	// provided, the default value is 20.
	MaxResults *int32

	// The value of the next token, if it exists. Null if there are no more results.
	NextToken *string

	// Filters the returned set of entities based on their owner. The default is SELF .
	// To list entities shared with you through AWS Resource Access Manager (AWS RAM),
	// set to SHARED . Entities shared through the AWS Marketplace Catalog API
	// PutResourcePolicy operation can't be discovered through the SHARED parameter.
	OwnershipType types.OwnershipType

	// An object that contains two attributes, SortBy and SortOrder .
	Sort *types.Sort

	noSmithyDocumentSerde
}

type ListEntitiesOutput struct {

	// Array of EntitySummary objects.
	EntitySummaryList []types.EntitySummary

	// The value of the next token if it exists. Null if there is no more result.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEntitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEntities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEntities{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEntities"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListEntitiesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEntities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEntitiesAPIClient is a client that implements the ListEntities operation.
type ListEntitiesAPIClient interface {
	ListEntities(context.Context, *ListEntitiesInput, ...func(*Options)) (*ListEntitiesOutput, error)
}

var _ ListEntitiesAPIClient = (*Client)(nil)

// ListEntitiesPaginatorOptions is the paginator options for ListEntities
type ListEntitiesPaginatorOptions struct {
	// Specifies the upper limit of the elements on a single page. If a value isn't
	// provided, the default value is 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEntitiesPaginator is a paginator for ListEntities
type ListEntitiesPaginator struct {
	options   ListEntitiesPaginatorOptions
	client    ListEntitiesAPIClient
	params    *ListEntitiesInput
	nextToken *string
	firstPage bool
}

// NewListEntitiesPaginator returns a new ListEntitiesPaginator
func NewListEntitiesPaginator(client ListEntitiesAPIClient, params *ListEntitiesInput, optFns ...func(*ListEntitiesPaginatorOptions)) *ListEntitiesPaginator {
	if params == nil {
		params = &ListEntitiesInput{}
	}

	options := ListEntitiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEntitiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEntitiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEntities page.
func (p *ListEntitiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEntitiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListEntities(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListEntities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEntities",
	}
}
