// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/audio_config.proto

package dialogflow

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Audio encoding of the audio content sent in the conversational query request.
// Refer to the
// [Cloud Speech API
// documentation](https://cloud.google.com/speech-to-text/docs/basics) for more
// details.
type AudioEncoding int32

const (
	// Not specified.
	AudioEncoding_AUDIO_ENCODING_UNSPECIFIED AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioEncoding_AUDIO_ENCODING_LINEAR_16 AudioEncoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is lossless (therefore
	// recognition is not compromised) and requires only about half the
	// bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	AudioEncoding_AUDIO_ENCODING_FLAC AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	AudioEncoding_AUDIO_ENCODING_MULAW AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	AudioEncoding_AUDIO_ENCODING_AMR AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_AMR_WB AudioEncoding = 5
	// Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_OGG_OPUS AudioEncoding = 6
	// Although the use of lossy encodings is not recommended, if a very low
	// bitrate encoding is required, `OGG_OPUS` is highly preferred over
	// Speex encoding. The [Speex](https://speex.org/) encoding supported by
	// Dialogflow API has a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in
	// [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each block
	// starts with a byte containing the length of the block, in bytes, followed
	// by one or more frames of Speex data, padded to an integral number of
	// bytes (octets) as specified in RFC 5574. In other words, each RTP header
	// is replaced with a single byte containing the block length. Only Speex
	// wideband is supported. `sample_rate_hertz` must be 16000.
	AudioEncoding_AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE AudioEncoding = 7
)

var AudioEncoding_name = map[int32]string{
	0: "AUDIO_ENCODING_UNSPECIFIED",
	1: "AUDIO_ENCODING_LINEAR_16",
	2: "AUDIO_ENCODING_FLAC",
	3: "AUDIO_ENCODING_MULAW",
	4: "AUDIO_ENCODING_AMR",
	5: "AUDIO_ENCODING_AMR_WB",
	6: "AUDIO_ENCODING_OGG_OPUS",
	7: "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE",
}

var AudioEncoding_value = map[string]int32{
	"AUDIO_ENCODING_UNSPECIFIED":            0,
	"AUDIO_ENCODING_LINEAR_16":              1,
	"AUDIO_ENCODING_FLAC":                   2,
	"AUDIO_ENCODING_MULAW":                  3,
	"AUDIO_ENCODING_AMR":                    4,
	"AUDIO_ENCODING_AMR_WB":                 5,
	"AUDIO_ENCODING_OGG_OPUS":               6,
	"AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE": 7,
}

func (x AudioEncoding) String() string {
	return proto.EnumName(AudioEncoding_name, int32(x))
}

func (AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{0}
}

// Variant of the specified [Speech model][google.cloud.dialogflow.v2.InputAudioConfig.model] to use.
//
// See the [Cloud Speech
// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
// for which models have different variants. For example, the "phone_call" model
// has both a standard and an enhanced variant. When you use an enhanced model,
// you will generally receive higher quality results than for a standard model.
type SpeechModelVariant int32

const (
	// No model variant specified. In this case Dialogflow defaults to
	// USE_BEST_AVAILABLE.
	SpeechModelVariant_SPEECH_MODEL_VARIANT_UNSPECIFIED SpeechModelVariant = 0
	// Use the best available variant of the [Speech
	// model][InputAudioConfig.model] that the caller is eligible for.
	//
	// Please see the [Dialogflow
	// docs](https://cloud.google.com/dialogflow/docs/data-logging) for
	// how to make your project eligible for enhanced models.
	SpeechModelVariant_USE_BEST_AVAILABLE SpeechModelVariant = 1
	// Use standard model variant even if an enhanced model is available.  See the
	// [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// for details about enhanced models.
	SpeechModelVariant_USE_STANDARD SpeechModelVariant = 2
	// Use an enhanced model variant:
	//
	// * If an enhanced variant does not exist for the given
	//   [model][google.cloud.dialogflow.v2.InputAudioConfig.model] and request language, Dialogflow falls
	//   back to the standard variant.
	//
	//   The [Cloud Speech
	//   documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	//   describes which models have enhanced variants.
	//
	// * If the API caller isn't eligible for enhanced models, Dialogflow returns
	//   an error. Please see the [Dialogflow
	//   docs](https://cloud.google.com/dialogflow/docs/data-logging)
	//   for how to make your project eligible.
	SpeechModelVariant_USE_ENHANCED SpeechModelVariant = 3
)

var SpeechModelVariant_name = map[int32]string{
	0: "SPEECH_MODEL_VARIANT_UNSPECIFIED",
	1: "USE_BEST_AVAILABLE",
	2: "USE_STANDARD",
	3: "USE_ENHANCED",
}

var SpeechModelVariant_value = map[string]int32{
	"SPEECH_MODEL_VARIANT_UNSPECIFIED": 0,
	"USE_BEST_AVAILABLE":               1,
	"USE_STANDARD":                     2,
	"USE_ENHANCED":                     3,
}

func (x SpeechModelVariant) String() string {
	return proto.EnumName(SpeechModelVariant_name, int32(x))
}

func (SpeechModelVariant) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{1}
}

// Gender of the voice as described in
// [SSML voice element](https://www.w3.org/TR/speech-synthesis11/#edef_voice).
type SsmlVoiceGender int32

const (
	// An unspecified gender, which means that the client doesn't care which
	// gender the selected voice will have.
	SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED SsmlVoiceGender = 0
	// A male voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_MALE SsmlVoiceGender = 1
	// A female voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_FEMALE SsmlVoiceGender = 2
	// A gender-neutral voice.
	SsmlVoiceGender_SSML_VOICE_GENDER_NEUTRAL SsmlVoiceGender = 3
)

var SsmlVoiceGender_name = map[int32]string{
	0: "SSML_VOICE_GENDER_UNSPECIFIED",
	1: "SSML_VOICE_GENDER_MALE",
	2: "SSML_VOICE_GENDER_FEMALE",
	3: "SSML_VOICE_GENDER_NEUTRAL",
}

var SsmlVoiceGender_value = map[string]int32{
	"SSML_VOICE_GENDER_UNSPECIFIED": 0,
	"SSML_VOICE_GENDER_MALE":        1,
	"SSML_VOICE_GENDER_FEMALE":      2,
	"SSML_VOICE_GENDER_NEUTRAL":     3,
}

func (x SsmlVoiceGender) String() string {
	return proto.EnumName(SsmlVoiceGender_name, int32(x))
}

func (SsmlVoiceGender) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{2}
}

// Audio encoding of the output audio format in Text-To-Speech.
type OutputAudioEncoding int32

const (
	// Not specified.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED OutputAudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// Audio content returned as LINEAR16 also contains a WAV header.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_LINEAR_16 OutputAudioEncoding = 1
	// MP3 audio at 32kbps.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3 OutputAudioEncoding = 2
	// Opus encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android, and in browsers (at least
	// Chrome and Firefox). The quality of the encoding is considerably higher
	// than MP3 while using approximately the same bitrate.
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_OGG_OPUS OutputAudioEncoding = 3
)

var OutputAudioEncoding_name = map[int32]string{
	0: "OUTPUT_AUDIO_ENCODING_UNSPECIFIED",
	1: "OUTPUT_AUDIO_ENCODING_LINEAR_16",
	2: "OUTPUT_AUDIO_ENCODING_MP3",
	3: "OUTPUT_AUDIO_ENCODING_OGG_OPUS",
}

var OutputAudioEncoding_value = map[string]int32{
	"OUTPUT_AUDIO_ENCODING_UNSPECIFIED": 0,
	"OUTPUT_AUDIO_ENCODING_LINEAR_16":   1,
	"OUTPUT_AUDIO_ENCODING_MP3":         2,
	"OUTPUT_AUDIO_ENCODING_OGG_OPUS":    3,
}

func (x OutputAudioEncoding) String() string {
	return proto.EnumName(OutputAudioEncoding_name, int32(x))
}

func (OutputAudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{3}
}

// Hints for the speech recognizer to help with recognition in a specific
// conversation state.
type SpeechContext struct {
	// Optional. A list of strings containing words and phrases that the speech
	// recognizer should recognize with higher likelihood.
	//
	// This list can be used to:
	// * improve accuracy for words and phrases you expect the user to say,
	//   e.g. typical commands for your Dialogflow agent
	// * add additional words to the speech recognizer vocabulary
	// * ...
	//
	// See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/quotas) for usage
	// limits.
	Phrases []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	// Optional. Boost for this context compared to other contexts:
	// * If the boost is positive, Dialogflow will increase the probability that
	//   the phrases in this context are recognized over similar sounding phrases.
	// * If the boost is unspecified or non-positive, Dialogflow will not apply
	//   any boost.
	//
	// Dialogflow recommends that you use boosts in the range (0, 20] and that you
	// find a value that fits your use case with binary search.
	Boost                float32  `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{0}
}

func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (m *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(m, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

func (m *SpeechContext) GetBoost() float32 {
	if m != nil {
		return m.Boost
	}
	return 0
}

// Information for a word recognized by the speech recognizer.
type SpeechWordInfo struct {
	// The word this info is for.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// Time offset relative to the beginning of the audio that corresponds to the
	// start of the spoken word. This is an experimental feature and the accuracy
	// of the time offset can vary.
	StartOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Time offset relative to the beginning of the audio that corresponds to the
	// end of the spoken word. This is an experimental feature and the accuracy of
	// the time offset can vary.
	EndOffset *duration.Duration `protobuf:"bytes,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for this word. A higher number
	// indicates an estimated greater likelihood that the recognized word is
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// This field is not guaranteed to be fully stable over time for the same
	// audio input. Users should also not rely on it to always be provided.
	Confidence           float32  `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechWordInfo) Reset()         { *m = SpeechWordInfo{} }
func (m *SpeechWordInfo) String() string { return proto.CompactTextString(m) }
func (*SpeechWordInfo) ProtoMessage()    {}
func (*SpeechWordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{1}
}

func (m *SpeechWordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechWordInfo.Unmarshal(m, b)
}
func (m *SpeechWordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechWordInfo.Marshal(b, m, deterministic)
}
func (m *SpeechWordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechWordInfo.Merge(m, src)
}
func (m *SpeechWordInfo) XXX_Size() int {
	return xxx_messageInfo_SpeechWordInfo.Size(m)
}
func (m *SpeechWordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechWordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechWordInfo proto.InternalMessageInfo

func (m *SpeechWordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func (m *SpeechWordInfo) GetStartOffset() *duration.Duration {
	if m != nil {
		return m.StartOffset
	}
	return nil
}

func (m *SpeechWordInfo) GetEndOffset() *duration.Duration {
	if m != nil {
		return m.EndOffset
	}
	return nil
}

func (m *SpeechWordInfo) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Instructs the speech recognizer how to process the audio content.
type InputAudioConfig struct {
	// Required. Audio encoding of the audio content to process.
	AudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.dialogflow.v2.AudioEncoding" json:"audio_encoding,omitempty"`
	// Required. Sample rate (in Hertz) of the audio content sent in the query.
	// Refer to
	// [Cloud Speech API
	// documentation](https://cloud.google.com/speech-to-text/docs/basics) for
	// more details.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Required. The language of the supplied audio. Dialogflow does not do
	// translations. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// If `true`, Dialogflow returns [SpeechWordInfo][google.cloud.dialogflow.v2.SpeechWordInfo] in
	// [StreamingRecognitionResult][google.cloud.dialogflow.v2.StreamingRecognitionResult] with information about the recognized speech
	// words, e.g. start and end time offsets. If false or unspecified, Speech
	// doesn't return any word-level information.
	EnableWordInfo bool `protobuf:"varint,13,opt,name=enable_word_info,json=enableWordInfo,proto3" json:"enable_word_info,omitempty"`
	// A list of strings containing words and phrases that the speech
	// recognizer should recognize with higher likelihood.
	//
	// See [the Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
	// for more details.
	//
	// This field is deprecated. Please use [speech_contexts]() instead. If you
	// specify both [phrase_hints]() and [speech_contexts](), Dialogflow will
	// treat the [phrase_hints]() as a single additional [SpeechContext]().
	PhraseHints []string `protobuf:"bytes,4,rep,name=phrase_hints,json=phraseHints,proto3" json:"phrase_hints,omitempty"` // Deprecated: Do not use.
	// Context information to assist speech recognition.
	//
	// See [the Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
	// for more details.
	SpeechContexts []*SpeechContext `protobuf:"bytes,11,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// Which Speech model to select for the given request. Select the
	// model best suited to your domain to get best results. If a model is not
	// explicitly specified, then we auto-select a model based on the parameters
	// in the InputAudioConfig.
	// If enhanced speech model is enabled for the agent and an enhanced
	// version of the specified model for the language does not exist, then the
	// speech is recognized using the standard version of the specified model.
	// Refer to
	// [Cloud Speech API
	// documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
	// for more details.
	Model string `protobuf:"bytes,7,opt,name=model,proto3" json:"model,omitempty"`
	// Which variant of the [Speech model][google.cloud.dialogflow.v2.InputAudioConfig.model] to use.
	ModelVariant SpeechModelVariant `protobuf:"varint,10,opt,name=model_variant,json=modelVariant,proto3,enum=google.cloud.dialogflow.v2.SpeechModelVariant" json:"model_variant,omitempty"`
	// If `false` (default), recognition does not cease until the
	// client closes the stream.
	// If `true`, the recognizer will detect a single spoken utterance in input
	// audio. Recognition ceases when it detects the audio's voice has
	// stopped or paused. In this case, once a detected intent is received, the
	// client should close the stream and start a new request with a new stream as
	// needed.
	// Note: This setting is relevant only for streaming methods.
	// Note: When specified, InputAudioConfig.single_utterance takes precedence
	// over StreamingDetectIntentRequest.single_utterance.
	SingleUtterance      bool     `protobuf:"varint,8,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputAudioConfig) Reset()         { *m = InputAudioConfig{} }
func (m *InputAudioConfig) String() string { return proto.CompactTextString(m) }
func (*InputAudioConfig) ProtoMessage()    {}
func (*InputAudioConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{2}
}

func (m *InputAudioConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputAudioConfig.Unmarshal(m, b)
}
func (m *InputAudioConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputAudioConfig.Marshal(b, m, deterministic)
}
func (m *InputAudioConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputAudioConfig.Merge(m, src)
}
func (m *InputAudioConfig) XXX_Size() int {
	return xxx_messageInfo_InputAudioConfig.Size(m)
}
func (m *InputAudioConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputAudioConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputAudioConfig proto.InternalMessageInfo

func (m *InputAudioConfig) GetAudioEncoding() AudioEncoding {
	if m != nil {
		return m.AudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (m *InputAudioConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *InputAudioConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *InputAudioConfig) GetEnableWordInfo() bool {
	if m != nil {
		return m.EnableWordInfo
	}
	return false
}

// Deprecated: Do not use.
func (m *InputAudioConfig) GetPhraseHints() []string {
	if m != nil {
		return m.PhraseHints
	}
	return nil
}

func (m *InputAudioConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *InputAudioConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *InputAudioConfig) GetModelVariant() SpeechModelVariant {
	if m != nil {
		return m.ModelVariant
	}
	return SpeechModelVariant_SPEECH_MODEL_VARIANT_UNSPECIFIED
}

func (m *InputAudioConfig) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

// Description of which voice to use for speech synthesis.
type VoiceSelectionParams struct {
	// Optional. The name of the voice. If not set, the service will choose a
	// voice based on the other parameters such as language_code and
	// [ssml_gender][google.cloud.dialogflow.v2.VoiceSelectionParams.ssml_gender].
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The preferred gender of the voice. If not set, the service will
	// choose a voice based on the other parameters such as language_code and
	// [name][google.cloud.dialogflow.v2.VoiceSelectionParams.name]. Note that this is only a preference, not requirement. If a
	// voice of the appropriate gender is not available, the synthesizer should
	// substitute a voice with a different gender rather than failing the request.
	SsmlGender           SsmlVoiceGender `protobuf:"varint,2,opt,name=ssml_gender,json=ssmlGender,proto3,enum=google.cloud.dialogflow.v2.SsmlVoiceGender" json:"ssml_gender,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *VoiceSelectionParams) Reset()         { *m = VoiceSelectionParams{} }
func (m *VoiceSelectionParams) String() string { return proto.CompactTextString(m) }
func (*VoiceSelectionParams) ProtoMessage()    {}
func (*VoiceSelectionParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{3}
}

func (m *VoiceSelectionParams) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VoiceSelectionParams.Unmarshal(m, b)
}
func (m *VoiceSelectionParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VoiceSelectionParams.Marshal(b, m, deterministic)
}
func (m *VoiceSelectionParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VoiceSelectionParams.Merge(m, src)
}
func (m *VoiceSelectionParams) XXX_Size() int {
	return xxx_messageInfo_VoiceSelectionParams.Size(m)
}
func (m *VoiceSelectionParams) XXX_DiscardUnknown() {
	xxx_messageInfo_VoiceSelectionParams.DiscardUnknown(m)
}

var xxx_messageInfo_VoiceSelectionParams proto.InternalMessageInfo

func (m *VoiceSelectionParams) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VoiceSelectionParams) GetSsmlGender() SsmlVoiceGender {
	if m != nil {
		return m.SsmlGender
	}
	return SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
}

// Configuration of how speech should be synthesized.
type SynthesizeSpeechConfig struct {
	// Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is the normal
	// native speed supported by the specific voice. 2.0 is twice as fast, and
	// 0.5 is half as fast. If unset(0.0), defaults to the native 1.0 speed. Any
	// other values < 0.25 or > 4.0 will return an error.
	SpeakingRate float64 `protobuf:"fixed64,1,opt,name=speaking_rate,json=speakingRate,proto3" json:"speaking_rate,omitempty"`
	// Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means increase 20
	// semitones from the original pitch. -20 means decrease 20 semitones from the
	// original pitch.
	Pitch float64 `protobuf:"fixed64,2,opt,name=pitch,proto3" json:"pitch,omitempty"`
	// Optional. Volume gain (in dB) of the normal native volume supported by the
	// specific voice, in the range [-96.0, 16.0]. If unset, or set to a value of
	// 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
	// will play at approximately half the amplitude of the normal native signal
	// amplitude. A value of +6.0 (dB) will play at approximately twice the
	// amplitude of the normal native signal amplitude. We strongly recommend not
	// to exceed +10 (dB) as there's usually no effective increase in loudness for
	// any value greater than that.
	VolumeGainDb float64 `protobuf:"fixed64,3,opt,name=volume_gain_db,json=volumeGainDb,proto3" json:"volume_gain_db,omitempty"`
	// Optional. An identifier which selects 'audio effects' profiles that are
	// applied on (post synthesized) text to speech. Effects are applied on top of
	// each other in the order they are given.
	EffectsProfileId []string `protobuf:"bytes,5,rep,name=effects_profile_id,json=effectsProfileId,proto3" json:"effects_profile_id,omitempty"`
	// Optional. The desired voice of the synthesized audio.
	Voice                *VoiceSelectionParams `protobuf:"bytes,4,opt,name=voice,proto3" json:"voice,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SynthesizeSpeechConfig) Reset()         { *m = SynthesizeSpeechConfig{} }
func (m *SynthesizeSpeechConfig) String() string { return proto.CompactTextString(m) }
func (*SynthesizeSpeechConfig) ProtoMessage()    {}
func (*SynthesizeSpeechConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{4}
}

func (m *SynthesizeSpeechConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SynthesizeSpeechConfig.Unmarshal(m, b)
}
func (m *SynthesizeSpeechConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SynthesizeSpeechConfig.Marshal(b, m, deterministic)
}
func (m *SynthesizeSpeechConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SynthesizeSpeechConfig.Merge(m, src)
}
func (m *SynthesizeSpeechConfig) XXX_Size() int {
	return xxx_messageInfo_SynthesizeSpeechConfig.Size(m)
}
func (m *SynthesizeSpeechConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SynthesizeSpeechConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SynthesizeSpeechConfig proto.InternalMessageInfo

func (m *SynthesizeSpeechConfig) GetSpeakingRate() float64 {
	if m != nil {
		return m.SpeakingRate
	}
	return 0
}

func (m *SynthesizeSpeechConfig) GetPitch() float64 {
	if m != nil {
		return m.Pitch
	}
	return 0
}

func (m *SynthesizeSpeechConfig) GetVolumeGainDb() float64 {
	if m != nil {
		return m.VolumeGainDb
	}
	return 0
}

func (m *SynthesizeSpeechConfig) GetEffectsProfileId() []string {
	if m != nil {
		return m.EffectsProfileId
	}
	return nil
}

func (m *SynthesizeSpeechConfig) GetVoice() *VoiceSelectionParams {
	if m != nil {
		return m.Voice
	}
	return nil
}

// Instructs the speech synthesizer on how to generate the output audio content.
// If this audio config is supplied in a request, it overrides all existing
// text-to-speech settings applied to the agent.
type OutputAudioConfig struct {
	// Required. Audio encoding of the synthesized audio content.
	AudioEncoding OutputAudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.dialogflow.v2.OutputAudioEncoding" json:"audio_encoding,omitempty"`
	// The synthesis sample rate (in hertz) for this audio. If not
	// provided, then the synthesizer will use the default sample rate based on
	// the audio encoding. If this is different from the voice's natural sample
	// rate, then the synthesizer will honor this request by converting to the
	// desired sample rate (which might result in worse audio quality).
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Configuration of how speech should be synthesized.
	SynthesizeSpeechConfig *SynthesizeSpeechConfig `protobuf:"bytes,3,opt,name=synthesize_speech_config,json=synthesizeSpeechConfig,proto3" json:"synthesize_speech_config,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                `json:"-"`
	XXX_unrecognized       []byte                  `json:"-"`
	XXX_sizecache          int32                   `json:"-"`
}

func (m *OutputAudioConfig) Reset()         { *m = OutputAudioConfig{} }
func (m *OutputAudioConfig) String() string { return proto.CompactTextString(m) }
func (*OutputAudioConfig) ProtoMessage()    {}
func (*OutputAudioConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3ff9be2146363af6, []int{5}
}

func (m *OutputAudioConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputAudioConfig.Unmarshal(m, b)
}
func (m *OutputAudioConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputAudioConfig.Marshal(b, m, deterministic)
}
func (m *OutputAudioConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputAudioConfig.Merge(m, src)
}
func (m *OutputAudioConfig) XXX_Size() int {
	return xxx_messageInfo_OutputAudioConfig.Size(m)
}
func (m *OutputAudioConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputAudioConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputAudioConfig proto.InternalMessageInfo

func (m *OutputAudioConfig) GetAudioEncoding() OutputAudioEncoding {
	if m != nil {
		return m.AudioEncoding
	}
	return OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED
}

func (m *OutputAudioConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *OutputAudioConfig) GetSynthesizeSpeechConfig() *SynthesizeSpeechConfig {
	if m != nil {
		return m.SynthesizeSpeechConfig
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2.AudioEncoding", AudioEncoding_name, AudioEncoding_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2.SpeechModelVariant", SpeechModelVariant_name, SpeechModelVariant_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2.SsmlVoiceGender", SsmlVoiceGender_name, SsmlVoiceGender_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2.OutputAudioEncoding", OutputAudioEncoding_name, OutputAudioEncoding_value)
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.dialogflow.v2.SpeechContext")
	proto.RegisterType((*SpeechWordInfo)(nil), "google.cloud.dialogflow.v2.SpeechWordInfo")
	proto.RegisterType((*InputAudioConfig)(nil), "google.cloud.dialogflow.v2.InputAudioConfig")
	proto.RegisterType((*VoiceSelectionParams)(nil), "google.cloud.dialogflow.v2.VoiceSelectionParams")
	proto.RegisterType((*SynthesizeSpeechConfig)(nil), "google.cloud.dialogflow.v2.SynthesizeSpeechConfig")
	proto.RegisterType((*OutputAudioConfig)(nil), "google.cloud.dialogflow.v2.OutputAudioConfig")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/audio_config.proto", fileDescriptor_3ff9be2146363af6)
}

var fileDescriptor_3ff9be2146363af6 = []byte{
	// 1151 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdb, 0x6e, 0xdb, 0x46,
	0x13, 0xfe, 0x49, 0xd9, 0x49, 0x3c, 0x3a, 0x98, 0xd9, 0xe4, 0x77, 0x68, 0x37, 0x71, 0x14, 0x25,
	0x01, 0x14, 0xb7, 0x95, 0x5a, 0x05, 0x28, 0x0a, 0xb4, 0x40, 0x41, 0x89, 0xb4, 0x2c, 0x40, 0x27,
	0xac, 0x0e, 0xee, 0xe1, 0x62, 0xb1, 0x12, 0x97, 0x14, 0x51, 0x6a, 0x57, 0x20, 0x29, 0x25, 0xcd,
	0x23, 0x14, 0xe8, 0x33, 0x14, 0x28, 0x7a, 0xd5, 0x67, 0xe8, 0xc3, 0xf4, 0x0d, 0xda, 0xcb, 0x02,
	0xbd, 0x29, 0xb8, 0x94, 0x6c, 0x45, 0x56, 0x94, 0x8b, 0xde, 0xed, 0xcc, 0x37, 0x33, 0x3b, 0x3b,
	0xdf, 0x37, 0x20, 0xe1, 0x63, 0x57, 0x08, 0xd7, 0x67, 0xe5, 0xb1, 0x2f, 0xe6, 0x76, 0xd9, 0xf6,
	0xa8, 0x2f, 0x5c, 0xc7, 0x17, 0xaf, 0xca, 0x8b, 0x4a, 0x99, 0xce, 0x6d, 0x4f, 0x90, 0xb1, 0xe0,
	0x8e, 0xe7, 0x96, 0x66, 0x81, 0x88, 0x04, 0x3a, 0x49, 0xc2, 0x4b, 0x32, 0xbc, 0x74, 0x1d, 0x5e,
	0x5a, 0x54, 0x4e, 0x1e, 0x2f, 0x4b, 0xd1, 0x99, 0x57, 0x76, 0x3c, 0xe6, 0xdb, 0x64, 0xc4, 0x26,
	0x74, 0xe1, 0x89, 0x20, 0x49, 0x3e, 0x39, 0x5e, 0x0b, 0x08, 0x58, 0x28, 0xe6, 0xc1, 0x98, 0x2d,
	0xa1, 0xd3, 0x25, 0x24, 0xad, 0xd1, 0xdc, 0x29, 0xdb, 0xf3, 0x80, 0x46, 0x9e, 0xe0, 0x4b, 0xfc,
	0xe1, 0x5a, 0x2a, 0xe5, 0x5c, 0x44, 0x12, 0x0c, 0x13, 0xb4, 0xf0, 0x15, 0x64, 0x7b, 0x33, 0xc6,
	0xc6, 0x93, 0x9a, 0xe0, 0x11, 0x7b, 0x1d, 0x21, 0x1d, 0x6e, 0xcf, 0x26, 0x01, 0x0d, 0x59, 0xa8,
	0x2b, 0xf9, 0x54, 0xf1, 0x00, 0xaf, 0x4c, 0x74, 0x1f, 0xf6, 0x47, 0x42, 0x84, 0x91, 0xae, 0xe6,
	0x95, 0xa2, 0x8a, 0x13, 0xa3, 0xf0, 0xbb, 0x02, 0xb9, 0xa4, 0xc2, 0xa5, 0x08, 0xec, 0x06, 0x77,
	0x04, 0x42, 0xb0, 0xf7, 0x4a, 0x04, 0xb6, 0x9e, 0xca, 0x2b, 0xc5, 0x03, 0x2c, 0xcf, 0xe8, 0x4b,
	0xc8, 0x84, 0x11, 0x0d, 0x22, 0x22, 0x1c, 0x27, 0x64, 0x91, 0xae, 0xe4, 0x95, 0x62, 0xba, 0x72,
	0x5c, 0x5a, 0x0e, 0x65, 0xd5, 0x7c, 0xc9, 0x5c, 0x36, 0x8f, 0xd3, 0x32, 0xbc, 0x23, 0xa3, 0xd1,
	0xe7, 0x00, 0x8c, 0xdb, 0xab, 0x5c, 0xf5, 0x7d, 0xb9, 0x07, 0x8c, 0xdb, 0xcb, 0xcc, 0x53, 0x00,
	0xc9, 0x82, 0xcd, 0xf8, 0x98, 0xe9, 0x7b, 0xb2, 0xf3, 0x35, 0x4f, 0xe1, 0xaf, 0x14, 0x68, 0x0d,
	0x3e, 0x9b, 0x47, 0x46, 0xcc, 0x58, 0x4d, 0x12, 0x86, 0xba, 0x90, 0x4b, 0x08, 0x64, 0x7c, 0x2c,
	0x6c, 0x8f, 0xbb, 0xb2, 0xdd, 0x5c, 0xe5, 0x45, 0xe9, 0xdd, 0x1c, 0x96, 0x64, 0x01, 0x6b, 0x99,
	0x80, 0xb3, 0x74, 0xdd, 0x44, 0x67, 0x70, 0x37, 0xa4, 0xd3, 0x99, 0xcf, 0x48, 0x40, 0x23, 0x46,
	0x26, 0x2c, 0x88, 0xde, 0xc8, 0x77, 0xec, 0xe3, 0xc3, 0x04, 0xc0, 0x34, 0x62, 0x17, 0xb1, 0x1b,
	0x3d, 0x85, 0xac, 0x4f, 0xb9, 0x3b, 0xa7, 0x2e, 0x23, 0x63, 0x61, 0xb3, 0xe5, 0x1c, 0x33, 0x2b,
	0x67, 0x4d, 0xd8, 0x0c, 0x15, 0x41, 0x63, 0x9c, 0x8e, 0x7c, 0x46, 0xe2, 0xf1, 0x12, 0x8f, 0x3b,
	0x42, 0xcf, 0xe6, 0x95, 0xe2, 0x1d, 0x9c, 0x4b, 0xfc, 0x57, 0x6c, 0x3c, 0x87, 0x4c, 0xc2, 0x20,
	0x99, 0x78, 0x3c, 0x0a, 0xf5, 0xbd, 0x98, 0xd5, 0xaa, 0xaa, 0x2b, 0x38, 0x9d, 0xf8, 0x2f, 0x62,
	0x37, 0xc2, 0x70, 0x18, 0x4a, 0x1a, 0x63, 0xd5, 0xc6, 0x4a, 0x08, 0xf5, 0x74, 0x3e, 0x55, 0x4c,
	0xef, 0x7e, 0xf4, 0x5b, 0xda, 0xc1, 0xb9, 0x70, 0xdd, 0x94, 0x8a, 0x99, 0x0a, 0x9b, 0xf9, 0xfa,
	0x6d, 0xf9, 0x82, 0xc4, 0x40, 0x3d, 0xc8, 0xca, 0x03, 0x59, 0xd0, 0xc0, 0xa3, 0x3c, 0xd2, 0x41,
	0x0e, 0xb7, 0xf4, 0xfe, 0x7b, 0x5a, 0x71, 0xda, 0x30, 0xc9, 0xc2, 0x99, 0xe9, 0x9a, 0x85, 0x5e,
	0x80, 0x16, 0x7a, 0xdc, 0xf5, 0x19, 0x99, 0x47, 0x11, 0x0b, 0x68, 0xcc, 0xf6, 0x1d, 0x39, 0x8f,
	0xc3, 0xc4, 0x3f, 0x58, 0xb9, 0x0b, 0xaf, 0xe1, 0xfe, 0x50, 0x78, 0x63, 0xd6, 0x63, 0x3e, 0x1b,
	0xc7, 0x7a, 0xe9, 0xd2, 0x80, 0x4e, 0xc3, 0x58, 0xb6, 0x9c, 0x4e, 0x99, 0xe4, 0xfa, 0x00, 0xcb,
	0x33, 0x6a, 0x42, 0x3a, 0x0c, 0xa7, 0x3e, 0x71, 0x19, 0xb7, 0x59, 0x20, 0x19, 0xcb, 0x55, 0x3e,
	0xdc, 0xd9, 0x69, 0x38, 0xf5, 0x65, 0xf9, 0xba, 0x4c, 0xc1, 0x10, 0xe7, 0x27, 0xe7, 0xc2, 0x9f,
	0x0a, 0x1c, 0xf5, 0x7e, 0xe0, 0xd1, 0x84, 0x85, 0xde, 0x1b, 0x76, 0x35, 0xbb, 0x58, 0x72, 0x4f,
	0x21, 0x1b, 0xce, 0x18, 0xfd, 0xde, 0xe3, 0xae, 0x94, 0x88, 0xec, 0x42, 0xc1, 0x99, 0x95, 0x33,
	0x96, 0x47, 0x3c, 0xcf, 0x99, 0x17, 0x8d, 0x27, 0xb2, 0x0f, 0x05, 0x27, 0x06, 0x7a, 0x06, 0xb9,
	0x85, 0xf0, 0xe7, 0x53, 0x46, 0x5c, 0xea, 0x71, 0x62, 0x8f, 0xa4, 0x60, 0x14, 0x9c, 0x49, 0xbc,
	0x75, 0xea, 0x71, 0x73, 0x84, 0x3e, 0x02, 0xc4, 0x1c, 0x87, 0x8d, 0xa3, 0x90, 0xcc, 0x02, 0xe1,
	0x78, 0x3e, 0x23, 0x9e, 0xad, 0xef, 0xcb, 0x15, 0xd7, 0x96, 0x48, 0x37, 0x01, 0x1a, 0x36, 0x3a,
	0x87, 0xfd, 0x45, 0xfc, 0x08, 0xb9, 0x31, 0xe9, 0xca, 0x27, 0xbb, 0x5e, 0xbc, 0x6d, 0x98, 0x38,
	0x49, 0x2f, 0xfc, 0xa8, 0xc2, 0xdd, 0xce, 0x3c, 0xda, 0xd8, 0xaf, 0xef, 0xde, 0xb1, 0x5f, 0xe5,
	0x5d, 0xd7, 0xac, 0x95, 0x59, 0xad, 0x55, 0x35, 0xf5, 0x87, 0xa1, 0xfe, 0x97, 0x55, 0xf3, 0x41,
	0x0f, 0xaf, 0xf8, 0x20, 0xd7, 0xfa, 0x77, 0x3c, 0x57, 0x0e, 0x31, 0x5d, 0xa9, 0xec, 0xe4, 0x7a,
	0x2b, 0x97, 0xf8, 0x28, 0xdc, 0xea, 0x3f, 0xfb, 0x47, 0x81, 0xec, 0x5b, 0xfd, 0xa3, 0x53, 0x38,
	0x31, 0x06, 0x66, 0xa3, 0x43, 0xac, 0x76, 0xad, 0x63, 0x36, 0xda, 0x75, 0x32, 0x68, 0xf7, 0xba,
	0x56, 0xad, 0x71, 0xde, 0xb0, 0x4c, 0xed, 0x7f, 0xe8, 0x21, 0xe8, 0x1b, 0x78, 0xb3, 0xd1, 0xb6,
	0x0c, 0x4c, 0x3e, 0xfd, 0x4c, 0x53, 0xd0, 0x03, 0xb8, 0xb7, 0x81, 0x9e, 0x37, 0x8d, 0x9a, 0xa6,
	0x22, 0x1d, 0xee, 0x6f, 0x00, 0xad, 0x41, 0xd3, 0xb8, 0xd4, 0x52, 0xe8, 0x08, 0xd0, 0x06, 0x62,
	0xb4, 0xb0, 0xb6, 0x87, 0x8e, 0xe1, 0xff, 0x37, 0xfd, 0xe4, 0xb2, 0xaa, 0xed, 0xa3, 0x0f, 0xe0,
	0xc1, 0x06, 0xd4, 0xa9, 0xd7, 0x49, 0xa7, 0x3b, 0xe8, 0x69, 0xb7, 0xd0, 0x0b, 0x78, 0xbe, 0x01,
	0xf6, 0xba, 0x96, 0xf5, 0x35, 0xb9, 0x6c, 0xf4, 0x2f, 0xc8, 0x85, 0x65, 0x98, 0x16, 0x26, 0xd5,
	0x6f, 0xfa, 0x96, 0x76, 0xfb, 0x6c, 0x01, 0xe8, 0xe6, 0x16, 0xa3, 0x67, 0x90, 0x8f, 0x33, 0x6a,
	0x17, 0xa4, 0xd5, 0x31, 0xad, 0x26, 0x19, 0x1a, 0xb8, 0x61, 0xb4, 0xfb, 0x1b, 0x73, 0x38, 0x02,
	0x34, 0xe8, 0x59, 0xa4, 0x6a, 0xf5, 0xfa, 0xc4, 0x18, 0x1a, 0x8d, 0xa6, 0x51, 0x6d, 0x5a, 0x9a,
	0x82, 0x34, 0xc8, 0xc4, 0xfe, 0x5e, 0xdf, 0x68, 0x9b, 0x06, 0x36, 0x35, 0x75, 0xe5, 0xb1, 0xda,
	0x17, 0x46, 0xbb, 0x66, 0x99, 0x5a, 0xea, 0xec, 0x27, 0x05, 0x0e, 0x37, 0x96, 0x12, 0x3d, 0x81,
	0x47, 0xbd, 0x5e, 0xab, 0x49, 0x86, 0x9d, 0x46, 0xcd, 0x22, 0x75, 0xab, 0x1d, 0xf7, 0xf9, 0xf6,
	0x95, 0x27, 0x70, 0x74, 0x33, 0xa4, 0x65, 0xc8, 0x6b, 0x1f, 0x82, 0x7e, 0x13, 0x3b, 0xb7, 0x24,
	0xaa, 0xa2, 0x47, 0x70, 0x7c, 0x13, 0x6d, 0x5b, 0x83, 0x3e, 0x36, 0x9a, 0x5a, 0xea, 0xec, 0x57,
	0x05, 0xee, 0x6d, 0xd1, 0x32, 0x7a, 0x0e, 0x4f, 0x3a, 0x83, 0x7e, 0x77, 0xd0, 0x27, 0x3b, 0x25,
	0xf1, 0x14, 0x1e, 0x6f, 0x0f, 0x5b, 0x57, 0xc6, 0x23, 0x38, 0xde, 0x1e, 0xd4, 0xea, 0xbe, 0xd4,
	0x54, 0x54, 0x80, 0xd3, 0xed, 0xf0, 0x15, 0xb3, 0xa9, 0xea, 0xcf, 0x0a, 0x9c, 0x8e, 0xc5, 0x74,
	0x87, 0xfc, 0xab, 0xda, 0xda, 0x4e, 0x77, 0xe3, 0x8f, 0x70, 0x57, 0xf9, 0xd6, 0x5c, 0xc6, 0xbb,
	0x22, 0xfe, 0x5c, 0x95, 0x44, 0xe0, 0x96, 0x5d, 0xc6, 0xe5, 0x27, 0xba, 0x9c, 0x40, 0x74, 0xe6,
	0x85, 0xdb, 0xfe, 0x99, 0xbe, 0xb8, 0xb6, 0xfe, 0x56, 0x94, 0x5f, 0x54, 0xd5, 0x3c, 0xff, 0x4d,
	0x3d, 0xa9, 0x27, 0xe5, 0x6a, 0xf2, 0x7a, 0xf3, 0xfa, 0xfa, 0x61, 0x65, 0x74, 0x4b, 0x56, 0x7d,
	0xf9, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xc7, 0xfa, 0xbf, 0x1c, 0x88, 0x09, 0x00, 0x00,
}
