// Copyright 2016 The gRPC Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// A ServiceConfig is supplied when a service is deployed. It mostly contains
// parameters for how clients that connect to the service should behave (for
// example, the load balancing policy to use to pick between service replicas).
//
// The configuration options provided here act as overrides to automatically
// chosen option values. Service owners should be conservative in specifying
// options as the system is likely to choose better values for these options in
// the vast majority of cases. In other words, please specify a configuration
// option only if you really have to, and avoid copy-paste inclusion of configs.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.3.0
// source: grpc/service_config/service_config.proto

package grpc_service_config

import (
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	code "google.golang.org/genproto/googleapis/rpc/code"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Load balancing policy.
//
// Note that load_balancing_policy is deprecated in favor of
// load_balancing_config; the former will be used only if the latter
// is unset.
//
// If no LB policy is configured here, then the default is pick_first.
// If the policy name is set via the client API, that value overrides
// the value specified here.
//
// If the deprecated load_balancing_policy field is used, note that if the
// resolver returns at least one balancer address (as opposed to backend
// addresses), gRPC will use grpclb (see
// https://github.com/grpc/grpc/blob/master/doc/load-balancing.md),
// regardless of what policy is configured here.  However, if the resolver
// returns at least one backend address in addition to the balancer
// address(es), the client may fall back to the requested policy if it
// is unable to reach any of the grpclb load balancers.
type ServiceConfig_LoadBalancingPolicy int32

const (
	ServiceConfig_UNSPECIFIED ServiceConfig_LoadBalancingPolicy = 0
	ServiceConfig_ROUND_ROBIN ServiceConfig_LoadBalancingPolicy = 1
)

// Enum value maps for ServiceConfig_LoadBalancingPolicy.
var (
	ServiceConfig_LoadBalancingPolicy_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "ROUND_ROBIN",
	}
	ServiceConfig_LoadBalancingPolicy_value = map[string]int32{
		"UNSPECIFIED": 0,
		"ROUND_ROBIN": 1,
	}
)

func (x ServiceConfig_LoadBalancingPolicy) Enum() *ServiceConfig_LoadBalancingPolicy {
	p := new(ServiceConfig_LoadBalancingPolicy)
	*p = x
	return p
}

func (x ServiceConfig_LoadBalancingPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConfig_LoadBalancingPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_grpc_service_config_service_config_proto_enumTypes[0].Descriptor()
}

func (ServiceConfig_LoadBalancingPolicy) Type() protoreflect.EnumType {
	return &file_grpc_service_config_service_config_proto_enumTypes[0]
}

func (x ServiceConfig_LoadBalancingPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConfig_LoadBalancingPolicy.Descriptor instead.
func (ServiceConfig_LoadBalancingPolicy) EnumDescriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{11, 0}
}

// Configuration for a method.
type MethodConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name []*MethodConfig_Name `protobuf:"bytes,1,rep,name=name,proto3" json:"name,omitempty"`
	// Whether RPCs sent to this method should wait until the connection is
	// ready by default. If false, the RPC will abort immediately if there is
	// a transient failure connecting to the server. Otherwise, gRPC will
	// attempt to connect until the deadline is exceeded.
	//
	// The value specified via the gRPC client API will override the value
	// set here. However, note that setting the value in the client API will
	// also affect transient errors encountered during name resolution, which
	// cannot be caught by the value here, since the service config is
	// obtained by the gRPC client via name resolution.
	WaitForReady *wrappers.BoolValue `protobuf:"bytes,2,opt,name=wait_for_ready,json=waitForReady,proto3" json:"wait_for_ready,omitempty"`
	// The default timeout in seconds for RPCs sent to this method. This can be
	// overridden in code. If no reply is received in the specified amount of
	// time, the request is aborted and a DEADLINE_EXCEEDED error status
	// is returned to the caller.
	//
	// The actual deadline used will be the minimum of the value specified here
	// and the value set by the application via the gRPC client API.  If either
	// one is not set, then the other will be used.  If neither is set, then the
	// request has no deadline.
	Timeout *duration.Duration `protobuf:"bytes,3,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The maximum allowed payload size for an individual request or object in a
	// stream (client->server) in bytes. The size which is measured is the
	// serialized payload after per-message compression (but before stream
	// compression) in bytes. This applies both to streaming and non-streaming
	// requests.
	//
	// The actual value used is the minimum of the value specified here and the
	// value set by the application via the gRPC client API.  If either one is
	// not set, then the other will be used.  If neither is set, then the
	// built-in default is used.
	//
	// If a client attempts to send an object larger than this value, it will not
	// be sent and the client will see a ClientError.
	// Note that 0 is a valid value, meaning that the request message
	// must be empty.
	MaxRequestMessageBytes *wrappers.UInt32Value `protobuf:"bytes,4,opt,name=max_request_message_bytes,json=maxRequestMessageBytes,proto3" json:"max_request_message_bytes,omitempty"`
	// The maximum allowed payload size for an individual response or object in a
	// stream (server->client) in bytes. The size which is measured is the
	// serialized payload after per-message compression (but before stream
	// compression) in bytes. This applies both to streaming and non-streaming
	// requests.
	//
	// The actual value used is the minimum of the value specified here and the
	// value set by the application via the gRPC client API.  If either one is
	// not set, then the other will be used.  If neither is set, then the
	// built-in default is used.
	//
	// If a server attempts to send an object larger than this value, it will not
	// be sent, and a ServerError will be sent to the client instead.
	// Note that 0 is a valid value, meaning that the response message
	// must be empty.
	MaxResponseMessageBytes *wrappers.UInt32Value `protobuf:"bytes,5,opt,name=max_response_message_bytes,json=maxResponseMessageBytes,proto3" json:"max_response_message_bytes,omitempty"`
	// Only one of retry_policy or hedging_policy may be set. If neither is set,
	// RPCs will not be retried or hedged.
	//
	// Types that are assignable to RetryOrHedgingPolicy:
	//	*MethodConfig_RetryPolicy_
	//	*MethodConfig_HedgingPolicy_
	RetryOrHedgingPolicy isMethodConfig_RetryOrHedgingPolicy `protobuf_oneof:"retry_or_hedging_policy"`
}

func (x *MethodConfig) Reset() {
	*x = MethodConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MethodConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodConfig) ProtoMessage() {}

func (x *MethodConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodConfig.ProtoReflect.Descriptor instead.
func (*MethodConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{0}
}

func (x *MethodConfig) GetName() []*MethodConfig_Name {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *MethodConfig) GetWaitForReady() *wrappers.BoolValue {
	if x != nil {
		return x.WaitForReady
	}
	return nil
}

func (x *MethodConfig) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *MethodConfig) GetMaxRequestMessageBytes() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxRequestMessageBytes
	}
	return nil
}

func (x *MethodConfig) GetMaxResponseMessageBytes() *wrappers.UInt32Value {
	if x != nil {
		return x.MaxResponseMessageBytes
	}
	return nil
}

func (m *MethodConfig) GetRetryOrHedgingPolicy() isMethodConfig_RetryOrHedgingPolicy {
	if m != nil {
		return m.RetryOrHedgingPolicy
	}
	return nil
}

func (x *MethodConfig) GetRetryPolicy() *MethodConfig_RetryPolicy {
	if x, ok := x.GetRetryOrHedgingPolicy().(*MethodConfig_RetryPolicy_); ok {
		return x.RetryPolicy
	}
	return nil
}

func (x *MethodConfig) GetHedgingPolicy() *MethodConfig_HedgingPolicy {
	if x, ok := x.GetRetryOrHedgingPolicy().(*MethodConfig_HedgingPolicy_); ok {
		return x.HedgingPolicy
	}
	return nil
}

type isMethodConfig_RetryOrHedgingPolicy interface {
	isMethodConfig_RetryOrHedgingPolicy()
}

type MethodConfig_RetryPolicy_ struct {
	RetryPolicy *MethodConfig_RetryPolicy `protobuf:"bytes,6,opt,name=retry_policy,json=retryPolicy,proto3,oneof"`
}

type MethodConfig_HedgingPolicy_ struct {
	HedgingPolicy *MethodConfig_HedgingPolicy `protobuf:"bytes,7,opt,name=hedging_policy,json=hedgingPolicy,proto3,oneof"`
}

func (*MethodConfig_RetryPolicy_) isMethodConfig_RetryOrHedgingPolicy() {}

func (*MethodConfig_HedgingPolicy_) isMethodConfig_RetryOrHedgingPolicy() {}

// Configuration for pick_first LB policy.
type PickFirstConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PickFirstConfig) Reset() {
	*x = PickFirstConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PickFirstConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PickFirstConfig) ProtoMessage() {}

func (x *PickFirstConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PickFirstConfig.ProtoReflect.Descriptor instead.
func (*PickFirstConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{1}
}

// Configuration for round_robin LB policy.
type RoundRobinConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RoundRobinConfig) Reset() {
	*x = RoundRobinConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoundRobinConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoundRobinConfig) ProtoMessage() {}

func (x *RoundRobinConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoundRobinConfig.ProtoReflect.Descriptor instead.
func (*RoundRobinConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{2}
}

// Configuration for priority LB policy.
type PriorityLoadBalancingPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Children map[string]*PriorityLoadBalancingPolicyConfig_Child `protobuf:"bytes,1,rep,name=children,proto3" json:"children,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A list of child names in decreasing priority order
	// (i.e., first element is the highest priority).
	Priorities []string `protobuf:"bytes,2,rep,name=priorities,proto3" json:"priorities,omitempty"`
}

func (x *PriorityLoadBalancingPolicyConfig) Reset() {
	*x = PriorityLoadBalancingPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriorityLoadBalancingPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriorityLoadBalancingPolicyConfig) ProtoMessage() {}

func (x *PriorityLoadBalancingPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriorityLoadBalancingPolicyConfig.ProtoReflect.Descriptor instead.
func (*PriorityLoadBalancingPolicyConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{3}
}

func (x *PriorityLoadBalancingPolicyConfig) GetChildren() map[string]*PriorityLoadBalancingPolicyConfig_Child {
	if x != nil {
		return x.Children
	}
	return nil
}

func (x *PriorityLoadBalancingPolicyConfig) GetPriorities() []string {
	if x != nil {
		return x.Priorities
	}
	return nil
}

// Configuration for weighted_target LB policy.
type WeightedTargetLoadBalancingPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Targets map[string]*WeightedTargetLoadBalancingPolicyConfig_Target `protobuf:"bytes,1,rep,name=targets,proto3" json:"targets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *WeightedTargetLoadBalancingPolicyConfig) Reset() {
	*x = WeightedTargetLoadBalancingPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WeightedTargetLoadBalancingPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeightedTargetLoadBalancingPolicyConfig) ProtoMessage() {}

func (x *WeightedTargetLoadBalancingPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeightedTargetLoadBalancingPolicyConfig.ProtoReflect.Descriptor instead.
func (*WeightedTargetLoadBalancingPolicyConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{4}
}

func (x *WeightedTargetLoadBalancingPolicyConfig) GetTargets() map[string]*WeightedTargetLoadBalancingPolicyConfig_Target {
	if x != nil {
		return x.Targets
	}
	return nil
}

// Configuration for grpclb LB policy.
type GrpcLbConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional.  What LB policy to use for routing between the backend
	// addresses.  If unset, defaults to round_robin.
	// Currently, the only supported values are round_robin and pick_first.
	// Note that this will be used both in balancer mode and in fallback mode.
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support.
	ChildPolicy []*LoadBalancingConfig `protobuf:"bytes,1,rep,name=child_policy,json=childPolicy,proto3" json:"child_policy,omitempty"`
	// Optional.  If specified, overrides the name of the service to be sent to
	// the balancer.
	ServiceName string `protobuf:"bytes,2,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
}

func (x *GrpcLbConfig) Reset() {
	*x = GrpcLbConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcLbConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcLbConfig) ProtoMessage() {}

func (x *GrpcLbConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcLbConfig.ProtoReflect.Descriptor instead.
func (*GrpcLbConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{5}
}

func (x *GrpcLbConfig) GetChildPolicy() []*LoadBalancingConfig {
	if x != nil {
		return x.ChildPolicy
	}
	return nil
}

func (x *GrpcLbConfig) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

// Configuration for the cds LB policy.
type CdsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"` // Required.
}

func (x *CdsConfig) Reset() {
	*x = CdsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CdsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CdsConfig) ProtoMessage() {}

func (x *CdsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CdsConfig.ProtoReflect.Descriptor instead.
func (*CdsConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{6}
}

func (x *CdsConfig) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

// Configuration for xds LB policy.
type XdsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of balancer to connect to.
	//
	// Deprecated: Do not use.
	BalancerName string `protobuf:"bytes,1,opt,name=balancer_name,json=balancerName,proto3" json:"balancer_name,omitempty"`
	// Optional.  What LB policy to use for intra-locality routing.
	// If unset, will use whatever algorithm is specified by the balancer.
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support.
	ChildPolicy []*LoadBalancingConfig `protobuf:"bytes,2,rep,name=child_policy,json=childPolicy,proto3" json:"child_policy,omitempty"`
	// Optional.  What LB policy to use in fallback mode.  If not
	// specified, defaults to round_robin.
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support.
	FallbackPolicy []*LoadBalancingConfig `protobuf:"bytes,3,rep,name=fallback_policy,json=fallbackPolicy,proto3" json:"fallback_policy,omitempty"`
	// Optional.  Name to use in EDS query.  If not present, defaults to
	// the server name from the target URI.
	EdsServiceName string `protobuf:"bytes,4,opt,name=eds_service_name,json=edsServiceName,proto3" json:"eds_service_name,omitempty"`
	// LRS server to send load reports to.
	// If not present, load reporting will be disabled.
	// If set to the empty string, load reporting will be sent to the same
	// server that we obtained CDS data from.
	LrsLoadReportingServerName *wrappers.StringValue `protobuf:"bytes,5,opt,name=lrs_load_reporting_server_name,json=lrsLoadReportingServerName,proto3" json:"lrs_load_reporting_server_name,omitempty"`
}

func (x *XdsConfig) Reset() {
	*x = XdsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *XdsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*XdsConfig) ProtoMessage() {}

func (x *XdsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use XdsConfig.ProtoReflect.Descriptor instead.
func (*XdsConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{7}
}

// Deprecated: Do not use.
func (x *XdsConfig) GetBalancerName() string {
	if x != nil {
		return x.BalancerName
	}
	return ""
}

func (x *XdsConfig) GetChildPolicy() []*LoadBalancingConfig {
	if x != nil {
		return x.ChildPolicy
	}
	return nil
}

func (x *XdsConfig) GetFallbackPolicy() []*LoadBalancingConfig {
	if x != nil {
		return x.FallbackPolicy
	}
	return nil
}

func (x *XdsConfig) GetEdsServiceName() string {
	if x != nil {
		return x.EdsServiceName
	}
	return ""
}

func (x *XdsConfig) GetLrsLoadReportingServerName() *wrappers.StringValue {
	if x != nil {
		return x.LrsLoadReportingServerName
	}
	return nil
}

// Configuration for eds LB policy.
type EdsLoadBalancingPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cluster name.  Required.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// EDS service name, as returned in CDS.
	// May be unset if not specified in CDS.
	EdsServiceName string `protobuf:"bytes,2,opt,name=eds_service_name,json=edsServiceName,proto3" json:"eds_service_name,omitempty"`
	// Server to send load reports to.
	// If unset, no load reporting is done.
	// If set to empty string, load reporting will be sent to the same
	// server as we are getting xds data from.
	LrsLoadReportingServerName *wrappers.StringValue `protobuf:"bytes,3,opt,name=lrs_load_reporting_server_name,json=lrsLoadReportingServerName,proto3" json:"lrs_load_reporting_server_name,omitempty"`
	// Locality-picking policy.
	// This policy's config is expected to be in the format used
	// by the weighted_target policy.  Note that the config should include
	// an empty value for the "targets" field; that empty value will be
	// replaced by one that is dynamically generated based on the EDS data.
	// Optional; defaults to "weighted_target".
	LocalityPickingPolicy []*LoadBalancingConfig `protobuf:"bytes,4,rep,name=locality_picking_policy,json=localityPickingPolicy,proto3" json:"locality_picking_policy,omitempty"`
	// Endpoint-picking policy.
	// This will be configured as the policy for each child in the
	// locality-policy's config.
	// Optional; defaults to "round_robin".
	EndpointPickingPolicy []*LoadBalancingConfig `protobuf:"bytes,5,rep,name=endpoint_picking_policy,json=endpointPickingPolicy,proto3" json:"endpoint_picking_policy,omitempty"`
}

func (x *EdsLoadBalancingPolicyConfig) Reset() {
	*x = EdsLoadBalancingPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EdsLoadBalancingPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EdsLoadBalancingPolicyConfig) ProtoMessage() {}

func (x *EdsLoadBalancingPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EdsLoadBalancingPolicyConfig.ProtoReflect.Descriptor instead.
func (*EdsLoadBalancingPolicyConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{8}
}

func (x *EdsLoadBalancingPolicyConfig) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *EdsLoadBalancingPolicyConfig) GetEdsServiceName() string {
	if x != nil {
		return x.EdsServiceName
	}
	return ""
}

func (x *EdsLoadBalancingPolicyConfig) GetLrsLoadReportingServerName() *wrappers.StringValue {
	if x != nil {
		return x.LrsLoadReportingServerName
	}
	return nil
}

func (x *EdsLoadBalancingPolicyConfig) GetLocalityPickingPolicy() []*LoadBalancingConfig {
	if x != nil {
		return x.LocalityPickingPolicy
	}
	return nil
}

func (x *EdsLoadBalancingPolicyConfig) GetEndpointPickingPolicy() []*LoadBalancingConfig {
	if x != nil {
		return x.EndpointPickingPolicy
	}
	return nil
}

// Configuration for lrs LB policy.
type LrsLoadBalancingPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cluster name.  Required.
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// EDS service name, as returned in CDS.
	// May be unset if not specified in CDS.
	EdsServiceName string `protobuf:"bytes,2,opt,name=eds_service_name,json=edsServiceName,proto3" json:"eds_service_name,omitempty"`
	// Server to send load reports to.  Required.
	// If set to empty string, load reporting will be sent to the same
	// server as we are getting xds data from.
	LrsLoadReportingServerName string                                 `protobuf:"bytes,3,opt,name=lrs_load_reporting_server_name,json=lrsLoadReportingServerName,proto3" json:"lrs_load_reporting_server_name,omitempty"`
	Locality                   *LrsLoadBalancingPolicyConfig_Locality `protobuf:"bytes,4,opt,name=locality,proto3" json:"locality,omitempty"`
	// Endpoint-picking policy.
	ChildPolicy []*LoadBalancingConfig `protobuf:"bytes,5,rep,name=child_policy,json=childPolicy,proto3" json:"child_policy,omitempty"`
}

func (x *LrsLoadBalancingPolicyConfig) Reset() {
	*x = LrsLoadBalancingPolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LrsLoadBalancingPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LrsLoadBalancingPolicyConfig) ProtoMessage() {}

func (x *LrsLoadBalancingPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LrsLoadBalancingPolicyConfig.ProtoReflect.Descriptor instead.
func (*LrsLoadBalancingPolicyConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{9}
}

func (x *LrsLoadBalancingPolicyConfig) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *LrsLoadBalancingPolicyConfig) GetEdsServiceName() string {
	if x != nil {
		return x.EdsServiceName
	}
	return ""
}

func (x *LrsLoadBalancingPolicyConfig) GetLrsLoadReportingServerName() string {
	if x != nil {
		return x.LrsLoadReportingServerName
	}
	return ""
}

func (x *LrsLoadBalancingPolicyConfig) GetLocality() *LrsLoadBalancingPolicyConfig_Locality {
	if x != nil {
		return x.Locality
	}
	return nil
}

func (x *LrsLoadBalancingPolicyConfig) GetChildPolicy() []*LoadBalancingConfig {
	if x != nil {
		return x.ChildPolicy
	}
	return nil
}

// Selects LB policy and provides corresponding configuration.
//
// In general, all instances of this field should be repeated. Clients will
// iterate through the list in order and stop at the first policy that they
// support.  This allows the service config to specify custom policies that may
// not be known to all clients.
//
// - If the config for the first supported policy is invalid, the whole service
//   config is invalid.
// - If the list doesn't contain any supported policy, the whole service config
//   is invalid.
type LoadBalancingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one LB policy may be configured.
	//
	// Types that are assignable to Policy:
	//	*LoadBalancingConfig_PickFirst
	//	*LoadBalancingConfig_RoundRobin
	//	*LoadBalancingConfig_Grpclb
	//	*LoadBalancingConfig_Priority
	//	*LoadBalancingConfig_WeightedTarget
	//	*LoadBalancingConfig_Cds
	//	*LoadBalancingConfig_Eds
	//	*LoadBalancingConfig_Lrs
	//	*LoadBalancingConfig_Xds
	//	*LoadBalancingConfig_XdsExperimental
	Policy isLoadBalancingConfig_Policy `protobuf_oneof:"policy"`
}

func (x *LoadBalancingConfig) Reset() {
	*x = LoadBalancingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancingConfig) ProtoMessage() {}

func (x *LoadBalancingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancingConfig.ProtoReflect.Descriptor instead.
func (*LoadBalancingConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{10}
}

func (m *LoadBalancingConfig) GetPolicy() isLoadBalancingConfig_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (x *LoadBalancingConfig) GetPickFirst() *PickFirstConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_PickFirst); ok {
		return x.PickFirst
	}
	return nil
}

func (x *LoadBalancingConfig) GetRoundRobin() *RoundRobinConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_RoundRobin); ok {
		return x.RoundRobin
	}
	return nil
}

func (x *LoadBalancingConfig) GetGrpclb() *GrpcLbConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_Grpclb); ok {
		return x.Grpclb
	}
	return nil
}

func (x *LoadBalancingConfig) GetPriority() *PriorityLoadBalancingPolicyConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_Priority); ok {
		return x.Priority
	}
	return nil
}

func (x *LoadBalancingConfig) GetWeightedTarget() *WeightedTargetLoadBalancingPolicyConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_WeightedTarget); ok {
		return x.WeightedTarget
	}
	return nil
}

func (x *LoadBalancingConfig) GetCds() *CdsConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_Cds); ok {
		return x.Cds
	}
	return nil
}

func (x *LoadBalancingConfig) GetEds() *EdsLoadBalancingPolicyConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_Eds); ok {
		return x.Eds
	}
	return nil
}

func (x *LoadBalancingConfig) GetLrs() *LrsLoadBalancingPolicyConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_Lrs); ok {
		return x.Lrs
	}
	return nil
}

// Deprecated: Do not use.
func (x *LoadBalancingConfig) GetXds() *XdsConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_Xds); ok {
		return x.Xds
	}
	return nil
}

// Deprecated: Do not use.
func (x *LoadBalancingConfig) GetXdsExperimental() *XdsConfig {
	if x, ok := x.GetPolicy().(*LoadBalancingConfig_XdsExperimental); ok {
		return x.XdsExperimental
	}
	return nil
}

type isLoadBalancingConfig_Policy interface {
	isLoadBalancingConfig_Policy()
}

type LoadBalancingConfig_PickFirst struct {
	PickFirst *PickFirstConfig `protobuf:"bytes,4,opt,name=pick_first,proto3,oneof"`
}

type LoadBalancingConfig_RoundRobin struct {
	RoundRobin *RoundRobinConfig `protobuf:"bytes,1,opt,name=round_robin,proto3,oneof"`
}

type LoadBalancingConfig_Grpclb struct {
	// gRPC lookaside load balancing.
	// This will eventually be deprecated by the new xDS-based local
	// balancing policy.
	Grpclb *GrpcLbConfig `protobuf:"bytes,3,opt,name=grpclb,proto3,oneof"`
}

type LoadBalancingConfig_Priority struct {
	Priority *PriorityLoadBalancingPolicyConfig `protobuf:"bytes,9,opt,name=priority,proto3,oneof"`
}

type LoadBalancingConfig_WeightedTarget struct {
	WeightedTarget *WeightedTargetLoadBalancingPolicyConfig `protobuf:"bytes,10,opt,name=weighted_target,json=weightedTarget,proto3,oneof"`
}

type LoadBalancingConfig_Cds struct {
	// EXPERIMENTAL -- DO NOT USE
	// xDS-based load balancing.
	// The policy is known as xds_experimental while it is under development.
	// It will be renamed to xds once it is ready for public use.
	Cds *CdsConfig `protobuf:"bytes,6,opt,name=cds,proto3,oneof"`
}

type LoadBalancingConfig_Eds struct {
	Eds *EdsLoadBalancingPolicyConfig `protobuf:"bytes,7,opt,name=eds,proto3,oneof"`
}

type LoadBalancingConfig_Lrs struct {
	Lrs *LrsLoadBalancingPolicyConfig `protobuf:"bytes,8,opt,name=lrs,proto3,oneof"`
}

type LoadBalancingConfig_Xds struct {
	// Deprecated: Do not use.
	Xds *XdsConfig `protobuf:"bytes,2,opt,name=xds,proto3,oneof"`
}

type LoadBalancingConfig_XdsExperimental struct {
	// TODO(rekarthik): Deprecate this field after the xds policy
	// is ready for public use.
	//
	// Deprecated: Do not use.
	XdsExperimental *XdsConfig `protobuf:"bytes,5,opt,name=xds_experimental,proto3,oneof"`
}

func (*LoadBalancingConfig_PickFirst) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_RoundRobin) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Grpclb) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Priority) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_WeightedTarget) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Cds) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Eds) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Lrs) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_Xds) isLoadBalancingConfig_Policy() {}

func (*LoadBalancingConfig_XdsExperimental) isLoadBalancingConfig_Policy() {}

// A ServiceConfig represents information about a service but is not specific to
// any name resolver.
type ServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Do not use.
	LoadBalancingPolicy ServiceConfig_LoadBalancingPolicy `protobuf:"varint,1,opt,name=load_balancing_policy,json=loadBalancingPolicy,proto3,enum=grpc.service_config.ServiceConfig_LoadBalancingPolicy" json:"load_balancing_policy,omitempty"`
	// Multiple LB policies can be specified; clients will iterate through
	// the list in order and stop at the first policy that they support. If none
	// are supported, the service config is considered invalid.
	LoadBalancingConfig []*LoadBalancingConfig `protobuf:"bytes,4,rep,name=load_balancing_config,json=loadBalancingConfig,proto3" json:"load_balancing_config,omitempty"`
	// Per-method configuration.
	MethodConfig      []*MethodConfig                      `protobuf:"bytes,2,rep,name=method_config,json=methodConfig,proto3" json:"method_config,omitempty"`
	RetryThrottling   *ServiceConfig_RetryThrottlingPolicy `protobuf:"bytes,3,opt,name=retry_throttling,json=retryThrottling,proto3" json:"retry_throttling,omitempty"`
	HealthCheckConfig *ServiceConfig_HealthCheckConfig     `protobuf:"bytes,5,opt,name=health_check_config,json=healthCheckConfig,proto3" json:"health_check_config,omitempty"`
}

func (x *ServiceConfig) Reset() {
	*x = ServiceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConfig) ProtoMessage() {}

func (x *ServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConfig.ProtoReflect.Descriptor instead.
func (*ServiceConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{11}
}

// Deprecated: Do not use.
func (x *ServiceConfig) GetLoadBalancingPolicy() ServiceConfig_LoadBalancingPolicy {
	if x != nil {
		return x.LoadBalancingPolicy
	}
	return ServiceConfig_UNSPECIFIED
}

func (x *ServiceConfig) GetLoadBalancingConfig() []*LoadBalancingConfig {
	if x != nil {
		return x.LoadBalancingConfig
	}
	return nil
}

func (x *ServiceConfig) GetMethodConfig() []*MethodConfig {
	if x != nil {
		return x.MethodConfig
	}
	return nil
}

func (x *ServiceConfig) GetRetryThrottling() *ServiceConfig_RetryThrottlingPolicy {
	if x != nil {
		return x.RetryThrottling
	}
	return nil
}

func (x *ServiceConfig) GetHealthCheckConfig() *ServiceConfig_HealthCheckConfig {
	if x != nil {
		return x.HealthCheckConfig
	}
	return nil
}

// The names of the methods to which this configuration applies.
// - MethodConfig without names (empty list) will be skipped.
// - Each name entry must be unique across the entire ServiceConfig.
// - If the 'method' field is empty, this MethodConfig specifies the defaults
//   for all methods for the specified service.
// - If the 'service' field is empty, the 'method' field must be empty, and
//   this MethodConfig specifies the default for all methods (it's the default
//   config).
//
// When determining which MethodConfig to use for a given RPC, the most
// specific match wins. For example, let's say that the service config
// contains the following MethodConfig entries:
//
// method_config { name { } ... }
// method_config { name { service: "MyService" } ... }
// method_config { name { service: "MyService" method: "Foo" } ... }
//
// MyService/Foo will use the third entry, because it exactly matches the
// service and method name. MyService/Bar will use the second entry, because
// it provides the default for all methods of MyService. AnotherService/Baz
// will use the first entry, because it doesn't match the other two.
//
// In JSON representation, value "", value `null`, and not present are the
// same. The following are the same Name:
// - { "service": "s" }
// - { "service": "s", "method": null }
// - { "service": "s", "method": "" }
type MethodConfig_Name struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"` // Required. Includes proto package name.
	Method  string `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
}

func (x *MethodConfig_Name) Reset() {
	*x = MethodConfig_Name{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MethodConfig_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodConfig_Name) ProtoMessage() {}

func (x *MethodConfig_Name) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodConfig_Name.ProtoReflect.Descriptor instead.
func (*MethodConfig_Name) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{0, 0}
}

func (x *MethodConfig_Name) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MethodConfig_Name) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

// The retry policy for outgoing RPCs.
type MethodConfig_RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of RPC attempts, including the original attempt.
	//
	// This field is required and must be greater than 1.
	// Any value greater than 5 will be treated as if it were 5.
	MaxAttempts uint32 `protobuf:"varint,1,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// Exponential backoff parameters. The initial retry attempt will occur at
	// random(0, initial_backoff). In general, the nth attempt will occur at
	// random(0,
	//   min(initial_backoff*backoff_multiplier**(n-1), max_backoff)).
	// Required. Must be greater than zero.
	InitialBackoff *duration.Duration `protobuf:"bytes,2,opt,name=initial_backoff,json=initialBackoff,proto3" json:"initial_backoff,omitempty"`
	// Required. Must be greater than zero.
	MaxBackoff        *duration.Duration `protobuf:"bytes,3,opt,name=max_backoff,json=maxBackoff,proto3" json:"max_backoff,omitempty"`
	BackoffMultiplier float32            `protobuf:"fixed32,4,opt,name=backoff_multiplier,json=backoffMultiplier,proto3" json:"backoff_multiplier,omitempty"` // Required. Must be greater than zero.
	// The set of status codes which may be retried.
	//
	// This field is required and must be non-empty.
	RetryableStatusCodes []code.Code `protobuf:"varint,5,rep,packed,name=retryable_status_codes,json=retryableStatusCodes,proto3,enum=google.rpc.Code" json:"retryable_status_codes,omitempty"`
}

func (x *MethodConfig_RetryPolicy) Reset() {
	*x = MethodConfig_RetryPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MethodConfig_RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodConfig_RetryPolicy) ProtoMessage() {}

func (x *MethodConfig_RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodConfig_RetryPolicy.ProtoReflect.Descriptor instead.
func (*MethodConfig_RetryPolicy) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{0, 1}
}

func (x *MethodConfig_RetryPolicy) GetMaxAttempts() uint32 {
	if x != nil {
		return x.MaxAttempts
	}
	return 0
}

func (x *MethodConfig_RetryPolicy) GetInitialBackoff() *duration.Duration {
	if x != nil {
		return x.InitialBackoff
	}
	return nil
}

func (x *MethodConfig_RetryPolicy) GetMaxBackoff() *duration.Duration {
	if x != nil {
		return x.MaxBackoff
	}
	return nil
}

func (x *MethodConfig_RetryPolicy) GetBackoffMultiplier() float32 {
	if x != nil {
		return x.BackoffMultiplier
	}
	return 0
}

func (x *MethodConfig_RetryPolicy) GetRetryableStatusCodes() []code.Code {
	if x != nil {
		return x.RetryableStatusCodes
	}
	return nil
}

// The hedging policy for outgoing RPCs. Hedged RPCs may execute more than
// once on the server, so only idempotent methods should specify a hedging
// policy.
type MethodConfig_HedgingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hedging policy will send up to max_requests RPCs.
	// This number represents the total number of all attempts, including
	// the original attempt.
	//
	// This field is required and must be greater than 1.
	// Any value greater than 5 will be treated as if it were 5.
	MaxAttempts uint32 `protobuf:"varint,1,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// The first RPC will be sent immediately, but the max_requests-1 subsequent
	// hedged RPCs will be sent at intervals of every hedging_delay. Set this
	// to 0 to immediately send all max_requests RPCs.
	HedgingDelay *duration.Duration `protobuf:"bytes,2,opt,name=hedging_delay,json=hedgingDelay,proto3" json:"hedging_delay,omitempty"`
	// The set of status codes which indicate other hedged RPCs may still
	// succeed. If a non-fatal status code is returned by the server, hedged
	// RPCs will continue. Otherwise, outstanding requests will be canceled and
	// the error returned to the client application layer.
	//
	// This field is optional.
	NonFatalStatusCodes []code.Code `protobuf:"varint,3,rep,packed,name=non_fatal_status_codes,json=nonFatalStatusCodes,proto3,enum=google.rpc.Code" json:"non_fatal_status_codes,omitempty"`
}

func (x *MethodConfig_HedgingPolicy) Reset() {
	*x = MethodConfig_HedgingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MethodConfig_HedgingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MethodConfig_HedgingPolicy) ProtoMessage() {}

func (x *MethodConfig_HedgingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MethodConfig_HedgingPolicy.ProtoReflect.Descriptor instead.
func (*MethodConfig_HedgingPolicy) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{0, 2}
}

func (x *MethodConfig_HedgingPolicy) GetMaxAttempts() uint32 {
	if x != nil {
		return x.MaxAttempts
	}
	return 0
}

func (x *MethodConfig_HedgingPolicy) GetHedgingDelay() *duration.Duration {
	if x != nil {
		return x.HedgingDelay
	}
	return nil
}

func (x *MethodConfig_HedgingPolicy) GetNonFatalStatusCodes() []code.Code {
	if x != nil {
		return x.NonFatalStatusCodes
	}
	return nil
}

// A map of name to child policy configuration.
// The names are used to allow the priority policy to update
// existing child policies instead of creating new ones every
// time it receives a config update.
type PriorityLoadBalancingPolicyConfig_Child struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Config []*LoadBalancingConfig `protobuf:"bytes,1,rep,name=config,proto3" json:"config,omitempty"`
}

func (x *PriorityLoadBalancingPolicyConfig_Child) Reset() {
	*x = PriorityLoadBalancingPolicyConfig_Child{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriorityLoadBalancingPolicyConfig_Child) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriorityLoadBalancingPolicyConfig_Child) ProtoMessage() {}

func (x *PriorityLoadBalancingPolicyConfig_Child) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriorityLoadBalancingPolicyConfig_Child.ProtoReflect.Descriptor instead.
func (*PriorityLoadBalancingPolicyConfig_Child) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{3, 0}
}

func (x *PriorityLoadBalancingPolicyConfig_Child) GetConfig() []*LoadBalancingConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

type WeightedTargetLoadBalancingPolicyConfig_Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Weight      uint32                 `protobuf:"varint,1,opt,name=weight,proto3" json:"weight,omitempty"`
	ChildPolicy []*LoadBalancingConfig `protobuf:"bytes,2,rep,name=child_policy,json=childPolicy,proto3" json:"child_policy,omitempty"`
}

func (x *WeightedTargetLoadBalancingPolicyConfig_Target) Reset() {
	*x = WeightedTargetLoadBalancingPolicyConfig_Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WeightedTargetLoadBalancingPolicyConfig_Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeightedTargetLoadBalancingPolicyConfig_Target) ProtoMessage() {}

func (x *WeightedTargetLoadBalancingPolicyConfig_Target) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeightedTargetLoadBalancingPolicyConfig_Target.ProtoReflect.Descriptor instead.
func (*WeightedTargetLoadBalancingPolicyConfig_Target) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{4, 0}
}

func (x *WeightedTargetLoadBalancingPolicyConfig_Target) GetWeight() uint32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *WeightedTargetLoadBalancingPolicyConfig_Target) GetChildPolicy() []*LoadBalancingConfig {
	if x != nil {
		return x.ChildPolicy
	}
	return nil
}

// The locality for which this policy will report load.  Required.
type LrsLoadBalancingPolicyConfig_Locality struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Region  string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	Zone    string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	Subzone string `protobuf:"bytes,3,opt,name=subzone,proto3" json:"subzone,omitempty"`
}

func (x *LrsLoadBalancingPolicyConfig_Locality) Reset() {
	*x = LrsLoadBalancingPolicyConfig_Locality{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LrsLoadBalancingPolicyConfig_Locality) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LrsLoadBalancingPolicyConfig_Locality) ProtoMessage() {}

func (x *LrsLoadBalancingPolicyConfig_Locality) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LrsLoadBalancingPolicyConfig_Locality.ProtoReflect.Descriptor instead.
func (*LrsLoadBalancingPolicyConfig_Locality) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{9, 0}
}

func (x *LrsLoadBalancingPolicyConfig_Locality) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *LrsLoadBalancingPolicyConfig_Locality) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *LrsLoadBalancingPolicyConfig_Locality) GetSubzone() string {
	if x != nil {
		return x.Subzone
	}
	return ""
}

// If a RetryThrottlingPolicy is provided, gRPC will automatically throttle
// retry attempts and hedged RPCs when the client's ratio of failures to
// successes exceeds a threshold.
//
// For each server name, the gRPC client will maintain a token_count which is
// initially set to max_tokens. Every outgoing RPC (regardless of service or
// method invoked) will change token_count as follows:
//
//   - Every failed RPC will decrement the token_count by 1.
//   - Every successful RPC will increment the token_count by token_ratio.
//
// If token_count is less than or equal to max_tokens / 2, then RPCs will not
// be retried and hedged RPCs will not be sent.
type ServiceConfig_RetryThrottlingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of tokens starts at max_tokens. The token_count will always be
	// between 0 and max_tokens.
	//
	// This field is required and must be greater than zero.
	MaxTokens uint32 `protobuf:"varint,1,opt,name=max_tokens,json=maxTokens,proto3" json:"max_tokens,omitempty"`
	// The amount of tokens to add on each successful RPC. Typically this will
	// be some number between 0 and 1, e.g., 0.1.
	//
	// This field is required and must be greater than zero. Up to 3 decimal
	// places are supported.
	TokenRatio float32 `protobuf:"fixed32,2,opt,name=token_ratio,json=tokenRatio,proto3" json:"token_ratio,omitempty"`
}

func (x *ServiceConfig_RetryThrottlingPolicy) Reset() {
	*x = ServiceConfig_RetryThrottlingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConfig_RetryThrottlingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConfig_RetryThrottlingPolicy) ProtoMessage() {}

func (x *ServiceConfig_RetryThrottlingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConfig_RetryThrottlingPolicy.ProtoReflect.Descriptor instead.
func (*ServiceConfig_RetryThrottlingPolicy) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{11, 0}
}

func (x *ServiceConfig_RetryThrottlingPolicy) GetMaxTokens() uint32 {
	if x != nil {
		return x.MaxTokens
	}
	return 0
}

func (x *ServiceConfig_RetryThrottlingPolicy) GetTokenRatio() float32 {
	if x != nil {
		return x.TokenRatio
	}
	return 0
}

type ServiceConfig_HealthCheckConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Service name to use in the health-checking request.
	ServiceName *wrappers.StringValue `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
}

func (x *ServiceConfig_HealthCheckConfig) Reset() {
	*x = ServiceConfig_HealthCheckConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grpc_service_config_service_config_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConfig_HealthCheckConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConfig_HealthCheckConfig) ProtoMessage() {}

func (x *ServiceConfig_HealthCheckConfig) ProtoReflect() protoreflect.Message {
	mi := &file_grpc_service_config_service_config_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConfig_HealthCheckConfig.ProtoReflect.Descriptor instead.
func (*ServiceConfig_HealthCheckConfig) Descriptor() ([]byte, []int) {
	return file_grpc_service_config_service_config_proto_rawDescGZIP(), []int{11, 1}
}

func (x *ServiceConfig_HealthCheckConfig) GetServiceName() *wrappers.StringValue {
	if x != nil {
		return x.ServiceName
	}
	return nil
}

var File_grpc_service_config_service_config_proto protoreflect.FileDescriptor

var file_grpc_service_config_service_config_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xde, 0x08, 0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x5f,
	0x72, 0x65, 0x61, 0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x77, 0x61, 0x69, 0x74, 0x46, 0x6f, 0x72,
	0x52, 0x65, 0x61, 0x64, 0x79, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x57, 0x0a, 0x19, 0x6d, 0x61,
	0x78, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x6d, 0x61, 0x78,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x1a, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x52,
	0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x58, 0x0a, 0x0e, 0x68, 0x65, 0x64, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x72, 0x70,
	0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x65,
	0x64, 0x67, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x68,
	0x65, 0x64, 0x67, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x38, 0x0a, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x1a, 0xa7, 0x02, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x6d, 0x61,
	0x78, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x0f, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x3a, 0x0a,
	0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6d,
	0x61, 0x78, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x2d, 0x0a, 0x12, 0x62, 0x61, 0x63,
	0x6b, 0x6f, 0x66, 0x66, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x16, 0x72, 0x65, 0x74, 0x72,
	0x79, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x14, 0x72, 0x65, 0x74, 0x72,
	0x79, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x73,
	0x1a, 0xb9, 0x01, 0x0a, 0x0d, 0x48, 0x65, 0x64, 0x67, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x41, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x0d, 0x68, 0x65, 0x64, 0x67, 0x69, 0x6e, 0x67,
	0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x68, 0x65, 0x64, 0x67, 0x69, 0x6e, 0x67,
	0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x45, 0x0a, 0x16, 0x6e, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x74,
	0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x13, 0x6e, 0x6f, 0x6e, 0x46, 0x61, 0x74, 0x61,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x42, 0x19, 0x0a, 0x17,
	0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x6f, 0x72, 0x5f, 0x68, 0x65, 0x64, 0x67, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x11, 0x0a, 0x0f, 0x50, 0x69, 0x63, 0x6b, 0x46,
	0x69, 0x72, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x12, 0x0a, 0x10, 0x52, 0x6f,
	0x75, 0x6e, 0x64, 0x52, 0x6f, 0x62, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xeb,
	0x02, 0x0a, 0x21, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x08, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x69,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43,
	0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x63, 0x68,
	0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x49, 0x0a, 0x05, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x12,
	0x40, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x1a, 0x79, 0x0a, 0x0d, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x52, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x68, 0x69, 0x6c,
	0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfe, 0x02, 0x0a,
	0x27, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c,
	0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x07, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x1a, 0x6d, 0x0a,
	0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12,
	0x4b, 0x0a, 0x0c, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64,
	0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0b, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x7f, 0x0a, 0x0c,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x59,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7e, 0x0a,
	0x0c, 0x47, 0x72, 0x70, 0x63, 0x4c, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a,
	0x0c, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x63,
	0x68, 0x69, 0x6c, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x25, 0x0a,
	0x09, 0x43, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x22, 0xe0, 0x02, 0x0a, 0x09, 0x58, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x27, 0x0a, 0x0d, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x63,
	0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x63, 0x68, 0x69,
	0x6c, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x51, 0x0a, 0x0f, 0x66, 0x61, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x66, 0x61, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x28, 0x0a, 0x10, 0x65,
	0x64, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x64, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x1e, 0x6c, 0x72, 0x73, 0x5f, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x6c, 0x72, 0x73,
	0x4c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x88, 0x03, 0x0a, 0x1c, 0x45, 0x64, 0x73, 0x4c,
	0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x64, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x64,
	0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x1e,
	0x6c, 0x72, 0x73, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x1a, 0x6c, 0x72, 0x73, 0x4c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x60,
	0x0a, 0x17, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x50, 0x69, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x60, 0x0a, 0x17, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x70, 0x69, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x50, 0x69, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0xa6, 0x03, 0x0a, 0x1c, 0x4c, 0x72, 0x73, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x64, 0x73, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x65, 0x64, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x42, 0x0a, 0x1e, 0x6c, 0x72, 0x73, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x6c, 0x72, 0x73, 0x4c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x72, 0x73,
	0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x4b, 0x0a, 0x0c,
	0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x63, 0x68,
	0x69, 0x6c, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x50, 0x0a, 0x08, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x62, 0x7a, 0x6f, 0x6e, 0x65, 0x22, 0xfa, 0x05, 0x0a, 0x13,
	0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x0a, 0x70, 0x69, 0x63, 0x6b, 0x5f, 0x66, 0x69, 0x72, 0x73,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x69,
	0x63, 0x6b, 0x46, 0x69, 0x72, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x0a, 0x70, 0x69, 0x63, 0x6b, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0b, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x72, 0x6f, 0x62, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x6f, 0x62, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x5f, 0x72, 0x6f, 0x62, 0x69, 0x6e, 0x12, 0x3b, 0x0a, 0x06, 0x67, 0x72, 0x70, 0x63, 0x6c, 0x62,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x70,
	0x63, 0x4c, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x67, 0x72, 0x70,
	0x63, 0x6c, 0x62, 0x12, 0x54, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x67, 0x0a, 0x0f, 0x77, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65,
	0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x0e, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x32, 0x0a, 0x03, 0x63, 0x64, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48,
	0x00, 0x52, 0x03, 0x63, 0x64, 0x73, 0x12, 0x45, 0x0a, 0x03, 0x65, 0x64, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x64, 0x73, 0x4c, 0x6f, 0x61,
	0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x03, 0x65, 0x64, 0x73, 0x12, 0x45, 0x0a,
	0x03, 0x6c, 0x72, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x72, 0x70,
	0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4c, 0x72, 0x73, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x03, 0x6c, 0x72, 0x73, 0x12, 0x36, 0x0a, 0x03, 0x78, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x58, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x03, 0x78, 0x64, 0x73, 0x12, 0x50, 0x0a, 0x10,
	0x78, 0x64, 0x73, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x58, 0x64, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x10, 0x78, 0x64,
	0x73, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x42, 0x08,
	0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xd8, 0x05, 0x0a, 0x0d, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x15, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5c, 0x0a, 0x15, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x13, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x63, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x74, 0x74,
	0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x72, 0x70,
	0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52,
	0x65, 0x74, 0x72, 0x79, 0x54, 0x68, 0x72, 0x6f, 0x74, 0x74, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x72, 0x79, 0x54, 0x68, 0x72, 0x6f, 0x74,
	0x74, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x64, 0x0a, 0x13, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x57, 0x0a, 0x15, 0x52,
	0x65, 0x74, 0x72, 0x79, 0x54, 0x68, 0x72, 0x6f, 0x74, 0x74, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x61, 0x74, 0x69, 0x6f, 0x1a, 0x54, 0x0a, 0x11, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x0c, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x37, 0x0a, 0x13, 0x4c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x52, 0x4f, 0x42, 0x49,
	0x4e, 0x10, 0x01, 0x42, 0x2d, 0x0a, 0x15, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x12, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_grpc_service_config_service_config_proto_rawDescOnce sync.Once
	file_grpc_service_config_service_config_proto_rawDescData = file_grpc_service_config_service_config_proto_rawDesc
)

func file_grpc_service_config_service_config_proto_rawDescGZIP() []byte {
	file_grpc_service_config_service_config_proto_rawDescOnce.Do(func() {
		file_grpc_service_config_service_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_grpc_service_config_service_config_proto_rawDescData)
	})
	return file_grpc_service_config_service_config_proto_rawDescData
}

var file_grpc_service_config_service_config_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_grpc_service_config_service_config_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_grpc_service_config_service_config_proto_goTypes = []interface{}{
	(ServiceConfig_LoadBalancingPolicy)(0),          // 0: grpc.service_config.ServiceConfig.LoadBalancingPolicy
	(*MethodConfig)(nil),                            // 1: grpc.service_config.MethodConfig
	(*PickFirstConfig)(nil),                         // 2: grpc.service_config.PickFirstConfig
	(*RoundRobinConfig)(nil),                        // 3: grpc.service_config.RoundRobinConfig
	(*PriorityLoadBalancingPolicyConfig)(nil),       // 4: grpc.service_config.PriorityLoadBalancingPolicyConfig
	(*WeightedTargetLoadBalancingPolicyConfig)(nil), // 5: grpc.service_config.WeightedTargetLoadBalancingPolicyConfig
	(*GrpcLbConfig)(nil),                            // 6: grpc.service_config.GrpcLbConfig
	(*CdsConfig)(nil),                               // 7: grpc.service_config.CdsConfig
	(*XdsConfig)(nil),                               // 8: grpc.service_config.XdsConfig
	(*EdsLoadBalancingPolicyConfig)(nil),            // 9: grpc.service_config.EdsLoadBalancingPolicyConfig
	(*LrsLoadBalancingPolicyConfig)(nil),            // 10: grpc.service_config.LrsLoadBalancingPolicyConfig
	(*LoadBalancingConfig)(nil),                     // 11: grpc.service_config.LoadBalancingConfig
	(*ServiceConfig)(nil),                           // 12: grpc.service_config.ServiceConfig
	(*MethodConfig_Name)(nil),                       // 13: grpc.service_config.MethodConfig.Name
	(*MethodConfig_RetryPolicy)(nil),                // 14: grpc.service_config.MethodConfig.RetryPolicy
	(*MethodConfig_HedgingPolicy)(nil),              // 15: grpc.service_config.MethodConfig.HedgingPolicy
	(*PriorityLoadBalancingPolicyConfig_Child)(nil), // 16: grpc.service_config.PriorityLoadBalancingPolicyConfig.Child
	nil, // 17: grpc.service_config.PriorityLoadBalancingPolicyConfig.ChildrenEntry
	(*WeightedTargetLoadBalancingPolicyConfig_Target)(nil), // 18: grpc.service_config.WeightedTargetLoadBalancingPolicyConfig.Target
	nil, // 19: grpc.service_config.WeightedTargetLoadBalancingPolicyConfig.TargetsEntry
	(*LrsLoadBalancingPolicyConfig_Locality)(nil), // 20: grpc.service_config.LrsLoadBalancingPolicyConfig.Locality
	(*ServiceConfig_RetryThrottlingPolicy)(nil),   // 21: grpc.service_config.ServiceConfig.RetryThrottlingPolicy
	(*ServiceConfig_HealthCheckConfig)(nil),       // 22: grpc.service_config.ServiceConfig.HealthCheckConfig
	(*wrappers.BoolValue)(nil),                    // 23: google.protobuf.BoolValue
	(*duration.Duration)(nil),                     // 24: google.protobuf.Duration
	(*wrappers.UInt32Value)(nil),                  // 25: google.protobuf.UInt32Value
	(*wrappers.StringValue)(nil),                  // 26: google.protobuf.StringValue
	(code.Code)(0),                                // 27: google.rpc.Code
}
var file_grpc_service_config_service_config_proto_depIdxs = []int32{
	13, // 0: grpc.service_config.MethodConfig.name:type_name -> grpc.service_config.MethodConfig.Name
	23, // 1: grpc.service_config.MethodConfig.wait_for_ready:type_name -> google.protobuf.BoolValue
	24, // 2: grpc.service_config.MethodConfig.timeout:type_name -> google.protobuf.Duration
	25, // 3: grpc.service_config.MethodConfig.max_request_message_bytes:type_name -> google.protobuf.UInt32Value
	25, // 4: grpc.service_config.MethodConfig.max_response_message_bytes:type_name -> google.protobuf.UInt32Value
	14, // 5: grpc.service_config.MethodConfig.retry_policy:type_name -> grpc.service_config.MethodConfig.RetryPolicy
	15, // 6: grpc.service_config.MethodConfig.hedging_policy:type_name -> grpc.service_config.MethodConfig.HedgingPolicy
	17, // 7: grpc.service_config.PriorityLoadBalancingPolicyConfig.children:type_name -> grpc.service_config.PriorityLoadBalancingPolicyConfig.ChildrenEntry
	19, // 8: grpc.service_config.WeightedTargetLoadBalancingPolicyConfig.targets:type_name -> grpc.service_config.WeightedTargetLoadBalancingPolicyConfig.TargetsEntry
	11, // 9: grpc.service_config.GrpcLbConfig.child_policy:type_name -> grpc.service_config.LoadBalancingConfig
	11, // 10: grpc.service_config.XdsConfig.child_policy:type_name -> grpc.service_config.LoadBalancingConfig
	11, // 11: grpc.service_config.XdsConfig.fallback_policy:type_name -> grpc.service_config.LoadBalancingConfig
	26, // 12: grpc.service_config.XdsConfig.lrs_load_reporting_server_name:type_name -> google.protobuf.StringValue
	26, // 13: grpc.service_config.EdsLoadBalancingPolicyConfig.lrs_load_reporting_server_name:type_name -> google.protobuf.StringValue
	11, // 14: grpc.service_config.EdsLoadBalancingPolicyConfig.locality_picking_policy:type_name -> grpc.service_config.LoadBalancingConfig
	11, // 15: grpc.service_config.EdsLoadBalancingPolicyConfig.endpoint_picking_policy:type_name -> grpc.service_config.LoadBalancingConfig
	20, // 16: grpc.service_config.LrsLoadBalancingPolicyConfig.locality:type_name -> grpc.service_config.LrsLoadBalancingPolicyConfig.Locality
	11, // 17: grpc.service_config.LrsLoadBalancingPolicyConfig.child_policy:type_name -> grpc.service_config.LoadBalancingConfig
	2,  // 18: grpc.service_config.LoadBalancingConfig.pick_first:type_name -> grpc.service_config.PickFirstConfig
	3,  // 19: grpc.service_config.LoadBalancingConfig.round_robin:type_name -> grpc.service_config.RoundRobinConfig
	6,  // 20: grpc.service_config.LoadBalancingConfig.grpclb:type_name -> grpc.service_config.GrpcLbConfig
	4,  // 21: grpc.service_config.LoadBalancingConfig.priority:type_name -> grpc.service_config.PriorityLoadBalancingPolicyConfig
	5,  // 22: grpc.service_config.LoadBalancingConfig.weighted_target:type_name -> grpc.service_config.WeightedTargetLoadBalancingPolicyConfig
	7,  // 23: grpc.service_config.LoadBalancingConfig.cds:type_name -> grpc.service_config.CdsConfig
	9,  // 24: grpc.service_config.LoadBalancingConfig.eds:type_name -> grpc.service_config.EdsLoadBalancingPolicyConfig
	10, // 25: grpc.service_config.LoadBalancingConfig.lrs:type_name -> grpc.service_config.LrsLoadBalancingPolicyConfig
	8,  // 26: grpc.service_config.LoadBalancingConfig.xds:type_name -> grpc.service_config.XdsConfig
	8,  // 27: grpc.service_config.LoadBalancingConfig.xds_experimental:type_name -> grpc.service_config.XdsConfig
	0,  // 28: grpc.service_config.ServiceConfig.load_balancing_policy:type_name -> grpc.service_config.ServiceConfig.LoadBalancingPolicy
	11, // 29: grpc.service_config.ServiceConfig.load_balancing_config:type_name -> grpc.service_config.LoadBalancingConfig
	1,  // 30: grpc.service_config.ServiceConfig.method_config:type_name -> grpc.service_config.MethodConfig
	21, // 31: grpc.service_config.ServiceConfig.retry_throttling:type_name -> grpc.service_config.ServiceConfig.RetryThrottlingPolicy
	22, // 32: grpc.service_config.ServiceConfig.health_check_config:type_name -> grpc.service_config.ServiceConfig.HealthCheckConfig
	24, // 33: grpc.service_config.MethodConfig.RetryPolicy.initial_backoff:type_name -> google.protobuf.Duration
	24, // 34: grpc.service_config.MethodConfig.RetryPolicy.max_backoff:type_name -> google.protobuf.Duration
	27, // 35: grpc.service_config.MethodConfig.RetryPolicy.retryable_status_codes:type_name -> google.rpc.Code
	24, // 36: grpc.service_config.MethodConfig.HedgingPolicy.hedging_delay:type_name -> google.protobuf.Duration
	27, // 37: grpc.service_config.MethodConfig.HedgingPolicy.non_fatal_status_codes:type_name -> google.rpc.Code
	11, // 38: grpc.service_config.PriorityLoadBalancingPolicyConfig.Child.config:type_name -> grpc.service_config.LoadBalancingConfig
	16, // 39: grpc.service_config.PriorityLoadBalancingPolicyConfig.ChildrenEntry.value:type_name -> grpc.service_config.PriorityLoadBalancingPolicyConfig.Child
	11, // 40: grpc.service_config.WeightedTargetLoadBalancingPolicyConfig.Target.child_policy:type_name -> grpc.service_config.LoadBalancingConfig
	18, // 41: grpc.service_config.WeightedTargetLoadBalancingPolicyConfig.TargetsEntry.value:type_name -> grpc.service_config.WeightedTargetLoadBalancingPolicyConfig.Target
	26, // 42: grpc.service_config.ServiceConfig.HealthCheckConfig.service_name:type_name -> google.protobuf.StringValue
	43, // [43:43] is the sub-list for method output_type
	43, // [43:43] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_grpc_service_config_service_config_proto_init() }
func file_grpc_service_config_service_config_proto_init() {
	if File_grpc_service_config_service_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_grpc_service_config_service_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MethodConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PickFirstConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoundRobinConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriorityLoadBalancingPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WeightedTargetLoadBalancingPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcLbConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CdsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*XdsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EdsLoadBalancingPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LrsLoadBalancingPolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadBalancingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MethodConfig_Name); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MethodConfig_RetryPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MethodConfig_HedgingPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriorityLoadBalancingPolicyConfig_Child); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WeightedTargetLoadBalancingPolicyConfig_Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LrsLoadBalancingPolicyConfig_Locality); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConfig_RetryThrottlingPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grpc_service_config_service_config_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConfig_HealthCheckConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_grpc_service_config_service_config_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*MethodConfig_RetryPolicy_)(nil),
		(*MethodConfig_HedgingPolicy_)(nil),
	}
	file_grpc_service_config_service_config_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*LoadBalancingConfig_PickFirst)(nil),
		(*LoadBalancingConfig_RoundRobin)(nil),
		(*LoadBalancingConfig_Grpclb)(nil),
		(*LoadBalancingConfig_Priority)(nil),
		(*LoadBalancingConfig_WeightedTarget)(nil),
		(*LoadBalancingConfig_Cds)(nil),
		(*LoadBalancingConfig_Eds)(nil),
		(*LoadBalancingConfig_Lrs)(nil),
		(*LoadBalancingConfig_Xds)(nil),
		(*LoadBalancingConfig_XdsExperimental)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grpc_service_config_service_config_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grpc_service_config_service_config_proto_goTypes,
		DependencyIndexes: file_grpc_service_config_service_config_proto_depIdxs,
		EnumInfos:         file_grpc_service_config_service_config_proto_enumTypes,
		MessageInfos:      file_grpc_service_config_service_config_proto_msgTypes,
	}.Build()
	File_grpc_service_config_service_config_proto = out.File
	file_grpc_service_config_service_config_proto_rawDesc = nil
	file_grpc_service_config_service_config_proto_goTypes = nil
	file_grpc_service_config_service_config_proto_depIdxs = nil
}
