
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinTools_LocationSet.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Geom2d_Curve.hxx>
#include <Poly_Polygon3D.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Poly_Polygon3D.hxx>
#include <Poly_PolygonOnTriangulation.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>

// module includes
#include <BinTools.hxx>
#include <BinTools_Curve2dSet.hxx>
#include <BinTools_CurveSet.hxx>
#include <BinTools_FormatVersion.hxx>
#include <BinTools_IStream.hxx>
#include <BinTools_LocationSet.hxx>
#include <BinTools_LocationSetPtr.hxx>
#include <BinTools_ObjectType.hxx>
#include <BinTools_OStream.hxx>
#include <BinTools_ShapeReader.hxx>
#include <BinTools_ShapeSet.hxx>
#include <BinTools_ShapeSetBase.hxx>
#include <BinTools_ShapeWriter.hxx>
#include <BinTools_SurfaceSet.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinTools(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinTools"));
py::object klass;

//Python trampoline classes

// classes

    // Class BinTools from ./opencascade/BinTools.hxx
    klass = m.attr("BinTools");

    // default constructor
    register_default_constructor<BinTools , shared_ptr<BinTools>>(m,"BinTools");

    // nested enums

    static_cast<py::class_<BinTools , shared_ptr<BinTools>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("PutReal_s",
                    (Standard_OStream & (*)( std::ostream & ,  const Standard_Real &  ) ) static_cast<Standard_OStream & (*)( std::ostream & ,  const Standard_Real &  ) >(&BinTools::PutReal),
                    R"#(None)#"  , py::arg("OS"),  py::arg("theValue")
          )
        .def_static("PutShortReal_s",
                    (Standard_OStream & (*)( std::ostream & ,  const Standard_ShortReal &  ) ) static_cast<Standard_OStream & (*)( std::ostream & ,  const Standard_ShortReal &  ) >(&BinTools::PutShortReal),
                    R"#(None)#"  , py::arg("OS"),  py::arg("theValue")
          )
        .def_static("PutInteger_s",
                    (Standard_OStream & (*)( std::ostream & ,  const Standard_Integer  ) ) static_cast<Standard_OStream & (*)( std::ostream & ,  const Standard_Integer  ) >(&BinTools::PutInteger),
                    R"#(None)#"  , py::arg("OS"),  py::arg("theValue")
          )
        .def_static("PutBool_s",
                    (Standard_OStream & (*)( std::ostream & ,  const Standard_Boolean  ) ) static_cast<Standard_OStream & (*)( std::ostream & ,  const Standard_Boolean  ) >(&BinTools::PutBool),
                    R"#(None)#"  , py::arg("OS"),  py::arg("theValue")
          )
        .def_static("PutExtChar_s",
                    (Standard_OStream & (*)( std::ostream & ,  const Standard_ExtCharacter  ) ) static_cast<Standard_OStream & (*)( std::ostream & ,  const Standard_ExtCharacter  ) >(&BinTools::PutExtChar),
                    R"#(None)#"  , py::arg("OS"),  py::arg("theValue")
          )
        .def_static("GetReal_s",
                    (Standard_IStream & (*)( std::istream & ,  Standard_Real &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  Standard_Real &  ) >(&BinTools::GetReal),
                    R"#(None)#"  , py::arg("IS"),  py::arg("theValue")
          )
        .def_static("GetShortReal_s",
                    (Standard_IStream & (*)( std::istream & ,  Standard_ShortReal &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  Standard_ShortReal &  ) >(&BinTools::GetShortReal),
                    R"#(None)#"  , py::arg("IS"),  py::arg("theValue")
          )
        .def_static("GetInteger_s",
                    (Standard_IStream & (*)( std::istream & ,  Standard_Integer &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  Standard_Integer &  ) >(&BinTools::GetInteger),
                    R"#(None)#"  , py::arg("IS"),  py::arg("theValue")
          )
        .def_static("GetBool_s",
                    (Standard_IStream & (*)( std::istream & ,  Standard_Boolean &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  Standard_Boolean &  ) >(&BinTools::GetBool),
                    R"#(None)#"  , py::arg("IS"),  py::arg("theValue")
          )
        .def_static("GetExtChar_s",
                    (Standard_IStream & (*)( std::istream & ,  Standard_ExtCharacter &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  Standard_ExtCharacter &  ) >(&BinTools::GetExtChar),
                    R"#(None)#"  , py::arg("IS"),  py::arg("theValue")
          )
        .def_static("Write_s",
                    (void (*)( const TopoDS_Shape & ,  std::ostream & ,  const Message_ProgressRange &  ) ) static_cast<void (*)( const TopoDS_Shape & ,  std::ostream & ,  const Message_ProgressRange &  ) >(&BinTools::Write),
                    R"#(Writes the shape to the stream in binary format BinTools_FormatVersion_CURRENT. This alias writes shape with triangulation data.)#"  , py::arg("theShape"),  py::arg("theStream"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("Write_s",
                    (void (*)( const TopoDS_Shape & ,  std::ostream & ,  const Standard_Boolean ,  const Standard_Boolean ,  const BinTools_FormatVersion ,  const Message_ProgressRange &  ) ) static_cast<void (*)( const TopoDS_Shape & ,  std::ostream & ,  const Standard_Boolean ,  const Standard_Boolean ,  const BinTools_FormatVersion ,  const Message_ProgressRange &  ) >(&BinTools::Write),
                    R"#(Writes the shape to the stream in binary format of specified version.)#"  , py::arg("theShape"),  py::arg("theStream"),  py::arg("theWithTriangles"),  py::arg("theWithNormals"),  py::arg("theVersion"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("Read_s",
                    (void (*)( TopoDS_Shape & ,  std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (*)( TopoDS_Shape & ,  std::istream & ,  const Message_ProgressRange &  ) >(&BinTools::Read),
                    R"#(Reads a shape from <theStream> and returns it in <theShape>.)#"  , py::arg("theShape"),  py::arg("theStream"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("Write_s",
                    (Standard_Boolean (*)( const TopoDS_Shape & ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Shape & ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&BinTools::Write),
                    R"#(Writes the shape to the file in binary format BinTools_FormatVersion_CURRENT.)#"  , py::arg("theShape"),  py::arg("theFile"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("Write_s",
                    (Standard_Boolean (*)( const TopoDS_Shape & ,  const Standard_CString ,  const Standard_Boolean ,  const Standard_Boolean ,  const BinTools_FormatVersion ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (*)( const TopoDS_Shape & ,  const Standard_CString ,  const Standard_Boolean ,  const Standard_Boolean ,  const BinTools_FormatVersion ,  const Message_ProgressRange &  ) >(&BinTools::Write),
                    R"#(Writes the shape to the file in binary format of specified version.)#"  , py::arg("theShape"),  py::arg("theFile"),  py::arg("theWithTriangles"),  py::arg("theWithNormals"),  py::arg("theVersion"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def_static("Read_s",
                    (Standard_Boolean (*)( TopoDS_Shape & ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (*)( TopoDS_Shape & ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&BinTools::Read),
                    R"#(Reads a shape from <theFile> and returns it in <theShape>.)#"  , py::arg("theShape"),  py::arg("theFile"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTools_Curve2dSet from ./opencascade/BinTools_Curve2dSet.hxx
    klass = m.attr("BinTools_Curve2dSet");


    // nested enums

    static_cast<py::class_<BinTools_Curve2dSet , shared_ptr<BinTools_Curve2dSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BinTools_Curve2dSet::*)() ) static_cast<void (BinTools_Curve2dSet::*)() >(&BinTools_Curve2dSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (BinTools_Curve2dSet::*)( const opencascade::handle<Geom2d_Curve> &  ) ) static_cast<Standard_Integer (BinTools_Curve2dSet::*)( const opencascade::handle<Geom2d_Curve> &  ) >(&BinTools_Curve2dSet::Add),
             R"#(Incorporate a new Curve in the set and returns its index.)#"  , py::arg("C")
          )
        .def("Curve2d",
             (opencascade::handle<Geom2d_Curve> (BinTools_Curve2dSet::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<Geom2d_Curve> (BinTools_Curve2dSet::*)( const Standard_Integer  ) const>(&BinTools_Curve2dSet::Curve2d),
             R"#(Returns the Curve of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (BinTools_Curve2dSet::*)( const opencascade::handle<Geom2d_Curve> &  ) const) static_cast<Standard_Integer (BinTools_Curve2dSet::*)( const opencascade::handle<Geom2d_Curve> &  ) const>(&BinTools_Curve2dSet::Index),
             R"#(Returns the index of <L>.)#"  , py::arg("C")
          )
        .def("Write",
             (void (BinTools_Curve2dSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const) static_cast<void (BinTools_Curve2dSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const>(&BinTools_Curve2dSet::Write),
             R"#(Writes the content of me on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (BinTools_Curve2dSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_Curve2dSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_Curve2dSet::Read),
             R"#(Reads the content of me from the stream <IS>. me is first cleared.)#"  , py::arg("IS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("WriteCurve2d_s",
                    (void (*)( const opencascade::handle<Geom2d_Curve> & ,  BinTools_OStream &  ) ) static_cast<void (*)( const opencascade::handle<Geom2d_Curve> & ,  BinTools_OStream &  ) >(&BinTools_Curve2dSet::WriteCurve2d),
                    R"#(Dumps the curve on the binary stream, that can be read back.)#"  , py::arg("C"),  py::arg("OS")
          )
        .def_static("ReadCurve2d_s",
                    (Standard_IStream & (*)( std::istream & ,  opencascade::handle<Geom2d_Curve> &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  opencascade::handle<Geom2d_Curve> &  ) >(&BinTools_Curve2dSet::ReadCurve2d),
                    R"#(Reads the curve from the stream. The curve is assumed to have been written with the Write method.)#"  , py::arg("IS"),  py::arg("C")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTools_CurveSet from ./opencascade/BinTools_CurveSet.hxx
    klass = m.attr("BinTools_CurveSet");


    // nested enums

    static_cast<py::class_<BinTools_CurveSet , shared_ptr<BinTools_CurveSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BinTools_CurveSet::*)() ) static_cast<void (BinTools_CurveSet::*)() >(&BinTools_CurveSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (BinTools_CurveSet::*)( const opencascade::handle<Geom_Curve> &  ) ) static_cast<Standard_Integer (BinTools_CurveSet::*)( const opencascade::handle<Geom_Curve> &  ) >(&BinTools_CurveSet::Add),
             R"#(Incorporate a new Curve in the set and returns its index.)#"  , py::arg("C")
          )
        .def("Curve",
             (opencascade::handle<Geom_Curve> (BinTools_CurveSet::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<Geom_Curve> (BinTools_CurveSet::*)( const Standard_Integer  ) const>(&BinTools_CurveSet::Curve),
             R"#(Returns the Curve of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (BinTools_CurveSet::*)( const opencascade::handle<Geom_Curve> &  ) const) static_cast<Standard_Integer (BinTools_CurveSet::*)( const opencascade::handle<Geom_Curve> &  ) const>(&BinTools_CurveSet::Index),
             R"#(Returns the index of <L>.)#"  , py::arg("C")
          )
        .def("Write",
             (void (BinTools_CurveSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const) static_cast<void (BinTools_CurveSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const>(&BinTools_CurveSet::Write),
             R"#(Writes the content of me on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (BinTools_CurveSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_CurveSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_CurveSet::Read),
             R"#(Reads the content of me from the stream <IS>. me is first cleared.)#"  , py::arg("IS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("WriteCurve_s",
                    (void (*)( const opencascade::handle<Geom_Curve> & ,  BinTools_OStream &  ) ) static_cast<void (*)( const opencascade::handle<Geom_Curve> & ,  BinTools_OStream &  ) >(&BinTools_CurveSet::WriteCurve),
                    R"#(Dumps the curve on the stream in binary format that can be read back.)#"  , py::arg("C"),  py::arg("OS")
          )
        .def_static("ReadCurve_s",
                    (Standard_IStream & (*)( std::istream & ,  opencascade::handle<Geom_Curve> &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  opencascade::handle<Geom_Curve> &  ) >(&BinTools_CurveSet::ReadCurve),
                    R"#(Reads the curve from the stream. The curve is assumed to have been written with the Write method)#"  , py::arg("IS"),  py::arg("C")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTools_IStream from ./opencascade/BinTools_IStream.hxx
    klass = m.attr("BinTools_IStream");


    // nested enums

    static_cast<py::class_<BinTools_IStream , shared_ptr<BinTools_IStream>  >>(klass)
    // constructors
        .def(py::init< std::istream & >()  , py::arg("theStream") )
    // custom constructors
    // methods
        .def("ReadType",
             (BinTools_ObjectType (BinTools_IStream::*)() ) static_cast<BinTools_ObjectType (BinTools_IStream::*)() >(&BinTools_IStream::ReadType),
             R"#(Reads and returns the type.)#" 
          )
        .def("ShapeType",
             (TopAbs_ShapeEnum (BinTools_IStream::*)() ) static_cast<TopAbs_ShapeEnum (BinTools_IStream::*)() >(&BinTools_IStream::ShapeType),
             R"#(Returns the shape type by the last retrieved type.)#" 
          )
        .def("ShapeOrientation",
             (TopAbs_Orientation (BinTools_IStream::*)() ) static_cast<TopAbs_Orientation (BinTools_IStream::*)() >(&BinTools_IStream::ShapeOrientation),
             R"#(Returns the shape orientation by the last retrieved type.)#" 
          )
        .def("Position",
             (uint64_t (BinTools_IStream::*)() ) static_cast<uint64_t (BinTools_IStream::*)() >(&BinTools_IStream::Position),
             R"#(Returns the current position in the stream.)#" 
          )
        .def("GoTo",
             (void (BinTools_IStream::*)( const uint64_t &  ) ) static_cast<void (BinTools_IStream::*)( const uint64_t &  ) >(&BinTools_IStream::GoTo),
             R"#(Moves the current stream position to the given one.)#"  , py::arg("thePosition")
          )
        .def("IsReference",
             (Standard_Boolean (BinTools_IStream::*)() ) static_cast<Standard_Boolean (BinTools_IStream::*)() >(&BinTools_IStream::IsReference),
             R"#(Returns true if the last restored type is one of a reference)#" 
          )
        .def("ReadReference",
             (uint64_t (BinTools_IStream::*)() ) static_cast<uint64_t (BinTools_IStream::*)() >(&BinTools_IStream::ReadReference),
             R"#(Reads a reference IStream using the last restored type.)#" 
          )
        .def("UpdatePosition",
             (void (BinTools_IStream::*)() ) static_cast<void (BinTools_IStream::*)() >(&BinTools_IStream::UpdatePosition),
             R"#(Makes up to date the myPosition because myStream was used outside and position is changed.)#" 
          )
        .def("ReadReal",
             (Standard_Real (BinTools_IStream::*)() ) static_cast<Standard_Real (BinTools_IStream::*)() >(&BinTools_IStream::ReadReal),
             R"#(Reads real value from the stream.)#" 
          )
        .def("ReadInteger",
             (Standard_Integer (BinTools_IStream::*)() ) static_cast<Standard_Integer (BinTools_IStream::*)() >(&BinTools_IStream::ReadInteger),
             R"#(Reads integer value from the stream.)#" 
          )
        .def("ReadPnt",
             (gp_Pnt (BinTools_IStream::*)() ) static_cast<gp_Pnt (BinTools_IStream::*)() >(&BinTools_IStream::ReadPnt),
             R"#(Reads point coordinates value from the stream.)#" 
          )
        .def("ReadByte",
             (Standard_Byte (BinTools_IStream::*)() ) static_cast<Standard_Byte (BinTools_IStream::*)() >(&BinTools_IStream::ReadByte),
             R"#(Reads byte value from the stream.)#" 
          )
        .def("ReadBool",
             (Standard_Boolean (BinTools_IStream::*)() ) static_cast<Standard_Boolean (BinTools_IStream::*)() >(&BinTools_IStream::ReadBool),
             R"#(Reads boolean value from the stream (stored as one byte).)#" 
          )
        .def("ReadShortReal",
             (Standard_ShortReal (BinTools_IStream::*)() ) static_cast<Standard_ShortReal (BinTools_IStream::*)() >(&BinTools_IStream::ReadShortReal),
             R"#(Reads short real value from the stream.)#" 
          )
    // methods using call by reference i.s.o. return
        .def("ReadBools",
             []( BinTools_IStream &self   ){
                 Standard_Boolean  theBool1;
                Standard_Boolean  theBool2;
                Standard_Boolean  theBool3;

                 self.ReadBools(theBool1,theBool2,theBool3);
                 
                 return std::make_tuple(theBool1,theBool2,theBool3); },
             R"#(Reads 3 boolean values from one byte)#" 
          )
        .def("ReadBools",
             []( BinTools_IStream &self   ){
                 Standard_Boolean  theBool1;
                Standard_Boolean  theBool2;
                Standard_Boolean  theBool3;
                Standard_Boolean  theBool4;
                Standard_Boolean  theBool5;
                Standard_Boolean  theBool6;
                Standard_Boolean  theBool7;

                 self.ReadBools(theBool1,theBool2,theBool3,theBool4,theBool5,theBool6,theBool7);
                 
                 return std::make_tuple(theBool1,theBool2,theBool3,theBool4,theBool5,theBool6,theBool7); },
             R"#(Reads 7 boolean values from one byte)#" 
          )
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("LastType",
             (const BinTools_ObjectType & (BinTools_IStream::*)() ) static_cast<const BinTools_ObjectType & (BinTools_IStream::*)() >(&BinTools_IStream::LastType),
             R"#(Returns the last read type.)#"
             
         )
       .def("Stream",
             (Standard_IStream & (BinTools_IStream::*)() ) static_cast<Standard_IStream & (BinTools_IStream::*)() >(&BinTools_IStream::Stream),
             R"#(Returns the original IStream.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class BinTools_LocationSet from ./opencascade/BinTools_LocationSet.hxx
    klass = m.attr("BinTools_LocationSet");


    // nested enums

    static_cast<py::class_<BinTools_LocationSet , shared_ptr<BinTools_LocationSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BinTools_LocationSet::*)() ) static_cast<void (BinTools_LocationSet::*)() >(&BinTools_LocationSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (BinTools_LocationSet::*)( const TopLoc_Location &  ) ) static_cast<Standard_Integer (BinTools_LocationSet::*)( const TopLoc_Location &  ) >(&BinTools_LocationSet::Add),
             R"#(Incorporate a new Location in the set and returns its index.)#"  , py::arg("L")
          )
        .def("Location",
             (const TopLoc_Location & (BinTools_LocationSet::*)( const Standard_Integer  ) const) static_cast<const TopLoc_Location & (BinTools_LocationSet::*)( const Standard_Integer  ) const>(&BinTools_LocationSet::Location),
             R"#(Returns the location of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (BinTools_LocationSet::*)( const TopLoc_Location &  ) const) static_cast<Standard_Integer (BinTools_LocationSet::*)( const TopLoc_Location &  ) const>(&BinTools_LocationSet::Index),
             R"#(Returns the index of <L>.)#"  , py::arg("L")
          )
        .def("NbLocations",
             (Standard_Integer (BinTools_LocationSet::*)() const) static_cast<Standard_Integer (BinTools_LocationSet::*)() const>(&BinTools_LocationSet::NbLocations),
             R"#(Returns number of locations.)#" 
          )
        .def("Write",
             (void (BinTools_LocationSet::*)( std::ostream &  ) const) static_cast<void (BinTools_LocationSet::*)( std::ostream &  ) const>(&BinTools_LocationSet::Write),
             R"#(Writes the content of me on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS")
          )
        .def("Read",
             (void (BinTools_LocationSet::*)( std::istream &  ) ) static_cast<void (BinTools_LocationSet::*)( std::istream &  ) >(&BinTools_LocationSet::Read),
             R"#(Reads the content of me from the stream <IS>. me is first cleared.)#"  , py::arg("IS")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTools_OStream from ./opencascade/BinTools_OStream.hxx
    klass = m.attr("BinTools_OStream");


    // nested enums

    static_cast<py::class_<BinTools_OStream , shared_ptr<BinTools_OStream>  >>(klass)
    // constructors
        .def(py::init< std::ostream & >()  , py::arg("theStream") )
    // custom constructors
    // methods
        .def("WriteReference",
             (void (BinTools_OStream::*)( const uint64_t &  ) ) static_cast<void (BinTools_OStream::*)( const uint64_t &  ) >(&BinTools_OStream::WriteReference),
             R"#(Writes the reference to the given position (an offset between the current and the given one).)#"  , py::arg("thePosition")
          )
        .def("WriteShape",
             (void (BinTools_OStream::*)( const TopAbs_ShapeEnum & ,  const TopAbs_Orientation &  ) ) static_cast<void (BinTools_OStream::*)( const TopAbs_ShapeEnum & ,  const TopAbs_Orientation &  ) >(&BinTools_OStream::WriteShape),
             R"#(Writes an identifier of shape type and orientation into the stream.)#"  , py::arg("theType"),  py::arg("theOrientation")
          )
        .def("PutBools",
             (void (BinTools_OStream::*)( const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) ) static_cast<void (BinTools_OStream::*)( const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) >(&BinTools_OStream::PutBools),
             R"#(Writes 3 booleans as one byte to the stream.)#"  , py::arg("theValue1"),  py::arg("theValue2"),  py::arg("theValue3")
          )
        .def("PutBools",
             (void (BinTools_OStream::*)( const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) ) static_cast<void (BinTools_OStream::*)( const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) >(&BinTools_OStream::PutBools),
             R"#(Writes 7 booleans as one byte to the stream.)#"  , py::arg("theValue1"),  py::arg("theValue2"),  py::arg("theValue3"),  py::arg("theValue4"),  py::arg("theValue5"),  py::arg("theValue6"),  py::arg("theValue7")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Position",
             (const uint64_t & (BinTools_OStream::*)() ) static_cast<const uint64_t & (BinTools_OStream::*)() >(&BinTools_OStream::Position),
             R"#(Returns the current position of the stream)#"
             
         )
;

    // Class BinTools_ShapeSetBase from ./opencascade/BinTools_ShapeSetBase.hxx
    klass = m.attr("BinTools_ShapeSetBase");


    // nested enums

    static_cast<py::class_<BinTools_ShapeSetBase , shared_ptr<BinTools_ShapeSetBase>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsWithTriangles",
             (Standard_Boolean (BinTools_ShapeSetBase::*)() const) static_cast<Standard_Boolean (BinTools_ShapeSetBase::*)() const>(&BinTools_ShapeSetBase::IsWithTriangles),
             R"#(Return true if shape should be stored with triangles.)#" 
          )
        .def("IsWithNormals",
             (Standard_Boolean (BinTools_ShapeSetBase::*)() const) static_cast<Standard_Boolean (BinTools_ShapeSetBase::*)() const>(&BinTools_ShapeSetBase::IsWithNormals),
             R"#(Return true if shape should be stored triangulation with normals.)#" 
          )
        .def("SetWithTriangles",
             (void (BinTools_ShapeSetBase::*)( const Standard_Boolean  ) ) static_cast<void (BinTools_ShapeSetBase::*)( const Standard_Boolean  ) >(&BinTools_ShapeSetBase::SetWithTriangles),
             R"#(Define if shape will be stored with triangles. Ignored (always written) if face defines only triangulation (no surface).)#"  , py::arg("theWithTriangles")
          )
        .def("SetWithNormals",
             (void (BinTools_ShapeSetBase::*)( const Standard_Boolean  ) ) static_cast<void (BinTools_ShapeSetBase::*)( const Standard_Boolean  ) >(&BinTools_ShapeSetBase::SetWithNormals),
             R"#(Define if shape will be stored triangulation with normals. Ignored (always written) if face defines only triangulation (no surface).)#"  , py::arg("theWithNormals")
          )
        .def("SetFormatNb",
             (void (BinTools_ShapeSetBase::*)( const Standard_Integer  ) ) static_cast<void (BinTools_ShapeSetBase::*)( const Standard_Integer  ) >(&BinTools_ShapeSetBase::SetFormatNb),
             R"#(Sets the BinTools_FormatVersion.)#"  , py::arg("theFormatNb")
          )
        .def("FormatNb",
             (Standard_Integer (BinTools_ShapeSetBase::*)() const) static_cast<Standard_Integer (BinTools_ShapeSetBase::*)() const>(&BinTools_ShapeSetBase::FormatNb),
             R"#(Returns the BinTools_FormatVersion.)#" 
          )
        .def("Clear",
             (void (BinTools_ShapeSetBase::*)() ) static_cast<void (BinTools_ShapeSetBase::*)() >(&BinTools_ShapeSetBase::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Write",
             (void (BinTools_ShapeSetBase::*)( std::ostream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSetBase::*)( std::ostream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSetBase::Write),
             R"#(Writes the content of me on the stream <OS> in binary format that can be read back by Read.)#"  , py::arg("arg"),  py::arg("arg")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (BinTools_ShapeSetBase::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSetBase::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSetBase::Read),
             R"#(Reads the content of me from the binary stream <IS>. me is first cleared.)#"  , py::arg("arg"),  py::arg("arg")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (void (BinTools_ShapeSetBase::*)( const TopoDS_Shape & ,  std::ostream &  ) ) static_cast<void (BinTools_ShapeSetBase::*)( const TopoDS_Shape & ,  std::ostream &  ) >(&BinTools_ShapeSetBase::Write),
             R"#(Writes on <OS> the shape <S>. Writes the orientation, the index of the TShape and the index of the Location.)#"  , py::arg("arg"),  py::arg("arg")
          )
        .def("Read",
             (void (BinTools_ShapeSetBase::*)( std::istream & ,  TopoDS_Shape &  ) ) static_cast<void (BinTools_ShapeSetBase::*)( std::istream & ,  TopoDS_Shape &  ) >(&BinTools_ShapeSetBase::Read),
             R"#(An empty virtual method for redefinition in shape-reader.)#"  , py::arg("arg"),  py::arg("arg")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTools_SurfaceSet from ./opencascade/BinTools_SurfaceSet.hxx
    klass = m.attr("BinTools_SurfaceSet");


    // nested enums

    static_cast<py::class_<BinTools_SurfaceSet , shared_ptr<BinTools_SurfaceSet>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BinTools_SurfaceSet::*)() ) static_cast<void (BinTools_SurfaceSet::*)() >(&BinTools_SurfaceSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (BinTools_SurfaceSet::*)( const opencascade::handle<Geom_Surface> &  ) ) static_cast<Standard_Integer (BinTools_SurfaceSet::*)( const opencascade::handle<Geom_Surface> &  ) >(&BinTools_SurfaceSet::Add),
             R"#(Incorporate a new Surface in the set and returns its index.)#"  , py::arg("S")
          )
        .def("Surface",
             (opencascade::handle<Geom_Surface> (BinTools_SurfaceSet::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<Geom_Surface> (BinTools_SurfaceSet::*)( const Standard_Integer  ) const>(&BinTools_SurfaceSet::Surface),
             R"#(Returns the Surface of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (BinTools_SurfaceSet::*)( const opencascade::handle<Geom_Surface> &  ) const) static_cast<Standard_Integer (BinTools_SurfaceSet::*)( const opencascade::handle<Geom_Surface> &  ) const>(&BinTools_SurfaceSet::Index),
             R"#(Returns the index of <L>.)#"  , py::arg("S")
          )
        .def("Write",
             (void (BinTools_SurfaceSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const) static_cast<void (BinTools_SurfaceSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const>(&BinTools_SurfaceSet::Write),
             R"#(Writes the content of me on the stream <OS> in binary format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (BinTools_SurfaceSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_SurfaceSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_SurfaceSet::Read),
             R"#(Reads the content of me from the stream <IS>. me is first cleared.)#"  , py::arg("IS"),  py::arg("therange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("WriteSurface_s",
                    (void (*)( const opencascade::handle<Geom_Surface> & ,  BinTools_OStream &  ) ) static_cast<void (*)( const opencascade::handle<Geom_Surface> & ,  BinTools_OStream &  ) >(&BinTools_SurfaceSet::WriteSurface),
                    R"#(Dumps the surface on the stream in binary format that can be read back.)#"  , py::arg("S"),  py::arg("OS")
          )
        .def_static("ReadSurface_s",
                    (Standard_IStream & (*)( std::istream & ,  opencascade::handle<Geom_Surface> &  ) ) static_cast<Standard_IStream & (*)( std::istream & ,  opencascade::handle<Geom_Surface> &  ) >(&BinTools_SurfaceSet::ReadSurface),
                    R"#(Reads the surface from the stream. The surface is assumed to have been written with the Write method.)#"  , py::arg("IS"),  py::arg("S")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTools_ShapeReader from ./opencascade/BinTools_ShapeReader.hxx
    klass = m.attr("BinTools_ShapeReader");


    // nested enums

    static_cast<py::class_<BinTools_ShapeReader , shared_ptr<BinTools_ShapeReader>  , BinTools_ShapeSetBase >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BinTools_ShapeReader::*)() ) static_cast<void (BinTools_ShapeReader::*)() >(&BinTools_ShapeReader::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Read",
             (void (BinTools_ShapeReader::*)( std::istream & ,  TopoDS_Shape &  ) ) static_cast<void (BinTools_ShapeReader::*)( std::istream & ,  TopoDS_Shape &  ) >(&BinTools_ShapeReader::Read),
             R"#(Reads the shape from stream using previously restored shapes and objects by references.)#"  , py::arg("theStream"),  py::arg("theShape")
          )
        .def("ReadLocation",
             (const TopLoc_Location * (BinTools_ShapeReader::*)( BinTools_IStream &  ) ) static_cast<const TopLoc_Location * (BinTools_ShapeReader::*)( BinTools_IStream &  ) >(&BinTools_ShapeReader::ReadLocation),
             R"#(Reads location from the stream.)#"  , py::arg("theStream")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTools_ShapeSet from ./opencascade/BinTools_ShapeSet.hxx
    klass = m.attr("BinTools_ShapeSet");


    // nested enums

    static_cast<py::class_<BinTools_ShapeSet , shared_ptr<BinTools_ShapeSet>  , BinTools_ShapeSetBase >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BinTools_ShapeSet::*)() ) static_cast<void (BinTools_ShapeSet::*)() >(&BinTools_ShapeSet::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Add",
             (Standard_Integer (BinTools_ShapeSet::*)( const TopoDS_Shape &  ) ) static_cast<Standard_Integer (BinTools_ShapeSet::*)( const TopoDS_Shape &  ) >(&BinTools_ShapeSet::Add),
             R"#(Stores <S> and its sub-shape. Returns the index of <S>. The method AddGeometry is called on each sub-shape.)#"  , py::arg("S")
          )
        .def("Shape",
             (const TopoDS_Shape & (BinTools_ShapeSet::*)( const Standard_Integer  ) ) static_cast<const TopoDS_Shape & (BinTools_ShapeSet::*)( const Standard_Integer  ) >(&BinTools_ShapeSet::Shape),
             R"#(Returns the sub-shape of index <I>.)#"  , py::arg("I")
          )
        .def("Index",
             (Standard_Integer (BinTools_ShapeSet::*)( const TopoDS_Shape &  ) const) static_cast<Standard_Integer (BinTools_ShapeSet::*)( const TopoDS_Shape &  ) const>(&BinTools_ShapeSet::Index),
             R"#(Returns the index of <S>.)#"  , py::arg("S")
          )
        .def("NbShapes",
             (Standard_Integer (BinTools_ShapeSet::*)() const) static_cast<Standard_Integer (BinTools_ShapeSet::*)() const>(&BinTools_ShapeSet::NbShapes),
             R"#(Returns number of shapes read from file.)#" 
          )
        .def("Write",
             (void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSet::Write),
             R"#(Writes the content of me on the stream <OS> in binary format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSet::Read),
             R"#(Reads the content of me from the binary stream <IS>. me is first cleared.)#"  , py::arg("IS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (void (BinTools_ShapeSet::*)( const TopoDS_Shape & ,  std::ostream &  ) ) static_cast<void (BinTools_ShapeSet::*)( const TopoDS_Shape & ,  std::ostream &  ) >(&BinTools_ShapeSet::Write),
             R"#(Writes on <OS> the shape <S>. Writes the orientation, the index of the TShape and the index of the Location.)#"  , py::arg("S"),  py::arg("OS")
          )
        .def("WriteGeometry",
             (void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const) static_cast<void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const>(&BinTools_ShapeSet::WriteGeometry),
             R"#(Writes the geometry of me on the stream <OS> in a binary format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ReadGeometry",
             (void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSet::ReadGeometry),
             R"#(Reads the geometry of me from the stream <IS>.)#"  , py::arg("IS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ReadFlagsAndSubs",
             (void (BinTools_ShapeSet::*)( TopoDS_Shape & ,  const TopAbs_ShapeEnum ,  std::istream & ,  const Standard_Integer  ) ) static_cast<void (BinTools_ShapeSet::*)( TopoDS_Shape & ,  const TopAbs_ShapeEnum ,  std::istream & ,  const Standard_Integer  ) >(&BinTools_ShapeSet::ReadFlagsAndSubs),
             R"#(Reads from <IS> a shape flags and sub-shapes and modifies S.)#"  , py::arg("S"),  py::arg("T"),  py::arg("IS"),  py::arg("NbShapes")
          )
        .def("ReadSubs",
             (void (BinTools_ShapeSet::*)( TopoDS_Shape & ,  std::istream & ,  const Standard_Integer  ) ) static_cast<void (BinTools_ShapeSet::*)( TopoDS_Shape & ,  std::istream & ,  const Standard_Integer  ) >(&BinTools_ShapeSet::ReadSubs),
             R"#(Reads from <IS> a shape and returns it in S. <NbShapes> is the number of tshapes in the set.)#"  , py::arg("S"),  py::arg("IS"),  py::arg("NbShapes")
          )
        .def("Read",
             (void (BinTools_ShapeSet::*)( std::istream & ,  TopoDS_Shape &  ) ) static_cast<void (BinTools_ShapeSet::*)( std::istream & ,  TopoDS_Shape &  ) >(&BinTools_ShapeSet::Read),
             R"#(An empty virtual method for redefinition in shape-reader.)#"  , py::arg("arg"),  py::arg("arg")
          )
        .def("WriteShape",
             (void (BinTools_ShapeSet::*)( const TopoDS_Shape & ,  std::ostream &  ) const) static_cast<void (BinTools_ShapeSet::*)( const TopoDS_Shape & ,  std::ostream &  ) const>(&BinTools_ShapeSet::WriteShape),
             R"#(Writes the shape <S> on the stream <OS> in a binary format that can be read back by Read.)#"  , py::arg("S"),  py::arg("OS")
          )
        .def("ReadShape",
             (void (BinTools_ShapeSet::*)( const TopAbs_ShapeEnum ,  std::istream & ,  TopoDS_Shape &  ) ) static_cast<void (BinTools_ShapeSet::*)( const TopAbs_ShapeEnum ,  std::istream & ,  TopoDS_Shape &  ) >(&BinTools_ShapeSet::ReadShape),
             R"#(Reads a shape of type <T> from the stream <IS> and returns it in <S>.)#"  , py::arg("T"),  py::arg("IS"),  py::arg("S")
          )
        .def("AddShape",
             (void (BinTools_ShapeSet::*)( const TopoDS_Shape &  ) ) static_cast<void (BinTools_ShapeSet::*)( const TopoDS_Shape &  ) >(&BinTools_ShapeSet::AddShape),
             R"#(Stores the shape <S>.)#"  , py::arg("S")
          )
        .def("AddShapes",
             (void (BinTools_ShapeSet::*)( TopoDS_Shape & ,  const TopoDS_Shape &  ) ) static_cast<void (BinTools_ShapeSet::*)( TopoDS_Shape & ,  const TopoDS_Shape &  ) >(&BinTools_ShapeSet::AddShapes),
             R"#(Inserts the shape <S2> in the shape <S1>.)#"  , py::arg("S1"),  py::arg("S2")
          )
        .def("ReadPolygon3D",
             (void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSet::ReadPolygon3D),
             R"#(Reads the 3d polygons of me from the stream <IS>.)#"  , py::arg("IS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("WritePolygon3D",
             (void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const) static_cast<void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const>(&BinTools_ShapeSet::WritePolygon3D),
             R"#(Writes the 3d polygons on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ReadTriangulation",
             (void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSet::ReadTriangulation),
             R"#(Reads the triangulation of me from the stream <IS>.)#"  , py::arg("IS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("WriteTriangulation",
             (void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const) static_cast<void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const>(&BinTools_ShapeSet::WriteTriangulation),
             R"#(Writes the triangulation on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("ReadPolygonOnTriangulation",
             (void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) ) static_cast<void (BinTools_ShapeSet::*)( std::istream & ,  const Message_ProgressRange &  ) >(&BinTools_ShapeSet::ReadPolygonOnTriangulation),
             R"#(Reads the polygons on triangulation of me from the stream <IS>.)#"  , py::arg("IS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("WritePolygonOnTriangulation",
             (void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const) static_cast<void (BinTools_ShapeSet::*)( std::ostream & ,  const Message_ProgressRange &  ) const>(&BinTools_ShapeSet::WritePolygonOnTriangulation),
             R"#(Writes the polygons on triangulation on the stream <OS> in a format that can be read back by Read.)#"  , py::arg("OS"),  py::arg("theRange")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Locations",
             (const BinTools_LocationSet & (BinTools_ShapeSet::*)() const) static_cast<const BinTools_LocationSet & (BinTools_ShapeSet::*)() const>(&BinTools_ShapeSet::Locations),
             R"#(None)#"
             
         )
       .def("ChangeLocations",
             (BinTools_LocationSet & (BinTools_ShapeSet::*)() ) static_cast<BinTools_LocationSet & (BinTools_ShapeSet::*)() >(&BinTools_ShapeSet::ChangeLocations),
             R"#(None)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class BinTools_ShapeWriter from ./opencascade/BinTools_ShapeWriter.hxx
    klass = m.attr("BinTools_ShapeWriter");


    // nested enums

    static_cast<py::class_<BinTools_ShapeWriter , shared_ptr<BinTools_ShapeWriter>  , BinTools_ShapeSetBase >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Clear",
             (void (BinTools_ShapeWriter::*)() ) static_cast<void (BinTools_ShapeWriter::*)() >(&BinTools_ShapeWriter::Clear),
             R"#(Clears the content of the set.)#" 
          )
        .def("Write",
             (void (BinTools_ShapeWriter::*)( const TopoDS_Shape & ,  std::ostream &  ) ) static_cast<void (BinTools_ShapeWriter::*)( const TopoDS_Shape & ,  std::ostream &  ) >(&BinTools_ShapeWriter::Write),
             R"#(Writes the shape to stream using previously stored shapes and objects to refer them.)#"  , py::arg("theShape"),  py::arg("theStream")
          )
        .def("WriteLocation",
             (void (BinTools_ShapeWriter::*)( BinTools_OStream & ,  const TopLoc_Location &  ) ) static_cast<void (BinTools_ShapeWriter::*)( BinTools_OStream & ,  const TopLoc_Location &  ) >(&BinTools_ShapeWriter::WriteLocation),
             R"#(Writes location to the stream (all the needed sub-information or reference if it is already used).)#"  , py::arg("theStream"),  py::arg("theLocation")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/BinTools.hxx
// ./opencascade/BinTools_Curve2dSet.hxx
// ./opencascade/BinTools_CurveSet.hxx
// ./opencascade/BinTools_FormatVersion.hxx
// ./opencascade/BinTools_IStream.hxx
// ./opencascade/BinTools_LocationSet.hxx
// ./opencascade/BinTools_LocationSetPtr.hxx
// ./opencascade/BinTools_OStream.hxx
// ./opencascade/BinTools_ObjectType.hxx
// ./opencascade/BinTools_ShapeReader.hxx
// ./opencascade/BinTools_ShapeSet.hxx
// ./opencascade/BinTools_ShapeSetBase.hxx
// ./opencascade/BinTools_ShapeWriter.hxx
// ./opencascade/BinTools_SurfaceSet.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
