% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/acquireFile.R
\name{acquireFile}
\alias{acquireFile}
\alias{acquireMetadata}
\alias{acquireFile,character-method}
\alias{acquireMetadata,character-method}
\title{Acquire file or metadata}
\usage{
acquireFile(project, path)

acquireMetadata(project, path)

\S4method{acquireFile}{character}(project, path)

\S4method{acquireMetadata}{character}(project, path)
}
\arguments{
\item{project}{Any value specifying the project of interest.
The default methods expect a string containing a path to a staging directory,
but other objects can be used to control dispatch.}

\item{path}{String containing a relative path to a resource inside the staging directory.}
}
\value{
\code{acquireFile} methods return a local path to the file corresponding to the requested resource.

\code{acquireMetadata} methods return a named list of metadata for the requested resource.
}
\description{
\emph{WARNING: these functions are deprecated. 
Applications are expected to handle acquisition of files before loaders are called.}
Acquire a file or metadata for loading.
As one might expect, these are typically used inside a \code{load*} function.
}
\details{
By default, files and metadata are loaded from the same staging directory that is written to by \code{\link{stageObject}}.
alabaster applications can define custom methods to obtain the files and metadata from a different location, e.g., remote databases.
This is achieved by dispatching on a different class of \code{project}.

Each custom acquisition method should take two arguments.
The first argument is an R object representing some concept of a \dQuote{project}.
In the default case, this is a string containing a path to the staging directory representing the project.
However, it can be anything, e.g., a number containing a database identifier, a list of identifiers and versions, and so on -
as long as the custom acquisition method is capable of understanding it, the \code{load*} functions don't care.

The second argument is a string containing the relative path to the resource inside that project.
This should be the path to a specific file inside the project, not the subdirectory containing the file.
More concretely, it should be equivalent to the \code{path} in the \emph{output} of \code{\link{stageObject}},
not the path to the subdirectory used as the input to the same function.

The return value for each custom acquisition function should be the same as their local counterparts.
That is, any custom file acquisition function should return a file path,
and any custom metadata acquisition function should return a naamed list of metadata.
}
\examples{
# Staging an example DataFrame:
library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])
tmp <- tempfile()
dir.create(tmp)
info <- stageObject(df, tmp, path="coldata")
writeMetadata(info, tmp)

# Retrieving the metadata:
meta <- acquireMetadata(tmp, "coldata/simple.csv.gz")
str(meta)

# Retrieving the file:
acquireFile(tmp, "coldata/simple.csv.gz")

}
\author{
Aaron Lun
}
