% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-sf.R
\name{sf_transform_xy}
\alias{sf_transform_xy}
\title{Transform spatial position data}
\usage{
sf_transform_xy(data, target_crs, source_crs, authority_compliant = FALSE)
}
\arguments{
\item{data}{Data frame or list containing numerical columns \code{x} and \code{y}.}

\item{target_crs, source_crs}{Target and source coordinate reference systems.
If \code{NULL} or \code{NA}, the data is not transformed.}

\item{authority_compliant}{logical; \code{TRUE} means handle axis order authority
compliant (e.g. EPSG:4326 implying \code{x = lat}, \code{y = lon}), \code{FALSE} means use
visualisation order (i.e. always \code{x = lon}, \code{y = lat}). Default is \code{FALSE}.}
}
\value{
A copy of the input data with \code{x} and \code{y} replaced by transformed values.
}
\description{
Helper function that can transform spatial position data (pairs of x, y
values) among coordinate systems. This is implemented as a thin wrapper
around \code{\link[sf:sf_project]{sf::sf_project()}}.
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
# location of cities in NC by long (x) and lat (y)
data <- data.frame(
  city = c("Charlotte", "Raleigh", "Greensboro"),
  x =  c(-80.843, -78.639, -79.792),
  y = c(35.227, 35.772, 36.073)
)

# transform to projected coordinates
data_proj <- sf_transform_xy(data, 3347, 4326)
data_proj

# transform back
sf_transform_xy(data_proj, 4326, 3347)
}
}
\keyword{internal}
