% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_attr_def.R
\name{wm_attr_def}
\alias{wm_attr_def}
\alias{wm_attr_def_}
\title{Get attribute definition by ID}
\usage{
wm_attr_def(id, include_inherited = FALSE, ...)

wm_attr_def_(id = NULL, name = NULL, ...)
}
\arguments{
\item{id}{(numeric/integer) an attribute ID. For \code{wm_attr_def} it's
required and must be \code{length(id) == 1}, for \code{wm_attr_def_} it's
optional and can be \code{length(id) >= 1}}

\item{include_inherited}{(logical) Include attributes inherited from
its parent taxon. Default: \code{FALSE}}

\item{...}{named curl options. see \code{curl::curl_options}}

\item{name}{(character) one or more taxonomic names. optional}
}
\value{
A tibble/data.frame. when using underscore method, outputs from
each input are binded together, but can be split by \code{id} column
}
\description{
Get attribute definition by ID
}
\section{Singular vs. plural}{

Of the two sister functions, the one without the underscore is the original
function that wraps the relavant WoRMS API method - and only accepts
one thing (i.e., name or AphiaID) per request.

The sister function with the underscore at the end is the plural version,
accepting more than one input. Internally this function loops over
the non-underscore method, and labels output (whether it's a list or
data.frame rows) with the input names or IDs so that you can easily
parse output by your inputs.
}

\examples{
\dontrun{
wm_attr_def(id = 1)
wm_attr_def(id = 4)
wm_attr_def(id = 4, include_inherited = TRUE)

wm_attr_def_(id = c(4, 1))
}
}
