# Announce: Rakudo compiler, Release #166 (2023.11)

On behalf of the Rakudo development team, I’m very happy to announce the
November 2023 release of Rakudo #166. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2023.11:

+ Improvements:
    + Don't open handles when calling Distribution.content [9db25993]
    + Use new stat-time-nanos syscall (in IO::Path) [cc15340f]

+ Additions:
    + Add :slang argument to Cool.AST [4707dc5a]
    + Add L10N::PT [d1812ff1]
    + Add "Sonoma" as known MacOS description (for v14 in Distro) [08b35312]
    + Add Raku.legacy implementation-detail class method [a9da976e]

+ Fixes:
    + Check if requested backtrace is null (fixes jvm bug) [76bfebf5]
    + (Re-)align backtraces on JVM with MoarVM [53a79941]
    + Fix handling of dynamic containers on 6.e PseudoStash [0479e2fd]
    + Make sure that "no actions" really means it (in grammars) [bd2c719e]
    + Replace incorrect CoC report link [2846ea59]
    + Fix some aspects of using "is default" [8b800e02][c0b19bec][4b7a9bf6]
      [d32b729a][c34d60b6]
    + Fix X::Hash::Store::OddNumber message with undefined last element [f29cecfa]
    + Fix a regression where exception is thrown for a generic type [49ddf5fe]

+ Removals:
    + Remove largely unknown flags from installed raku script shims [bdd77290]

+ Internal:
    + Make sure t/13-localization tests are actually run [f3a7c045]
    + Add test for Unicode 15.1 [bd53ad25]

+ RakuAST Development:
    + A lot of work was done on RakuAST development (over 100 commits), raising
      the number of passing spectest files from 975 to 981 (out of 1358).

      [86458273][ed97a478][5567dd45][8b659b55][47585807][711032b0][9b6c660d]
      [b5c9c9b3][fe8123d0][92ed414c][f712bdf8][c0eb6b6f][45b1a26b][bd5a28c9]
      [05a2c26e][d8d79a32][36844606][2b365ac9][9a115ba4][7fcbfd65][60f4b8b9]
      [f1de73e9][790c7ac9][7a3b2bec][3a44581f][090e6f51][6a991a02][06d9773e]
      [f6e7475b][efe05847][63fd90ac][fcde2745][ec8628c5][5e3f8f33][4ef932fd]
      [57ea28d1][e008984a][30b944e7][d6b33aef][a992d305][94caf95a][464ffab3]
      [98f71865][7049370f][f6c41fcc][42f402c9][70b477ba][4b5333bf][33a6bccf]
      [3fea4738][18551ef9][a186dd05][a3baa9df][688b625a][c727c2ae][4a5e0181]
      [9ca11986][0fb3d809][1623e67e][1d626078][6d64ee39][95973945][974c48bb]
      [24fdf40c][d6de1390][89f58733][b689ae07][4d4e2a8a][8e096c24][721906f6]
      [ec57a59f][aff290da][cf3feb58][3d91a34c][b468d243][30697fea][fd99f6dc]
      [12a13c48][92522e89][50b8e191][dc85a994][37fbee11][f53c6505][e8b49542]
      [2f59eeeb][37e8d29f][9438ef1a][ad87284a][d7c64bdb][349ee9c2][d47c8feb]
      [98da5961][d15cec91][356faf99][f2c39412][a3bbb380][b224a091][f20f7eee]
      [41b4a971][16526185][50bd91f0]

The following people contributed to this release:

Elizabeth Mattijsen, Vadim Belman, Christian Bartolomäus, ab5tract,
Nick Logan, Daniel Green, Daniel Sockwell, Will Coleda, Justin DeVuyst,
Dan Vu, Fernando Corrêa de Oliveira, Jan-Olof Hendig, Patrick Böker,
Stefan Seifert, rir

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2023 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#167), is tentatively scheduled for 2023-12-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
