#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum BidiClass {
  LeftToRight, RightToLeft, ArabicLetter, EuropeanNumber, EuropeanSeparator,
  EuropeanTerminator, ArabicNumber, CommonSeparator, NonspacingMark,
  BoundaryNeutral, ParagraphSeparator, SegmentSeparator, WhiteSpace,
  OtherNeutral, LeftToRightEmbedding, LeftToRightOverride, RightToLeftEmbedding,
  RightToLeftOverride, PopDirectionalFormat, LeftToRightIsolate,
  RightToLeftIsolate, FirstStrongIsolate, PopDirectionalIsolate
}

pub static UCD_BIDI_CLASS: &'static [((u8,u8,u8), (u8,u8,u8), BidiClass)] = &[
  ((0,0,0),(0,0,8),BidiClass::BoundaryNeutral),
  ((0,0,9),(0,0,9),BidiClass::SegmentSeparator),
  ((0,0,10),(0,0,10),BidiClass::ParagraphSeparator),
  ((0,0,11),(0,0,11),BidiClass::SegmentSeparator),
  ((0,0,12),(0,0,12),BidiClass::WhiteSpace),
  ((0,0,13),(0,0,13),BidiClass::ParagraphSeparator),
  ((0,0,14),(0,0,27),BidiClass::BoundaryNeutral),
  ((0,0,28),(0,0,30),BidiClass::ParagraphSeparator),
  ((0,0,31),(0,0,31),BidiClass::SegmentSeparator),
  ((0,0,32),(0,0,32),BidiClass::WhiteSpace),
  ((0,0,33),(0,0,34),BidiClass::OtherNeutral),
  ((0,0,35),(0,0,37),BidiClass::EuropeanTerminator),
  ((0,0,38),(0,0,42),BidiClass::OtherNeutral),
  ((0,0,43),(0,0,43),BidiClass::EuropeanSeparator),
  ((0,0,44),(0,0,44),BidiClass::CommonSeparator),
  ((0,0,45),(0,0,45),BidiClass::EuropeanSeparator),
  ((0,0,46),(0,0,47),BidiClass::CommonSeparator),
  ((0,0,48),(0,0,57),BidiClass::EuropeanNumber),
  ((0,0,58),(0,0,58),BidiClass::CommonSeparator),
  ((0,0,59),(0,0,64),BidiClass::OtherNeutral),
  ((0,0,91),(0,0,96),BidiClass::OtherNeutral),
  ((0,0,123),(0,0,126),BidiClass::OtherNeutral),
  ((0,0,127),(0,0,132),BidiClass::BoundaryNeutral),
  ((0,0,133),(0,0,133),BidiClass::ParagraphSeparator),
  ((0,0,134),(0,0,159),BidiClass::BoundaryNeutral),
  ((0,0,160),(0,0,160),BidiClass::CommonSeparator),
  ((0,0,161),(0,0,161),BidiClass::OtherNeutral),
  ((0,0,162),(0,0,165),BidiClass::EuropeanTerminator),
  ((0,0,166),(0,0,169),BidiClass::OtherNeutral),
  ((0,0,171),(0,0,172),BidiClass::OtherNeutral),
  ((0,0,173),(0,0,173),BidiClass::BoundaryNeutral),
  ((0,0,174),(0,0,175),BidiClass::OtherNeutral),
  ((0,0,176),(0,0,177),BidiClass::EuropeanTerminator),
  ((0,0,178),(0,0,179),BidiClass::EuropeanNumber),
  ((0,0,180),(0,0,180),BidiClass::OtherNeutral),
  ((0,0,182),(0,0,184),BidiClass::OtherNeutral),
  ((0,0,185),(0,0,185),BidiClass::EuropeanNumber),
  ((0,0,187),(0,0,191),BidiClass::OtherNeutral),
  ((0,0,215),(0,0,215),BidiClass::OtherNeutral),
  ((0,0,247),(0,0,247),BidiClass::OtherNeutral),
  ((0,2,185),(0,2,186),BidiClass::OtherNeutral),
  ((0,2,194),(0,2,207),BidiClass::OtherNeutral),
  ((0,2,210),(0,2,223),BidiClass::OtherNeutral),
  ((0,2,229),(0,2,237),BidiClass::OtherNeutral),
  ((0,2,239),(0,2,255),BidiClass::OtherNeutral),
  ((0,3,0),(0,3,111),BidiClass::NonspacingMark),
  ((0,3,116),(0,3,117),BidiClass::OtherNeutral),
  ((0,3,126),(0,3,126),BidiClass::OtherNeutral),
  ((0,3,132),(0,3,133),BidiClass::OtherNeutral),
  ((0,3,135),(0,3,135),BidiClass::OtherNeutral),
  ((0,3,246),(0,3,246),BidiClass::OtherNeutral),
  ((0,4,131),(0,4,137),BidiClass::NonspacingMark),
  ((0,5,138),(0,5,138),BidiClass::OtherNeutral),
  ((0,5,141),(0,5,142),BidiClass::OtherNeutral),
  ((0,5,143),(0,5,143),BidiClass::EuropeanTerminator),
  ((0,5,144),(0,5,144),BidiClass::RightToLeft),
  ((0,5,145),(0,5,189),BidiClass::NonspacingMark),
  ((0,5,190),(0,5,190),BidiClass::RightToLeft),
  ((0,5,191),(0,5,191),BidiClass::NonspacingMark),
  ((0,5,192),(0,5,192),BidiClass::RightToLeft),
  ((0,5,193),(0,5,194),BidiClass::NonspacingMark),
  ((0,5,195),(0,5,195),BidiClass::RightToLeft),
  ((0,5,196),(0,5,197),BidiClass::NonspacingMark),
  ((0,5,198),(0,5,198),BidiClass::RightToLeft),
  ((0,5,199),(0,5,199),BidiClass::NonspacingMark),
  ((0,5,200),(0,5,255),BidiClass::RightToLeft),
  ((0,6,0),(0,6,5),BidiClass::ArabicNumber),
  ((0,6,6),(0,6,7),BidiClass::OtherNeutral),
  ((0,6,8),(0,6,8),BidiClass::ArabicLetter),
  ((0,6,9),(0,6,10),BidiClass::EuropeanTerminator),
  ((0,6,11),(0,6,11),BidiClass::ArabicLetter),
  ((0,6,12),(0,6,12),BidiClass::CommonSeparator),
  ((0,6,13),(0,6,13),BidiClass::ArabicLetter),
  ((0,6,14),(0,6,15),BidiClass::OtherNeutral),
  ((0,6,16),(0,6,26),BidiClass::NonspacingMark),
  ((0,6,27),(0,6,74),BidiClass::ArabicLetter),
  ((0,6,75),(0,6,95),BidiClass::NonspacingMark),
  ((0,6,96),(0,6,105),BidiClass::ArabicNumber),
  ((0,6,106),(0,6,106),BidiClass::EuropeanTerminator),
  ((0,6,107),(0,6,108),BidiClass::ArabicNumber),
  ((0,6,109),(0,6,111),BidiClass::ArabicLetter),
  ((0,6,112),(0,6,112),BidiClass::NonspacingMark),
  ((0,6,113),(0,6,213),BidiClass::ArabicLetter),
  ((0,6,214),(0,6,220),BidiClass::NonspacingMark),
  ((0,6,221),(0,6,221),BidiClass::ArabicNumber),
  ((0,6,222),(0,6,222),BidiClass::OtherNeutral),
  ((0,6,223),(0,6,228),BidiClass::NonspacingMark),
  ((0,6,229),(0,6,230),BidiClass::ArabicLetter),
  ((0,6,231),(0,6,232),BidiClass::NonspacingMark),
  ((0,6,233),(0,6,233),BidiClass::OtherNeutral),
  ((0,6,234),(0,6,237),BidiClass::NonspacingMark),
  ((0,6,238),(0,6,239),BidiClass::ArabicLetter),
  ((0,6,240),(0,6,249),BidiClass::EuropeanNumber),
  ((0,6,250),(0,7,16),BidiClass::ArabicLetter),
  ((0,7,17),(0,7,17),BidiClass::NonspacingMark),
  ((0,7,18),(0,7,47),BidiClass::ArabicLetter),
  ((0,7,48),(0,7,74),BidiClass::NonspacingMark),
  ((0,7,75),(0,7,165),BidiClass::ArabicLetter),
  ((0,7,166),(0,7,176),BidiClass::NonspacingMark),
  ((0,7,177),(0,7,191),BidiClass::ArabicLetter),
  ((0,7,192),(0,7,234),BidiClass::RightToLeft),
  ((0,7,235),(0,7,243),BidiClass::NonspacingMark),
  ((0,7,244),(0,7,245),BidiClass::RightToLeft),
  ((0,7,246),(0,7,249),BidiClass::OtherNeutral),
  ((0,7,250),(0,8,21),BidiClass::RightToLeft),
  ((0,8,22),(0,8,25),BidiClass::NonspacingMark),
  ((0,8,26),(0,8,26),BidiClass::RightToLeft),
  ((0,8,27),(0,8,35),BidiClass::NonspacingMark),
  ((0,8,36),(0,8,36),BidiClass::RightToLeft),
  ((0,8,37),(0,8,39),BidiClass::NonspacingMark),
  ((0,8,40),(0,8,40),BidiClass::RightToLeft),
  ((0,8,41),(0,8,45),BidiClass::NonspacingMark),
  ((0,8,46),(0,8,88),BidiClass::RightToLeft),
  ((0,8,89),(0,8,91),BidiClass::NonspacingMark),
  ((0,8,92),(0,8,159),BidiClass::RightToLeft),
  ((0,8,160),(0,8,211),BidiClass::ArabicLetter),
  ((0,8,212),(0,8,225),BidiClass::NonspacingMark),
  ((0,8,226),(0,8,226),BidiClass::ArabicNumber),
  ((0,8,227),(0,9,2),BidiClass::NonspacingMark),
  ((0,9,58),(0,9,58),BidiClass::NonspacingMark),
  ((0,9,60),(0,9,60),BidiClass::NonspacingMark),
  ((0,9,65),(0,9,72),BidiClass::NonspacingMark),
  ((0,9,77),(0,9,77),BidiClass::NonspacingMark),
  ((0,9,81),(0,9,87),BidiClass::NonspacingMark),
  ((0,9,98),(0,9,99),BidiClass::NonspacingMark),
  ((0,9,129),(0,9,129),BidiClass::NonspacingMark),
  ((0,9,188),(0,9,188),BidiClass::NonspacingMark),
  ((0,9,193),(0,9,196),BidiClass::NonspacingMark),
  ((0,9,205),(0,9,205),BidiClass::NonspacingMark),
  ((0,9,226),(0,9,227),BidiClass::NonspacingMark),
  ((0,9,242),(0,9,243),BidiClass::EuropeanTerminator),
  ((0,9,251),(0,9,251),BidiClass::EuropeanTerminator),
  ((0,10,1),(0,10,2),BidiClass::NonspacingMark),
  ((0,10,60),(0,10,60),BidiClass::NonspacingMark),
  ((0,10,65),(0,10,66),BidiClass::NonspacingMark),
  ((0,10,71),(0,10,72),BidiClass::NonspacingMark),
  ((0,10,75),(0,10,77),BidiClass::NonspacingMark),
  ((0,10,81),(0,10,81),BidiClass::NonspacingMark),
  ((0,10,112),(0,10,113),BidiClass::NonspacingMark),
  ((0,10,117),(0,10,117),BidiClass::NonspacingMark),
  ((0,10,129),(0,10,130),BidiClass::NonspacingMark),
  ((0,10,188),(0,10,188),BidiClass::NonspacingMark),
  ((0,10,193),(0,10,197),BidiClass::NonspacingMark),
  ((0,10,199),(0,10,200),BidiClass::NonspacingMark),
  ((0,10,205),(0,10,205),BidiClass::NonspacingMark),
  ((0,10,226),(0,10,227),BidiClass::NonspacingMark),
  ((0,10,241),(0,10,241),BidiClass::EuropeanTerminator),
  ((0,11,1),(0,11,1),BidiClass::NonspacingMark),
  ((0,11,60),(0,11,60),BidiClass::NonspacingMark),
  ((0,11,63),(0,11,63),BidiClass::NonspacingMark),
  ((0,11,65),(0,11,68),BidiClass::NonspacingMark),
  ((0,11,77),(0,11,77),BidiClass::NonspacingMark),
  ((0,11,86),(0,11,86),BidiClass::NonspacingMark),
  ((0,11,98),(0,11,99),BidiClass::NonspacingMark),
  ((0,11,130),(0,11,130),BidiClass::NonspacingMark),
  ((0,11,192),(0,11,192),BidiClass::NonspacingMark),
  ((0,11,205),(0,11,205),BidiClass::NonspacingMark),
  ((0,11,243),(0,11,248),BidiClass::OtherNeutral),
  ((0,11,249),(0,11,249),BidiClass::EuropeanTerminator),
  ((0,11,250),(0,11,250),BidiClass::OtherNeutral),
  ((0,12,0),(0,12,0),BidiClass::NonspacingMark),
  ((0,12,62),(0,12,64),BidiClass::NonspacingMark),
  ((0,12,70),(0,12,72),BidiClass::NonspacingMark),
  ((0,12,74),(0,12,77),BidiClass::NonspacingMark),
  ((0,12,85),(0,12,86),BidiClass::NonspacingMark),
  ((0,12,98),(0,12,99),BidiClass::NonspacingMark),
  ((0,12,120),(0,12,126),BidiClass::OtherNeutral),
  ((0,12,129),(0,12,129),BidiClass::NonspacingMark),
  ((0,12,188),(0,12,188),BidiClass::NonspacingMark),
  ((0,12,204),(0,12,205),BidiClass::NonspacingMark),
  ((0,12,226),(0,12,227),BidiClass::NonspacingMark),
  ((0,13,1),(0,13,1),BidiClass::NonspacingMark),
  ((0,13,65),(0,13,68),BidiClass::NonspacingMark),
  ((0,13,77),(0,13,77),BidiClass::NonspacingMark),
  ((0,13,98),(0,13,99),BidiClass::NonspacingMark),
  ((0,13,202),(0,13,202),BidiClass::NonspacingMark),
  ((0,13,210),(0,13,212),BidiClass::NonspacingMark),
  ((0,13,214),(0,13,214),BidiClass::NonspacingMark),
  ((0,14,49),(0,14,49),BidiClass::NonspacingMark),
  ((0,14,52),(0,14,58),BidiClass::NonspacingMark),
  ((0,14,63),(0,14,63),BidiClass::EuropeanTerminator),
  ((0,14,71),(0,14,78),BidiClass::NonspacingMark),
  ((0,14,177),(0,14,177),BidiClass::NonspacingMark),
  ((0,14,180),(0,14,185),BidiClass::NonspacingMark),
  ((0,14,187),(0,14,188),BidiClass::NonspacingMark),
  ((0,14,200),(0,14,205),BidiClass::NonspacingMark),
  ((0,15,24),(0,15,25),BidiClass::NonspacingMark),
  ((0,15,53),(0,15,53),BidiClass::NonspacingMark),
  ((0,15,55),(0,15,55),BidiClass::NonspacingMark),
  ((0,15,57),(0,15,57),BidiClass::NonspacingMark),
  ((0,15,58),(0,15,61),BidiClass::OtherNeutral),
  ((0,15,113),(0,15,126),BidiClass::NonspacingMark),
  ((0,15,128),(0,15,132),BidiClass::NonspacingMark),
  ((0,15,134),(0,15,135),BidiClass::NonspacingMark),
  ((0,15,141),(0,15,151),BidiClass::NonspacingMark),
  ((0,15,153),(0,15,188),BidiClass::NonspacingMark),
  ((0,15,198),(0,15,198),BidiClass::NonspacingMark),
  ((0,16,45),(0,16,48),BidiClass::NonspacingMark),
  ((0,16,50),(0,16,55),BidiClass::NonspacingMark),
  ((0,16,57),(0,16,58),BidiClass::NonspacingMark),
  ((0,16,61),(0,16,62),BidiClass::NonspacingMark),
  ((0,16,88),(0,16,89),BidiClass::NonspacingMark),
  ((0,16,94),(0,16,96),BidiClass::NonspacingMark),
  ((0,16,113),(0,16,116),BidiClass::NonspacingMark),
  ((0,16,130),(0,16,130),BidiClass::NonspacingMark),
  ((0,16,133),(0,16,134),BidiClass::NonspacingMark),
  ((0,16,141),(0,16,141),BidiClass::NonspacingMark),
  ((0,16,157),(0,16,157),BidiClass::NonspacingMark),
  ((0,19,93),(0,19,95),BidiClass::NonspacingMark),
  ((0,19,144),(0,19,153),BidiClass::OtherNeutral),
  ((0,20,0),(0,20,0),BidiClass::OtherNeutral),
  ((0,22,128),(0,22,128),BidiClass::WhiteSpace),
  ((0,22,155),(0,22,156),BidiClass::OtherNeutral),
  ((0,23,18),(0,23,20),BidiClass::NonspacingMark),
  ((0,23,50),(0,23,52),BidiClass::NonspacingMark),
  ((0,23,82),(0,23,83),BidiClass::NonspacingMark),
  ((0,23,114),(0,23,115),BidiClass::NonspacingMark),
  ((0,23,180),(0,23,181),BidiClass::NonspacingMark),
  ((0,23,183),(0,23,189),BidiClass::NonspacingMark),
  ((0,23,198),(0,23,198),BidiClass::NonspacingMark),
  ((0,23,201),(0,23,211),BidiClass::NonspacingMark),
  ((0,23,219),(0,23,219),BidiClass::EuropeanTerminator),
  ((0,23,221),(0,23,221),BidiClass::NonspacingMark),
  ((0,23,240),(0,23,249),BidiClass::OtherNeutral),
  ((0,24,0),(0,24,10),BidiClass::OtherNeutral),
  ((0,24,11),(0,24,13),BidiClass::NonspacingMark),
  ((0,24,14),(0,24,14),BidiClass::BoundaryNeutral),
  ((0,24,133),(0,24,134),BidiClass::NonspacingMark),
  ((0,24,169),(0,24,169),BidiClass::NonspacingMark),
  ((0,25,32),(0,25,34),BidiClass::NonspacingMark),
  ((0,25,39),(0,25,40),BidiClass::NonspacingMark),
  ((0,25,50),(0,25,50),BidiClass::NonspacingMark),
  ((0,25,57),(0,25,59),BidiClass::NonspacingMark),
  ((0,25,64),(0,25,64),BidiClass::OtherNeutral),
  ((0,25,68),(0,25,69),BidiClass::OtherNeutral),
  ((0,25,222),(0,25,255),BidiClass::OtherNeutral),
  ((0,26,23),(0,26,24),BidiClass::NonspacingMark),
  ((0,26,27),(0,26,27),BidiClass::NonspacingMark),
  ((0,26,86),(0,26,86),BidiClass::NonspacingMark),
  ((0,26,88),(0,26,94),BidiClass::NonspacingMark),
  ((0,26,96),(0,26,96),BidiClass::NonspacingMark),
  ((0,26,98),(0,26,98),BidiClass::NonspacingMark),
  ((0,26,101),(0,26,108),BidiClass::NonspacingMark),
  ((0,26,115),(0,26,124),BidiClass::NonspacingMark),
  ((0,26,127),(0,26,127),BidiClass::NonspacingMark),
  ((0,26,176),(0,26,190),BidiClass::NonspacingMark),
  ((0,27,0),(0,27,3),BidiClass::NonspacingMark),
  ((0,27,52),(0,27,52),BidiClass::NonspacingMark),
  ((0,27,54),(0,27,58),BidiClass::NonspacingMark),
  ((0,27,60),(0,27,60),BidiClass::NonspacingMark),
  ((0,27,66),(0,27,66),BidiClass::NonspacingMark),
  ((0,27,107),(0,27,115),BidiClass::NonspacingMark),
  ((0,27,128),(0,27,129),BidiClass::NonspacingMark),
  ((0,27,162),(0,27,165),BidiClass::NonspacingMark),
  ((0,27,168),(0,27,169),BidiClass::NonspacingMark),
  ((0,27,171),(0,27,173),BidiClass::NonspacingMark),
  ((0,27,230),(0,27,230),BidiClass::NonspacingMark),
  ((0,27,232),(0,27,233),BidiClass::NonspacingMark),
  ((0,27,237),(0,27,237),BidiClass::NonspacingMark),
  ((0,27,239),(0,27,241),BidiClass::NonspacingMark),
  ((0,28,44),(0,28,51),BidiClass::NonspacingMark),
  ((0,28,54),(0,28,55),BidiClass::NonspacingMark),
  ((0,28,208),(0,28,210),BidiClass::NonspacingMark),
  ((0,28,212),(0,28,224),BidiClass::NonspacingMark),
  ((0,28,226),(0,28,232),BidiClass::NonspacingMark),
  ((0,28,237),(0,28,237),BidiClass::NonspacingMark),
  ((0,28,244),(0,28,244),BidiClass::NonspacingMark),
  ((0,28,248),(0,28,249),BidiClass::NonspacingMark),
  ((0,29,192),(0,29,245),BidiClass::NonspacingMark),
  ((0,29,251),(0,29,255),BidiClass::NonspacingMark),
  ((0,31,189),(0,31,189),BidiClass::OtherNeutral),
  ((0,31,191),(0,31,193),BidiClass::OtherNeutral),
  ((0,31,205),(0,31,207),BidiClass::OtherNeutral),
  ((0,31,221),(0,31,223),BidiClass::OtherNeutral),
  ((0,31,237),(0,31,239),BidiClass::OtherNeutral),
  ((0,31,253),(0,31,254),BidiClass::OtherNeutral),
  ((0,32,0),(0,32,10),BidiClass::WhiteSpace),
  ((0,32,11),(0,32,13),BidiClass::BoundaryNeutral),
  ((0,32,15),(0,32,15),BidiClass::RightToLeft),
  ((0,32,16),(0,32,39),BidiClass::OtherNeutral),
  ((0,32,40),(0,32,40),BidiClass::WhiteSpace),
  ((0,32,41),(0,32,41),BidiClass::ParagraphSeparator),
  ((0,32,42),(0,32,42),BidiClass::LeftToRightEmbedding),
  ((0,32,43),(0,32,43),BidiClass::RightToLeftEmbedding),
  ((0,32,44),(0,32,44),BidiClass::PopDirectionalFormat),
  ((0,32,45),(0,32,45),BidiClass::LeftToRightOverride),
  ((0,32,46),(0,32,46),BidiClass::RightToLeftOverride),
  ((0,32,47),(0,32,47),BidiClass::CommonSeparator),
  ((0,32,48),(0,32,52),BidiClass::EuropeanTerminator),
  ((0,32,53),(0,32,67),BidiClass::OtherNeutral),
  ((0,32,68),(0,32,68),BidiClass::CommonSeparator),
  ((0,32,69),(0,32,94),BidiClass::OtherNeutral),
  ((0,32,95),(0,32,95),BidiClass::WhiteSpace),
  ((0,32,96),(0,32,101),BidiClass::BoundaryNeutral),
  ((0,32,102),(0,32,102),BidiClass::LeftToRightIsolate),
  ((0,32,103),(0,32,103),BidiClass::RightToLeftIsolate),
  ((0,32,104),(0,32,104),BidiClass::FirstStrongIsolate),
  ((0,32,105),(0,32,105),BidiClass::PopDirectionalIsolate),
  ((0,32,106),(0,32,111),BidiClass::BoundaryNeutral),
  ((0,32,112),(0,32,112),BidiClass::EuropeanNumber),
  ((0,32,116),(0,32,121),BidiClass::EuropeanNumber),
  ((0,32,122),(0,32,123),BidiClass::EuropeanSeparator),
  ((0,32,124),(0,32,126),BidiClass::OtherNeutral),
  ((0,32,128),(0,32,137),BidiClass::EuropeanNumber),
  ((0,32,138),(0,32,139),BidiClass::EuropeanSeparator),
  ((0,32,140),(0,32,142),BidiClass::OtherNeutral),
  ((0,32,160),(0,32,207),BidiClass::EuropeanTerminator),
  ((0,32,208),(0,32,240),BidiClass::NonspacingMark),
  ((0,33,0),(0,33,1),BidiClass::OtherNeutral),
  ((0,33,3),(0,33,6),BidiClass::OtherNeutral),
  ((0,33,8),(0,33,9),BidiClass::OtherNeutral),
  ((0,33,20),(0,33,20),BidiClass::OtherNeutral),
  ((0,33,22),(0,33,24),BidiClass::OtherNeutral),
  ((0,33,30),(0,33,35),BidiClass::OtherNeutral),
  ((0,33,37),(0,33,37),BidiClass::OtherNeutral),
  ((0,33,39),(0,33,39),BidiClass::OtherNeutral),
  ((0,33,41),(0,33,41),BidiClass::OtherNeutral),
  ((0,33,46),(0,33,46),BidiClass::EuropeanTerminator),
  ((0,33,58),(0,33,59),BidiClass::OtherNeutral),
  ((0,33,64),(0,33,68),BidiClass::OtherNeutral),
  ((0,33,74),(0,33,77),BidiClass::OtherNeutral),
  ((0,33,80),(0,33,95),BidiClass::OtherNeutral),
  ((0,33,137),(0,33,139),BidiClass::OtherNeutral),
  ((0,33,144),(0,34,17),BidiClass::OtherNeutral),
  ((0,34,18),(0,34,18),BidiClass::EuropeanSeparator),
  ((0,34,19),(0,34,19),BidiClass::EuropeanTerminator),
  ((0,34,20),(0,35,53),BidiClass::OtherNeutral),
  ((0,35,123),(0,35,148),BidiClass::OtherNeutral),
  ((0,35,150),(0,35,254),BidiClass::OtherNeutral),
  ((0,36,0),(0,36,38),BidiClass::OtherNeutral),
  ((0,36,64),(0,36,74),BidiClass::OtherNeutral),
  ((0,36,96),(0,36,135),BidiClass::OtherNeutral),
  ((0,36,136),(0,36,155),BidiClass::EuropeanNumber),
  ((0,36,234),(0,38,171),BidiClass::OtherNeutral),
  ((0,38,173),(0,39,255),BidiClass::OtherNeutral),
  ((0,41,0),(0,43,115),BidiClass::OtherNeutral),
  ((0,43,118),(0,43,149),BidiClass::OtherNeutral),
  ((0,43,152),(0,43,185),BidiClass::OtherNeutral),
  ((0,43,189),(0,43,200),BidiClass::OtherNeutral),
  ((0,43,202),(0,43,209),BidiClass::OtherNeutral),
  ((0,43,236),(0,43,239),BidiClass::OtherNeutral),
  ((0,44,229),(0,44,234),BidiClass::OtherNeutral),
  ((0,44,239),(0,44,241),BidiClass::NonspacingMark),
  ((0,44,249),(0,44,255),BidiClass::OtherNeutral),
  ((0,45,127),(0,45,127),BidiClass::NonspacingMark),
  ((0,45,224),(0,45,255),BidiClass::NonspacingMark),
  ((0,46,0),(0,46,68),BidiClass::OtherNeutral),
  ((0,46,128),(0,46,153),BidiClass::OtherNeutral),
  ((0,46,155),(0,46,243),BidiClass::OtherNeutral),
  ((0,47,0),(0,47,213),BidiClass::OtherNeutral),
  ((0,47,240),(0,47,251),BidiClass::OtherNeutral),
  ((0,48,0),(0,48,0),BidiClass::WhiteSpace),
  ((0,48,1),(0,48,4),BidiClass::OtherNeutral),
  ((0,48,8),(0,48,32),BidiClass::OtherNeutral),
  ((0,48,42),(0,48,45),BidiClass::NonspacingMark),
  ((0,48,48),(0,48,48),BidiClass::OtherNeutral),
  ((0,48,54),(0,48,55),BidiClass::OtherNeutral),
  ((0,48,61),(0,48,63),BidiClass::OtherNeutral),
  ((0,48,153),(0,48,154),BidiClass::NonspacingMark),
  ((0,48,155),(0,48,156),BidiClass::OtherNeutral),
  ((0,48,160),(0,48,160),BidiClass::OtherNeutral),
  ((0,48,251),(0,48,251),BidiClass::OtherNeutral),
  ((0,49,192),(0,49,227),BidiClass::OtherNeutral),
  ((0,50,29),(0,50,30),BidiClass::OtherNeutral),
  ((0,50,80),(0,50,95),BidiClass::OtherNeutral),
  ((0,50,124),(0,50,126),BidiClass::OtherNeutral),
  ((0,50,177),(0,50,191),BidiClass::OtherNeutral),
  ((0,50,204),(0,50,207),BidiClass::OtherNeutral),
  ((0,51,119),(0,51,122),BidiClass::OtherNeutral),
  ((0,51,222),(0,51,223),BidiClass::OtherNeutral),
  ((0,51,255),(0,51,255),BidiClass::OtherNeutral),
  ((0,77,192),(0,77,255),BidiClass::OtherNeutral),
  ((0,164,144),(0,164,198),BidiClass::OtherNeutral),
  ((0,166,13),(0,166,15),BidiClass::OtherNeutral),
  ((0,166,111),(0,166,114),BidiClass::NonspacingMark),
  ((0,166,115),(0,166,115),BidiClass::OtherNeutral),
  ((0,166,116),(0,166,125),BidiClass::NonspacingMark),
  ((0,166,126),(0,166,127),BidiClass::OtherNeutral),
  ((0,166,158),(0,166,159),BidiClass::NonspacingMark),
  ((0,166,240),(0,166,241),BidiClass::NonspacingMark),
  ((0,167,0),(0,167,33),BidiClass::OtherNeutral),
  ((0,167,136),(0,167,136),BidiClass::OtherNeutral),
  ((0,168,2),(0,168,2),BidiClass::NonspacingMark),
  ((0,168,6),(0,168,6),BidiClass::NonspacingMark),
  ((0,168,11),(0,168,11),BidiClass::NonspacingMark),
  ((0,168,37),(0,168,38),BidiClass::NonspacingMark),
  ((0,168,40),(0,168,43),BidiClass::OtherNeutral),
  ((0,168,56),(0,168,57),BidiClass::EuropeanTerminator),
  ((0,168,116),(0,168,119),BidiClass::OtherNeutral),
  ((0,168,196),(0,168,197),BidiClass::NonspacingMark),
  ((0,168,224),(0,168,241),BidiClass::NonspacingMark),
  ((0,169,38),(0,169,45),BidiClass::NonspacingMark),
  ((0,169,71),(0,169,81),BidiClass::NonspacingMark),
  ((0,169,128),(0,169,130),BidiClass::NonspacingMark),
  ((0,169,179),(0,169,179),BidiClass::NonspacingMark),
  ((0,169,182),(0,169,185),BidiClass::NonspacingMark),
  ((0,169,188),(0,169,188),BidiClass::NonspacingMark),
  ((0,169,229),(0,169,229),BidiClass::NonspacingMark),
  ((0,170,41),(0,170,46),BidiClass::NonspacingMark),
  ((0,170,49),(0,170,50),BidiClass::NonspacingMark),
  ((0,170,53),(0,170,54),BidiClass::NonspacingMark),
  ((0,170,67),(0,170,67),BidiClass::NonspacingMark),
  ((0,170,76),(0,170,76),BidiClass::NonspacingMark),
  ((0,170,124),(0,170,124),BidiClass::NonspacingMark),
  ((0,170,176),(0,170,176),BidiClass::NonspacingMark),
  ((0,170,178),(0,170,180),BidiClass::NonspacingMark),
  ((0,170,183),(0,170,184),BidiClass::NonspacingMark),
  ((0,170,190),(0,170,191),BidiClass::NonspacingMark),
  ((0,170,193),(0,170,193),BidiClass::NonspacingMark),
  ((0,170,236),(0,170,237),BidiClass::NonspacingMark),
  ((0,170,246),(0,170,246),BidiClass::NonspacingMark),
  ((0,171,229),(0,171,229),BidiClass::NonspacingMark),
  ((0,171,232),(0,171,232),BidiClass::NonspacingMark),
  ((0,171,237),(0,171,237),BidiClass::NonspacingMark),
  ((0,251,29),(0,251,29),BidiClass::RightToLeft),
  ((0,251,30),(0,251,30),BidiClass::NonspacingMark),
  ((0,251,31),(0,251,40),BidiClass::RightToLeft),
  ((0,251,41),(0,251,41),BidiClass::EuropeanSeparator),
  ((0,251,42),(0,251,79),BidiClass::RightToLeft),
  ((0,251,80),(0,253,61),BidiClass::ArabicLetter),
  ((0,253,62),(0,253,63),BidiClass::OtherNeutral),
  ((0,253,64),(0,253,207),BidiClass::ArabicLetter),
  ((0,253,208),(0,253,239),BidiClass::BoundaryNeutral),
  ((0,253,240),(0,253,252),BidiClass::ArabicLetter),
  ((0,253,253),(0,253,253),BidiClass::OtherNeutral),
  ((0,253,254),(0,253,255),BidiClass::ArabicLetter),
  ((0,254,0),(0,254,15),BidiClass::NonspacingMark),
  ((0,254,16),(0,254,25),BidiClass::OtherNeutral),
  ((0,254,32),(0,254,47),BidiClass::NonspacingMark),
  ((0,254,48),(0,254,79),BidiClass::OtherNeutral),
  ((0,254,80),(0,254,80),BidiClass::CommonSeparator),
  ((0,254,81),(0,254,81),BidiClass::OtherNeutral),
  ((0,254,82),(0,254,82),BidiClass::CommonSeparator),
  ((0,254,84),(0,254,84),BidiClass::OtherNeutral),
  ((0,254,85),(0,254,85),BidiClass::CommonSeparator),
  ((0,254,86),(0,254,94),BidiClass::OtherNeutral),
  ((0,254,95),(0,254,95),BidiClass::EuropeanTerminator),
  ((0,254,96),(0,254,97),BidiClass::OtherNeutral),
  ((0,254,98),(0,254,99),BidiClass::EuropeanSeparator),
  ((0,254,100),(0,254,102),BidiClass::OtherNeutral),
  ((0,254,104),(0,254,104),BidiClass::OtherNeutral),
  ((0,254,105),(0,254,106),BidiClass::EuropeanTerminator),
  ((0,254,107),(0,254,107),BidiClass::OtherNeutral),
  ((0,254,112),(0,254,254),BidiClass::ArabicLetter),
  ((0,254,255),(0,254,255),BidiClass::BoundaryNeutral),
  ((0,255,1),(0,255,2),BidiClass::OtherNeutral),
  ((0,255,3),(0,255,5),BidiClass::EuropeanTerminator),
  ((0,255,6),(0,255,10),BidiClass::OtherNeutral),
  ((0,255,11),(0,255,11),BidiClass::EuropeanSeparator),
  ((0,255,12),(0,255,12),BidiClass::CommonSeparator),
  ((0,255,13),(0,255,13),BidiClass::EuropeanSeparator),
  ((0,255,14),(0,255,15),BidiClass::CommonSeparator),
  ((0,255,16),(0,255,25),BidiClass::EuropeanNumber),
  ((0,255,26),(0,255,26),BidiClass::CommonSeparator),
  ((0,255,27),(0,255,32),BidiClass::OtherNeutral),
  ((0,255,59),(0,255,64),BidiClass::OtherNeutral),
  ((0,255,91),(0,255,101),BidiClass::OtherNeutral),
  ((0,255,224),(0,255,225),BidiClass::EuropeanTerminator),
  ((0,255,226),(0,255,228),BidiClass::OtherNeutral),
  ((0,255,229),(0,255,230),BidiClass::EuropeanTerminator),
  ((0,255,232),(0,255,238),BidiClass::OtherNeutral),
  ((0,255,240),(0,255,248),BidiClass::BoundaryNeutral),
  ((0,255,249),(0,255,253),BidiClass::OtherNeutral),
  ((0,255,254),(0,255,255),BidiClass::BoundaryNeutral),
  ((1,1,1),(1,1,1),BidiClass::OtherNeutral),
  ((1,1,64),(1,1,140),BidiClass::OtherNeutral),
  ((1,1,144),(1,1,155),BidiClass::OtherNeutral),
  ((1,1,160),(1,1,160),BidiClass::OtherNeutral),
  ((1,1,253),(1,1,253),BidiClass::NonspacingMark),
  ((1,2,224),(1,2,224),BidiClass::NonspacingMark),
  ((1,2,225),(1,2,251),BidiClass::EuropeanNumber),
  ((1,3,118),(1,3,122),BidiClass::NonspacingMark),
  ((1,8,0),(1,9,30),BidiClass::RightToLeft),
  ((1,9,31),(1,9,31),BidiClass::OtherNeutral),
  ((1,9,32),(1,10,0),BidiClass::RightToLeft),
  ((1,10,1),(1,10,3),BidiClass::NonspacingMark),
  ((1,10,4),(1,10,4),BidiClass::RightToLeft),
  ((1,10,5),(1,10,6),BidiClass::NonspacingMark),
  ((1,10,7),(1,10,11),BidiClass::RightToLeft),
  ((1,10,12),(1,10,15),BidiClass::NonspacingMark),
  ((1,10,16),(1,10,55),BidiClass::RightToLeft),
  ((1,10,56),(1,10,58),BidiClass::NonspacingMark),
  ((1,10,59),(1,10,62),BidiClass::RightToLeft),
  ((1,10,63),(1,10,63),BidiClass::NonspacingMark),
  ((1,10,64),(1,10,228),BidiClass::RightToLeft),
  ((1,10,229),(1,10,230),BidiClass::NonspacingMark),
  ((1,10,231),(1,11,56),BidiClass::RightToLeft),
  ((1,11,57),(1,11,63),BidiClass::OtherNeutral),
  ((1,11,64),(1,14,95),BidiClass::RightToLeft),
  ((1,14,96),(1,14,126),BidiClass::ArabicNumber),
  ((1,14,127),(1,15,255),BidiClass::RightToLeft),
  ((1,16,1),(1,16,1),BidiClass::NonspacingMark),
  ((1,16,56),(1,16,70),BidiClass::NonspacingMark),
  ((1,16,82),(1,16,101),BidiClass::OtherNeutral),
  ((1,16,127),(1,16,129),BidiClass::NonspacingMark),
  ((1,16,179),(1,16,182),BidiClass::NonspacingMark),
  ((1,16,185),(1,16,186),BidiClass::NonspacingMark),
  ((1,17,0),(1,17,2),BidiClass::NonspacingMark),
  ((1,17,39),(1,17,43),BidiClass::NonspacingMark),
  ((1,17,45),(1,17,52),BidiClass::NonspacingMark),
  ((1,17,115),(1,17,115),BidiClass::NonspacingMark),
  ((1,17,128),(1,17,129),BidiClass::NonspacingMark),
  ((1,17,182),(1,17,190),BidiClass::NonspacingMark),
  ((1,17,202),(1,17,204),BidiClass::NonspacingMark),
  ((1,18,47),(1,18,49),BidiClass::NonspacingMark),
  ((1,18,52),(1,18,52),BidiClass::NonspacingMark),
  ((1,18,54),(1,18,55),BidiClass::NonspacingMark),
  ((1,18,62),(1,18,62),BidiClass::NonspacingMark),
  ((1,18,223),(1,18,223),BidiClass::NonspacingMark),
  ((1,18,227),(1,18,234),BidiClass::NonspacingMark),
  ((1,19,0),(1,19,1),BidiClass::NonspacingMark),
  ((1,19,60),(1,19,60),BidiClass::NonspacingMark),
  ((1,19,64),(1,19,64),BidiClass::NonspacingMark),
  ((1,19,102),(1,19,108),BidiClass::NonspacingMark),
  ((1,19,112),(1,19,116),BidiClass::NonspacingMark),
  ((1,20,56),(1,20,63),BidiClass::NonspacingMark),
  ((1,20,66),(1,20,68),BidiClass::NonspacingMark),
  ((1,20,70),(1,20,70),BidiClass::NonspacingMark),
  ((1,20,179),(1,20,184),BidiClass::NonspacingMark),
  ((1,20,186),(1,20,186),BidiClass::NonspacingMark),
  ((1,20,191),(1,20,192),BidiClass::NonspacingMark),
  ((1,20,194),(1,20,195),BidiClass::NonspacingMark),
  ((1,21,178),(1,21,181),BidiClass::NonspacingMark),
  ((1,21,188),(1,21,189),BidiClass::NonspacingMark),
  ((1,21,191),(1,21,192),BidiClass::NonspacingMark),
  ((1,21,220),(1,21,221),BidiClass::NonspacingMark),
  ((1,22,51),(1,22,58),BidiClass::NonspacingMark),
  ((1,22,61),(1,22,61),BidiClass::NonspacingMark),
  ((1,22,63),(1,22,64),BidiClass::NonspacingMark),
  ((1,22,96),(1,22,108),BidiClass::OtherNeutral),
  ((1,22,171),(1,22,171),BidiClass::NonspacingMark),
  ((1,22,173),(1,22,173),BidiClass::NonspacingMark),
  ((1,22,176),(1,22,181),BidiClass::NonspacingMark),
  ((1,22,183),(1,22,183),BidiClass::NonspacingMark),
  ((1,23,29),(1,23,31),BidiClass::NonspacingMark),
  ((1,23,34),(1,23,37),BidiClass::NonspacingMark),
  ((1,23,39),(1,23,43),BidiClass::NonspacingMark),
  ((1,28,48),(1,28,54),BidiClass::NonspacingMark),
  ((1,28,56),(1,28,61),BidiClass::NonspacingMark),
  ((1,28,146),(1,28,167),BidiClass::NonspacingMark),
  ((1,28,170),(1,28,176),BidiClass::NonspacingMark),
  ((1,28,178),(1,28,179),BidiClass::NonspacingMark),
  ((1,28,181),(1,28,182),BidiClass::NonspacingMark),
  ((1,106,240),(1,106,244),BidiClass::NonspacingMark),
  ((1,107,48),(1,107,54),BidiClass::NonspacingMark),
  ((1,111,143),(1,111,146),BidiClass::NonspacingMark),
  ((1,188,157),(1,188,158),BidiClass::NonspacingMark),
  ((1,188,160),(1,188,163),BidiClass::BoundaryNeutral),
  ((1,209,103),(1,209,105),BidiClass::NonspacingMark),
  ((1,209,115),(1,209,122),BidiClass::BoundaryNeutral),
  ((1,209,123),(1,209,130),BidiClass::NonspacingMark),
  ((1,209,133),(1,209,139),BidiClass::NonspacingMark),
  ((1,209,170),(1,209,173),BidiClass::NonspacingMark),
  ((1,210,0),(1,210,65),BidiClass::OtherNeutral),
  ((1,210,66),(1,210,68),BidiClass::NonspacingMark),
  ((1,210,69),(1,210,69),BidiClass::OtherNeutral),
  ((1,211,0),(1,211,86),BidiClass::OtherNeutral),
  ((1,214,219),(1,214,219),BidiClass::OtherNeutral),
  ((1,215,21),(1,215,21),BidiClass::OtherNeutral),
  ((1,215,79),(1,215,79),BidiClass::OtherNeutral),
  ((1,215,137),(1,215,137),BidiClass::OtherNeutral),
  ((1,215,195),(1,215,195),BidiClass::OtherNeutral),
  ((1,215,206),(1,215,255),BidiClass::EuropeanNumber),
  ((1,218,0),(1,218,54),BidiClass::NonspacingMark),
  ((1,218,59),(1,218,108),BidiClass::NonspacingMark),
  ((1,218,117),(1,218,117),BidiClass::NonspacingMark),
  ((1,218,132),(1,218,132),BidiClass::NonspacingMark),
  ((1,218,155),(1,218,159),BidiClass::NonspacingMark),
  ((1,218,161),(1,218,175),BidiClass::NonspacingMark),
  ((1,224,0),(1,224,6),BidiClass::NonspacingMark),
  ((1,224,8),(1,224,24),BidiClass::NonspacingMark),
  ((1,224,27),(1,224,33),BidiClass::NonspacingMark),
  ((1,224,35),(1,224,36),BidiClass::NonspacingMark),
  ((1,224,38),(1,224,42),BidiClass::NonspacingMark),
  ((1,232,0),(1,232,207),BidiClass::RightToLeft),
  ((1,232,208),(1,232,214),BidiClass::NonspacingMark),
  ((1,232,215),(1,233,67),BidiClass::RightToLeft),
  ((1,233,68),(1,233,74),BidiClass::NonspacingMark),
  ((1,233,75),(1,237,255),BidiClass::RightToLeft),
  ((1,238,0),(1,238,239),BidiClass::ArabicLetter),
  ((1,238,240),(1,238,241),BidiClass::OtherNeutral),
  ((1,238,242),(1,238,255),BidiClass::ArabicLetter),
  ((1,239,0),(1,239,255),BidiClass::RightToLeft),
  ((1,240,0),(1,240,43),BidiClass::OtherNeutral),
  ((1,240,48),(1,240,147),BidiClass::OtherNeutral),
  ((1,240,160),(1,240,174),BidiClass::OtherNeutral),
  ((1,240,177),(1,240,191),BidiClass::OtherNeutral),
  ((1,240,193),(1,240,207),BidiClass::OtherNeutral),
  ((1,240,209),(1,240,245),BidiClass::OtherNeutral),
  ((1,241,0),(1,241,10),BidiClass::EuropeanNumber),
  ((1,241,11),(1,241,12),BidiClass::OtherNeutral),
  ((1,241,106),(1,241,107),BidiClass::OtherNeutral),
  ((1,243,0),(1,246,210),BidiClass::OtherNeutral),
  ((1,246,224),(1,246,236),BidiClass::OtherNeutral),
  ((1,246,240),(1,246,246),BidiClass::OtherNeutral),
  ((1,247,0),(1,247,115),BidiClass::OtherNeutral),
  ((1,247,128),(1,247,212),BidiClass::OtherNeutral),
  ((1,248,0),(1,248,11),BidiClass::OtherNeutral),
  ((1,248,16),(1,248,71),BidiClass::OtherNeutral),
  ((1,248,80),(1,248,89),BidiClass::OtherNeutral),
  ((1,248,96),(1,248,135),BidiClass::OtherNeutral),
  ((1,248,144),(1,248,173),BidiClass::OtherNeutral),
  ((1,249,16),(1,249,30),BidiClass::OtherNeutral),
  ((1,249,32),(1,249,39),BidiClass::OtherNeutral),
  ((1,249,48),(1,249,48),BidiClass::OtherNeutral),
  ((1,249,51),(1,249,62),BidiClass::OtherNeutral),
  ((1,249,64),(1,249,75),BidiClass::OtherNeutral),
  ((1,249,80),(1,249,94),BidiClass::OtherNeutral),
  ((1,249,128),(1,249,145),BidiClass::OtherNeutral),
  ((1,249,192),(1,249,192),BidiClass::OtherNeutral),
  ((1,255,254),(1,255,255),BidiClass::BoundaryNeutral),
  ((2,255,254),(2,255,255),BidiClass::BoundaryNeutral),
  ((3,255,254),(3,255,255),BidiClass::BoundaryNeutral),
  ((4,255,254),(4,255,255),BidiClass::BoundaryNeutral),
  ((5,255,254),(5,255,255),BidiClass::BoundaryNeutral),
  ((6,255,254),(6,255,255),BidiClass::BoundaryNeutral),
  ((7,255,254),(7,255,255),BidiClass::BoundaryNeutral),
  ((8,255,254),(8,255,255),BidiClass::BoundaryNeutral),
  ((9,255,254),(9,255,255),BidiClass::BoundaryNeutral),
  ((10,255,254),(10,255,255),BidiClass::BoundaryNeutral),
  ((11,255,254),(11,255,255),BidiClass::BoundaryNeutral),
  ((12,255,254),(12,255,255),BidiClass::BoundaryNeutral),
  ((13,255,254),(14,0,255),BidiClass::BoundaryNeutral),
  ((14,1,0),(14,1,239),BidiClass::NonspacingMark),
  ((14,1,240),(14,15,255),BidiClass::BoundaryNeutral),
  ((14,255,254),(14,255,255),BidiClass::BoundaryNeutral),
  ((15,255,254),(15,255,255),BidiClass::BoundaryNeutral),
  ((16,255,254),(16,255,255),BidiClass::BoundaryNeutral)
];

pub static UCD_BIDI_MIRRORED: &'static [((u8,u8,u8), (u8,u8,u8), ())] = &[
  ((0,0,40),(0,0,41),()), ((0,0,60),(0,0,60),()), ((0,0,62),(0,0,62),()),
  ((0,0,91),(0,0,91),()), ((0,0,93),(0,0,93),()), ((0,0,123),(0,0,123),()),
  ((0,0,125),(0,0,125),()), ((0,0,171),(0,0,171),()), ((0,0,187),(0,0,187),()),
  ((0,15,58),(0,15,61),()), ((0,22,155),(0,22,156),()),
  ((0,32,57),(0,32,58),()), ((0,32,69),(0,32,70),()),
  ((0,32,125),(0,32,126),()), ((0,32,141),(0,32,142),()),
  ((0,33,64),(0,33,64),()), ((0,34,1),(0,34,4),()), ((0,34,8),(0,34,13),()),
  ((0,34,17),(0,34,17),()), ((0,34,21),(0,34,22),()), ((0,34,26),(0,34,29),()),
  ((0,34,31),(0,34,34),()), ((0,34,36),(0,34,36),()), ((0,34,38),(0,34,38),()),
  ((0,34,43),(0,34,51),()), ((0,34,57),(0,34,57),()), ((0,34,59),(0,34,76),()),
  ((0,34,82),(0,34,85),()), ((0,34,95),(0,34,96),()), ((0,34,98),(0,34,98),()),
  ((0,34,100),(0,34,107),()), ((0,34,110),(0,34,140),()),
  ((0,34,143),(0,34,146),()), ((0,34,152),(0,34,152),()),
  ((0,34,162),(0,34,163),()), ((0,34,166),(0,34,184),()),
  ((0,34,190),(0,34,191),()), ((0,34,201),(0,34,205),()),
  ((0,34,208),(0,34,209),()), ((0,34,214),(0,34,237),()),
  ((0,34,240),(0,34,255),()), ((0,35,8),(0,35,11),()), ((0,35,32),(0,35,33),()),
  ((0,35,41),(0,35,42),()), ((0,39,104),(0,39,117),()),
  ((0,39,192),(0,39,192),()), ((0,39,195),(0,39,198),()),
  ((0,39,200),(0,39,201),()), ((0,39,203),(0,39,205),()),
  ((0,39,211),(0,39,214),()), ((0,39,220),(0,39,222),()),
  ((0,39,226),(0,39,239),()), ((0,41,131),(0,41,152),()),
  ((0,41,155),(0,41,175),()), ((0,41,184),(0,41,184),()),
  ((0,41,192),(0,41,197),()), ((0,41,201),(0,41,201),()),
  ((0,41,206),(0,41,210),()), ((0,41,212),(0,41,213),()),
  ((0,41,216),(0,41,220),()), ((0,41,225),(0,41,225),()),
  ((0,41,227),(0,41,229),()), ((0,41,232),(0,41,233),()),
  ((0,41,244),(0,41,249),()), ((0,41,252),(0,41,253),()),
  ((0,42,10),(0,42,28),()), ((0,42,30),(0,42,33),()), ((0,42,36),(0,42,36),()),
  ((0,42,38),(0,42,38),()), ((0,42,41),(0,42,41),()), ((0,42,43),(0,42,46),()),
  ((0,42,52),(0,42,53),()), ((0,42,60),(0,42,62),()), ((0,42,87),(0,42,88),()),
  ((0,42,100),(0,42,101),()), ((0,42,106),(0,42,109),()),
  ((0,42,111),(0,42,112),()), ((0,42,115),(0,42,116),()),
  ((0,42,121),(0,42,163),()), ((0,42,166),(0,42,173),()),
  ((0,42,175),(0,42,214),()), ((0,42,220),(0,42,220),()),
  ((0,42,222),(0,42,222),()), ((0,42,226),(0,42,230),()),
  ((0,42,236),(0,42,238),()), ((0,42,243),(0,42,243),()),
  ((0,42,247),(0,42,251),()), ((0,42,253),(0,42,253),()),
  ((0,46,2),(0,46,5),()), ((0,46,9),(0,46,10),()), ((0,46,12),(0,46,13),()),
  ((0,46,28),(0,46,29),()), ((0,46,32),(0,46,41),()), ((0,48,8),(0,48,17),()),
  ((0,48,20),(0,48,27),()), ((0,254,89),(0,254,94),()),
  ((0,254,100),(0,254,101),()), ((0,255,8),(0,255,9),()),
  ((0,255,28),(0,255,28),()), ((0,255,30),(0,255,30),()),
  ((0,255,59),(0,255,59),()), ((0,255,61),(0,255,61),()),
  ((0,255,91),(0,255,91),()), ((0,255,93),(0,255,93),()),
  ((0,255,95),(0,255,96),()), ((0,255,98),(0,255,99),()),
  ((1,214,219),(1,214,219),()), ((1,215,21),(1,215,21),()),
  ((1,215,79),(1,215,79),()), ((1,215,137),(1,215,137),()),
  ((1,215,195),(1,215,195),())
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum BidiPairedBracketType {
  Open, Close
}

pub static UCD_BIDI_BRATYPE: &'static [((u8,u8,u8), BidiPairedBracketType)] = &[
  ((0,0,40),BidiPairedBracketType::Open),
  ((0,0,41),BidiPairedBracketType::Close),
  ((0,0,91),BidiPairedBracketType::Open),
  ((0,0,93),BidiPairedBracketType::Close),
  ((0,0,123),BidiPairedBracketType::Open),
  ((0,0,125),BidiPairedBracketType::Close),
  ((0,15,58),BidiPairedBracketType::Open),
  ((0,15,59),BidiPairedBracketType::Close),
  ((0,15,60),BidiPairedBracketType::Open),
  ((0,15,61),BidiPairedBracketType::Close),
  ((0,22,155),BidiPairedBracketType::Open),
  ((0,22,156),BidiPairedBracketType::Close),
  ((0,32,69),BidiPairedBracketType::Open),
  ((0,32,70),BidiPairedBracketType::Close),
  ((0,32,125),BidiPairedBracketType::Open),
  ((0,32,126),BidiPairedBracketType::Close),
  ((0,32,141),BidiPairedBracketType::Open),
  ((0,32,142),BidiPairedBracketType::Close),
  ((0,35,8),BidiPairedBracketType::Open),
  ((0,35,9),BidiPairedBracketType::Close),
  ((0,35,10),BidiPairedBracketType::Open),
  ((0,35,11),BidiPairedBracketType::Close),
  ((0,35,41),BidiPairedBracketType::Open),
  ((0,35,42),BidiPairedBracketType::Close),
  ((0,39,104),BidiPairedBracketType::Open),
  ((0,39,105),BidiPairedBracketType::Close),
  ((0,39,106),BidiPairedBracketType::Open),
  ((0,39,107),BidiPairedBracketType::Close),
  ((0,39,108),BidiPairedBracketType::Open),
  ((0,39,109),BidiPairedBracketType::Close),
  ((0,39,110),BidiPairedBracketType::Open),
  ((0,39,111),BidiPairedBracketType::Close),
  ((0,39,112),BidiPairedBracketType::Open),
  ((0,39,113),BidiPairedBracketType::Close),
  ((0,39,114),BidiPairedBracketType::Open),
  ((0,39,115),BidiPairedBracketType::Close),
  ((0,39,116),BidiPairedBracketType::Open),
  ((0,39,117),BidiPairedBracketType::Close),
  ((0,39,197),BidiPairedBracketType::Open),
  ((0,39,198),BidiPairedBracketType::Close),
  ((0,39,230),BidiPairedBracketType::Open),
  ((0,39,231),BidiPairedBracketType::Close),
  ((0,39,232),BidiPairedBracketType::Open),
  ((0,39,233),BidiPairedBracketType::Close),
  ((0,39,234),BidiPairedBracketType::Open),
  ((0,39,235),BidiPairedBracketType::Close),
  ((0,39,236),BidiPairedBracketType::Open),
  ((0,39,237),BidiPairedBracketType::Close),
  ((0,39,238),BidiPairedBracketType::Open),
  ((0,39,239),BidiPairedBracketType::Close),
  ((0,41,131),BidiPairedBracketType::Open),
  ((0,41,132),BidiPairedBracketType::Close),
  ((0,41,133),BidiPairedBracketType::Open),
  ((0,41,134),BidiPairedBracketType::Close),
  ((0,41,135),BidiPairedBracketType::Open),
  ((0,41,136),BidiPairedBracketType::Close),
  ((0,41,137),BidiPairedBracketType::Open),
  ((0,41,138),BidiPairedBracketType::Close),
  ((0,41,139),BidiPairedBracketType::Open),
  ((0,41,140),BidiPairedBracketType::Close),
  ((0,41,141),BidiPairedBracketType::Open),
  ((0,41,142),BidiPairedBracketType::Close),
  ((0,41,143),BidiPairedBracketType::Open),
  ((0,41,144),BidiPairedBracketType::Close),
  ((0,41,145),BidiPairedBracketType::Open),
  ((0,41,146),BidiPairedBracketType::Close),
  ((0,41,147),BidiPairedBracketType::Open),
  ((0,41,148),BidiPairedBracketType::Close),
  ((0,41,149),BidiPairedBracketType::Open),
  ((0,41,150),BidiPairedBracketType::Close),
  ((0,41,151),BidiPairedBracketType::Open),
  ((0,41,152),BidiPairedBracketType::Close),
  ((0,41,216),BidiPairedBracketType::Open),
  ((0,41,217),BidiPairedBracketType::Close),
  ((0,41,218),BidiPairedBracketType::Open),
  ((0,41,219),BidiPairedBracketType::Close),
  ((0,41,252),BidiPairedBracketType::Open),
  ((0,41,253),BidiPairedBracketType::Close),
  ((0,46,34),BidiPairedBracketType::Open),
  ((0,46,35),BidiPairedBracketType::Close),
  ((0,46,36),BidiPairedBracketType::Open),
  ((0,46,37),BidiPairedBracketType::Close),
  ((0,46,38),BidiPairedBracketType::Open),
  ((0,46,39),BidiPairedBracketType::Close),
  ((0,46,40),BidiPairedBracketType::Open),
  ((0,46,41),BidiPairedBracketType::Close),
  ((0,48,8),BidiPairedBracketType::Open),
  ((0,48,9),BidiPairedBracketType::Close),
  ((0,48,10),BidiPairedBracketType::Open),
  ((0,48,11),BidiPairedBracketType::Close),
  ((0,48,12),BidiPairedBracketType::Open),
  ((0,48,13),BidiPairedBracketType::Close),
  ((0,48,14),BidiPairedBracketType::Open),
  ((0,48,15),BidiPairedBracketType::Close),
  ((0,48,16),BidiPairedBracketType::Open),
  ((0,48,17),BidiPairedBracketType::Close),
  ((0,48,20),BidiPairedBracketType::Open),
  ((0,48,21),BidiPairedBracketType::Close),
  ((0,48,22),BidiPairedBracketType::Open),
  ((0,48,23),BidiPairedBracketType::Close),
  ((0,48,24),BidiPairedBracketType::Open),
  ((0,48,25),BidiPairedBracketType::Close),
  ((0,48,26),BidiPairedBracketType::Open),
  ((0,48,27),BidiPairedBracketType::Close),
  ((0,254,89),BidiPairedBracketType::Open),
  ((0,254,90),BidiPairedBracketType::Close),
  ((0,254,91),BidiPairedBracketType::Open),
  ((0,254,92),BidiPairedBracketType::Close),
  ((0,254,93),BidiPairedBracketType::Open),
  ((0,254,94),BidiPairedBracketType::Close),
  ((0,255,8),BidiPairedBracketType::Open),
  ((0,255,9),BidiPairedBracketType::Close),
  ((0,255,59),BidiPairedBracketType::Open),
  ((0,255,61),BidiPairedBracketType::Close),
  ((0,255,91),BidiPairedBracketType::Open),
  ((0,255,93),BidiPairedBracketType::Close),
  ((0,255,95),BidiPairedBracketType::Open),
  ((0,255,96),BidiPairedBracketType::Close),
  ((0,255,98),BidiPairedBracketType::Open),
  ((0,255,99),BidiPairedBracketType::Close)
];

pub static UCD_BIDI_MIRROR: &'static [(u16,u16)] = &[
  (40,41), (41,40), (60,62), (62,60), (91,93), (93,91), (123,125), (125,123),
  (171,187), (187,171), (3898,3899), (3899,3898), (3900,3901), (3901,3900),
  (5787,5788), (5788,5787), (8249,8250), (8250,8249), (8261,8262), (8262,8261),
  (8317,8318), (8318,8317), (8333,8334), (8334,8333), (8712,8715), (8713,8716),
  (8714,8717), (8715,8712), (8716,8713), (8717,8714), (8725,10741), (8764,8765),
  (8765,8764), (8771,8909), (8786,8787), (8787,8786), (8788,8789), (8789,8788),
  (8804,8805), (8805,8804), (8806,8807), (8807,8806), (8808,8809), (8809,8808),
  (8810,8811), (8811,8810), (8814,8815), (8815,8814), (8816,8817), (8817,8816),
  (8818,8819), (8819,8818), (8820,8821), (8821,8820), (8822,8823), (8823,8822),
  (8824,8825), (8825,8824), (8826,8827), (8827,8826), (8828,8829), (8829,8828),
  (8830,8831), (8831,8830), (8832,8833), (8833,8832), (8834,8835), (8835,8834),
  (8836,8837), (8837,8836), (8838,8839), (8839,8838), (8840,8841), (8841,8840),
  (8842,8843), (8843,8842), (8847,8848), (8848,8847), (8849,8850), (8850,8849),
  (8856,10680), (8866,8867), (8867,8866), (8870,10974), (8872,10980),
  (8873,10979), (8875,10981), (8880,8881), (8881,8880), (8882,8883),
  (8883,8882), (8884,8885), (8885,8884), (8886,8887), (8887,8886), (8905,8906),
  (8906,8905), (8907,8908), (8908,8907), (8909,8771), (8912,8913), (8913,8912),
  (8918,8919), (8919,8918), (8920,8921), (8921,8920), (8922,8923), (8923,8922),
  (8924,8925), (8925,8924), (8926,8927), (8927,8926), (8928,8929), (8929,8928),
  (8930,8931), (8931,8930), (8932,8933), (8933,8932), (8934,8935), (8935,8934),
  (8936,8937), (8937,8936), (8938,8939), (8939,8938), (8940,8941), (8941,8940),
  (8944,8945), (8945,8944), (8946,8954), (8947,8955), (8948,8956), (8950,8957),
  (8951,8958), (8954,8946), (8955,8947), (8956,8948), (8957,8950), (8958,8951),
  (8968,8969), (8969,8968), (8970,8971), (8971,8970), (9001,9002), (9002,9001),
  (10088,10089), (10089,10088), (10090,10091), (10091,10090), (10092,10093),
  (10093,10092), (10094,10095), (10095,10094), (10096,10097), (10097,10096),
  (10098,10099), (10099,10098), (10100,10101), (10101,10100), (10179,10180),
  (10180,10179), (10181,10182), (10182,10181), (10184,10185), (10185,10184),
  (10187,10189), (10189,10187), (10197,10198), (10198,10197), (10205,10206),
  (10206,10205), (10210,10211), (10211,10210), (10212,10213), (10213,10212),
  (10214,10215), (10215,10214), (10216,10217), (10217,10216), (10218,10219),
  (10219,10218), (10220,10221), (10221,10220), (10222,10223), (10223,10222),
  (10627,10628), (10628,10627), (10629,10630), (10630,10629), (10631,10632),
  (10632,10631), (10633,10634), (10634,10633), (10635,10636), (10636,10635),
  (10637,10640), (10638,10639), (10639,10638), (10640,10637), (10641,10642),
  (10642,10641), (10643,10644), (10644,10643), (10645,10646), (10646,10645),
  (10647,10648), (10648,10647), (10680,8856), (10688,10689), (10689,10688),
  (10692,10693), (10693,10692), (10703,10704), (10704,10703), (10705,10706),
  (10706,10705), (10708,10709), (10709,10708), (10712,10713), (10713,10712),
  (10714,10715), (10715,10714), (10741,8725), (10744,10745), (10745,10744),
  (10748,10749), (10749,10748), (10795,10796), (10796,10795), (10797,10798),
  (10798,10797), (10804,10805), (10805,10804), (10812,10813), (10813,10812),
  (10852,10853), (10853,10852), (10873,10874), (10874,10873), (10877,10878),
  (10878,10877), (10879,10880), (10880,10879), (10881,10882), (10882,10881),
  (10883,10884), (10884,10883), (10891,10892), (10892,10891), (10897,10898),
  (10898,10897), (10899,10900), (10900,10899), (10901,10902), (10902,10901),
  (10903,10904), (10904,10903), (10905,10906), (10906,10905), (10907,10908),
  (10908,10907), (10913,10914), (10914,10913), (10918,10919), (10919,10918),
  (10920,10921), (10921,10920), (10922,10923), (10923,10922), (10924,10925),
  (10925,10924), (10927,10928), (10928,10927), (10931,10932), (10932,10931),
  (10939,10940), (10940,10939), (10941,10942), (10942,10941), (10943,10944),
  (10944,10943), (10945,10946), (10946,10945), (10947,10948), (10948,10947),
  (10949,10950), (10950,10949), (10957,10958), (10958,10957), (10959,10960),
  (10960,10959), (10961,10962), (10962,10961), (10963,10964), (10964,10963),
  (10965,10966), (10966,10965), (10974,8870), (10979,8873), (10980,8872),
  (10981,8875), (10988,10989), (10989,10988), (10999,11000), (11000,10999),
  (11001,11002), (11002,11001), (11778,11779), (11779,11778), (11780,11781),
  (11781,11780), (11785,11786), (11786,11785), (11788,11789), (11789,11788),
  (11804,11805), (11805,11804), (11808,11809), (11809,11808), (11810,11811),
  (11811,11810), (11812,11813), (11813,11812), (11814,11815), (11815,11814),
  (11816,11817), (11817,11816), (12296,12297), (12297,12296), (12298,12299),
  (12299,12298), (12300,12301), (12301,12300), (12302,12303), (12303,12302),
  (12304,12305), (12305,12304), (12308,12309), (12309,12308), (12310,12311),
  (12311,12310), (12312,12313), (12313,12312), (12314,12315), (12315,12314),
  (65113,65114), (65114,65113), (65115,65116), (65116,65115), (65117,65118),
  (65118,65117), (65124,65125), (65125,65124), (65288,65289), (65289,65288),
  (65308,65310), (65310,65308), (65339,65341), (65341,65339), (65371,65373),
  (65373,65371), (65375,65376), (65376,65375), (65378,65379), (65379,65378)
];

pub static UCD_BIDI_PAIRED: &'static [(u16,u16)] = &[
  (40,41), (41,40), (91,93), (93,91), (123,125), (125,123), (3898,3899),
  (3899,3898), (3900,3901), (3901,3900), (5787,5788), (5788,5787), (8261,8262),
  (8262,8261), (8317,8318), (8318,8317), (8333,8334), (8334,8333), (8968,8969),
  (8969,8968), (8970,8971), (8971,8970), (9001,9002), (9002,9001),
  (10088,10089), (10089,10088), (10090,10091), (10091,10090), (10092,10093),
  (10093,10092), (10094,10095), (10095,10094), (10096,10097), (10097,10096),
  (10098,10099), (10099,10098), (10100,10101), (10101,10100), (10181,10182),
  (10182,10181), (10214,10215), (10215,10214), (10216,10217), (10217,10216),
  (10218,10219), (10219,10218), (10220,10221), (10221,10220), (10222,10223),
  (10223,10222), (10627,10628), (10628,10627), (10629,10630), (10630,10629),
  (10631,10632), (10632,10631), (10633,10634), (10634,10633), (10635,10636),
  (10636,10635), (10637,10640), (10638,10639), (10639,10638), (10640,10637),
  (10641,10642), (10642,10641), (10643,10644), (10644,10643), (10645,10646),
  (10646,10645), (10647,10648), (10648,10647), (10712,10713), (10713,10712),
  (10714,10715), (10715,10714), (10748,10749), (10749,10748), (11810,11811),
  (11811,11810), (11812,11813), (11813,11812), (11814,11815), (11815,11814),
  (11816,11817), (11817,11816), (12296,12297), (12297,12296), (12298,12299),
  (12299,12298), (12300,12301), (12301,12300), (12302,12303), (12303,12302),
  (12304,12305), (12305,12304), (12308,12309), (12309,12308), (12310,12311),
  (12311,12310), (12312,12313), (12313,12312), (12314,12315), (12315,12314),
  (65113,65114), (65114,65113), (65115,65116), (65116,65115), (65117,65118),
  (65118,65117), (65288,65289), (65289,65288), (65339,65341), (65341,65339),
  (65371,65373), (65373,65371), (65375,65376), (65376,65375), (65378,65379),
  (65379,65378)
];

