/*
 * Copyright (c) 2016-2017 Isode Limited.
 * All rights reserved.
 * See the COPYING file for more information.
 */

#include <SwifTools/EmojiMapper.h>

#include <algorithm>
#include <string>
#include <unordered_map>

namespace Swift {

    //AUTO-GENERATED CONTENT
    const std::unordered_map<std::string, std::string> EmojiMapper::shortnameUnicode = std::unordered_map<std::string, std::string>{{":100:", "\xf0\x9f\x92\xaf"}, {":1234:", "\xf0\x9f\x94\xa2"}, {":grinning:", "\xf0\x9f\x98\x80"}, {":grin:", "\xf0\x9f\x98\x81"}, {":joy:", "\xf0\x9f\x98\x82"}, {":rofl:", "\xf0\x9f\xa4\xa3"}, {":smiley:", "\xf0\x9f\x98\x83"}, {":smile:", "\xf0\x9f\x98\x84"}, {":sweat_smile:", "\xf0\x9f\x98\x85"}, {":laughing:", "\xf0\x9f\x98\x86"}, {":wink:", "\xf0\x9f\x98\x89"}, {":blush:", "\xf0\x9f\x98\x8a"}, {":yum:", "\xf0\x9f\x98\x8b"}, {":sunglasses:", "\xf0\x9f\x98\x8e"}, {":heart_eyes:", "\xf0\x9f\x98\x8d"}, {":kissing_heart:", "\xf0\x9f\x98\x98"}, {":kissing:", "\xf0\x9f\x98\x97"}, {":kissing_smiling_eyes:", "\xf0\x9f\x98\x99"}, {":kissing_closed_eyes:", "\xf0\x9f\x98\x9a"}, {":relaxed:", "\xe2\x98\xba"}, {":slight_smile:", "\xf0\x9f\x99\x82"}, {":hugging:", "\xf0\x9f\xa4\x97"}, {":thinking:", "\xf0\x9f\xa4\x94"}, {":neutral_face:", "\xf0\x9f\x98\x90"}, {":expressionless:", "\xf0\x9f\x98\x91"}, {":no_mouth:", "\xf0\x9f\x98\xb6"}, {":rolling_eyes:", "\xf0\x9f\x99\x84"}, {":smirk:", "\xf0\x9f\x98\x8f"}, {":persevere:", "\xf0\x9f\x98\xa3"}, {":disappointed_relieved:", "\xf0\x9f\x98\xa5"}, {":open_mouth:", "\xf0\x9f\x98\xae"}, {":zipper_mouth:", "\xf0\x9f\xa4\x90"}, {":hushed:", "\xf0\x9f\x98\xaf"}, {":sleepy:", "\xf0\x9f\x98\xaa"}, {":tired_face:", "\xf0\x9f\x98\xab"}, {":sleeping:", "\xf0\x9f\x98\xb4"}, {":relieved:", "\xf0\x9f\x98\x8c"}, {":nerd:", "\xf0\x9f\xa4\x93"}, {":stuck_out_tongue:", "\xf0\x9f\x98\x9b"}, {":stuck_out_tongue_winking_eye:", "\xf0\x9f\x98\x9c"}, {":stuck_out_tongue_closed_eyes:", "\xf0\x9f\x98\x9d"}, {":drooling_face:", "\xf0\x9f\xa4\xa4"}, {":unamused:", "\xf0\x9f\x98\x92"}, {":sweat:", "\xf0\x9f\x98\x93"}, {":pensive:", "\xf0\x9f\x98\x94"}, {":confused:", "\xf0\x9f\x98\x95"}, {":upside_down:", "\xf0\x9f\x99\x83"}, {":money_mouth:", "\xf0\x9f\xa4\x91"}, {":astonished:", "\xf0\x9f\x98\xb2"}, {":frowning2:", "\xe2\x98\xb9"}, {":slight_frown:", "\xf0\x9f\x99\x81"}, {":confounded:", "\xf0\x9f\x98\x96"}, {":disappointed:", "\xf0\x9f\x98\x9e"}, {":worried:", "\xf0\x9f\x98\x9f"}, {":triumph:", "\xf0\x9f\x98\xa4"}, {":cry:", "\xf0\x9f\x98\xa2"}, {":sob:", "\xf0\x9f\x98\xad"}, {":frowning:", "\xf0\x9f\x98\xa6"}, {":anguished:", "\xf0\x9f\x98\xa7"}, {":fearful:", "\xf0\x9f\x98\xa8"}, {":weary:", "\xf0\x9f\x98\xa9"}, {":grimacing:", "\xf0\x9f\x98\xac"}, {":cold_sweat:", "\xf0\x9f\x98\xb0"}, {":scream:", "\xf0\x9f\x98\xb1"}, {":flushed:", "\xf0\x9f\x98\xb3"}, {":dizzy_face:", "\xf0\x9f\x98\xb5"}, {":rage:", "\xf0\x9f\x98\xa1"}, {":angry:", "\xf0\x9f\x98\xa0"}, {":innocent:", "\xf0\x9f\x98\x87"}, {":cowboy:", "\xf0\x9f\xa4\xa0"}, {":clown:", "\xf0\x9f\xa4\xa1"}, {":lying_face:", "\xf0\x9f\xa4\xa5"}, {":mask:", "\xf0\x9f\x98\xb7"}, {":thermometer_face:", "\xf0\x9f\xa4\x92"}, {":head_bandage:", "\xf0\x9f\xa4\x95"}, {":nauseated_face:", "\xf0\x9f\xa4\xa2"}, {":sneezing_face:", "\xf0\x9f\xa4\xa7"}, {":smiling_imp:", "\xf0\x9f\x98\x88"}, {":imp:", "\xf0\x9f\x91\xbf"}, {":japanese_ogre:", "\xf0\x9f\x91\xb9"}, {":japanese_goblin:", "\xf0\x9f\x91\xba"}, {":skull:", "\xf0\x9f\x92\x80"}, {":skull_crossbones:", "\xe2\x98\xa0"}, {":ghost:", "\xf0\x9f\x91\xbb"}, {":alien:", "\xf0\x9f\x91\xbd"}, {":space_invader:", "\xf0\x9f\x91\xbe"}, {":robot:", "\xf0\x9f\xa4\x96"}, {":poop:", "\xf0\x9f\x92\xa9"}, {":smiley_cat:", "\xf0\x9f\x98\xba"}, {":smile_cat:", "\xf0\x9f\x98\xb8"}, {":joy_cat:", "\xf0\x9f\x98\xb9"}, {":heart_eyes_cat:", "\xf0\x9f\x98\xbb"}, {":smirk_cat:", "\xf0\x9f\x98\xbc"}, {":kissing_cat:", "\xf0\x9f\x98\xbd"}, {":scream_cat:", "\xf0\x9f\x99\x80"}, {":crying_cat_face:", "\xf0\x9f\x98\xbf"}, {":pouting_cat:", "\xf0\x9f\x98\xbe"}, {":see_no_evil:", "\xf0\x9f\x99\x88"}, {":hear_no_evil:", "\xf0\x9f\x99\x89"}, {":speak_no_evil:", "\xf0\x9f\x99\x8a"}, {":boy:", "\xf0\x9f\x91\xa6"}, {":boy_tone1:", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbb"}, {":boy_tone2:", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbc"}, {":boy_tone3:", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbd"}, {":boy_tone4:", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbe"}, {":boy_tone5:", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbf"}, {":girl:", "\xf0\x9f\x91\xa7"}, {":girl_tone1:", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbb"}, {":girl_tone2:", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbc"}, {":girl_tone3:", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbd"}, {":girl_tone4:", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbe"}, {":girl_tone5:", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbf"}, {":man:", "\xf0\x9f\x91\xa8"}, {":man_tone1:", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb"}, {":man_tone2:", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc"}, {":man_tone3:", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd"}, {":man_tone4:", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe"}, {":man_tone5:", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf"}, {":woman:", "\xf0\x9f\x91\xa9"}, {":woman_tone1:", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb"}, {":woman_tone2:", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc"}, {":woman_tone3:", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd"}, {":woman_tone4:", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe"}, {":woman_tone5:", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf"}, {":older_man:", "\xf0\x9f\x91\xb4"}, {":older_man_tone1:", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbb"}, {":older_man_tone2:", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbc"}, {":older_man_tone3:", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbd"}, {":older_man_tone4:", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbe"}, {":older_man_tone5:", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbf"}, {":older_woman:", "\xf0\x9f\x91\xb5"}, {":older_woman_tone1:", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbb"}, {":older_woman_tone2:", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbc"}, {":older_woman_tone3:", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbd"}, {":older_woman_tone4:", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbe"}, {":older_woman_tone5:", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbf"}, {":baby:", "\xf0\x9f\x91\xb6"}, {":baby_tone1:", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbb"}, {":baby_tone2:", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbc"}, {":baby_tone3:", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbd"}, {":baby_tone4:", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbe"}, {":baby_tone5:", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbf"}, {":angel:", "\xf0\x9f\x91\xbc"}, {":angel_tone1:", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbb"}, {":angel_tone2:", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbc"}, {":angel_tone3:", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbd"}, {":angel_tone4:", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbe"}, {":angel_tone5:", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbf"}, {":cop:", "\xf0\x9f\x91\xae"}, {":cop_tone1:", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb"}, {":cop_tone2:", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc"}, {":cop_tone3:", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd"}, {":cop_tone4:", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe"}, {":cop_tone5:", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf"}, {":spy:", "\xf0\x9f\x95\xb5"}, {":spy_tone1:", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb"}, {":spy_tone2:", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc"}, {":spy_tone3:", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd"}, {":spy_tone4:", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe"}, {":spy_tone5:", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf"}, {":guardsman:", "\xf0\x9f\x92\x82"}, {":guardsman_tone1:", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb"}, {":guardsman_tone2:", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc"}, {":guardsman_tone3:", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd"}, {":guardsman_tone4:", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe"}, {":guardsman_tone5:", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf"}, {":construction_worker:", "\xf0\x9f\x91\xb7"}, {":construction_worker_tone1:", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb"}, {":construction_worker_tone2:", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc"}, {":construction_worker_tone3:", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd"}, {":construction_worker_tone4:", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe"}, {":construction_worker_tone5:", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf"}, {":man_with_turban:", "\xf0\x9f\x91\xb3"}, {":man_with_turban_tone1:", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb"}, {":man_with_turban_tone2:", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc"}, {":man_with_turban_tone3:", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd"}, {":man_with_turban_tone4:", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe"}, {":man_with_turban_tone5:", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf"}, {":person_with_blond_hair:", "\xf0\x9f\x91\xb1"}, {":person_with_blond_hair_tone1:", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb"}, {":person_with_blond_hair_tone2:", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc"}, {":person_with_blond_hair_tone3:", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd"}, {":person_with_blond_hair_tone4:", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe"}, {":person_with_blond_hair_tone5:", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf"}, {":santa:", "\xf0\x9f\x8e\x85"}, {":santa_tone1:", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbb"}, {":santa_tone2:", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbc"}, {":santa_tone3:", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbd"}, {":santa_tone4:", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbe"}, {":santa_tone5:", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbf"}, {":mrs_claus:", "\xf0\x9f\xa4\xb6"}, {":mrs_claus_tone1:", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbb"}, {":mrs_claus_tone2:", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbc"}, {":mrs_claus_tone3:", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbd"}, {":mrs_claus_tone4:", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbe"}, {":mrs_claus_tone5:", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbf"}, {":princess:", "\xf0\x9f\x91\xb8"}, {":princess_tone1:", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbb"}, {":princess_tone2:", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbc"}, {":princess_tone3:", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbd"}, {":princess_tone4:", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbe"}, {":princess_tone5:", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbf"}, {":prince:", "\xf0\x9f\xa4\xb4"}, {":prince_tone1:", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbb"}, {":prince_tone2:", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbc"}, {":prince_tone3:", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbd"}, {":prince_tone4:", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbe"}, {":prince_tone5:", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbf"}, {":bride_with_veil:", "\xf0\x9f\x91\xb0"}, {":bride_with_veil_tone1:", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbb"}, {":bride_with_veil_tone2:", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbc"}, {":bride_with_veil_tone3:", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbd"}, {":bride_with_veil_tone4:", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbe"}, {":bride_with_veil_tone5:", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbf"}, {":man_in_tuxedo:", "\xf0\x9f\xa4\xb5"}, {":man_in_tuxedo_tone1:", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbb"}, {":man_in_tuxedo_tone2:", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbc"}, {":man_in_tuxedo_tone3:", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbd"}, {":man_in_tuxedo_tone4:", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbe"}, {":man_in_tuxedo_tone5:", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbf"}, {":pregnant_woman:", "\xf0\x9f\xa4\xb0"}, {":pregnant_woman_tone1:", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbb"}, {":pregnant_woman_tone2:", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbc"}, {":pregnant_woman_tone3:", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbd"}, {":pregnant_woman_tone4:", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbe"}, {":pregnant_woman_tone5:", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbf"}, {":man_with_gua_pi_mao:", "\xf0\x9f\x91\xb2"}, {":man_with_gua_pi_mao_tone1:", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbb"}, {":man_with_gua_pi_mao_tone2:", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbc"}, {":man_with_gua_pi_mao_tone3:", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbd"}, {":man_with_gua_pi_mao_tone4:", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbe"}, {":man_with_gua_pi_mao_tone5:", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbf"}, {":person_frowning:", "\xf0\x9f\x99\x8d"}, {":person_frowning_tone1:", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb"}, {":person_frowning_tone2:", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc"}, {":person_frowning_tone3:", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd"}, {":person_frowning_tone4:", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe"}, {":person_frowning_tone5:", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf"}, {":person_with_pouting_face:", "\xf0\x9f\x99\x8e"}, {":person_with_pouting_face_tone1:", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb"}, {":person_with_pouting_face_tone2:", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc"}, {":person_with_pouting_face_tone3:", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd"}, {":person_with_pouting_face_tone4:", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe"}, {":person_with_pouting_face_tone5:", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf"}, {":no_good:", "\xf0\x9f\x99\x85"}, {":no_good_tone1:", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb"}, {":no_good_tone2:", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc"}, {":no_good_tone3:", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd"}, {":no_good_tone4:", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe"}, {":no_good_tone5:", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf"}, {":ok_woman:", "\xf0\x9f\x99\x86"}, {":ok_woman_tone1:", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb"}, {":ok_woman_tone2:", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc"}, {":ok_woman_tone3:", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd"}, {":ok_woman_tone4:", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe"}, {":ok_woman_tone5:", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf"}, {":information_desk_person:", "\xf0\x9f\x92\x81"}, {":information_desk_person_tone1:", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb"}, {":information_desk_person_tone2:", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc"}, {":information_desk_person_tone3:", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd"}, {":information_desk_person_tone4:", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe"}, {":information_desk_person_tone5:", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf"}, {":raising_hand:", "\xf0\x9f\x99\x8b"}, {":raising_hand_tone1:", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb"}, {":raising_hand_tone2:", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc"}, {":raising_hand_tone3:", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd"}, {":raising_hand_tone4:", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe"}, {":raising_hand_tone5:", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf"}, {":bow:", "\xf0\x9f\x99\x87"}, {":bow_tone1:", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb"}, {":bow_tone2:", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc"}, {":bow_tone3:", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd"}, {":bow_tone4:", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe"}, {":bow_tone5:", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf"}, {":face_palm:", "\xf0\x9f\xa4\xa6"}, {":face_palm_tone1:", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb"}, {":face_palm_tone2:", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc"}, {":face_palm_tone3:", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd"}, {":face_palm_tone4:", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe"}, {":face_palm_tone5:", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf"}, {":shrug:", "\xf0\x9f\xa4\xb7"}, {":shrug_tone1:", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb"}, {":shrug_tone2:", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc"}, {":shrug_tone3:", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd"}, {":shrug_tone4:", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe"}, {":shrug_tone5:", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf"}, {":massage:", "\xf0\x9f\x92\x86"}, {":massage_tone1:", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb"}, {":massage_tone2:", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc"}, {":massage_tone3:", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd"}, {":massage_tone4:", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe"}, {":massage_tone5:", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf"}, {":haircut:", "\xf0\x9f\x92\x87"}, {":haircut_tone1:", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb"}, {":haircut_tone2:", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc"}, {":haircut_tone3:", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd"}, {":haircut_tone4:", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe"}, {":haircut_tone5:", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf"}, {":walking:", "\xf0\x9f\x9a\xb6"}, {":walking_tone1:", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb"}, {":walking_tone2:", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc"}, {":walking_tone3:", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd"}, {":walking_tone4:", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe"}, {":walking_tone5:", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf"}, {":runner:", "\xf0\x9f\x8f\x83"}, {":runner_tone1:", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb"}, {":runner_tone2:", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc"}, {":runner_tone3:", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd"}, {":runner_tone4:", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe"}, {":runner_tone5:", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf"}, {":dancer:", "\xf0\x9f\x92\x83"}, {":dancer_tone1:", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbb"}, {":dancer_tone2:", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbc"}, {":dancer_tone3:", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbd"}, {":dancer_tone4:", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbe"}, {":dancer_tone5:", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbf"}, {":man_dancing:", "\xf0\x9f\x95\xba"}, {":man_dancing_tone1:", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbb"}, {":man_dancing_tone2:", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbc"}, {":man_dancing_tone3:", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbd"}, {":man_dancing_tone4:", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbe"}, {":man_dancing_tone5:", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbf"}, {":dancers:", "\xf0\x9f\x91\xaf"}, {":levitate:", "\xf0\x9f\x95\xb4"}, {":speaking_head:", "\xf0\x9f\x97\xa3"}, {":bust_in_silhouette:", "\xf0\x9f\x91\xa4"}, {":busts_in_silhouette:", "\xf0\x9f\x91\xa5"}, {":fencer:", "\xf0\x9f\xa4\xba"}, {":horse_racing:", "\xf0\x9f\x8f\x87"}, {":horse_racing_tone1:", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbb"}, {":horse_racing_tone2:", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbc"}, {":horse_racing_tone3:", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbd"}, {":horse_racing_tone4:", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbe"}, {":horse_racing_tone5:", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbf"}, {":skier:", "\xe2\x9b\xb7"}, {":snowboarder:", "\xf0\x9f\x8f\x82"}, {":golfer:", "\xf0\x9f\x8f\x8c"}, {":surfer:", "\xf0\x9f\x8f\x84"}, {":surfer_tone1:", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb"}, {":surfer_tone2:", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc"}, {":surfer_tone3:", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd"}, {":surfer_tone4:", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe"}, {":surfer_tone5:", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf"}, {":rowboat:", "\xf0\x9f\x9a\xa3"}, {":rowboat_tone1:", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb"}, {":rowboat_tone2:", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc"}, {":rowboat_tone3:", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd"}, {":rowboat_tone4:", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe"}, {":rowboat_tone5:", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf"}, {":swimmer:", "\xf0\x9f\x8f\x8a"}, {":swimmer_tone1:", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb"}, {":swimmer_tone2:", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc"}, {":swimmer_tone3:", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd"}, {":swimmer_tone4:", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe"}, {":swimmer_tone5:", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf"}, {":basketball_player:", "\xe2\x9b\xb9"}, {":basketball_player_tone1:", "\xe2\x9b\xb9\xf0\x9f\x8f\xbb"}, {":basketball_player_tone2:", "\xe2\x9b\xb9\xf0\x9f\x8f\xbc"}, {":basketball_player_tone3:", "\xe2\x9b\xb9\xf0\x9f\x8f\xbd"}, {":basketball_player_tone4:", "\xe2\x9b\xb9\xf0\x9f\x8f\xbe"}, {":basketball_player_tone5:", "\xe2\x9b\xb9\xf0\x9f\x8f\xbf"}, {":lifter:", "\xf0\x9f\x8f\x8b"}, {":lifter_tone1:", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb"}, {":lifter_tone2:", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc"}, {":lifter_tone3:", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd"}, {":lifter_tone4:", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe"}, {":lifter_tone5:", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf"}, {":bicyclist:", "\xf0\x9f\x9a\xb4"}, {":bicyclist_tone1:", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb"}, {":bicyclist_tone2:", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc"}, {":bicyclist_tone3:", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd"}, {":bicyclist_tone4:", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe"}, {":bicyclist_tone5:", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf"}, {":mountain_bicyclist:", "\xf0\x9f\x9a\xb5"}, {":mountain_bicyclist_tone1:", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb"}, {":mountain_bicyclist_tone2:", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc"}, {":mountain_bicyclist_tone3:", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd"}, {":mountain_bicyclist_tone4:", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe"}, {":mountain_bicyclist_tone5:", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf"}, {":race_car:", "\xf0\x9f\x8f\x8e"}, {":motorcycle:", "\xf0\x9f\x8f\x8d"}, {":cartwheel:", "\xf0\x9f\xa4\xb8"}, {":cartwheel_tone1:", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb"}, {":cartwheel_tone2:", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc"}, {":cartwheel_tone3:", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd"}, {":cartwheel_tone4:", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe"}, {":cartwheel_tone5:", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf"}, {":wrestlers:", "\xf0\x9f\xa4\xbc"}, {":wrestlers_tone1:", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbb"}, {":wrestlers_tone2:", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbc"}, {":wrestlers_tone3:", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbd"}, {":wrestlers_tone4:", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbe"}, {":wrestlers_tone5:", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbf"}, {":water_polo:", "\xf0\x9f\xa4\xbd"}, {":water_polo_tone1:", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb"}, {":water_polo_tone2:", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc"}, {":water_polo_tone3:", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd"}, {":water_polo_tone4:", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe"}, {":water_polo_tone5:", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf"}, {":handball:", "\xf0\x9f\xa4\xbe"}, {":handball_tone1:", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb"}, {":handball_tone2:", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc"}, {":handball_tone3:", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd"}, {":handball_tone4:", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe"}, {":handball_tone5:", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf"}, {":juggling:", "\xf0\x9f\xa4\xb9"}, {":juggling_tone1:", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb"}, {":juggling_tone2:", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc"}, {":juggling_tone3:", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd"}, {":juggling_tone4:", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe"}, {":juggling_tone5:", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf"}, {":couple:", "\xf0\x9f\x91\xab"}, {":two_men_holding_hands:", "\xf0\x9f\x91\xac"}, {":two_women_holding_hands:", "\xf0\x9f\x91\xad"}, {":couplekiss:", "\xf0\x9f\x92\x8f"}, {":couple_with_heart:", "\xf0\x9f\x92\x91"}, {":family:", "\xf0\x9f\x91\xaa"}, {":tone1:", "\xf0\x9f\x8f\xbb"}, {":tone2:", "\xf0\x9f\x8f\xbc"}, {":tone3:", "\xf0\x9f\x8f\xbd"}, {":tone4:", "\xf0\x9f\x8f\xbe"}, {":tone5:", "\xf0\x9f\x8f\xbf"}, {":muscle:", "\xf0\x9f\x92\xaa"}, {":muscle_tone1:", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbb"}, {":muscle_tone2:", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbc"}, {":muscle_tone3:", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbd"}, {":muscle_tone4:", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbe"}, {":muscle_tone5:", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbf"}, {":selfie:", "\xf0\x9f\xa4\xb3"}, {":selfie_tone1:", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbb"}, {":selfie_tone2:", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbc"}, {":selfie_tone3:", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbd"}, {":selfie_tone4:", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbe"}, {":selfie_tone5:", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbf"}, {":point_left:", "\xf0\x9f\x91\x88"}, {":point_left_tone1:", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbb"}, {":point_left_tone2:", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbc"}, {":point_left_tone3:", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbd"}, {":point_left_tone4:", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbe"}, {":point_left_tone5:", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbf"}, {":point_right:", "\xf0\x9f\x91\x89"}, {":point_right_tone1:", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbb"}, {":point_right_tone2:", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbc"}, {":point_right_tone3:", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbd"}, {":point_right_tone4:", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbe"}, {":point_right_tone5:", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbf"}, {":point_up:", "\xe2\x98\x9d"}, {":point_up_tone1:", "\xe2\x98\x9d\xf0\x9f\x8f\xbb"}, {":point_up_tone2:", "\xe2\x98\x9d\xf0\x9f\x8f\xbc"}, {":point_up_tone3:", "\xe2\x98\x9d\xf0\x9f\x8f\xbd"}, {":point_up_tone4:", "\xe2\x98\x9d\xf0\x9f\x8f\xbe"}, {":point_up_tone5:", "\xe2\x98\x9d\xf0\x9f\x8f\xbf"}, {":point_up_2:", "\xf0\x9f\x91\x86"}, {":point_up_2_tone1:", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbb"}, {":point_up_2_tone2:", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbc"}, {":point_up_2_tone3:", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbd"}, {":point_up_2_tone4:", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbe"}, {":point_up_2_tone5:", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbf"}, {":middle_finger:", "\xf0\x9f\x96\x95"}, {":middle_finger_tone1:", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbb"}, {":middle_finger_tone2:", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbc"}, {":middle_finger_tone3:", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbd"}, {":middle_finger_tone4:", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbe"}, {":middle_finger_tone5:", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbf"}, {":point_down:", "\xf0\x9f\x91\x87"}, {":point_down_tone1:", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbb"}, {":point_down_tone2:", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbc"}, {":point_down_tone3:", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbd"}, {":point_down_tone4:", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbe"}, {":point_down_tone5:", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbf"}, {":v:", "\xe2\x9c\x8c"}, {":v_tone1:", "\xe2\x9c\x8c\xf0\x9f\x8f\xbb"}, {":v_tone2:", "\xe2\x9c\x8c\xf0\x9f\x8f\xbc"}, {":v_tone3:", "\xe2\x9c\x8c\xf0\x9f\x8f\xbd"}, {":v_tone4:", "\xe2\x9c\x8c\xf0\x9f\x8f\xbe"}, {":v_tone5:", "\xe2\x9c\x8c\xf0\x9f\x8f\xbf"}, {":fingers_crossed:", "\xf0\x9f\xa4\x9e"}, {":fingers_crossed_tone1:", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbb"}, {":fingers_crossed_tone2:", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbc"}, {":fingers_crossed_tone3:", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbd"}, {":fingers_crossed_tone4:", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbe"}, {":fingers_crossed_tone5:", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbf"}, {":vulcan:", "\xf0\x9f\x96\x96"}, {":vulcan_tone1:", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbb"}, {":vulcan_tone2:", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbc"}, {":vulcan_tone3:", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbd"}, {":vulcan_tone4:", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbe"}, {":vulcan_tone5:", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbf"}, {":metal:", "\xf0\x9f\xa4\x98"}, {":metal_tone1:", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbb"}, {":metal_tone2:", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbc"}, {":metal_tone3:", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbd"}, {":metal_tone4:", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbe"}, {":metal_tone5:", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbf"}, {":call_me:", "\xf0\x9f\xa4\x99"}, {":call_me_tone1:", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbb"}, {":call_me_tone2:", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbc"}, {":call_me_tone3:", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbd"}, {":call_me_tone4:", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbe"}, {":call_me_tone5:", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbf"}, {":hand_splayed:", "\xf0\x9f\x96\x90"}, {":hand_splayed_tone1:", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbb"}, {":hand_splayed_tone2:", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbc"}, {":hand_splayed_tone3:", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbd"}, {":hand_splayed_tone4:", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbe"}, {":hand_splayed_tone5:", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbf"}, {":raised_hand:", "\xe2\x9c\x8b"}, {":raised_hand_tone1:", "\xe2\x9c\x8b\xf0\x9f\x8f\xbb"}, {":raised_hand_tone2:", "\xe2\x9c\x8b\xf0\x9f\x8f\xbc"}, {":raised_hand_tone3:", "\xe2\x9c\x8b\xf0\x9f\x8f\xbd"}, {":raised_hand_tone4:", "\xe2\x9c\x8b\xf0\x9f\x8f\xbe"}, {":raised_hand_tone5:", "\xe2\x9c\x8b\xf0\x9f\x8f\xbf"}, {":ok_hand:", "\xf0\x9f\x91\x8c"}, {":ok_hand_tone1:", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbb"}, {":ok_hand_tone2:", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbc"}, {":ok_hand_tone3:", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbd"}, {":ok_hand_tone4:", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbe"}, {":ok_hand_tone5:", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbf"}, {":thumbsup:", "\xf0\x9f\x91\x8d"}, {":thumbsup_tone1:", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbb"}, {":thumbsup_tone2:", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbc"}, {":thumbsup_tone3:", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbd"}, {":thumbsup_tone4:", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbe"}, {":thumbsup_tone5:", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbf"}, {":thumbsdown:", "\xf0\x9f\x91\x8e"}, {":thumbsdown_tone1:", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbb"}, {":thumbsdown_tone2:", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbc"}, {":thumbsdown_tone3:", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbd"}, {":thumbsdown_tone4:", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbe"}, {":thumbsdown_tone5:", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbf"}, {":fist:", "\xe2\x9c\x8a"}, {":fist_tone1:", "\xe2\x9c\x8a\xf0\x9f\x8f\xbb"}, {":fist_tone2:", "\xe2\x9c\x8a\xf0\x9f\x8f\xbc"}, {":fist_tone3:", "\xe2\x9c\x8a\xf0\x9f\x8f\xbd"}, {":fist_tone4:", "\xe2\x9c\x8a\xf0\x9f\x8f\xbe"}, {":fist_tone5:", "\xe2\x9c\x8a\xf0\x9f\x8f\xbf"}, {":punch:", "\xf0\x9f\x91\x8a"}, {":punch_tone1:", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbb"}, {":punch_tone2:", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbc"}, {":punch_tone3:", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbd"}, {":punch_tone4:", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbe"}, {":punch_tone5:", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbf"}, {":left_facing_fist:", "\xf0\x9f\xa4\x9b"}, {":left_facing_fist_tone1:", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbb"}, {":left_facing_fist_tone2:", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbc"}, {":left_facing_fist_tone3:", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbd"}, {":left_facing_fist_tone4:", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbe"}, {":left_facing_fist_tone5:", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbf"}, {":right_facing_fist:", "\xf0\x9f\xa4\x9c"}, {":right_facing_fist_tone1:", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbb"}, {":right_facing_fist_tone2:", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbc"}, {":right_facing_fist_tone3:", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbd"}, {":right_facing_fist_tone4:", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbe"}, {":right_facing_fist_tone5:", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbf"}, {":raised_back_of_hand:", "\xf0\x9f\xa4\x9a"}, {":raised_back_of_hand_tone1:", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbb"}, {":raised_back_of_hand_tone2:", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbc"}, {":raised_back_of_hand_tone3:", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbd"}, {":raised_back_of_hand_tone4:", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbe"}, {":raised_back_of_hand_tone5:", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbf"}, {":wave:", "\xf0\x9f\x91\x8b"}, {":wave_tone1:", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbb"}, {":wave_tone2:", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbc"}, {":wave_tone3:", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbd"}, {":wave_tone4:", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbe"}, {":wave_tone5:", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbf"}, {":clap:", "\xf0\x9f\x91\x8f"}, {":clap_tone1:", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbb"}, {":clap_tone2:", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbc"}, {":clap_tone3:", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbd"}, {":clap_tone4:", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbe"}, {":clap_tone5:", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbf"}, {":writing_hand:", "\xe2\x9c\x8d"}, {":writing_hand_tone1:", "\xe2\x9c\x8d\xf0\x9f\x8f\xbb"}, {":writing_hand_tone2:", "\xe2\x9c\x8d\xf0\x9f\x8f\xbc"}, {":writing_hand_tone3:", "\xe2\x9c\x8d\xf0\x9f\x8f\xbd"}, {":writing_hand_tone4:", "\xe2\x9c\x8d\xf0\x9f\x8f\xbe"}, {":writing_hand_tone5:", "\xe2\x9c\x8d\xf0\x9f\x8f\xbf"}, {":open_hands:", "\xf0\x9f\x91\x90"}, {":open_hands_tone1:", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbb"}, {":open_hands_tone2:", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbc"}, {":open_hands_tone3:", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbd"}, {":open_hands_tone4:", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbe"}, {":open_hands_tone5:", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbf"}, {":raised_hands:", "\xf0\x9f\x99\x8c"}, {":raised_hands_tone1:", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbb"}, {":raised_hands_tone2:", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbc"}, {":raised_hands_tone3:", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbd"}, {":raised_hands_tone4:", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbe"}, {":raised_hands_tone5:", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbf"}, {":pray:", "\xf0\x9f\x99\x8f"}, {":pray_tone1:", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbb"}, {":pray_tone2:", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbc"}, {":pray_tone3:", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbd"}, {":pray_tone4:", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbe"}, {":pray_tone5:", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbf"}, {":handshake:", "\xf0\x9f\xa4\x9d"}, {":handshake_tone1:", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbb"}, {":handshake_tone2:", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbc"}, {":handshake_tone3:", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbd"}, {":handshake_tone4:", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbe"}, {":handshake_tone5:", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbf"}, {":nail_care:", "\xf0\x9f\x92\x85"}, {":nail_care_tone1:", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbb"}, {":nail_care_tone2:", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbc"}, {":nail_care_tone3:", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbd"}, {":nail_care_tone4:", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbe"}, {":nail_care_tone5:", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbf"}, {":ear:", "\xf0\x9f\x91\x82"}, {":ear_tone1:", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbb"}, {":ear_tone2:", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbc"}, {":ear_tone3:", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbd"}, {":ear_tone4:", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbe"}, {":ear_tone5:", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbf"}, {":nose:", "\xf0\x9f\x91\x83"}, {":nose_tone1:", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbb"}, {":nose_tone2:", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbc"}, {":nose_tone3:", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbd"}, {":nose_tone4:", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbe"}, {":nose_tone5:", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbf"}, {":footprints:", "\xf0\x9f\x91\xa3"}, {":eyes:", "\xf0\x9f\x91\x80"}, {":eye:", "\xf0\x9f\x91\x81"}, {":eye_in_speech_bubble:", "\xf0\x9f\x91\x81\xf0\x9f\x97\xa8"}, {":tongue:", "\xf0\x9f\x91\x85"}, {":lips:", "\xf0\x9f\x91\x84"}, {":kiss:", "\xf0\x9f\x92\x8b"}, {":cupid:", "\xf0\x9f\x92\x98"}, {":heart:", "\xe2\x9d\xa4"}, {":heartbeat:", "\xf0\x9f\x92\x93"}, {":broken_heart:", "\xf0\x9f\x92\x94"}, {":two_hearts:", "\xf0\x9f\x92\x95"}, {":sparkling_heart:", "\xf0\x9f\x92\x96"}, {":heartpulse:", "\xf0\x9f\x92\x97"}, {":blue_heart:", "\xf0\x9f\x92\x99"}, {":green_heart:", "\xf0\x9f\x92\x9a"}, {":yellow_heart:", "\xf0\x9f\x92\x9b"}, {":purple_heart:", "\xf0\x9f\x92\x9c"}, {":black_heart:", "\xf0\x9f\x96\xa4"}, {":gift_heart:", "\xf0\x9f\x92\x9d"}, {":revolving_hearts:", "\xf0\x9f\x92\x9e"}, {":heart_decoration:", "\xf0\x9f\x92\x9f"}, {":heart_exclamation:", "\xe2\x9d\xa3"}, {":love_letter:", "\xf0\x9f\x92\x8c"}, {":zzz:", "\xf0\x9f\x92\xa4"}, {":anger:", "\xf0\x9f\x92\xa2"}, {":bomb:", "\xf0\x9f\x92\xa3"}, {":boom:", "\xf0\x9f\x92\xa5"}, {":sweat_drops:", "\xf0\x9f\x92\xa6"}, {":dash:", "\xf0\x9f\x92\xa8"}, {":dizzy:", "\xf0\x9f\x92\xab"}, {":speech_balloon:", "\xf0\x9f\x92\xac"}, {":speech_left:", "\xf0\x9f\x97\xa8"}, {":anger_right:", "\xf0\x9f\x97\xaf"}, {":thought_balloon:", "\xf0\x9f\x92\xad"}, {":hole:", "\xf0\x9f\x95\xb3"}, {":eyeglasses:", "\xf0\x9f\x91\x93"}, {":dark_sunglasses:", "\xf0\x9f\x95\xb6"}, {":necktie:", "\xf0\x9f\x91\x94"}, {":shirt:", "\xf0\x9f\x91\x95"}, {":jeans:", "\xf0\x9f\x91\x96"}, {":dress:", "\xf0\x9f\x91\x97"}, {":kimono:", "\xf0\x9f\x91\x98"}, {":bikini:", "\xf0\x9f\x91\x99"}, {":womans_clothes:", "\xf0\x9f\x91\x9a"}, {":purse:", "\xf0\x9f\x91\x9b"}, {":handbag:", "\xf0\x9f\x91\x9c"}, {":pouch:", "\xf0\x9f\x91\x9d"}, {":shopping_bags:", "\xf0\x9f\x9b\x8d"}, {":school_satchel:", "\xf0\x9f\x8e\x92"}, {":mans_shoe:", "\xf0\x9f\x91\x9e"}, {":athletic_shoe:", "\xf0\x9f\x91\x9f"}, {":high_heel:", "\xf0\x9f\x91\xa0"}, {":sandal:", "\xf0\x9f\x91\xa1"}, {":boot:", "\xf0\x9f\x91\xa2"}, {":crown:", "\xf0\x9f\x91\x91"}, {":womans_hat:", "\xf0\x9f\x91\x92"}, {":tophat:", "\xf0\x9f\x8e\xa9"}, {":mortar_board:", "\xf0\x9f\x8e\x93"}, {":helmet_with_cross:", "\xe2\x9b\x91"}, {":prayer_beads:", "\xf0\x9f\x93\xbf"}, {":lipstick:", "\xf0\x9f\x92\x84"}, {":ring:", "\xf0\x9f\x92\x8d"}, {":gem:", "\xf0\x9f\x92\x8e"}, {":monkey_face:", "\xf0\x9f\x90\xb5"}, {":monkey:", "\xf0\x9f\x90\x92"}, {":gorilla:", "\xf0\x9f\xa6\x8d"}, {":dog:", "\xf0\x9f\x90\xb6"}, {":dog2:", "\xf0\x9f\x90\x95"}, {":poodle:", "\xf0\x9f\x90\xa9"}, {":wolf:", "\xf0\x9f\x90\xba"}, {":fox:", "\xf0\x9f\xa6\x8a"}, {":cat:", "\xf0\x9f\x90\xb1"}, {":cat2:", "\xf0\x9f\x90\x88"}, {":lion_face:", "\xf0\x9f\xa6\x81"}, {":tiger:", "\xf0\x9f\x90\xaf"}, {":tiger2:", "\xf0\x9f\x90\x85"}, {":leopard:", "\xf0\x9f\x90\x86"}, {":horse:", "\xf0\x9f\x90\xb4"}, {":racehorse:", "\xf0\x9f\x90\x8e"}, {":deer:", "\xf0\x9f\xa6\x8c"}, {":unicorn:", "\xf0\x9f\xa6\x84"}, {":cow:", "\xf0\x9f\x90\xae"}, {":ox:", "\xf0\x9f\x90\x82"}, {":water_buffalo:", "\xf0\x9f\x90\x83"}, {":cow2:", "\xf0\x9f\x90\x84"}, {":pig:", "\xf0\x9f\x90\xb7"}, {":pig2:", "\xf0\x9f\x90\x96"}, {":boar:", "\xf0\x9f\x90\x97"}, {":pig_nose:", "\xf0\x9f\x90\xbd"}, {":ram:", "\xf0\x9f\x90\x8f"}, {":sheep:", "\xf0\x9f\x90\x91"}, {":goat:", "\xf0\x9f\x90\x90"}, {":dromedary_camel:", "\xf0\x9f\x90\xaa"}, {":camel:", "\xf0\x9f\x90\xab"}, {":elephant:", "\xf0\x9f\x90\x98"}, {":rhino:", "\xf0\x9f\xa6\x8f"}, {":mouse:", "\xf0\x9f\x90\xad"}, {":mouse2:", "\xf0\x9f\x90\x81"}, {":rat:", "\xf0\x9f\x90\x80"}, {":hamster:", "\xf0\x9f\x90\xb9"}, {":rabbit:", "\xf0\x9f\x90\xb0"}, {":rabbit2:", "\xf0\x9f\x90\x87"}, {":chipmunk:", "\xf0\x9f\x90\xbf"}, {":bat:", "\xf0\x9f\xa6\x87"}, {":bear:", "\xf0\x9f\x90\xbb"}, {":koala:", "\xf0\x9f\x90\xa8"}, {":panda_face:", "\xf0\x9f\x90\xbc"}, {":feet:", "\xf0\x9f\x90\xbe"}, {":turkey:", "\xf0\x9f\xa6\x83"}, {":chicken:", "\xf0\x9f\x90\x94"}, {":rooster:", "\xf0\x9f\x90\x93"}, {":hatching_chick:", "\xf0\x9f\x90\xa3"}, {":baby_chick:", "\xf0\x9f\x90\xa4"}, {":hatched_chick:", "\xf0\x9f\x90\xa5"}, {":bird:", "\xf0\x9f\x90\xa6"}, {":penguin:", "\xf0\x9f\x90\xa7"}, {":dove:", "\xf0\x9f\x95\x8a"}, {":eagle:", "\xf0\x9f\xa6\x85"}, {":duck:", "\xf0\x9f\xa6\x86"}, {":owl:", "\xf0\x9f\xa6\x89"}, {":frog:", "\xf0\x9f\x90\xb8"}, {":crocodile:", "\xf0\x9f\x90\x8a"}, {":turtle:", "\xf0\x9f\x90\xa2"}, {":lizard:", "\xf0\x9f\xa6\x8e"}, {":snake:", "\xf0\x9f\x90\x8d"}, {":dragon_face:", "\xf0\x9f\x90\xb2"}, {":dragon:", "\xf0\x9f\x90\x89"}, {":whale:", "\xf0\x9f\x90\xb3"}, {":whale2:", "\xf0\x9f\x90\x8b"}, {":dolphin:", "\xf0\x9f\x90\xac"}, {":fish:", "\xf0\x9f\x90\x9f"}, {":tropical_fish:", "\xf0\x9f\x90\xa0"}, {":blowfish:", "\xf0\x9f\x90\xa1"}, {":shark:", "\xf0\x9f\xa6\x88"}, {":octopus:", "\xf0\x9f\x90\x99"}, {":shell:", "\xf0\x9f\x90\x9a"}, {":crab:", "\xf0\x9f\xa6\x80"}, {":shrimp:", "\xf0\x9f\xa6\x90"}, {":squid:", "\xf0\x9f\xa6\x91"}, {":butterfly:", "\xf0\x9f\xa6\x8b"}, {":snail:", "\xf0\x9f\x90\x8c"}, {":bug:", "\xf0\x9f\x90\x9b"}, {":ant:", "\xf0\x9f\x90\x9c"}, {":bee:", "\xf0\x9f\x90\x9d"}, {":beetle:", "\xf0\x9f\x90\x9e"}, {":spider:", "\xf0\x9f\x95\xb7"}, {":spider_web:", "\xf0\x9f\x95\xb8"}, {":scorpion:", "\xf0\x9f\xa6\x82"}, {":bouquet:", "\xf0\x9f\x92\x90"}, {":cherry_blossom:", "\xf0\x9f\x8c\xb8"}, {":white_flower:", "\xf0\x9f\x92\xae"}, {":rosette:", "\xf0\x9f\x8f\xb5"}, {":rose:", "\xf0\x9f\x8c\xb9"}, {":wilted_rose:", "\xf0\x9f\xa5\x80"}, {":hibiscus:", "\xf0\x9f\x8c\xba"}, {":sunflower:", "\xf0\x9f\x8c\xbb"}, {":blossom:", "\xf0\x9f\x8c\xbc"}, {":tulip:", "\xf0\x9f\x8c\xb7"}, {":seedling:", "\xf0\x9f\x8c\xb1"}, {":evergreen_tree:", "\xf0\x9f\x8c\xb2"}, {":deciduous_tree:", "\xf0\x9f\x8c\xb3"}, {":palm_tree:", "\xf0\x9f\x8c\xb4"}, {":cactus:", "\xf0\x9f\x8c\xb5"}, {":ear_of_rice:", "\xf0\x9f\x8c\xbe"}, {":herb:", "\xf0\x9f\x8c\xbf"}, {":shamrock:", "\xe2\x98\x98"}, {":four_leaf_clover:", "\xf0\x9f\x8d\x80"}, {":maple_leaf:", "\xf0\x9f\x8d\x81"}, {":fallen_leaf:", "\xf0\x9f\x8d\x82"}, {":leaves:", "\xf0\x9f\x8d\x83"}, {":grapes:", "\xf0\x9f\x8d\x87"}, {":melon:", "\xf0\x9f\x8d\x88"}, {":watermelon:", "\xf0\x9f\x8d\x89"}, {":tangerine:", "\xf0\x9f\x8d\x8a"}, {":lemon:", "\xf0\x9f\x8d\x8b"}, {":banana:", "\xf0\x9f\x8d\x8c"}, {":pineapple:", "\xf0\x9f\x8d\x8d"}, {":apple:", "\xf0\x9f\x8d\x8e"}, {":green_apple:", "\xf0\x9f\x8d\x8f"}, {":pear:", "\xf0\x9f\x8d\x90"}, {":peach:", "\xf0\x9f\x8d\x91"}, {":cherries:", "\xf0\x9f\x8d\x92"}, {":strawberry:", "\xf0\x9f\x8d\x93"}, {":kiwi:", "\xf0\x9f\xa5\x9d"}, {":tomato:", "\xf0\x9f\x8d\x85"}, {":avocado:", "\xf0\x9f\xa5\x91"}, {":eggplant:", "\xf0\x9f\x8d\x86"}, {":potato:", "\xf0\x9f\xa5\x94"}, {":carrot:", "\xf0\x9f\xa5\x95"}, {":corn:", "\xf0\x9f\x8c\xbd"}, {":hot_pepper:", "\xf0\x9f\x8c\xb6"}, {":cucumber:", "\xf0\x9f\xa5\x92"}, {":mushroom:", "\xf0\x9f\x8d\x84"}, {":peanuts:", "\xf0\x9f\xa5\x9c"}, {":chestnut:", "\xf0\x9f\x8c\xb0"}, {":bread:", "\xf0\x9f\x8d\x9e"}, {":croissant:", "\xf0\x9f\xa5\x90"}, {":french_bread:", "\xf0\x9f\xa5\x96"}, {":pancakes:", "\xf0\x9f\xa5\x9e"}, {":cheese:", "\xf0\x9f\xa7\x80"}, {":meat_on_bone:", "\xf0\x9f\x8d\x96"}, {":poultry_leg:", "\xf0\x9f\x8d\x97"}, {":bacon:", "\xf0\x9f\xa5\x93"}, {":hamburger:", "\xf0\x9f\x8d\x94"}, {":fries:", "\xf0\x9f\x8d\x9f"}, {":pizza:", "\xf0\x9f\x8d\x95"}, {":hotdog:", "\xf0\x9f\x8c\xad"}, {":taco:", "\xf0\x9f\x8c\xae"}, {":burrito:", "\xf0\x9f\x8c\xaf"}, {":stuffed_flatbread:", "\xf0\x9f\xa5\x99"}, {":egg:", "\xf0\x9f\xa5\x9a"}, {":cooking:", "\xf0\x9f\x8d\xb3"}, {":shallow_pan_of_food:", "\xf0\x9f\xa5\x98"}, {":stew:", "\xf0\x9f\x8d\xb2"}, {":salad:", "\xf0\x9f\xa5\x97"}, {":popcorn:", "\xf0\x9f\x8d\xbf"}, {":bento:", "\xf0\x9f\x8d\xb1"}, {":rice_cracker:", "\xf0\x9f\x8d\x98"}, {":rice_ball:", "\xf0\x9f\x8d\x99"}, {":rice:", "\xf0\x9f\x8d\x9a"}, {":curry:", "\xf0\x9f\x8d\x9b"}, {":ramen:", "\xf0\x9f\x8d\x9c"}, {":spaghetti:", "\xf0\x9f\x8d\x9d"}, {":sweet_potato:", "\xf0\x9f\x8d\xa0"}, {":oden:", "\xf0\x9f\x8d\xa2"}, {":sushi:", "\xf0\x9f\x8d\xa3"}, {":fried_shrimp:", "\xf0\x9f\x8d\xa4"}, {":fish_cake:", "\xf0\x9f\x8d\xa5"}, {":dango:", "\xf0\x9f\x8d\xa1"}, {":icecream:", "\xf0\x9f\x8d\xa6"}, {":shaved_ice:", "\xf0\x9f\x8d\xa7"}, {":ice_cream:", "\xf0\x9f\x8d\xa8"}, {":doughnut:", "\xf0\x9f\x8d\xa9"}, {":cookie:", "\xf0\x9f\x8d\xaa"}, {":birthday:", "\xf0\x9f\x8e\x82"}, {":cake:", "\xf0\x9f\x8d\xb0"}, {":chocolate_bar:", "\xf0\x9f\x8d\xab"}, {":candy:", "\xf0\x9f\x8d\xac"}, {":lollipop:", "\xf0\x9f\x8d\xad"}, {":custard:", "\xf0\x9f\x8d\xae"}, {":honey_pot:", "\xf0\x9f\x8d\xaf"}, {":baby_bottle:", "\xf0\x9f\x8d\xbc"}, {":milk:", "\xf0\x9f\xa5\x9b"}, {":coffee:", "\xe2\x98\x95"}, {":tea:", "\xf0\x9f\x8d\xb5"}, {":sake:", "\xf0\x9f\x8d\xb6"}, {":champagne:", "\xf0\x9f\x8d\xbe"}, {":wine_glass:", "\xf0\x9f\x8d\xb7"}, {":cocktail:", "\xf0\x9f\x8d\xb8"}, {":tropical_drink:", "\xf0\x9f\x8d\xb9"}, {":beer:", "\xf0\x9f\x8d\xba"}, {":beers:", "\xf0\x9f\x8d\xbb"}, {":champagne_glass:", "\xf0\x9f\xa5\x82"}, {":tumbler_glass:", "\xf0\x9f\xa5\x83"}, {":fork_knife_plate:", "\xf0\x9f\x8d\xbd"}, {":fork_and_knife:", "\xf0\x9f\x8d\xb4"}, {":spoon:", "\xf0\x9f\xa5\x84"}, {":knife:", "\xf0\x9f\x94\xaa"}, {":amphora:", "\xf0\x9f\x8f\xba"}, {":earth_africa:", "\xf0\x9f\x8c\x8d"}, {":earth_americas:", "\xf0\x9f\x8c\x8e"}, {":earth_asia:", "\xf0\x9f\x8c\x8f"}, {":globe_with_meridians:", "\xf0\x9f\x8c\x90"}, {":map:", "\xf0\x9f\x97\xba"}, {":japan:", "\xf0\x9f\x97\xbe"}, {":mountain_snow:", "\xf0\x9f\x8f\x94"}, {":mountain:", "\xe2\x9b\xb0"}, {":volcano:", "\xf0\x9f\x8c\x8b"}, {":mount_fuji:", "\xf0\x9f\x97\xbb"}, {":camping:", "\xf0\x9f\x8f\x95"}, {":beach:", "\xf0\x9f\x8f\x96"}, {":desert:", "\xf0\x9f\x8f\x9c"}, {":island:", "\xf0\x9f\x8f\x9d"}, {":park:", "\xf0\x9f\x8f\x9e"}, {":stadium:", "\xf0\x9f\x8f\x9f"}, {":classical_building:", "\xf0\x9f\x8f\x9b"}, {":construction_site:", "\xf0\x9f\x8f\x97"}, {":homes:", "\xf0\x9f\x8f\x98"}, {":cityscape:", "\xf0\x9f\x8f\x99"}, {":house_abandoned:", "\xf0\x9f\x8f\x9a"}, {":house:", "\xf0\x9f\x8f\xa0"}, {":house_with_garden:", "\xf0\x9f\x8f\xa1"}, {":office:", "\xf0\x9f\x8f\xa2"}, {":post_office:", "\xf0\x9f\x8f\xa3"}, {":european_post_office:", "\xf0\x9f\x8f\xa4"}, {":hospital:", "\xf0\x9f\x8f\xa5"}, {":bank:", "\xf0\x9f\x8f\xa6"}, {":hotel:", "\xf0\x9f\x8f\xa8"}, {":love_hotel:", "\xf0\x9f\x8f\xa9"}, {":convenience_store:", "\xf0\x9f\x8f\xaa"}, {":school:", "\xf0\x9f\x8f\xab"}, {":department_store:", "\xf0\x9f\x8f\xac"}, {":factory:", "\xf0\x9f\x8f\xad"}, {":japanese_castle:", "\xf0\x9f\x8f\xaf"}, {":european_castle:", "\xf0\x9f\x8f\xb0"}, {":wedding:", "\xf0\x9f\x92\x92"}, {":tokyo_tower:", "\xf0\x9f\x97\xbc"}, {":statue_of_liberty:", "\xf0\x9f\x97\xbd"}, {":church:", "\xe2\x9b\xaa"}, {":mosque:", "\xf0\x9f\x95\x8c"}, {":synagogue:", "\xf0\x9f\x95\x8d"}, {":shinto_shrine:", "\xe2\x9b\xa9"}, {":kaaba:", "\xf0\x9f\x95\x8b"}, {":fountain:", "\xe2\x9b\xb2"}, {":tent:", "\xe2\x9b\xba"}, {":foggy:", "\xf0\x9f\x8c\x81"}, {":night_with_stars:", "\xf0\x9f\x8c\x83"}, {":sunrise_over_mountains:", "\xf0\x9f\x8c\x84"}, {":sunrise:", "\xf0\x9f\x8c\x85"}, {":city_dusk:", "\xf0\x9f\x8c\x86"}, {":city_sunset:", "\xf0\x9f\x8c\x87"}, {":bridge_at_night:", "\xf0\x9f\x8c\x89"}, {":hotsprings:", "\xe2\x99\xa8"}, {":milky_way:", "\xf0\x9f\x8c\x8c"}, {":carousel_horse:", "\xf0\x9f\x8e\xa0"}, {":ferris_wheel:", "\xf0\x9f\x8e\xa1"}, {":roller_coaster:", "\xf0\x9f\x8e\xa2"}, {":barber:", "\xf0\x9f\x92\x88"}, {":circus_tent:", "\xf0\x9f\x8e\xaa"}, {":performing_arts:", "\xf0\x9f\x8e\xad"}, {":frame_photo:", "\xf0\x9f\x96\xbc"}, {":art:", "\xf0\x9f\x8e\xa8"}, {":slot_machine:", "\xf0\x9f\x8e\xb0"}, {":steam_locomotive:", "\xf0\x9f\x9a\x82"}, {":railway_car:", "\xf0\x9f\x9a\x83"}, {":bullettrain_side:", "\xf0\x9f\x9a\x84"}, {":bullettrain_front:", "\xf0\x9f\x9a\x85"}, {":train2:", "\xf0\x9f\x9a\x86"}, {":metro:", "\xf0\x9f\x9a\x87"}, {":light_rail:", "\xf0\x9f\x9a\x88"}, {":station:", "\xf0\x9f\x9a\x89"}, {":tram:", "\xf0\x9f\x9a\x8a"}, {":monorail:", "\xf0\x9f\x9a\x9d"}, {":mountain_railway:", "\xf0\x9f\x9a\x9e"}, {":train:", "\xf0\x9f\x9a\x8b"}, {":bus:", "\xf0\x9f\x9a\x8c"}, {":oncoming_bus:", "\xf0\x9f\x9a\x8d"}, {":trolleybus:", "\xf0\x9f\x9a\x8e"}, {":minibus:", "\xf0\x9f\x9a\x90"}, {":ambulance:", "\xf0\x9f\x9a\x91"}, {":fire_engine:", "\xf0\x9f\x9a\x92"}, {":police_car:", "\xf0\x9f\x9a\x93"}, {":oncoming_police_car:", "\xf0\x9f\x9a\x94"}, {":taxi:", "\xf0\x9f\x9a\x95"}, {":oncoming_taxi:", "\xf0\x9f\x9a\x96"}, {":red_car:", "\xf0\x9f\x9a\x97"}, {":oncoming_automobile:", "\xf0\x9f\x9a\x98"}, {":blue_car:", "\xf0\x9f\x9a\x99"}, {":truck:", "\xf0\x9f\x9a\x9a"}, {":articulated_lorry:", "\xf0\x9f\x9a\x9b"}, {":tractor:", "\xf0\x9f\x9a\x9c"}, {":bike:", "\xf0\x9f\x9a\xb2"}, {":scooter:", "\xf0\x9f\x9b\xb4"}, {":motor_scooter:", "\xf0\x9f\x9b\xb5"}, {":busstop:", "\xf0\x9f\x9a\x8f"}, {":motorway:", "\xf0\x9f\x9b\xa3"}, {":railway_track:", "\xf0\x9f\x9b\xa4"}, {":fuelpump:", "\xe2\x9b\xbd"}, {":rotating_light:", "\xf0\x9f\x9a\xa8"}, {":traffic_light:", "\xf0\x9f\x9a\xa5"}, {":vertical_traffic_light:", "\xf0\x9f\x9a\xa6"}, {":construction:", "\xf0\x9f\x9a\xa7"}, {":octagonal_sign:", "\xf0\x9f\x9b\x91"}, {":anchor:", "\xe2\x9a\x93"}, {":sailboat:", "\xe2\x9b\xb5"}, {":canoe:", "\xf0\x9f\x9b\xb6"}, {":speedboat:", "\xf0\x9f\x9a\xa4"}, {":cruise_ship:", "\xf0\x9f\x9b\xb3"}, {":ferry:", "\xe2\x9b\xb4"}, {":motorboat:", "\xf0\x9f\x9b\xa5"}, {":ship:", "\xf0\x9f\x9a\xa2"}, {":airplane:", "\xe2\x9c\x88"}, {":airplane_small:", "\xf0\x9f\x9b\xa9"}, {":airplane_departure:", "\xf0\x9f\x9b\xab"}, {":airplane_arriving:", "\xf0\x9f\x9b\xac"}, {":seat:", "\xf0\x9f\x92\xba"}, {":helicopter:", "\xf0\x9f\x9a\x81"}, {":suspension_railway:", "\xf0\x9f\x9a\x9f"}, {":mountain_cableway:", "\xf0\x9f\x9a\xa0"}, {":aerial_tramway:", "\xf0\x9f\x9a\xa1"}, {":rocket:", "\xf0\x9f\x9a\x80"}, {":satellite_orbital:", "\xf0\x9f\x9b\xb0"}, {":bellhop:", "\xf0\x9f\x9b\x8e"}, {":door:", "\xf0\x9f\x9a\xaa"}, {":sleeping_accommodation:", "\xf0\x9f\x9b\x8c"}, {":bed:", "\xf0\x9f\x9b\x8f"}, {":couch:", "\xf0\x9f\x9b\x8b"}, {":toilet:", "\xf0\x9f\x9a\xbd"}, {":shower:", "\xf0\x9f\x9a\xbf"}, {":bath:", "\xf0\x9f\x9b\x80"}, {":bath_tone1:", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbb"}, {":bath_tone2:", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbc"}, {":bath_tone3:", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbd"}, {":bath_tone4:", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbe"}, {":bath_tone5:", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbf"}, {":bathtub:", "\xf0\x9f\x9b\x81"}, {":hourglass:", "\xe2\x8c\x9b"}, {":hourglass_flowing_sand:", "\xe2\x8f\xb3"}, {":watch:", "\xe2\x8c\x9a"}, {":alarm_clock:", "\xe2\x8f\xb0"}, {":stopwatch:", "\xe2\x8f\xb1"}, {":timer:", "\xe2\x8f\xb2"}, {":clock:", "\xf0\x9f\x95\xb0"}, {":clock12:", "\xf0\x9f\x95\x9b"}, {":clock1230:", "\xf0\x9f\x95\xa7"}, {":clock1:", "\xf0\x9f\x95\x90"}, {":clock130:", "\xf0\x9f\x95\x9c"}, {":clock2:", "\xf0\x9f\x95\x91"}, {":clock230:", "\xf0\x9f\x95\x9d"}, {":clock3:", "\xf0\x9f\x95\x92"}, {":clock330:", "\xf0\x9f\x95\x9e"}, {":clock4:", "\xf0\x9f\x95\x93"}, {":clock430:", "\xf0\x9f\x95\x9f"}, {":clock5:", "\xf0\x9f\x95\x94"}, {":clock530:", "\xf0\x9f\x95\xa0"}, {":clock6:", "\xf0\x9f\x95\x95"}, {":clock630:", "\xf0\x9f\x95\xa1"}, {":clock7:", "\xf0\x9f\x95\x96"}, {":clock730:", "\xf0\x9f\x95\xa2"}, {":clock8:", "\xf0\x9f\x95\x97"}, {":clock830:", "\xf0\x9f\x95\xa3"}, {":clock9:", "\xf0\x9f\x95\x98"}, {":clock930:", "\xf0\x9f\x95\xa4"}, {":clock10:", "\xf0\x9f\x95\x99"}, {":clock1030:", "\xf0\x9f\x95\xa5"}, {":clock11:", "\xf0\x9f\x95\x9a"}, {":clock1130:", "\xf0\x9f\x95\xa6"}, {":new_moon:", "\xf0\x9f\x8c\x91"}, {":waxing_crescent_moon:", "\xf0\x9f\x8c\x92"}, {":first_quarter_moon:", "\xf0\x9f\x8c\x93"}, {":waxing_gibbous_moon:", "\xf0\x9f\x8c\x94"}, {":full_moon:", "\xf0\x9f\x8c\x95"}, {":waning_gibbous_moon:", "\xf0\x9f\x8c\x96"}, {":last_quarter_moon:", "\xf0\x9f\x8c\x97"}, {":waning_crescent_moon:", "\xf0\x9f\x8c\x98"}, {":crescent_moon:", "\xf0\x9f\x8c\x99"}, {":new_moon_with_face:", "\xf0\x9f\x8c\x9a"}, {":first_quarter_moon_with_face:", "\xf0\x9f\x8c\x9b"}, {":last_quarter_moon_with_face:", "\xf0\x9f\x8c\x9c"}, {":thermometer:", "\xf0\x9f\x8c\xa1"}, {":sunny:", "\xe2\x98\x80"}, {":full_moon_with_face:", "\xf0\x9f\x8c\x9d"}, {":sun_with_face:", "\xf0\x9f\x8c\x9e"}, {":star:", "\xe2\xad\x90"}, {":star2:", "\xf0\x9f\x8c\x9f"}, {":stars:", "\xf0\x9f\x8c\xa0"}, {":cloud:", "\xe2\x98\x81"}, {":partly_sunny:", "\xe2\x9b\x85"}, {":thunder_cloud_rain:", "\xe2\x9b\x88"}, {":white_sun_small_cloud:", "\xf0\x9f\x8c\xa4"}, {":white_sun_cloud:", "\xf0\x9f\x8c\xa5"}, {":white_sun_rain_cloud:", "\xf0\x9f\x8c\xa6"}, {":cloud_rain:", "\xf0\x9f\x8c\xa7"}, {":cloud_snow:", "\xf0\x9f\x8c\xa8"}, {":cloud_lightning:", "\xf0\x9f\x8c\xa9"}, {":cloud_tornado:", "\xf0\x9f\x8c\xaa"}, {":fog:", "\xf0\x9f\x8c\xab"}, {":wind_blowing_face:", "\xf0\x9f\x8c\xac"}, {":cyclone:", "\xf0\x9f\x8c\x80"}, {":rainbow:", "\xf0\x9f\x8c\x88"}, {":closed_umbrella:", "\xf0\x9f\x8c\x82"}, {":umbrella2:", "\xe2\x98\x82"}, {":umbrella:", "\xe2\x98\x94"}, {":beach_umbrella:", "\xe2\x9b\xb1"}, {":zap:", "\xe2\x9a\xa1"}, {":snowflake:", "\xe2\x9d\x84"}, {":snowman2:", "\xe2\x98\x83"}, {":snowman:", "\xe2\x9b\x84"}, {":comet:", "\xe2\x98\x84"}, {":fire:", "\xf0\x9f\x94\xa5"}, {":droplet:", "\xf0\x9f\x92\xa7"}, {":ocean:", "\xf0\x9f\x8c\x8a"}, {":jack_o_lantern:", "\xf0\x9f\x8e\x83"}, {":christmas_tree:", "\xf0\x9f\x8e\x84"}, {":fireworks:", "\xf0\x9f\x8e\x86"}, {":sparkler:", "\xf0\x9f\x8e\x87"}, {":sparkles:", "\xe2\x9c\xa8"}, {":balloon:", "\xf0\x9f\x8e\x88"}, {":tada:", "\xf0\x9f\x8e\x89"}, {":confetti_ball:", "\xf0\x9f\x8e\x8a"}, {":tanabata_tree:", "\xf0\x9f\x8e\x8b"}, {":bamboo:", "\xf0\x9f\x8e\x8d"}, {":dolls:", "\xf0\x9f\x8e\x8e"}, {":flags:", "\xf0\x9f\x8e\x8f"}, {":wind_chime:", "\xf0\x9f\x8e\x90"}, {":rice_scene:", "\xf0\x9f\x8e\x91"}, {":ribbon:", "\xf0\x9f\x8e\x80"}, {":gift:", "\xf0\x9f\x8e\x81"}, {":reminder_ribbon:", "\xf0\x9f\x8e\x97"}, {":tickets:", "\xf0\x9f\x8e\x9f"}, {":ticket:", "\xf0\x9f\x8e\xab"}, {":military_medal:", "\xf0\x9f\x8e\x96"}, {":trophy:", "\xf0\x9f\x8f\x86"}, {":medal:", "\xf0\x9f\x8f\x85"}, {":first_place:", "\xf0\x9f\xa5\x87"}, {":second_place:", "\xf0\x9f\xa5\x88"}, {":third_place:", "\xf0\x9f\xa5\x89"}, {":soccer:", "\xe2\x9a\xbd"}, {":baseball:", "\xe2\x9a\xbe"}, {":basketball:", "\xf0\x9f\x8f\x80"}, {":volleyball:", "\xf0\x9f\x8f\x90"}, {":football:", "\xf0\x9f\x8f\x88"}, {":rugby_football:", "\xf0\x9f\x8f\x89"}, {":tennis:", "\xf0\x9f\x8e\xbe"}, {":8ball:", "\xf0\x9f\x8e\xb1"}, {":bowling:", "\xf0\x9f\x8e\xb3"}, {":cricket:", "\xf0\x9f\x8f\x8f"}, {":field_hockey:", "\xf0\x9f\x8f\x91"}, {":hockey:", "\xf0\x9f\x8f\x92"}, {":ping_pong:", "\xf0\x9f\x8f\x93"}, {":badminton:", "\xf0\x9f\x8f\xb8"}, {":boxing_glove:", "\xf0\x9f\xa5\x8a"}, {":martial_arts_uniform:", "\xf0\x9f\xa5\x8b"}, {":goal:", "\xf0\x9f\xa5\x85"}, {":dart:", "\xf0\x9f\x8e\xaf"}, {":golf:", "\xe2\x9b\xb3"}, {":ice_skate:", "\xe2\x9b\xb8"}, {":fishing_pole_and_fish:", "\xf0\x9f\x8e\xa3"}, {":running_shirt_with_sash:", "\xf0\x9f\x8e\xbd"}, {":ski:", "\xf0\x9f\x8e\xbf"}, {":video_game:", "\xf0\x9f\x8e\xae"}, {":joystick:", "\xf0\x9f\x95\xb9"}, {":game_die:", "\xf0\x9f\x8e\xb2"}, {":spades:", "\xe2\x99\xa0"}, {":hearts:", "\xe2\x99\xa5"}, {":diamonds:", "\xe2\x99\xa6"}, {":clubs:", "\xe2\x99\xa3"}, {":black_joker:", "\xf0\x9f\x83\x8f"}, {":mahjong:", "\xf0\x9f\x80\x84"}, {":flower_playing_cards:", "\xf0\x9f\x8e\xb4"}, {":mute:", "\xf0\x9f\x94\x87"}, {":speaker:", "\xf0\x9f\x94\x88"}, {":sound:", "\xf0\x9f\x94\x89"}, {":loud_sound:", "\xf0\x9f\x94\x8a"}, {":loudspeaker:", "\xf0\x9f\x93\xa2"}, {":mega:", "\xf0\x9f\x93\xa3"}, {":postal_horn:", "\xf0\x9f\x93\xaf"}, {":bell:", "\xf0\x9f\x94\x94"}, {":no_bell:", "\xf0\x9f\x94\x95"}, {":musical_score:", "\xf0\x9f\x8e\xbc"}, {":musical_note:", "\xf0\x9f\x8e\xb5"}, {":notes:", "\xf0\x9f\x8e\xb6"}, {":microphone2:", "\xf0\x9f\x8e\x99"}, {":level_slider:", "\xf0\x9f\x8e\x9a"}, {":control_knobs:", "\xf0\x9f\x8e\x9b"}, {":microphone:", "\xf0\x9f\x8e\xa4"}, {":headphones:", "\xf0\x9f\x8e\xa7"}, {":radio:", "\xf0\x9f\x93\xbb"}, {":saxophone:", "\xf0\x9f\x8e\xb7"}, {":guitar:", "\xf0\x9f\x8e\xb8"}, {":musical_keyboard:", "\xf0\x9f\x8e\xb9"}, {":trumpet:", "\xf0\x9f\x8e\xba"}, {":violin:", "\xf0\x9f\x8e\xbb"}, {":drum:", "\xf0\x9f\xa5\x81"}, {":iphone:", "\xf0\x9f\x93\xb1"}, {":calling:", "\xf0\x9f\x93\xb2"}, {":telephone:", "\xe2\x98\x8e"}, {":telephone_receiver:", "\xf0\x9f\x93\x9e"}, {":pager:", "\xf0\x9f\x93\x9f"}, {":fax:", "\xf0\x9f\x93\xa0"}, {":battery:", "\xf0\x9f\x94\x8b"}, {":electric_plug:", "\xf0\x9f\x94\x8c"}, {":computer:", "\xf0\x9f\x92\xbb"}, {":desktop:", "\xf0\x9f\x96\xa5"}, {":printer:", "\xf0\x9f\x96\xa8"}, {":keyboard:", "\xe2\x8c\xa8"}, {":mouse_three_button:", "\xf0\x9f\x96\xb1"}, {":trackball:", "\xf0\x9f\x96\xb2"}, {":minidisc:", "\xf0\x9f\x92\xbd"}, {":floppy_disk:", "\xf0\x9f\x92\xbe"}, {":cd:", "\xf0\x9f\x92\xbf"}, {":dvd:", "\xf0\x9f\x93\x80"}, {":movie_camera:", "\xf0\x9f\x8e\xa5"}, {":film_frames:", "\xf0\x9f\x8e\x9e"}, {":projector:", "\xf0\x9f\x93\xbd"}, {":clapper:", "\xf0\x9f\x8e\xac"}, {":tv:", "\xf0\x9f\x93\xba"}, {":camera:", "\xf0\x9f\x93\xb7"}, {":camera_with_flash:", "\xf0\x9f\x93\xb8"}, {":video_camera:", "\xf0\x9f\x93\xb9"}, {":vhs:", "\xf0\x9f\x93\xbc"}, {":mag:", "\xf0\x9f\x94\x8d"}, {":mag_right:", "\xf0\x9f\x94\x8e"}, {":microscope:", "\xf0\x9f\x94\xac"}, {":telescope:", "\xf0\x9f\x94\xad"}, {":satellite:", "\xf0\x9f\x93\xa1"}, {":candle:", "\xf0\x9f\x95\xaf"}, {":bulb:", "\xf0\x9f\x92\xa1"}, {":flashlight:", "\xf0\x9f\x94\xa6"}, {":izakaya_lantern:", "\xf0\x9f\x8f\xae"}, {":notebook_with_decorative_cover:", "\xf0\x9f\x93\x94"}, {":closed_book:", "\xf0\x9f\x93\x95"}, {":book:", "\xf0\x9f\x93\x96"}, {":green_book:", "\xf0\x9f\x93\x97"}, {":blue_book:", "\xf0\x9f\x93\x98"}, {":orange_book:", "\xf0\x9f\x93\x99"}, {":books:", "\xf0\x9f\x93\x9a"}, {":notebook:", "\xf0\x9f\x93\x93"}, {":ledger:", "\xf0\x9f\x93\x92"}, {":page_with_curl:", "\xf0\x9f\x93\x83"}, {":scroll:", "\xf0\x9f\x93\x9c"}, {":page_facing_up:", "\xf0\x9f\x93\x84"}, {":newspaper:", "\xf0\x9f\x93\xb0"}, {":newspaper2:", "\xf0\x9f\x97\x9e"}, {":bookmark_tabs:", "\xf0\x9f\x93\x91"}, {":bookmark:", "\xf0\x9f\x94\x96"}, {":label:", "\xf0\x9f\x8f\xb7"}, {":moneybag:", "\xf0\x9f\x92\xb0"}, {":yen:", "\xf0\x9f\x92\xb4"}, {":dollar:", "\xf0\x9f\x92\xb5"}, {":euro:", "\xf0\x9f\x92\xb6"}, {":pound:", "\xf0\x9f\x92\xb7"}, {":money_with_wings:", "\xf0\x9f\x92\xb8"}, {":credit_card:", "\xf0\x9f\x92\xb3"}, {":chart:", "\xf0\x9f\x92\xb9"}, {":currency_exchange:", "\xf0\x9f\x92\xb1"}, {":heavy_dollar_sign:", "\xf0\x9f\x92\xb2"}, {":envelope:", "\xe2\x9c\x89"}, {":e-mail:", "\xf0\x9f\x93\xa7"}, {":incoming_envelope:", "\xf0\x9f\x93\xa8"}, {":envelope_with_arrow:", "\xf0\x9f\x93\xa9"}, {":outbox_tray:", "\xf0\x9f\x93\xa4"}, {":inbox_tray:", "\xf0\x9f\x93\xa5"}, {":package:", "\xf0\x9f\x93\xa6"}, {":mailbox:", "\xf0\x9f\x93\xab"}, {":mailbox_closed:", "\xf0\x9f\x93\xaa"}, {":mailbox_with_mail:", "\xf0\x9f\x93\xac"}, {":mailbox_with_no_mail:", "\xf0\x9f\x93\xad"}, {":postbox:", "\xf0\x9f\x93\xae"}, {":ballot_box:", "\xf0\x9f\x97\xb3"}, {":pencil2:", "\xe2\x9c\x8f"}, {":black_nib:", "\xe2\x9c\x92"}, {":pen_fountain:", "\xf0\x9f\x96\x8b"}, {":pen_ballpoint:", "\xf0\x9f\x96\x8a"}, {":paintbrush:", "\xf0\x9f\x96\x8c"}, {":crayon:", "\xf0\x9f\x96\x8d"}, {":pencil:", "\xf0\x9f\x93\x9d"}, {":briefcase:", "\xf0\x9f\x92\xbc"}, {":file_folder:", "\xf0\x9f\x93\x81"}, {":open_file_folder:", "\xf0\x9f\x93\x82"}, {":dividers:", "\xf0\x9f\x97\x82"}, {":date:", "\xf0\x9f\x93\x85"}, {":calendar:", "\xf0\x9f\x93\x86"}, {":notepad_spiral:", "\xf0\x9f\x97\x92"}, {":calendar_spiral:", "\xf0\x9f\x97\x93"}, {":card_index:", "\xf0\x9f\x93\x87"}, {":chart_with_upwards_trend:", "\xf0\x9f\x93\x88"}, {":chart_with_downwards_trend:", "\xf0\x9f\x93\x89"}, {":bar_chart:", "\xf0\x9f\x93\x8a"}, {":clipboard:", "\xf0\x9f\x93\x8b"}, {":pushpin:", "\xf0\x9f\x93\x8c"}, {":round_pushpin:", "\xf0\x9f\x93\x8d"}, {":paperclip:", "\xf0\x9f\x93\x8e"}, {":paperclips:", "\xf0\x9f\x96\x87"}, {":straight_ruler:", "\xf0\x9f\x93\x8f"}, {":triangular_ruler:", "\xf0\x9f\x93\x90"}, {":scissors:", "\xe2\x9c\x82"}, {":card_box:", "\xf0\x9f\x97\x83"}, {":file_cabinet:", "\xf0\x9f\x97\x84"}, {":wastebasket:", "\xf0\x9f\x97\x91"}, {":lock:", "\xf0\x9f\x94\x92"}, {":unlock:", "\xf0\x9f\x94\x93"}, {":lock_with_ink_pen:", "\xf0\x9f\x94\x8f"}, {":closed_lock_with_key:", "\xf0\x9f\x94\x90"}, {":key:", "\xf0\x9f\x94\x91"}, {":key2:", "\xf0\x9f\x97\x9d"}, {":hammer:", "\xf0\x9f\x94\xa8"}, {":pick:", "\xe2\x9b\x8f"}, {":hammer_pick:", "\xe2\x9a\x92"}, {":tools:", "\xf0\x9f\x9b\xa0"}, {":dagger:", "\xf0\x9f\x97\xa1"}, {":crossed_swords:", "\xe2\x9a\x94"}, {":gun:", "\xf0\x9f\x94\xab"}, {":bow_and_arrow:", "\xf0\x9f\x8f\xb9"}, {":shield:", "\xf0\x9f\x9b\xa1"}, {":wrench:", "\xf0\x9f\x94\xa7"}, {":nut_and_bolt:", "\xf0\x9f\x94\xa9"}, {":gear:", "\xe2\x9a\x99"}, {":compression:", "\xf0\x9f\x97\x9c"}, {":alembic:", "\xe2\x9a\x97"}, {":scales:", "\xe2\x9a\x96"}, {":link:", "\xf0\x9f\x94\x97"}, {":chains:", "\xe2\x9b\x93"}, {":syringe:", "\xf0\x9f\x92\x89"}, {":pill:", "\xf0\x9f\x92\x8a"}, {":smoking:", "\xf0\x9f\x9a\xac"}, {":coffin:", "\xe2\x9a\xb0"}, {":urn:", "\xe2\x9a\xb1"}, {":moyai:", "\xf0\x9f\x97\xbf"}, {":oil:", "\xf0\x9f\x9b\xa2"}, {":crystal_ball:", "\xf0\x9f\x94\xae"}, {":shopping_cart:", "\xf0\x9f\x9b\x92"}, {":atm:", "\xf0\x9f\x8f\xa7"}, {":put_litter_in_its_place:", "\xf0\x9f\x9a\xae"}, {":potable_water:", "\xf0\x9f\x9a\xb0"}, {":wheelchair:", "\xe2\x99\xbf"}, {":mens:", "\xf0\x9f\x9a\xb9"}, {":womens:", "\xf0\x9f\x9a\xba"}, {":restroom:", "\xf0\x9f\x9a\xbb"}, {":baby_symbol:", "\xf0\x9f\x9a\xbc"}, {":wc:", "\xf0\x9f\x9a\xbe"}, {":passport_control:", "\xf0\x9f\x9b\x82"}, {":customs:", "\xf0\x9f\x9b\x83"}, {":baggage_claim:", "\xf0\x9f\x9b\x84"}, {":left_luggage:", "\xf0\x9f\x9b\x85"}, {":warning:", "\xe2\x9a\xa0"}, {":children_crossing:", "\xf0\x9f\x9a\xb8"}, {":no_entry:", "\xe2\x9b\x94"}, {":no_entry_sign:", "\xf0\x9f\x9a\xab"}, {":no_bicycles:", "\xf0\x9f\x9a\xb3"}, {":no_smoking:", "\xf0\x9f\x9a\xad"}, {":do_not_litter:", "\xf0\x9f\x9a\xaf"}, {":non-potable_water:", "\xf0\x9f\x9a\xb1"}, {":no_pedestrians:", "\xf0\x9f\x9a\xb7"}, {":no_mobile_phones:", "\xf0\x9f\x93\xb5"}, {":underage:", "\xf0\x9f\x94\x9e"}, {":radioactive:", "\xe2\x98\xa2"}, {":biohazard:", "\xe2\x98\xa3"}, {":arrow_up:", "\xe2\xac\x86"}, {":arrow_upper_right:", "\xe2\x86\x97"}, {":arrow_right:", "\xe2\x9e\xa1"}, {":arrow_lower_right:", "\xe2\x86\x98"}, {":arrow_down:", "\xe2\xac\x87"}, {":arrow_lower_left:", "\xe2\x86\x99"}, {":arrow_left:", "\xe2\xac\x85"}, {":arrow_upper_left:", "\xe2\x86\x96"}, {":arrow_up_down:", "\xe2\x86\x95"}, {":left_right_arrow:", "\xe2\x86\x94"}, {":leftwards_arrow_with_hook:", "\xe2\x86\xa9"}, {":arrow_right_hook:", "\xe2\x86\xaa"}, {":arrow_heading_up:", "\xe2\xa4\xb4"}, {":arrow_heading_down:", "\xe2\xa4\xb5"}, {":arrows_clockwise:", "\xf0\x9f\x94\x83"}, {":arrows_counterclockwise:", "\xf0\x9f\x94\x84"}, {":back:", "\xf0\x9f\x94\x99"}, {":end:", "\xf0\x9f\x94\x9a"}, {":on:", "\xf0\x9f\x94\x9b"}, {":soon:", "\xf0\x9f\x94\x9c"}, {":top:", "\xf0\x9f\x94\x9d"}, {":place_of_worship:", "\xf0\x9f\x9b\x90"}, {":atom:", "\xe2\x9a\x9b"}, {":om_symbol:", "\xf0\x9f\x95\x89"}, {":star_of_david:", "\xe2\x9c\xa1"}, {":wheel_of_dharma:", "\xe2\x98\xb8"}, {":yin_yang:", "\xe2\x98\xaf"}, {":cross:", "\xe2\x9c\x9d"}, {":orthodox_cross:", "\xe2\x98\xa6"}, {":star_and_crescent:", "\xe2\x98\xaa"}, {":peace:", "\xe2\x98\xae"}, {":menorah:", "\xf0\x9f\x95\x8e"}, {":six_pointed_star:", "\xf0\x9f\x94\xaf"}, {":aries:", "\xe2\x99\x88"}, {":taurus:", "\xe2\x99\x89"}, {":gemini:", "\xe2\x99\x8a"}, {":cancer:", "\xe2\x99\x8b"}, {":leo:", "\xe2\x99\x8c"}, {":virgo:", "\xe2\x99\x8d"}, {":libra:", "\xe2\x99\x8e"}, {":scorpius:", "\xe2\x99\x8f"}, {":sagittarius:", "\xe2\x99\x90"}, {":capricorn:", "\xe2\x99\x91"}, {":aquarius:", "\xe2\x99\x92"}, {":pisces:", "\xe2\x99\x93"}, {":ophiuchus:", "\xe2\x9b\x8e"}, {":twisted_rightwards_arrows:", "\xf0\x9f\x94\x80"}, {":repeat:", "\xf0\x9f\x94\x81"}, {":repeat_one:", "\xf0\x9f\x94\x82"}, {":arrow_forward:", "\xe2\x96\xb6"}, {":fast_forward:", "\xe2\x8f\xa9"}, {":track_next:", "\xe2\x8f\xad"}, {":play_pause:", "\xe2\x8f\xaf"}, {":arrow_backward:", "\xe2\x97\x80"}, {":rewind:", "\xe2\x8f\xaa"}, {":track_previous:", "\xe2\x8f\xae"}, {":arrow_up_small:", "\xf0\x9f\x94\xbc"}, {":arrow_double_up:", "\xe2\x8f\xab"}, {":arrow_down_small:", "\xf0\x9f\x94\xbd"}, {":arrow_double_down:", "\xe2\x8f\xac"}, {":pause_button:", "\xe2\x8f\xb8"}, {":stop_button:", "\xe2\x8f\xb9"}, {":record_button:", "\xe2\x8f\xba"}, {":eject:", "\xe2\x8f\x8f"}, {":cinema:", "\xf0\x9f\x8e\xa6"}, {":low_brightness:", "\xf0\x9f\x94\x85"}, {":high_brightness:", "\xf0\x9f\x94\x86"}, {":signal_strength:", "\xf0\x9f\x93\xb6"}, {":vibration_mode:", "\xf0\x9f\x93\xb3"}, {":mobile_phone_off:", "\xf0\x9f\x93\xb4"}, {":recycle:", "\xe2\x99\xbb"}, {":name_badge:", "\xf0\x9f\x93\x9b"}, {":fleur-de-lis:", "\xe2\x9a\x9c"}, {":beginner:", "\xf0\x9f\x94\xb0"}, {":trident:", "\xf0\x9f\x94\xb1"}, {":o:", "\xe2\xad\x95"}, {":white_check_mark:", "\xe2\x9c\x85"}, {":ballot_box_with_check:", "\xe2\x98\x91"}, {":heavy_check_mark:", "\xe2\x9c\x94"}, {":heavy_multiplication_x:", "\xe2\x9c\x96"}, {":x:", "\xe2\x9d\x8c"}, {":negative_squared_cross_mark:", "\xe2\x9d\x8e"}, {":heavy_plus_sign:", "\xe2\x9e\x95"}, {":heavy_minus_sign:", "\xe2\x9e\x96"}, {":heavy_division_sign:", "\xe2\x9e\x97"}, {":curly_loop:", "\xe2\x9e\xb0"}, {":loop:", "\xe2\x9e\xbf"}, {":part_alternation_mark:", "\xe3\x80\xbd"}, {":eight_spoked_asterisk:", "\xe2\x9c\xb3"}, {":eight_pointed_black_star:", "\xe2\x9c\xb4"}, {":sparkle:", "\xe2\x9d\x87"}, {":bangbang:", "\xe2\x80\xbc"}, {":interrobang:", "\xe2\x81\x89"}, {":question:", "\xe2\x9d\x93"}, {":grey_question:", "\xe2\x9d\x94"}, {":grey_exclamation:", "\xe2\x9d\x95"}, {":exclamation:", "\xe2\x9d\x97"}, {":wavy_dash:", "\xe3\x80\xb0"}, {":copyright:", "\xc2\xa9"}, {":registered:", "\xc2\xae"}, {":tm:", "\xe2\x84\xa2"}, {":hash:", "\x23\xe2\x83\xa3"}, {":asterisk:", "\x2a\xe2\x83\xa3"}, {":zero:", "\x30\xe2\x83\xa3"}, {":one:", "\x31\xe2\x83\xa3"}, {":two:", "\x32\xe2\x83\xa3"}, {":three:", "\x33\xe2\x83\xa3"}, {":four:", "\x34\xe2\x83\xa3"}, {":five:", "\x35\xe2\x83\xa3"}, {":six:", "\x36\xe2\x83\xa3"}, {":seven:", "\x37\xe2\x83\xa3"}, {":eight:", "\x38\xe2\x83\xa3"}, {":nine:", "\x39\xe2\x83\xa3"}, {":keycap_ten:", "\xf0\x9f\x94\x9f"}, {":capital_abcd:", "\xf0\x9f\x94\xa0"}, {":abcd:", "\xf0\x9f\x94\xa1"}, {":symbols:", "\xf0\x9f\x94\xa3"}, {":abc:", "\xf0\x9f\x94\xa4"}, {":a:", "\xf0\x9f\x85\xb0"}, {":ab:", "\xf0\x9f\x86\x8e"}, {":b:", "\xf0\x9f\x85\xb1"}, {":cl:", "\xf0\x9f\x86\x91"}, {":cool:", "\xf0\x9f\x86\x92"}, {":free:", "\xf0\x9f\x86\x93"}, {":information_source:", "\xe2\x84\xb9"}, {":id:", "\xf0\x9f\x86\x94"}, {":m:", "\xe2\x93\x82"}, {":new:", "\xf0\x9f\x86\x95"}, {":ng:", "\xf0\x9f\x86\x96"}, {":o2:", "\xf0\x9f\x85\xbe"}, {":ok:", "\xf0\x9f\x86\x97"}, {":parking:", "\xf0\x9f\x85\xbf"}, {":sos:", "\xf0\x9f\x86\x98"}, {":up:", "\xf0\x9f\x86\x99"}, {":vs:", "\xf0\x9f\x86\x9a"}, {":koko:", "\xf0\x9f\x88\x81"}, {":sa:", "\xf0\x9f\x88\x82"}, {":u6708:", "\xf0\x9f\x88\xb7"}, {":u6709:", "\xf0\x9f\x88\xb6"}, {":u6307:", "\xf0\x9f\x88\xaf"}, {":ideograph_advantage:", "\xf0\x9f\x89\x90"}, {":u5272:", "\xf0\x9f\x88\xb9"}, {":u7121:", "\xf0\x9f\x88\x9a"}, {":u7981:", "\xf0\x9f\x88\xb2"}, {":accept:", "\xf0\x9f\x89\x91"}, {":u7533:", "\xf0\x9f\x88\xb8"}, {":u5408:", "\xf0\x9f\x88\xb4"}, {":u7a7a:", "\xf0\x9f\x88\xb3"}, {":congratulations:", "\xe3\x8a\x97"}, {":secret:", "\xe3\x8a\x99"}, {":u55b6:", "\xf0\x9f\x88\xba"}, {":u6e80:", "\xf0\x9f\x88\xb5"}, {":black_small_square:", "\xe2\x96\xaa"}, {":white_small_square:", "\xe2\x96\xab"}, {":white_medium_square:", "\xe2\x97\xbb"}, {":black_medium_square:", "\xe2\x97\xbc"}, {":white_medium_small_square:", "\xe2\x97\xbd"}, {":black_medium_small_square:", "\xe2\x97\xbe"}, {":black_large_square:", "\xe2\xac\x9b"}, {":white_large_square:", "\xe2\xac\x9c"}, {":large_orange_diamond:", "\xf0\x9f\x94\xb6"}, {":large_blue_diamond:", "\xf0\x9f\x94\xb7"}, {":small_orange_diamond:", "\xf0\x9f\x94\xb8"}, {":small_blue_diamond:", "\xf0\x9f\x94\xb9"}, {":small_red_triangle:", "\xf0\x9f\x94\xba"}, {":small_red_triangle_down:", "\xf0\x9f\x94\xbb"}, {":diamond_shape_with_a_dot_inside:", "\xf0\x9f\x92\xa0"}, {":radio_button:", "\xf0\x9f\x94\x98"}, {":black_square_button:", "\xf0\x9f\x94\xb2"}, {":white_square_button:", "\xf0\x9f\x94\xb3"}, {":white_circle:", "\xe2\x9a\xaa"}, {":black_circle:", "\xe2\x9a\xab"}, {":red_circle:", "\xf0\x9f\x94\xb4"}, {":blue_circle:", "\xf0\x9f\x94\xb5"}, {":checkered_flag:", "\xf0\x9f\x8f\x81"}, {":triangular_flag_on_post:", "\xf0\x9f\x9a\xa9"}, {":crossed_flags:", "\xf0\x9f\x8e\x8c"}, {":flag_black:", "\xf0\x9f\x8f\xb4"}, {":flag_white:", "\xf0\x9f\x8f\xb3"}, {":rainbow_flag:", "\xf0\x9f\x8f\xb3\xf0\x9f\x8c\x88"}, {":flag_ac:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xa8"}, {":flag_ad:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xa9"}, {":flag_ae:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xaa"}, {":flag_af:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xab"}, {":flag_ag:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xac"}, {":flag_ai:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xae"}, {":flag_al:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb1"}, {":flag_am:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb2"}, {":flag_ao:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb4"}, {":flag_aq:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb6"}, {":flag_ar:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb7"}, {":flag_as:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb8"}, {":flag_at:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb9"}, {":flag_au:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xba"}, {":flag_aw:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbc"}, {":flag_ax:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbd"}, {":flag_az:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbf"}, {":flag_ba:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa6"}, {":flag_bb:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa7"}, {":flag_bd:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa9"}, {":flag_be:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xaa"}, {":flag_bf:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xab"}, {":flag_bg:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xac"}, {":flag_bh:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xad"}, {":flag_bi:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xae"}, {":flag_bj:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xaf"}, {":flag_bl:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb1"}, {":flag_bm:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb2"}, {":flag_bn:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb3"}, {":flag_bo:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb4"}, {":flag_bq:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb6"}, {":flag_br:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb7"}, {":flag_bs:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb8"}, {":flag_bt:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb9"}, {":flag_bv:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbb"}, {":flag_bw:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbc"}, {":flag_by:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbe"}, {":flag_bz:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbf"}, {":flag_ca:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa6"}, {":flag_cc:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa8"}, {":flag_cd:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa9"}, {":flag_cf:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xab"}, {":flag_cg:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xac"}, {":flag_ch:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xad"}, {":flag_ci:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xae"}, {":flag_ck:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb0"}, {":flag_cl:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb1"}, {":flag_cm:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb2"}, {":flag_cn:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb3"}, {":flag_co:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb4"}, {":flag_cp:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb5"}, {":flag_cr:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb7"}, {":flag_cu:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xba"}, {":flag_cv:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbb"}, {":flag_cw:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbc"}, {":flag_cx:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbd"}, {":flag_cy:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbe"}, {":flag_cz:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbf"}, {":flag_de:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xaa"}, {":flag_dg:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xac"}, {":flag_dj:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xaf"}, {":flag_dk:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb0"}, {":flag_dm:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb2"}, {":flag_do:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb4"}, {":flag_dz:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xbf"}, {":flag_ea:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xa6"}, {":flag_ec:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xa8"}, {":flag_ee:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xaa"}, {":flag_eg:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xac"}, {":flag_eh:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xad"}, {":flag_er:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb7"}, {":flag_es:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb8"}, {":flag_et:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb9"}, {":flag_eu:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xba"}, {":flag_fi:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xae"}, {":flag_fj:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xaf"}, {":flag_fk:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb0"}, {":flag_fm:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb2"}, {":flag_fo:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb4"}, {":flag_fr:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb7"}, {":flag_ga:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa6"}, {":flag_gb:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa7"}, {":flag_gd:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa9"}, {":flag_ge:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xaa"}, {":flag_gf:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xab"}, {":flag_gg:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xac"}, {":flag_gh:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xad"}, {":flag_gi:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xae"}, {":flag_gl:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb1"}, {":flag_gm:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb2"}, {":flag_gn:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb3"}, {":flag_gp:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb5"}, {":flag_gq:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb6"}, {":flag_gr:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb7"}, {":flag_gs:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb8"}, {":flag_gt:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb9"}, {":flag_gu:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xba"}, {":flag_gw:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xbc"}, {":flag_gy:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xbe"}, {":flag_hk:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb0"}, {":flag_hm:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb2"}, {":flag_hn:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb3"}, {":flag_hr:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb7"}, {":flag_ht:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb9"}, {":flag_hu:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xba"}, {":flag_ic:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xa8"}, {":flag_id:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xa9"}, {":flag_ie:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xaa"}, {":flag_il:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb1"}, {":flag_im:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb2"}, {":flag_in:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb3"}, {":flag_io:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb4"}, {":flag_iq:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb6"}, {":flag_ir:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb7"}, {":flag_is:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb8"}, {":flag_it:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb9"}, {":flag_je:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xaa"}, {":flag_jm:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb2"}, {":flag_jo:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb4"}, {":flag_jp:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb5"}, {":flag_ke:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xaa"}, {":flag_kg:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xac"}, {":flag_kh:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xad"}, {":flag_ki:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xae"}, {":flag_km:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb2"}, {":flag_kn:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb3"}, {":flag_kp:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb5"}, {":flag_kr:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb7"}, {":flag_kw:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbc"}, {":flag_ky:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbe"}, {":flag_kz:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbf"}, {":flag_la:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa6"}, {":flag_lb:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa7"}, {":flag_lc:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa8"}, {":flag_li:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xae"}, {":flag_lk:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb0"}, {":flag_lr:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb7"}, {":flag_ls:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb8"}, {":flag_lt:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb9"}, {":flag_lu:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xba"}, {":flag_lv:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xbb"}, {":flag_ly:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xbe"}, {":flag_ma:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa6"}, {":flag_mc:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa8"}, {":flag_md:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa9"}, {":flag_me:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xaa"}, {":flag_mf:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xab"}, {":flag_mg:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xac"}, {":flag_mh:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xad"}, {":flag_mk:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb0"}, {":flag_ml:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb1"}, {":flag_mm:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb2"}, {":flag_mn:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb3"}, {":flag_mo:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb4"}, {":flag_mp:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb5"}, {":flag_mq:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb6"}, {":flag_mr:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb7"}, {":flag_ms:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb8"}, {":flag_mt:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb9"}, {":flag_mu:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xba"}, {":flag_mv:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbb"}, {":flag_mw:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbc"}, {":flag_mx:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbd"}, {":flag_my:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbe"}, {":flag_mz:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbf"}, {":flag_na:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xa6"}, {":flag_nc:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xa8"}, {":flag_ne:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xaa"}, {":flag_nf:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xab"}, {":flag_ng:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xac"}, {":flag_ni:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xae"}, {":flag_nl:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb1"}, {":flag_no:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb4"}, {":flag_np:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb5"}, {":flag_nr:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb7"}, {":flag_nu:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xba"}, {":flag_nz:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xbf"}, {":flag_om:", "\xf0\x9f\x87\xb4\xf0\x9f\x87\xb2"}, {":flag_pa:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xa6"}, {":flag_pe:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xaa"}, {":flag_pf:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xab"}, {":flag_pg:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xac"}, {":flag_ph:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xad"}, {":flag_pk:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb0"}, {":flag_pl:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb1"}, {":flag_pm:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb2"}, {":flag_pn:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb3"}, {":flag_pr:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb7"}, {":flag_ps:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb8"}, {":flag_pt:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb9"}, {":flag_pw:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xbc"}, {":flag_py:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xbe"}, {":flag_qa:", "\xf0\x9f\x87\xb6\xf0\x9f\x87\xa6"}, {":flag_re:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xaa"}, {":flag_ro:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xb4"}, {":flag_rs:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xb8"}, {":flag_ru:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xba"}, {":flag_rw:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xbc"}, {":flag_sa:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa6"}, {":flag_sb:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa7"}, {":flag_sc:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa8"}, {":flag_sd:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa9"}, {":flag_se:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xaa"}, {":flag_sg:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xac"}, {":flag_sh:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xad"}, {":flag_si:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xae"}, {":flag_sj:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xaf"}, {":flag_sk:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb0"}, {":flag_sl:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb1"}, {":flag_sm:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb2"}, {":flag_sn:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb3"}, {":flag_so:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb4"}, {":flag_sr:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb7"}, {":flag_ss:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb8"}, {":flag_st:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb9"}, {":flag_sv:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbb"}, {":flag_sx:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbd"}, {":flag_sy:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbe"}, {":flag_sz:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbf"}, {":flag_ta:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa6"}, {":flag_tc:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa8"}, {":flag_td:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa9"}, {":flag_tf:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xab"}, {":flag_tg:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xac"}, {":flag_th:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xad"}, {":flag_tj:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xaf"}, {":flag_tk:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb0"}, {":flag_tl:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb1"}, {":flag_tm:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb2"}, {":flag_tn:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb3"}, {":flag_to:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb4"}, {":flag_tr:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb7"}, {":flag_tt:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb9"}, {":flag_tv:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbb"}, {":flag_tw:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbc"}, {":flag_tz:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbf"}, {":flag_ua:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xa6"}, {":flag_ug:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xac"}, {":flag_um:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xb2"}, {":flag_us:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xb8"}, {":flag_uy:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xbe"}, {":flag_uz:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xbf"}, {":flag_va:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xa6"}, {":flag_vc:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xa8"}, {":flag_ve:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xaa"}, {":flag_vg:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xac"}, {":flag_vi:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xae"}, {":flag_vn:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xb3"}, {":flag_vu:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xba"}, {":flag_wf:", "\xf0\x9f\x87\xbc\xf0\x9f\x87\xab"}, {":flag_ws:", "\xf0\x9f\x87\xbc\xf0\x9f\x87\xb8"}, {":flag_xk:", "\xf0\x9f\x87\xbd\xf0\x9f\x87\xb0"}, {":flag_ye:", "\xf0\x9f\x87\xbe\xf0\x9f\x87\xaa"}, {":flag_yt:", "\xf0\x9f\x87\xbe\xf0\x9f\x87\xb9"}, {":flag_za:", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xa6"}, {":flag_zm:", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xb2"}, {":flag_zw:", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xbc"}};

    const std::unordered_map<std::string, std::string> EmojiMapper::unicodeShortname = [](){
        std::unordered_map<std::string, std::string> unicodeSequenceToShortname;
        const auto& shortnameToUnicodeMap = EmojiMapper::shortnameUnicode;
        for (const auto& shortnameToUnicode : shortnameToUnicodeMap) {
            unicodeSequenceToShortname[shortnameToUnicode.second] = shortnameToUnicode.first;
        }
        return unicodeSequenceToShortname;
    }();

    const std::unordered_map<std::string, std::vector<std::string>> EmojiMapper::emojisInCategory = std::unordered_map<std::string, std::vector<std::string>>{{"symbols", {"\xf0\x9f\x92\xaf", "\xf0\x9f\x94\xa2", "\xf0\x9f\x91\x81\xf0\x9f\x97\xa8", "\xf0\x9f\x92\x98", "\xe2\x9d\xa4", "\xf0\x9f\x92\x93", "\xf0\x9f\x92\x94", "\xf0\x9f\x92\x95", "\xf0\x9f\x92\x96", "\xf0\x9f\x92\x97", "\xf0\x9f\x92\x99", "\xf0\x9f\x92\x9a", "\xf0\x9f\x92\x9b", "\xf0\x9f\x92\x9c", "\xf0\x9f\x96\xa4", "\xf0\x9f\x92\x9d", "\xf0\x9f\x92\x9e", "\xf0\x9f\x92\x9f", "\xe2\x9d\xa3", "\xf0\x9f\x92\xa2", "\xf0\x9f\x92\xa5", "\xf0\x9f\x92\xab", "\xf0\x9f\x92\xac", "\xf0\x9f\x97\xa8", "\xf0\x9f\x97\xaf", "\xf0\x9f\x92\xad", "\xf0\x9f\x92\xae", "\xf0\x9f\x8c\x90", "\xe2\x99\xa8", "\xf0\x9f\x9b\x91", "\xf0\x9f\x95\x9b", "\xf0\x9f\x95\xa7", "\xf0\x9f\x95\x90", "\xf0\x9f\x95\x9c", "\xf0\x9f\x95\x91", "\xf0\x9f\x95\x9d", "\xf0\x9f\x95\x92", "\xf0\x9f\x95\x9e", "\xf0\x9f\x95\x93", "\xf0\x9f\x95\x9f", "\xf0\x9f\x95\x94", "\xf0\x9f\x95\xa0", "\xf0\x9f\x95\x95", "\xf0\x9f\x95\xa1", "\xf0\x9f\x95\x96", "\xf0\x9f\x95\xa2", "\xf0\x9f\x95\x97", "\xf0\x9f\x95\xa3", "\xf0\x9f\x95\x98", "\xf0\x9f\x95\xa4", "\xf0\x9f\x95\x99", "\xf0\x9f\x95\xa5", "\xf0\x9f\x95\x9a", "\xf0\x9f\x95\xa6", "\xf0\x9f\x8c\x80", "\xe2\x99\xa0", "\xe2\x99\xa5", "\xe2\x99\xa6", "\xe2\x99\xa3", "\xf0\x9f\x83\x8f", "\xf0\x9f\x80\x84", "\xf0\x9f\x8e\xb4", "\xf0\x9f\x94\x87", "\xf0\x9f\x94\x88", "\xf0\x9f\x94\x89", "\xf0\x9f\x94\x8a", "\xf0\x9f\x93\xa2", "\xf0\x9f\x93\xa3", "\xf0\x9f\x94\x94", "\xf0\x9f\x94\x95", "\xf0\x9f\x8e\xb5", "\xf0\x9f\x8e\xb6", "\xf0\x9f\x92\xb9", "\xf0\x9f\x92\xb1", "\xf0\x9f\x92\xb2", "\xf0\x9f\x8f\xa7", "\xf0\x9f\x9a\xae", "\xf0\x9f\x9a\xb0", "\xe2\x99\xbf", "\xf0\x9f\x9a\xb9", "\xf0\x9f\x9a\xba", "\xf0\x9f\x9a\xbb", "\xf0\x9f\x9a\xbc", "\xf0\x9f\x9a\xbe", "\xf0\x9f\x9b\x82", "\xf0\x9f\x9b\x83", "\xf0\x9f\x9b\x84", "\xf0\x9f\x9b\x85", "\xe2\x9a\xa0", "\xf0\x9f\x9a\xb8", "\xe2\x9b\x94", "\xf0\x9f\x9a\xab", "\xf0\x9f\x9a\xb3", "\xf0\x9f\x9a\xad", "\xf0\x9f\x9a\xaf", "\xf0\x9f\x9a\xb1", "\xf0\x9f\x9a\xb7", "\xf0\x9f\x93\xb5", "\xf0\x9f\x94\x9e", "\xe2\x98\xa2", "\xe2\x98\xa3", "\xe2\xac\x86", "\xe2\x86\x97", "\xe2\x9e\xa1", "\xe2\x86\x98", "\xe2\xac\x87", "\xe2\x86\x99", "\xe2\xac\x85", "\xe2\x86\x96", "\xe2\x86\x95", "\xe2\x86\x94", "\xe2\x86\xa9", "\xe2\x86\xaa", "\xe2\xa4\xb4", "\xe2\xa4\xb5", "\xf0\x9f\x94\x83", "\xf0\x9f\x94\x84", "\xf0\x9f\x94\x99", "\xf0\x9f\x94\x9a", "\xf0\x9f\x94\x9b", "\xf0\x9f\x94\x9c", "\xf0\x9f\x94\x9d", "\xf0\x9f\x9b\x90", "\xe2\x9a\x9b", "\xf0\x9f\x95\x89", "\xe2\x9c\xa1", "\xe2\x98\xb8", "\xe2\x98\xaf", "\xe2\x9c\x9d", "\xe2\x98\xa6", "\xe2\x98\xaa", "\xe2\x98\xae", "\xf0\x9f\x95\x8e", "\xf0\x9f\x94\xaf", "\xe2\x99\x88", "\xe2\x99\x89", "\xe2\x99\x8a", "\xe2\x99\x8b", "\xe2\x99\x8c", "\xe2\x99\x8d", "\xe2\x99\x8e", "\xe2\x99\x8f", "\xe2\x99\x90", "\xe2\x99\x91", "\xe2\x99\x92", "\xe2\x99\x93", "\xe2\x9b\x8e", "\xf0\x9f\x94\x80", "\xf0\x9f\x94\x81", "\xf0\x9f\x94\x82", "\xe2\x96\xb6", "\xe2\x8f\xa9", "\xe2\x8f\xad", "\xe2\x8f\xaf", "\xe2\x97\x80", "\xe2\x8f\xaa", "\xe2\x8f\xae", "\xf0\x9f\x94\xbc", "\xe2\x8f\xab", "\xf0\x9f\x94\xbd", "\xe2\x8f\xac", "\xe2\x8f\xb8", "\xe2\x8f\xb9", "\xe2\x8f\xba", "\xe2\x8f\x8f", "\xf0\x9f\x8e\xa6", "\xf0\x9f\x94\x85", "\xf0\x9f\x94\x86", "\xf0\x9f\x93\xb6", "\xf0\x9f\x93\xb3", "\xf0\x9f\x93\xb4", "\xe2\x99\xbb", "\xf0\x9f\x93\x9b", "\xe2\x9a\x9c", "\xf0\x9f\x94\xb0", "\xf0\x9f\x94\xb1", "\xe2\xad\x95", "\xe2\x9c\x85", "\xe2\x98\x91", "\xe2\x9c\x94", "\xe2\x9c\x96", "\xe2\x9d\x8c", "\xe2\x9d\x8e", "\xe2\x9e\x95", "\xe2\x9e\x96", "\xe2\x9e\x97", "\xe2\x9e\xb0", "\xe2\x9e\xbf", "\xe3\x80\xbd", "\xe2\x9c\xb3", "\xe2\x9c\xb4", "\xe2\x9d\x87", "\xe2\x80\xbc", "\xe2\x81\x89", "\xe2\x9d\x93", "\xe2\x9d\x94", "\xe2\x9d\x95", "\xe2\x9d\x97", "\xe3\x80\xb0", "\xc2\xa9", "\xc2\xae", "\xe2\x84\xa2", "\x23\xe2\x83\xa3", "\x2a\xe2\x83\xa3", "\x30\xe2\x83\xa3", "\x31\xe2\x83\xa3", "\x32\xe2\x83\xa3", "\x33\xe2\x83\xa3", "\x34\xe2\x83\xa3", "\x35\xe2\x83\xa3", "\x36\xe2\x83\xa3", "\x37\xe2\x83\xa3", "\x38\xe2\x83\xa3", "\x39\xe2\x83\xa3", "\xf0\x9f\x94\x9f", "\xf0\x9f\x94\xa0", "\xf0\x9f\x94\xa1", "\xf0\x9f\x94\xa3", "\xf0\x9f\x94\xa4", "\xf0\x9f\x85\xb0", "\xf0\x9f\x86\x8e", "\xf0\x9f\x85\xb1", "\xf0\x9f\x86\x91", "\xf0\x9f\x86\x92", "\xf0\x9f\x86\x93", "\xe2\x84\xb9", "\xf0\x9f\x86\x94", "\xe2\x93\x82", "\xf0\x9f\x86\x95", "\xf0\x9f\x86\x96", "\xf0\x9f\x85\xbe", "\xf0\x9f\x86\x97", "\xf0\x9f\x85\xbf", "\xf0\x9f\x86\x98", "\xf0\x9f\x86\x99", "\xf0\x9f\x86\x9a", "\xf0\x9f\x88\x81", "\xf0\x9f\x88\x82", "\xf0\x9f\x88\xb7", "\xf0\x9f\x88\xb6", "\xf0\x9f\x88\xaf", "\xf0\x9f\x89\x90", "\xf0\x9f\x88\xb9", "\xf0\x9f\x88\x9a", "\xf0\x9f\x88\xb2", "\xf0\x9f\x89\x91", "\xf0\x9f\x88\xb8", "\xf0\x9f\x88\xb4", "\xf0\x9f\x88\xb3", "\xe3\x8a\x97", "\xe3\x8a\x99", "\xf0\x9f\x88\xba", "\xf0\x9f\x88\xb5", "\xe2\x96\xaa", "\xe2\x96\xab", "\xe2\x97\xbb", "\xe2\x97\xbc", "\xe2\x97\xbd", "\xe2\x97\xbe", "\xe2\xac\x9b", "\xe2\xac\x9c", "\xf0\x9f\x94\xb6", "\xf0\x9f\x94\xb7", "\xf0\x9f\x94\xb8", "\xf0\x9f\x94\xb9", "\xf0\x9f\x94\xba", "\xf0\x9f\x94\xbb", "\xf0\x9f\x92\xa0", "\xf0\x9f\x94\x98", "\xf0\x9f\x94\xb2", "\xf0\x9f\x94\xb3", "\xe2\x9a\xaa", "\xe2\x9a\xab", "\xf0\x9f\x94\xb4", "\xf0\x9f\x94\xb5"}}, {"people", {"\xf0\x9f\x98\x80", "\xf0\x9f\x98\x81", "\xf0\x9f\x98\x82", "\xf0\x9f\xa4\xa3", "\xf0\x9f\x98\x83", "\xf0\x9f\x98\x84", "\xf0\x9f\x98\x85", "\xf0\x9f\x98\x86", "\xf0\x9f\x98\x89", "\xf0\x9f\x98\x8a", "\xf0\x9f\x98\x8b", "\xf0\x9f\x98\x8e", "\xf0\x9f\x98\x8d", "\xf0\x9f\x98\x98", "\xf0\x9f\x98\x97", "\xf0\x9f\x98\x99", "\xf0\x9f\x98\x9a", "\xe2\x98\xba", "\xf0\x9f\x99\x82", "\xf0\x9f\xa4\x97", "\xf0\x9f\xa4\x94", "\xf0\x9f\x98\x90", "\xf0\x9f\x98\x91", "\xf0\x9f\x98\xb6", "\xf0\x9f\x99\x84", "\xf0\x9f\x98\x8f", "\xf0\x9f\x98\xa3", "\xf0\x9f\x98\xa5", "\xf0\x9f\x98\xae", "\xf0\x9f\xa4\x90", "\xf0\x9f\x98\xaf", "\xf0\x9f\x98\xaa", "\xf0\x9f\x98\xab", "\xf0\x9f\x98\xb4", "\xf0\x9f\x98\x8c", "\xf0\x9f\xa4\x93", "\xf0\x9f\x98\x9b", "\xf0\x9f\x98\x9c", "\xf0\x9f\x98\x9d", "\xf0\x9f\xa4\xa4", "\xf0\x9f\x98\x92", "\xf0\x9f\x98\x93", "\xf0\x9f\x98\x94", "\xf0\x9f\x98\x95", "\xf0\x9f\x99\x83", "\xf0\x9f\xa4\x91", "\xf0\x9f\x98\xb2", "\xe2\x98\xb9", "\xf0\x9f\x99\x81", "\xf0\x9f\x98\x96", "\xf0\x9f\x98\x9e", "\xf0\x9f\x98\x9f", "\xf0\x9f\x98\xa4", "\xf0\x9f\x98\xa2", "\xf0\x9f\x98\xad", "\xf0\x9f\x98\xa6", "\xf0\x9f\x98\xa7", "\xf0\x9f\x98\xa8", "\xf0\x9f\x98\xa9", "\xf0\x9f\x98\xac", "\xf0\x9f\x98\xb0", "\xf0\x9f\x98\xb1", "\xf0\x9f\x98\xb3", "\xf0\x9f\x98\xb5", "\xf0\x9f\x98\xa1", "\xf0\x9f\x98\xa0", "\xf0\x9f\x98\x87", "\xf0\x9f\xa4\xa0", "\xf0\x9f\xa4\xa1", "\xf0\x9f\xa4\xa5", "\xf0\x9f\x98\xb7", "\xf0\x9f\xa4\x92", "\xf0\x9f\xa4\x95", "\xf0\x9f\xa4\xa2", "\xf0\x9f\xa4\xa7", "\xf0\x9f\x98\x88", "\xf0\x9f\x91\xbf", "\xf0\x9f\x91\xb9", "\xf0\x9f\x91\xba", "\xf0\x9f\x92\x80", "\xf0\x9f\x91\xbb", "\xf0\x9f\x91\xbd", "\xf0\x9f\xa4\x96", "\xf0\x9f\x92\xa9", "\xf0\x9f\x98\xba", "\xf0\x9f\x98\xb8", "\xf0\x9f\x98\xb9", "\xf0\x9f\x98\xbb", "\xf0\x9f\x98\xbc", "\xf0\x9f\x98\xbd", "\xf0\x9f\x99\x80", "\xf0\x9f\x98\xbf", "\xf0\x9f\x98\xbe", "\xf0\x9f\x91\xa6", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xa6\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xa7", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xa7\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xa8", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xa8\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xa9", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xa9\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb4", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb4\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb5", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb5\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb6", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb6\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xbc", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xbc\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xae", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xae\xf0\x9f\x8f\xbf", "\xf0\x9f\x95\xb5", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbb", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbc", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbd", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbe", "\xf0\x9f\x95\xb5\xf0\x9f\x8f\xbf", "\xf0\x9f\x92\x82", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbb", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbc", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbd", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbe", "\xf0\x9f\x92\x82\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb7", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb7\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb3", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb3\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb1", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb1\xf0\x9f\x8f\xbf", "\xf0\x9f\x8e\x85", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbb", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbc", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbd", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbe", "\xf0\x9f\x8e\x85\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb6", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb6\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb8", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb8\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb4", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb4\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb0", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb0\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb5", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb5\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb0", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb0\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xb2", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\xb2\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x8d", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x8d\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x8e", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x8e\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x85", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x85\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x86", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x86\xf0\x9f\x8f\xbf", "\xf0\x9f\x92\x81", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbb", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbc", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbd", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbe", "\xf0\x9f\x92\x81\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x8b", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x8b\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x87", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x87\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xa6", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xa6\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb7", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb7\xf0\x9f\x8f\xbf", "\xf0\x9f\x92\x86", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbb", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbc", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbd", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbe", "\xf0\x9f\x92\x86\xf0\x9f\x8f\xbf", "\xf0\x9f\x92\x87", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbb", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbc", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbd", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbe", "\xf0\x9f\x92\x87\xf0\x9f\x8f\xbf", "\xf0\x9f\x9a\xb6", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbb", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbc", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbd", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbe", "\xf0\x9f\x9a\xb6\xf0\x9f\x8f\xbf", "\xf0\x9f\x8f\x83", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbb", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbc", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbd", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbe", "\xf0\x9f\x8f\x83\xf0\x9f\x8f\xbf", "\xf0\x9f\x92\x83", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbb", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbc", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbd", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbe", "\xf0\x9f\x92\x83\xf0\x9f\x8f\xbf", "\xf0\x9f\x95\xba", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbb", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbc", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbd", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbe", "\xf0\x9f\x95\xba\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xaf", "\xf0\x9f\x97\xa3", "\xf0\x9f\x91\xa4", "\xf0\x9f\x91\xa5", "\xf0\x9f\x91\xab", "\xf0\x9f\x91\xac", "\xf0\x9f\x91\xad", "\xf0\x9f\x92\x8f", "\xf0\x9f\x92\x91", "\xf0\x9f\x91\xaa", "\xf0\x9f\x92\xaa", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbb", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbc", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbd", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbe", "\xf0\x9f\x92\xaa\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb3", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb3\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x88", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x88\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x89", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x89\xf0\x9f\x8f\xbf", "\xe2\x98\x9d", "\xe2\x98\x9d\xf0\x9f\x8f\xbb", "\xe2\x98\x9d\xf0\x9f\x8f\xbc", "\xe2\x98\x9d\xf0\x9f\x8f\xbd", "\xe2\x98\x9d\xf0\x9f\x8f\xbe", "\xe2\x98\x9d\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x86", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x86\xf0\x9f\x8f\xbf", "\xf0\x9f\x96\x95", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbb", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbc", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbd", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbe", "\xf0\x9f\x96\x95\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x87", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x87\xf0\x9f\x8f\xbf", "\xe2\x9c\x8c", "\xe2\x9c\x8c\xf0\x9f\x8f\xbb", "\xe2\x9c\x8c\xf0\x9f\x8f\xbc", "\xe2\x9c\x8c\xf0\x9f\x8f\xbd", "\xe2\x9c\x8c\xf0\x9f\x8f\xbe", "\xe2\x9c\x8c\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\x9e", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\x9e\xf0\x9f\x8f\xbf", "\xf0\x9f\x96\x96", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbb", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbc", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbd", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbe", "\xf0\x9f\x96\x96\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\x98", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\x98\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\x99", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\x99\xf0\x9f\x8f\xbf", "\xf0\x9f\x96\x90", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbb", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbc", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbd", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbe", "\xf0\x9f\x96\x90\xf0\x9f\x8f\xbf", "\xe2\x9c\x8b", "\xe2\x9c\x8b\xf0\x9f\x8f\xbb", "\xe2\x9c\x8b\xf0\x9f\x8f\xbc", "\xe2\x9c\x8b\xf0\x9f\x8f\xbd", "\xe2\x9c\x8b\xf0\x9f\x8f\xbe", "\xe2\x9c\x8b\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x8c", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x8c\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x8d", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x8d\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x8e", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x8e\xf0\x9f\x8f\xbf", "\xe2\x9c\x8a", "\xe2\x9c\x8a\xf0\x9f\x8f\xbb", "\xe2\x9c\x8a\xf0\x9f\x8f\xbc", "\xe2\x9c\x8a\xf0\x9f\x8f\xbd", "\xe2\x9c\x8a\xf0\x9f\x8f\xbe", "\xe2\x9c\x8a\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x8a", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x8a\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\x9b", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\x9b\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\x9c", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\x9c\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\x9a", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\x9a\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x8b", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x8b\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x8f", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x8f\xf0\x9f\x8f\xbf", "\xe2\x9c\x8d", "\xe2\x9c\x8d\xf0\x9f\x8f\xbb", "\xe2\x9c\x8d\xf0\x9f\x8f\xbc", "\xe2\x9c\x8d\xf0\x9f\x8f\xbd", "\xe2\x9c\x8d\xf0\x9f\x8f\xbe", "\xe2\x9c\x8d\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x90", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x90\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x8c", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x8c\xf0\x9f\x8f\xbf", "\xf0\x9f\x99\x8f", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbb", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbc", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbd", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbe", "\xf0\x9f\x99\x8f\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\x9d", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\x9d\xf0\x9f\x8f\xbf", "\xf0\x9f\x92\x85", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbb", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbc", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbd", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbe", "\xf0\x9f\x92\x85\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x82", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x82\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\x83", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbb", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbc", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbd", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbe", "\xf0\x9f\x91\x83\xf0\x9f\x8f\xbf", "\xf0\x9f\x91\xa3", "\xf0\x9f\x91\x80", "\xf0\x9f\x91\x81", "\xf0\x9f\x91\x85", "\xf0\x9f\x91\x84", "\xf0\x9f\x92\x8b", "\xf0\x9f\x92\xa4", "\xf0\x9f\x91\x93", "\xf0\x9f\x95\xb6", "\xf0\x9f\x91\x94", "\xf0\x9f\x91\x95", "\xf0\x9f\x91\x96", "\xf0\x9f\x91\x97", "\xf0\x9f\x91\x98", "\xf0\x9f\x91\x99", "\xf0\x9f\x91\x9a", "\xf0\x9f\x91\x9b", "\xf0\x9f\x91\x9c", "\xf0\x9f\x91\x9d", "\xf0\x9f\x8e\x92", "\xf0\x9f\x91\x9e", "\xf0\x9f\x91\x9f", "\xf0\x9f\x91\xa0", "\xf0\x9f\x91\xa1", "\xf0\x9f\x91\xa2", "\xf0\x9f\x91\x91", "\xf0\x9f\x91\x92", "\xf0\x9f\x8e\xa9", "\xf0\x9f\x8e\x93", "\xe2\x9b\x91", "\xf0\x9f\x92\x84", "\xf0\x9f\x92\x8d", "\xf0\x9f\x8c\x82", "\xf0\x9f\x92\xbc"}}, {"objects", {"\xe2\x98\xa0", "\xf0\x9f\x92\x8c", "\xf0\x9f\x92\xa3", "\xf0\x9f\x95\xb3", "\xf0\x9f\x9b\x8d", "\xf0\x9f\x93\xbf", "\xf0\x9f\x92\x8e", "\xf0\x9f\x94\xaa", "\xf0\x9f\x8f\xba", "\xf0\x9f\x97\xba", "\xf0\x9f\x92\x88", "\xf0\x9f\x96\xbc", "\xf0\x9f\x9b\x8e", "\xf0\x9f\x9a\xaa", "\xf0\x9f\x9b\x8c", "\xf0\x9f\x9b\x8f", "\xf0\x9f\x9b\x8b", "\xf0\x9f\x9a\xbd", "\xf0\x9f\x9a\xbf", "\xf0\x9f\x9b\x81", "\xe2\x8c\x9b", "\xe2\x8f\xb3", "\xe2\x8c\x9a", "\xe2\x8f\xb0", "\xe2\x8f\xb1", "\xe2\x8f\xb2", "\xf0\x9f\x95\xb0", "\xf0\x9f\x8c\xa1", "\xe2\x9b\xb1", "\xf0\x9f\x8e\x88", "\xf0\x9f\x8e\x89", "\xf0\x9f\x8e\x8a", "\xf0\x9f\x8e\x8e", "\xf0\x9f\x8e\x8f", "\xf0\x9f\x8e\x90", "\xf0\x9f\x8e\x80", "\xf0\x9f\x8e\x81", "\xf0\x9f\x95\xb9", "\xf0\x9f\x93\xaf", "\xf0\x9f\x8e\x99", "\xf0\x9f\x8e\x9a", "\xf0\x9f\x8e\x9b", "\xf0\x9f\x93\xbb", "\xf0\x9f\x93\xb1", "\xf0\x9f\x93\xb2", "\xe2\x98\x8e", "\xf0\x9f\x93\x9e", "\xf0\x9f\x93\x9f", "\xf0\x9f\x93\xa0", "\xf0\x9f\x94\x8b", "\xf0\x9f\x94\x8c", "\xf0\x9f\x92\xbb", "\xf0\x9f\x96\xa5", "\xf0\x9f\x96\xa8", "\xe2\x8c\xa8", "\xf0\x9f\x96\xb1", "\xf0\x9f\x96\xb2", "\xf0\x9f\x92\xbd", "\xf0\x9f\x92\xbe", "\xf0\x9f\x92\xbf", "\xf0\x9f\x93\x80", "\xf0\x9f\x8e\xa5", "\xf0\x9f\x8e\x9e", "\xf0\x9f\x93\xbd", "\xf0\x9f\x93\xba", "\xf0\x9f\x93\xb7", "\xf0\x9f\x93\xb8", "\xf0\x9f\x93\xb9", "\xf0\x9f\x93\xbc", "\xf0\x9f\x94\x8d", "\xf0\x9f\x94\x8e", "\xf0\x9f\x94\xac", "\xf0\x9f\x94\xad", "\xf0\x9f\x93\xa1", "\xf0\x9f\x95\xaf", "\xf0\x9f\x92\xa1", "\xf0\x9f\x94\xa6", "\xf0\x9f\x8f\xae", "\xf0\x9f\x93\x94", "\xf0\x9f\x93\x95", "\xf0\x9f\x93\x96", "\xf0\x9f\x93\x97", "\xf0\x9f\x93\x98", "\xf0\x9f\x93\x99", "\xf0\x9f\x93\x9a", "\xf0\x9f\x93\x93", "\xf0\x9f\x93\x92", "\xf0\x9f\x93\x83", "\xf0\x9f\x93\x9c", "\xf0\x9f\x93\x84", "\xf0\x9f\x93\xb0", "\xf0\x9f\x97\x9e", "\xf0\x9f\x93\x91", "\xf0\x9f\x94\x96", "\xf0\x9f\x8f\xb7", "\xf0\x9f\x92\xb0", "\xf0\x9f\x92\xb4", "\xf0\x9f\x92\xb5", "\xf0\x9f\x92\xb6", "\xf0\x9f\x92\xb7", "\xf0\x9f\x92\xb8", "\xf0\x9f\x92\xb3", "\xe2\x9c\x89", "\xf0\x9f\x93\xa7", "\xf0\x9f\x93\xa8", "\xf0\x9f\x93\xa9", "\xf0\x9f\x93\xa4", "\xf0\x9f\x93\xa5", "\xf0\x9f\x93\xa6", "\xf0\x9f\x93\xab", "\xf0\x9f\x93\xaa", "\xf0\x9f\x93\xac", "\xf0\x9f\x93\xad", "\xf0\x9f\x93\xae", "\xf0\x9f\x97\xb3", "\xe2\x9c\x8f", "\xe2\x9c\x92", "\xf0\x9f\x96\x8b", "\xf0\x9f\x96\x8a", "\xf0\x9f\x96\x8c", "\xf0\x9f\x96\x8d", "\xf0\x9f\x93\x9d", "\xf0\x9f\x93\x81", "\xf0\x9f\x93\x82", "\xf0\x9f\x97\x82", "\xf0\x9f\x93\x85", "\xf0\x9f\x93\x86", "\xf0\x9f\x97\x92", "\xf0\x9f\x97\x93", "\xf0\x9f\x93\x87", "\xf0\x9f\x93\x88", "\xf0\x9f\x93\x89", "\xf0\x9f\x93\x8a", "\xf0\x9f\x93\x8b", "\xf0\x9f\x93\x8c", "\xf0\x9f\x93\x8d", "\xf0\x9f\x93\x8e", "\xf0\x9f\x96\x87", "\xf0\x9f\x93\x8f", "\xf0\x9f\x93\x90", "\xe2\x9c\x82", "\xf0\x9f\x97\x83", "\xf0\x9f\x97\x84", "\xf0\x9f\x97\x91", "\xf0\x9f\x94\x92", "\xf0\x9f\x94\x93", "\xf0\x9f\x94\x8f", "\xf0\x9f\x94\x90", "\xf0\x9f\x94\x91", "\xf0\x9f\x97\x9d", "\xf0\x9f\x94\xa8", "\xe2\x9b\x8f", "\xe2\x9a\x92", "\xf0\x9f\x9b\xa0", "\xf0\x9f\x97\xa1", "\xe2\x9a\x94", "\xf0\x9f\x94\xab", "\xf0\x9f\x9b\xa1", "\xf0\x9f\x94\xa7", "\xf0\x9f\x94\xa9", "\xe2\x9a\x99", "\xf0\x9f\x97\x9c", "\xe2\x9a\x97", "\xe2\x9a\x96", "\xf0\x9f\x94\x97", "\xe2\x9b\x93", "\xf0\x9f\x92\x89", "\xf0\x9f\x92\x8a", "\xf0\x9f\x9a\xac", "\xe2\x9a\xb0", "\xe2\x9a\xb1", "\xf0\x9f\x97\xbf", "\xf0\x9f\x9b\xa2", "\xf0\x9f\x94\xae", "\xf0\x9f\x9b\x92", "\xf0\x9f\x9a\xa9", "\xf0\x9f\x8e\x8c", "\xf0\x9f\x8f\xb4", "\xf0\x9f\x8f\xb3", "\xf0\x9f\x8f\xb3\xf0\x9f\x8c\x88"}}, {"activity", {"\xf0\x9f\x91\xbe", "\xf0\x9f\x95\xb4", "\xf0\x9f\xa4\xba", "\xf0\x9f\x8f\x87", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbb", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbc", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbd", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbe", "\xf0\x9f\x8f\x87\xf0\x9f\x8f\xbf", "\xe2\x9b\xb7", "\xf0\x9f\x8f\x82", "\xf0\x9f\x8f\x8c", "\xf0\x9f\x8f\x84", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbb", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbc", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbd", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbe", "\xf0\x9f\x8f\x84\xf0\x9f\x8f\xbf", "\xf0\x9f\x9a\xa3", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbb", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbc", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbd", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbe", "\xf0\x9f\x9a\xa3\xf0\x9f\x8f\xbf", "\xf0\x9f\x8f\x8a", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbb", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbc", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbd", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbe", "\xf0\x9f\x8f\x8a\xf0\x9f\x8f\xbf", "\xe2\x9b\xb9", "\xe2\x9b\xb9\xf0\x9f\x8f\xbb", "\xe2\x9b\xb9\xf0\x9f\x8f\xbc", "\xe2\x9b\xb9\xf0\x9f\x8f\xbd", "\xe2\x9b\xb9\xf0\x9f\x8f\xbe", "\xe2\x9b\xb9\xf0\x9f\x8f\xbf", "\xf0\x9f\x8f\x8b", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbb", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbc", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbd", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbe", "\xf0\x9f\x8f\x8b\xf0\x9f\x8f\xbf", "\xf0\x9f\x9a\xb4", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbb", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbc", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbd", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbe", "\xf0\x9f\x9a\xb4\xf0\x9f\x8f\xbf", "\xf0\x9f\x9a\xb5", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbb", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbc", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbd", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbe", "\xf0\x9f\x9a\xb5\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb8", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb8\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xbc", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xbc\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xbd", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xbd\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xbe", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xbe\xf0\x9f\x8f\xbf", "\xf0\x9f\xa4\xb9", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbb", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbc", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbd", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbe", "\xf0\x9f\xa4\xb9\xf0\x9f\x8f\xbf", "\xf0\x9f\x8e\xaa", "\xf0\x9f\x8e\xad", "\xf0\x9f\x8e\xa8", "\xf0\x9f\x8e\xb0", "\xf0\x9f\x9b\x80", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbb", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbc", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbd", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbe", "\xf0\x9f\x9b\x80\xf0\x9f\x8f\xbf", "\xf0\x9f\x8e\x97", "\xf0\x9f\x8e\x9f", "\xf0\x9f\x8e\xab", "\xf0\x9f\x8e\x96", "\xf0\x9f\x8f\x86", "\xf0\x9f\x8f\x85", "\xf0\x9f\xa5\x87", "\xf0\x9f\xa5\x88", "\xf0\x9f\xa5\x89", "\xe2\x9a\xbd", "\xe2\x9a\xbe", "\xf0\x9f\x8f\x80", "\xf0\x9f\x8f\x90", "\xf0\x9f\x8f\x88", "\xf0\x9f\x8f\x89", "\xf0\x9f\x8e\xbe", "\xf0\x9f\x8e\xb1", "\xf0\x9f\x8e\xb3", "\xf0\x9f\x8f\x8f", "\xf0\x9f\x8f\x91", "\xf0\x9f\x8f\x92", "\xf0\x9f\x8f\x93", "\xf0\x9f\x8f\xb8", "\xf0\x9f\xa5\x8a", "\xf0\x9f\xa5\x8b", "\xf0\x9f\xa5\x85", "\xf0\x9f\x8e\xaf", "\xe2\x9b\xb3", "\xe2\x9b\xb8", "\xf0\x9f\x8e\xa3", "\xf0\x9f\x8e\xbd", "\xf0\x9f\x8e\xbf", "\xf0\x9f\x8e\xae", "\xf0\x9f\x8e\xb2", "\xf0\x9f\x8e\xbc", "\xf0\x9f\x8e\xa4", "\xf0\x9f\x8e\xa7", "\xf0\x9f\x8e\xb7", "\xf0\x9f\x8e\xb8", "\xf0\x9f\x8e\xb9", "\xf0\x9f\x8e\xba", "\xf0\x9f\x8e\xbb", "\xf0\x9f\xa5\x81", "\xf0\x9f\x8e\xac", "\xf0\x9f\x8f\xb9"}}, {"nature", {"\xf0\x9f\x99\x88", "\xf0\x9f\x99\x89", "\xf0\x9f\x99\x8a", "\xf0\x9f\x92\xa6", "\xf0\x9f\x92\xa8", "\xf0\x9f\x90\xb5", "\xf0\x9f\x90\x92", "\xf0\x9f\xa6\x8d", "\xf0\x9f\x90\xb6", "\xf0\x9f\x90\x95", "\xf0\x9f\x90\xa9", "\xf0\x9f\x90\xba", "\xf0\x9f\xa6\x8a", "\xf0\x9f\x90\xb1", "\xf0\x9f\x90\x88", "\xf0\x9f\xa6\x81", "\xf0\x9f\x90\xaf", "\xf0\x9f\x90\x85", "\xf0\x9f\x90\x86", "\xf0\x9f\x90\xb4", "\xf0\x9f\x90\x8e", "\xf0\x9f\xa6\x8c", "\xf0\x9f\xa6\x84", "\xf0\x9f\x90\xae", "\xf0\x9f\x90\x82", "\xf0\x9f\x90\x83", "\xf0\x9f\x90\x84", "\xf0\x9f\x90\xb7", "\xf0\x9f\x90\x96", "\xf0\x9f\x90\x97", "\xf0\x9f\x90\xbd", "\xf0\x9f\x90\x8f", "\xf0\x9f\x90\x91", "\xf0\x9f\x90\x90", "\xf0\x9f\x90\xaa", "\xf0\x9f\x90\xab", "\xf0\x9f\x90\x98", "\xf0\x9f\xa6\x8f", "\xf0\x9f\x90\xad", "\xf0\x9f\x90\x81", "\xf0\x9f\x90\x80", "\xf0\x9f\x90\xb9", "\xf0\x9f\x90\xb0", "\xf0\x9f\x90\x87", "\xf0\x9f\x90\xbf", "\xf0\x9f\xa6\x87", "\xf0\x9f\x90\xbb", "\xf0\x9f\x90\xa8", "\xf0\x9f\x90\xbc", "\xf0\x9f\x90\xbe", "\xf0\x9f\xa6\x83", "\xf0\x9f\x90\x94", "\xf0\x9f\x90\x93", "\xf0\x9f\x90\xa3", "\xf0\x9f\x90\xa4", "\xf0\x9f\x90\xa5", "\xf0\x9f\x90\xa6", "\xf0\x9f\x90\xa7", "\xf0\x9f\x95\x8a", "\xf0\x9f\xa6\x85", "\xf0\x9f\xa6\x86", "\xf0\x9f\xa6\x89", "\xf0\x9f\x90\xb8", "\xf0\x9f\x90\x8a", "\xf0\x9f\x90\xa2", "\xf0\x9f\xa6\x8e", "\xf0\x9f\x90\x8d", "\xf0\x9f\x90\xb2", "\xf0\x9f\x90\x89", "\xf0\x9f\x90\xb3", "\xf0\x9f\x90\x8b", "\xf0\x9f\x90\xac", "\xf0\x9f\x90\x9f", "\xf0\x9f\x90\xa0", "\xf0\x9f\x90\xa1", "\xf0\x9f\xa6\x88", "\xf0\x9f\x90\x99", "\xf0\x9f\x90\x9a", "\xf0\x9f\xa6\x80", "\xf0\x9f\xa6\x90", "\xf0\x9f\xa6\x91", "\xf0\x9f\xa6\x8b", "\xf0\x9f\x90\x8c", "\xf0\x9f\x90\x9b", "\xf0\x9f\x90\x9c", "\xf0\x9f\x90\x9d", "\xf0\x9f\x90\x9e", "\xf0\x9f\x95\xb7", "\xf0\x9f\x95\xb8", "\xf0\x9f\xa6\x82", "\xf0\x9f\x92\x90", "\xf0\x9f\x8c\xb8", "\xf0\x9f\x8f\xb5", "\xf0\x9f\x8c\xb9", "\xf0\x9f\xa5\x80", "\xf0\x9f\x8c\xba", "\xf0\x9f\x8c\xbb", "\xf0\x9f\x8c\xbc", "\xf0\x9f\x8c\xb7", "\xf0\x9f\x8c\xb1", "\xf0\x9f\x8c\xb2", "\xf0\x9f\x8c\xb3", "\xf0\x9f\x8c\xb4", "\xf0\x9f\x8c\xb5", "\xf0\x9f\x8c\xbe", "\xf0\x9f\x8c\xbf", "\xe2\x98\x98", "\xf0\x9f\x8d\x80", "\xf0\x9f\x8d\x81", "\xf0\x9f\x8d\x82", "\xf0\x9f\x8d\x83", "\xf0\x9f\x8d\x84", "\xf0\x9f\x8c\xb0", "\xf0\x9f\x8c\x8d", "\xf0\x9f\x8c\x8e", "\xf0\x9f\x8c\x8f", "\xf0\x9f\x8c\x91", "\xf0\x9f\x8c\x92", "\xf0\x9f\x8c\x93", "\xf0\x9f\x8c\x94", "\xf0\x9f\x8c\x95", "\xf0\x9f\x8c\x96", "\xf0\x9f\x8c\x97", "\xf0\x9f\x8c\x98", "\xf0\x9f\x8c\x99", "\xf0\x9f\x8c\x9a", "\xf0\x9f\x8c\x9b", "\xf0\x9f\x8c\x9c", "\xe2\x98\x80", "\xf0\x9f\x8c\x9d", "\xf0\x9f\x8c\x9e", "\xe2\xad\x90", "\xf0\x9f\x8c\x9f", "\xe2\x98\x81", "\xe2\x9b\x85", "\xe2\x9b\x88", "\xf0\x9f\x8c\xa4", "\xf0\x9f\x8c\xa5", "\xf0\x9f\x8c\xa6", "\xf0\x9f\x8c\xa7", "\xf0\x9f\x8c\xa8", "\xf0\x9f\x8c\xa9", "\xf0\x9f\x8c\xaa", "\xf0\x9f\x8c\xab", "\xf0\x9f\x8c\xac", "\xe2\x98\x82", "\xe2\x98\x94", "\xe2\x9a\xa1", "\xe2\x9d\x84", "\xe2\x98\x83", "\xe2\x9b\x84", "\xe2\x98\x84", "\xf0\x9f\x94\xa5", "\xf0\x9f\x92\xa7", "\xf0\x9f\x8c\x8a", "\xf0\x9f\x8e\x83", "\xf0\x9f\x8e\x84", "\xe2\x9c\xa8", "\xf0\x9f\x8e\x8b", "\xf0\x9f\x8e\x8d"}}, {"travel", {"\xf0\x9f\x8f\x8e", "\xf0\x9f\x8f\x8d", "\xf0\x9f\x97\xbe", "\xf0\x9f\x8f\x94", "\xe2\x9b\xb0", "\xf0\x9f\x8c\x8b", "\xf0\x9f\x97\xbb", "\xf0\x9f\x8f\x95", "\xf0\x9f\x8f\x96", "\xf0\x9f\x8f\x9c", "\xf0\x9f\x8f\x9d", "\xf0\x9f\x8f\x9e", "\xf0\x9f\x8f\x9f", "\xf0\x9f\x8f\x9b", "\xf0\x9f\x8f\x97", "\xf0\x9f\x8f\x98", "\xf0\x9f\x8f\x99", "\xf0\x9f\x8f\x9a", "\xf0\x9f\x8f\xa0", "\xf0\x9f\x8f\xa1", "\xf0\x9f\x8f\xa2", "\xf0\x9f\x8f\xa3", "\xf0\x9f\x8f\xa4", "\xf0\x9f\x8f\xa5", "\xf0\x9f\x8f\xa6", "\xf0\x9f\x8f\xa8", "\xf0\x9f\x8f\xa9", "\xf0\x9f\x8f\xaa", "\xf0\x9f\x8f\xab", "\xf0\x9f\x8f\xac", "\xf0\x9f\x8f\xad", "\xf0\x9f\x8f\xaf", "\xf0\x9f\x8f\xb0", "\xf0\x9f\x92\x92", "\xf0\x9f\x97\xbc", "\xf0\x9f\x97\xbd", "\xe2\x9b\xaa", "\xf0\x9f\x95\x8c", "\xf0\x9f\x95\x8d", "\xe2\x9b\xa9", "\xf0\x9f\x95\x8b", "\xe2\x9b\xb2", "\xe2\x9b\xba", "\xf0\x9f\x8c\x81", "\xf0\x9f\x8c\x83", "\xf0\x9f\x8c\x84", "\xf0\x9f\x8c\x85", "\xf0\x9f\x8c\x86", "\xf0\x9f\x8c\x87", "\xf0\x9f\x8c\x89", "\xf0\x9f\x8c\x8c", "\xf0\x9f\x8e\xa0", "\xf0\x9f\x8e\xa1", "\xf0\x9f\x8e\xa2", "\xf0\x9f\x9a\x82", "\xf0\x9f\x9a\x83", "\xf0\x9f\x9a\x84", "\xf0\x9f\x9a\x85", "\xf0\x9f\x9a\x86", "\xf0\x9f\x9a\x87", "\xf0\x9f\x9a\x88", "\xf0\x9f\x9a\x89", "\xf0\x9f\x9a\x8a", "\xf0\x9f\x9a\x9d", "\xf0\x9f\x9a\x9e", "\xf0\x9f\x9a\x8b", "\xf0\x9f\x9a\x8c", "\xf0\x9f\x9a\x8d", "\xf0\x9f\x9a\x8e", "\xf0\x9f\x9a\x90", "\xf0\x9f\x9a\x91", "\xf0\x9f\x9a\x92", "\xf0\x9f\x9a\x93", "\xf0\x9f\x9a\x94", "\xf0\x9f\x9a\x95", "\xf0\x9f\x9a\x96", "\xf0\x9f\x9a\x97", "\xf0\x9f\x9a\x98", "\xf0\x9f\x9a\x99", "\xf0\x9f\x9a\x9a", "\xf0\x9f\x9a\x9b", "\xf0\x9f\x9a\x9c", "\xf0\x9f\x9a\xb2", "\xf0\x9f\x9b\xb4", "\xf0\x9f\x9b\xb5", "\xf0\x9f\x9a\x8f", "\xf0\x9f\x9b\xa3", "\xf0\x9f\x9b\xa4", "\xe2\x9b\xbd", "\xf0\x9f\x9a\xa8", "\xf0\x9f\x9a\xa5", "\xf0\x9f\x9a\xa6", "\xf0\x9f\x9a\xa7", "\xe2\x9a\x93", "\xe2\x9b\xb5", "\xf0\x9f\x9b\xb6", "\xf0\x9f\x9a\xa4", "\xf0\x9f\x9b\xb3", "\xe2\x9b\xb4", "\xf0\x9f\x9b\xa5", "\xf0\x9f\x9a\xa2", "\xe2\x9c\x88", "\xf0\x9f\x9b\xa9", "\xf0\x9f\x9b\xab", "\xf0\x9f\x9b\xac", "\xf0\x9f\x92\xba", "\xf0\x9f\x9a\x81", "\xf0\x9f\x9a\x9f", "\xf0\x9f\x9a\xa0", "\xf0\x9f\x9a\xa1", "\xf0\x9f\x9a\x80", "\xf0\x9f\x9b\xb0", "\xf0\x9f\x8c\xa0", "\xf0\x9f\x8c\x88", "\xf0\x9f\x8e\x86", "\xf0\x9f\x8e\x87", "\xf0\x9f\x8e\x91", "\xf0\x9f\x8f\x81"}}, {"modifier", {"\xf0\x9f\x8f\xbb", "\xf0\x9f\x8f\xbc", "\xf0\x9f\x8f\xbd", "\xf0\x9f\x8f\xbe", "\xf0\x9f\x8f\xbf"}}, {"food", {"\xf0\x9f\x8d\x87", "\xf0\x9f\x8d\x88", "\xf0\x9f\x8d\x89", "\xf0\x9f\x8d\x8a", "\xf0\x9f\x8d\x8b", "\xf0\x9f\x8d\x8c", "\xf0\x9f\x8d\x8d", "\xf0\x9f\x8d\x8e", "\xf0\x9f\x8d\x8f", "\xf0\x9f\x8d\x90", "\xf0\x9f\x8d\x91", "\xf0\x9f\x8d\x92", "\xf0\x9f\x8d\x93", "\xf0\x9f\xa5\x9d", "\xf0\x9f\x8d\x85", "\xf0\x9f\xa5\x91", "\xf0\x9f\x8d\x86", "\xf0\x9f\xa5\x94", "\xf0\x9f\xa5\x95", "\xf0\x9f\x8c\xbd", "\xf0\x9f\x8c\xb6", "\xf0\x9f\xa5\x92", "\xf0\x9f\xa5\x9c", "\xf0\x9f\x8d\x9e", "\xf0\x9f\xa5\x90", "\xf0\x9f\xa5\x96", "\xf0\x9f\xa5\x9e", "\xf0\x9f\xa7\x80", "\xf0\x9f\x8d\x96", "\xf0\x9f\x8d\x97", "\xf0\x9f\xa5\x93", "\xf0\x9f\x8d\x94", "\xf0\x9f\x8d\x9f", "\xf0\x9f\x8d\x95", "\xf0\x9f\x8c\xad", "\xf0\x9f\x8c\xae", "\xf0\x9f\x8c\xaf", "\xf0\x9f\xa5\x99", "\xf0\x9f\xa5\x9a", "\xf0\x9f\x8d\xb3", "\xf0\x9f\xa5\x98", "\xf0\x9f\x8d\xb2", "\xf0\x9f\xa5\x97", "\xf0\x9f\x8d\xbf", "\xf0\x9f\x8d\xb1", "\xf0\x9f\x8d\x98", "\xf0\x9f\x8d\x99", "\xf0\x9f\x8d\x9a", "\xf0\x9f\x8d\x9b", "\xf0\x9f\x8d\x9c", "\xf0\x9f\x8d\x9d", "\xf0\x9f\x8d\xa0", "\xf0\x9f\x8d\xa2", "\xf0\x9f\x8d\xa3", "\xf0\x9f\x8d\xa4", "\xf0\x9f\x8d\xa5", "\xf0\x9f\x8d\xa1", "\xf0\x9f\x8d\xa6", "\xf0\x9f\x8d\xa7", "\xf0\x9f\x8d\xa8", "\xf0\x9f\x8d\xa9", "\xf0\x9f\x8d\xaa", "\xf0\x9f\x8e\x82", "\xf0\x9f\x8d\xb0", "\xf0\x9f\x8d\xab", "\xf0\x9f\x8d\xac", "\xf0\x9f\x8d\xad", "\xf0\x9f\x8d\xae", "\xf0\x9f\x8d\xaf", "\xf0\x9f\x8d\xbc", "\xf0\x9f\xa5\x9b", "\xe2\x98\x95", "\xf0\x9f\x8d\xb5", "\xf0\x9f\x8d\xb6", "\xf0\x9f\x8d\xbe", "\xf0\x9f\x8d\xb7", "\xf0\x9f\x8d\xb8", "\xf0\x9f\x8d\xb9", "\xf0\x9f\x8d\xba", "\xf0\x9f\x8d\xbb", "\xf0\x9f\xa5\x82", "\xf0\x9f\xa5\x83", "\xf0\x9f\x8d\xbd", "\xf0\x9f\x8d\xb4", "\xf0\x9f\xa5\x84"}}, {"flags", {"\xf0\x9f\x87\xa6\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xab", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xac", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xae", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb6", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xba", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbd", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa7", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xab", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xac", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xad", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xae", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xaf", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb6", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbb", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xab", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xac", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xad", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xae", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb5", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xba", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbb", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbd", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xac", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xaf", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xac", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xad", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xba", "\xf0\x9f\x87\xab\xf0\x9f\x87\xae", "\xf0\x9f\x87\xab\xf0\x9f\x87\xaf", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa7", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xac\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xac\xf0\x9f\x87\xab", "\xf0\x9f\x87\xac\xf0\x9f\x87\xac", "\xf0\x9f\x87\xac\xf0\x9f\x87\xad", "\xf0\x9f\x87\xac\xf0\x9f\x87\xae", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb5", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb6", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xac\xf0\x9f\x87\xba", "\xf0\x9f\x87\xac\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xac\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xad\xf0\x9f\x87\xba", "\xf0\x9f\x87\xae\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xae\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xae\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb6", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb5", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xac", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xad", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xae", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb5", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa7", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xae", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xba", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xbb", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xab", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xac", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xad", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb5", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb6", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xba", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbb", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbd", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xab", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xac", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xae", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb5", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xba", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xb4\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xab", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xac", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xad", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xb6\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xba", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa7", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xac", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xad", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xae", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xaf", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbb", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbd", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa9", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xab", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xac", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xad", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xaf", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb1", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb4", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb7", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbb", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbc", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xba\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xba\xf0\x9f\x87\xac", "\xf0\x9f\x87\xba\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xba\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xba\xf0\x9f\x87\xbe", "\xf0\x9f\x87\xba\xf0\x9f\x87\xbf", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xa8", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xac", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xae", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xb3", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xba", "\xf0\x9f\x87\xbc\xf0\x9f\x87\xab", "\xf0\x9f\x87\xbc\xf0\x9f\x87\xb8", "\xf0\x9f\x87\xbd\xf0\x9f\x87\xb0", "\xf0\x9f\x87\xbe\xf0\x9f\x87\xaa", "\xf0\x9f\x87\xbe\xf0\x9f\x87\xb9", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xa6", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xb2", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xbc"}}};


    std::vector<std::string> EmojiMapper::getCategories() {
        std::vector<std::string> categories = {
            "people",
            "nature",
            "food",
            "activity",
            "travel",
            "objects",
            "symbols",
            "flags"
        };

        for (const auto& keyValuePair : emojisInCategory) {
            if (std::find(std::begin(categories), std::end(categories), keyValuePair.first) == std::end(categories)) {
                categories.push_back(keyValuePair.first);
            }
        }
        return categories;
    }

    std::string EmojiMapper::shortnameToUnicode(const std::string& shortname) {
        auto unicodeSequenceIterator = shortnameUnicode.find(shortname);
        if (unicodeSequenceIterator != shortnameUnicode.end()) {
            return unicodeSequenceIterator->second;
        }
        else {
            return std::string();
        }
    }

    std::string EmojiMapper::unicodeToShortname(const std::string& unicode) {
        auto shortnameIterator = unicodeShortname.find(unicode);
        if (shortnameIterator != unicodeShortname.end()) {
            return shortnameIterator->second;
        }
        else {
            return std::string();
        }
    }

    std::vector<std::string> EmojiMapper::categoryNameToEmojis(const std::string& categoryName) {
        auto emojiIterator = emojisInCategory.find(categoryName);
        if (emojiIterator != emojisInCategory.end()) {
            return emojiIterator->second;
        }
        else {
            return std::vector<std::string>();
        }
    }

    std::string EmojiMapper::categoryToFlagshipUnicodeEmoji(const std::string& category) {
        if (category == "recent") {
            return shortnameToUnicode(":clock3:");
        } else if (category == "people") {
            return shortnameToUnicode(":smiley:");
        } else if (category == "nature" ) {
            return shortnameToUnicode(":dog:");
        } else if (category == "food") {
            return shortnameToUnicode(":apple:");
        } else if (category == "activity") {
            return shortnameToUnicode(":soccer:");
        } else if (category == "travel") {
            return shortnameToUnicode(":red_car:");
        } else if (category == "objects") {
            return shortnameToUnicode(":bulb:");
        } else if (category == "symbols") {
            return shortnameToUnicode(":heavy_division_sign:");
        } else if (category == "flags") {
            return shortnameToUnicode(":flag_white:");
        }
        return std::string();
    }
}
