/*
 * Copyright (C) 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/IDBIndexIdentifier.h>
#include <WebCore/IDBKeyData.h>
#include <wtf/HashMap.h>
#include <wtf/Vector.h>

namespace WebCore {

class IndexKey {
public:
    using Data = Variant<std::nullptr_t, IDBKeyData, Vector<IDBKeyData>>;
    WEBCORE_EXPORT IndexKey();
    WEBCORE_EXPORT IndexKey(Data&&);

    WEBCORE_EXPORT IndexKey isolatedCopy() const &;
    WEBCORE_EXPORT IndexKey isolatedCopy() &&;

    IDBKeyData asOneKey() const;
    Vector<IDBKeyData> multiEntry() const;

    bool isNull() const { return std::holds_alternative<std::nullptr_t>(m_keys); }
    Data data() const { return m_keys; }

    void updatePlaceholderKeys(const IDBKeyData&);

private:
    Data m_keys;
};

using IndexIDToIndexKeyMap = HashMap<IDBIndexIdentifier, IndexKey>;

} // namespace WebCore
