/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Version;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.codec.util.NativeMemoryCacheKeyHelper;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryEntryContext;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.query.FilterIdsSelector;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.query.KNNQueryResult;
import org.opensearch.knn.index.query.KNNWeight;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.TopApproxKnnCollector;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.knn.jni.JNIService;
import org.opensearch.knn.plugin.stats.KNNCounter;

public class DefaultKNNWeight
extends KNNWeight {
    @Generated
    private static final Logger log = LogManager.getLogger(DefaultKNNWeight.class);
    private final NativeMemoryCacheManager nativeMemoryCacheManager = NativeMemoryCacheManager.getInstance();

    public DefaultKNNWeight(KNNQuery query, float boost, Weight filterWeight) {
        super(query, boost, filterWeight);
    }

    @Override
    protected TopDocs doANNSearch(LeafReaderContext context, SegmentReader reader, FieldInfo fieldInfo, SpaceType spaceType, KNNEngine knnEngine, VectorDataType vectorDataType, byte[] quantizedVector, float[] transformedVector, String modelId, BitSet filterIdsBitSet, int cardinality, int k) throws IOException {
        KNNQueryResult[] results;
        NativeMemoryAllocation indexAllocation;
        List<String> engineFiles = KNNCodecUtil.getEngineFiles(knnEngine.getExtension(), this.knnQuery.getField(), reader.getSegmentInfo().info);
        String vectorIndexFileName = engineFiles.get(0);
        String cacheKey = NativeMemoryCacheKeyHelper.constructCacheKey(vectorIndexFileName, reader.getSegmentInfo().info);
        Version segmentLuceneVersion = reader.getSegmentInfo().info.getVersion();
        SegmentLevelQuantizationInfo segmentLevelQuantizationInfo = SegmentLevelQuantizationInfo.build((LeafReader)reader, fieldInfo, this.knnQuery.getField(), segmentLuceneVersion);
        try {
            indexAllocation = this.loadGraph(reader, cacheKey, spaceType, knnEngine, this.knnQuery, vectorDataType, quantizedVector, segmentLevelQuantizationInfo, modelId, context);
        }
        catch (ExecutionException e) {
            KNNCounter.GRAPH_QUERY_ERRORS.increment();
            throw new RuntimeException(e);
        }
        FilterIdsSelector filterIdsSelector = FilterIdsSelector.getFilterIdSelector(filterIdsBitSet, cardinality);
        long[] filterIds = filterIdsSelector.getFilterIds();
        FilterIdsSelector.FilterIdsSelectorType filterType = filterIdsSelector.getFilterType();
        indexAllocation.readLock();
        try {
            indexAllocation.incRef();
        }
        catch (IllegalStateException e) {
            indexAllocation.readUnlock();
            log.error("[KNN] Exception when allocation getting evicted: ", (Throwable)e);
            throw new RuntimeException("Failed to do kNN search when vector data structures getting evicted ", e);
        }
        try {
            if (indexAllocation.isClosed()) {
                throw new RuntimeException("Index has already been closed");
            }
            int[] parentIds = this.getParentIdsArray(context);
            results = k > 0 ? (this.knnQuery.getVectorDataType() == VectorDataType.BINARY || quantizedVector != null && this.quantizationService.getVectorDataTypeForTransfer(fieldInfo, segmentLuceneVersion) == VectorDataType.BINARY ? JNIService.queryBinaryIndex(indexAllocation.getMemoryAddress(), quantizedVector == null ? this.knnQuery.getByteQueryVector() : quantizedVector, k, this.knnQuery.getMethodParameters(), knnEngine, filterIds, filterType.getValue(), parentIds) : JNIService.queryIndex(indexAllocation.getMemoryAddress(), transformedVector == null ? this.knnQuery.getQueryVector() : transformedVector, k, this.knnQuery.getMethodParameters(), knnEngine, filterIds, filterType.getValue(), parentIds)) : JNIService.radiusQueryIndex(indexAllocation.getMemoryAddress(), this.knnQuery.getQueryVector(), this.knnQuery.getRadius().floatValue(), this.knnQuery.getMethodParameters(), knnEngine, this.knnQuery.getContext().getMaxResultWindow(), filterIds, filterType.getValue(), parentIds);
        }
        catch (Exception e) {
            KNNCounter.GRAPH_QUERY_ERRORS.increment();
            throw new RuntimeException(e);
        }
        finally {
            indexAllocation.readUnlock();
            indexAllocation.decRef();
        }
        TopApproxKnnCollector collector = new TopApproxKnnCollector(k > 0 ? k : this.knnQuery.getContext().getMaxResultWindow(), knnEngine, quantizedVector != null ? SpaceType.HAMMING : spaceType);
        for (KNNQueryResult knnQueryResult : results) {
            collector.incVisitedCount(1);
            collector.collect(knnQueryResult.getId(), knnQueryResult.getScore());
        }
        TopDocs topDocs = collector.topDocs();
        this.addExplainIfRequired(results, knnEngine, spaceType);
        return topDocs;
    }

    protected NativeMemoryAllocation loadGraph(SegmentReader reader, String cacheKey, SpaceType spaceType, KNNEngine knnEngine, KNNQuery knnQuery, VectorDataType vectorDataType, byte[] quantizedVector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo, String modelId, LeafReaderContext context) throws ExecutionException, IOException {
        return this.nativeMemoryCacheManager.get(new NativeMemoryEntryContext.IndexEntryContext(reader.directory(), cacheKey, NativeMemoryLoadStrategy.IndexLoadStrategy.getInstance(), IndexUtil.getParametersAtLoading(spaceType, knnEngine, knnQuery.getIndexName(), quantizedVector == null ? vectorDataType : VectorDataType.BINARY, segmentLevelQuantizationInfo), knnQuery.getIndexName(), modelId), true);
    }
}

