/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.opensearch.neuralsearch.sparse.codec.SparseBinaryDocValuesPassThrough;

public class SparseDocValuesProducer
extends DocValuesProducer {
    private final DocValuesProducer delegate;
    private final SegmentReadState state;

    public SparseDocValuesProducer(SegmentReadState state, DocValuesProducer delegate) {
        this.state = state;
        this.delegate = delegate;
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        return this.delegate.getNumeric(field);
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        return new SparseBinaryDocValuesPassThrough(this.delegate.getBinary(field), this.state.segmentInfo, field);
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        return this.delegate.getSorted(field);
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        return this.delegate.getSortedNumeric(field);
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        return this.delegate.getSortedSet(field);
    }

    public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
        return this.delegate.getSkipper(field);
    }

    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    @Generated
    public SegmentReadState getState() {
        return this.state;
    }
}

