/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class StringCastFunction {
    public static final String name = "string";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The string function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof StringValueStream) {
            return LambdaFunction.createStringLambdaFunction(name, a -> a, (StringValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The string function requires a string-castable parameter.");
    };
}

