/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tld;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.scan.JarFactory;
import org.apache.tomcat.util.scan.ReferenceCountedJar;

public class TldResourcePath {
    private final URL url;
    private final String webappPath;
    private final String entryName;

    public TldResourcePath(URL uRL, String string) {
        this(uRL, string, null);
    }

    public TldResourcePath(URL uRL, String string, String string2) {
        this.url = uRL;
        this.webappPath = string;
        this.entryName = string2;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getWebappPath() {
        return this.webappPath;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String toExternalForm() {
        if (this.entryName == null) {
            return this.url.toExternalForm();
        }
        return "jar:" + this.url.toExternalForm() + "!/" + this.entryName;
    }

    public InputStream openStream() throws IOException {
        if (this.entryName == null) {
            return this.url.openStream();
        }
        URL uRL = JarFactory.getJarEntryURL(this.url, this.entryName);
        return uRL.openStream();
    }

    public Jar openJar() throws IOException {
        if (this.entryName == null) {
            return null;
        }
        return new ReferenceCountedJar(this.url);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TldResourcePath tldResourcePath = (TldResourcePath)object;
        return this.url.equals(tldResourcePath.url) && Objects.equals(this.webappPath, tldResourcePath.webappPath) && Objects.equals(this.entryName, tldResourcePath.entryName);
    }

    public int hashCode() {
        int n = this.url.hashCode();
        n = n * 31 + Objects.hashCode(this.webappPath);
        n = n * 31 + Objects.hashCode(this.entryName);
        return n;
    }
}

