/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.fdw;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.fdw.FDWConfigDescriptor;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;

public class FDWConfigRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.postgresql.fdw.config";
    private static FDWConfigRegistry instance = null;
    private static final Log log = Log.getLog(FDWConfigRegistry.class);
    private List<FDWConfigDescriptor> configDescriptors = new ArrayList<FDWConfigDescriptor>();

    public static synchronized FDWConfigRegistry getInstance() {
        if (instance == null) {
            instance = new FDWConfigRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private FDWConfigRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("fdw".equals(ext.getName())) {
                this.configDescriptors.add(new FDWConfigDescriptor(ext));
            }
            ++n2;
        }
    }

    public List<FDWConfigDescriptor> getConfigDescriptors() {
        return this.configDescriptors;
    }

    public FDWConfigDescriptor findFirstMatch(DBPDataSourceContainer dataSource) {
        for (FDWConfigDescriptor desc : this.configDescriptors) {
            if (!desc.matches(dataSource)) continue;
            return desc;
        }
        return null;
    }
}

