%%
%% This is file `wgexport.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% util/export.dtx  (with options: `exportcls')
%% 
%% Copyright (C) 2019 Christian Holm.
%% 
%% This file is NOT the source for wargame, because almost all comments
%% have been stripped from it.  It is NOT the preferred form of universal
%% for making modifications to it.
%% 
%% Therefore you can NOT redistribute and/or modify THIS file.  You can
%% however redistribute the complete source (wargame.dtx and wargame.ins)
%% and/or modify it under the terms of the GNU General Public License as
%% published by the Free Software Foundation; either version 2, or (at
%% your option) any later version.
%% 
%% The wargame package is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%% General Public License for more details.
%% 
%% You should have received a copy of the GNU General Public
%% License along with this package; if not, write to the
%%   Free Software Foundation, Inc.,
%%   675 Mass Ave, Cambridge,
%%   MA 02139, USA.
%% 
%% See the file wargame.dtx for further comments and documentation.
%% 
\ProvidesClass{wgexport}
\PassOptionsToClass{multi=tikzpicture,varwidth=false}{standalone}
\DeclareOption{noterrainpic}{%
  \PassOptionsToPackage{\CurrentOption}{wargame}}
\DeclareOption{terrainpic}{%
  \PassOptionsToPackage{\CurrentOption}{wargame}}
\DeclareOption*{%
  \PassOptionsToClass{\CurrentOption}{standalone}}
\ProcessOptions\relax
\LoadClass{standalone}
\RequirePackage{wargame}
\begingroup
\catcode`\^^I=12
\def\@tabchar{^^I}
\catcode`<=1 \catcode`>=2
\catcode`{=12 \catcode`}=12
\gdef\@lbchar<{>
\gdef\@rbchar<}>
\endgroup
\newenvironment{imagelist}[1][\jobname]{%
  \newwrite\mk@out%
  \def\mk@i{}%
  \def\mk@w{\immediate\write\mk@out}%
  \immediate\openout\mk@out=#1.json
  \mk@w{[}
}{
  \mk@w{\mk@i \@lbchar "name":"End of list", "category": "<<eol>>",
      "subcategory": "" \@rbchar }
  \mk@w{]}
  \immediate\closeout\mk@out
}
\def\info{%
  \@ifstar{\@@info{,}}{\@@info{\@rbchar,}}}
\def\@@info#1#2#3#4{%
  \chit@dbg{2}{Making image `#2' of type `#3'/`#4' on page \thepage}%
  \mk@w{ \@lbchar}%
  \mk@w{ \space "name": "#2",}%
  \mk@w{ \space "category": "#3",}%
  \mk@w{ \space "subcategory": "#4", }%
  \mk@w{ \space "number": \thepage #1}%
  \let\oldmk@i\mk@i%
  \ifx#1,\relax\edef\mk@i{\mk@i\space\space}\fi}
\def\endinfo{%
  \let\mk@i\oldmk@i%
  \mk@w{ \space \@rbchar,}}
\def\wg@add@drop@margin{%
  \@ifundefined{wg@drop@margin}{}{
    \dimen0=\wg@drop@margin
    % \ifwg@chit@drop
    \ifdim\dimen0>0pt%
      \path ($(current bounding box.north east)+(45:\wg@drop@margin)$)
      -- ($(current bounding box.south west)+(225:\wg@drop@margin)$);
    \fi}}
\def\chitimages{%
  \@ifnextchar[{\@chitimages}{\chitimages[]}%]
}%
\def\@chitimages[#1]{%
  \@ifnextchar[{\@@chitimages[#1]}{\@@chitimages[#1][]}%]
}%
\def\@@chitimages[#1][#2]#3{%
  \begingroup%
  \let\chit@report\do@chit@report%
  \let\natoapp@report\do@natoapp@report%
  \chit@dbg{2}{chits to make images of `#3'}%
  \foreach[count=\ti from 0] \t/\x in #3{%
    \chit@dbg{2}{^^JRow: `\t' (`\x')}
    \ifx\t\empty\else% Ignore empty rows
      \chit@dbg{5}{^^JSubcategory: `\x' (default `#1')}
      % Take sub-category or default
      \ifx\t\x\def\x{#1}\else\ifx\x\empty\def\x{#1}\fi\fi
      \foreach \u/\m in \t{%
        \ifx\u\empty\else% Ignore empty cells
          \ifx\u\chit@blank\else%
            \ifx\u\chit@oob@vspacer\else%
              \ifx\u\chit@oob@spacer\else%
                \chit@dbg{2}{Next chit `\u' with possible multiplicity
                  `\m'}%
                \chit@dbg{1}{Next chit `\u' not `\chit@blank',
                  `\chit@oob@vspacer', `\chit@oob@spacer'}
                \ifx\m\@empty\def\m{1}\fi% If no multiplicity defined
                \ifx\u\m\def\m{1}\fi% If the same as unit
                \chit@dbg{2}{Next chit `\u' multiplicity `\m'}%
                %% We only make one copy of the chit, since we can duplicate
                %% it in VASSAL
                \begin{info}*{\u}{counter}{\x}
                  \nopagecolor%
                  \gdef\wg@drop@margin{0pt}%
                  \begin{tikzpicture}[chit has drop=false,#2]
                    \chit[\u=\ti]%
                    \wg@add@drop@margin%
                  \end{tikzpicture}
                \end{info}%
                %% \foreach \n in {1,...,\m}{% Make a number of copies
                %% \ifx\u\chit@blank%
                %%   \chit@dbg{3}{Ignoring blank chit:\u}%
                %% \else%
                %%   \info{\u}{counter}{#2}
                %%   \begin{tikzpicture}
                %%     \chit[\u=\ti](\c,\r)%
                %%   \end{tikzpicture}
                %% \fi%
                %% }%
              \fi%
            \fi%
          \fi%
        \fi%
      }%
      \chit@dbg{2}{End of inner loop}%
    \fi%
  }%
  \chit@dbg{2}{End of outer loop}%
  \endgroup%
}
\def\doublechitimages{%
  \@ifnextchar[{\@doublechitimages}{\doublechitimages[]}%]
}%
\def\@doublechitimages[#1]{%
  \@ifnextchar[{\@@doublechitimages[#1]}{\@@doublechitimages[#1][]}%]
}%
\def\@@doublechitimages[#1][#2]#3{%
  \begingroup%
  \let\chit@report\do@chit@report%
  \let\natoapp@report\do@natoapp@report%
  \foreach[count=\ti from 0] \t/\x in #3{%
    \ifx\t\empty\else% Ignore empty rows
      \chit@dbg{5}{^^JSubcategory: `\x' (default `#1')}
      % Take sub-category or default
      \ifx\t\x\def\x{#1}\else\ifx\x\empty\def\x{#1}\fi\fi
      \foreach \u/\m in \t{%
        \ifx\u\empty\else% Ignore empty cells
          \ifx\u\chit@blank\else%
            \ifx\u\chit@oob@vspacer\else%
              \ifx\u\chit@oob@spacer\else%
                \chit@dbg{2}{Next chit `\u' with possible multiplicity `\m'}%
                \ifx\m\@empty\def\m{1}\fi% If not multiplicity defined
                \ifx\u\m\def\m{1}\fi% If the same as unit
                \chit@dbg{2}{Next chit `\u' multiplicity `\m'}%
                %% Flipped chit
                \edef\s{\u\space flipped}%
                %% We only make one copy of the chit, since we can duplicate
                %% it in VASSAL
                \begin{info}*{\u}{counter}{\x}%
                  \nopagecolor%
                  \gdef\wg@drop@margin{0pt}%
                  \begin{tikzpicture}[chit has drop=false,#2]%
                    \chit[\u=\ti]%
                    \wg@add@drop@margin%
                  \end{tikzpicture}%
                \end{info}%
                \begin{info}*{\s}{counter}{\x}%
                  \nopagecolor%
                  \begin{tikzpicture}[chit has drop=false,#2]%
                    \chit[\s=\ti]%
                    \wg@add@drop@margin%
                  \end{tikzpicture}%
                \end{info}%
                %% \foreach \n in {1,...,\m}{% Make a number of copies
                %% \ifx\u\chit@blank%
                %%   \chit@dbg{3}{Ignoring blank chit:\u}%
                %% \else%
                %%   \info{\u}{counter}{#2}
                %%   \begin{tikzpicture}
                %%     \chit[\u=\ti](\c,\r)%
                %%   \end{tikzpicture}
                %% \fi%
                %% }%
              \fi%
            \fi%
          \fi%
        \fi%
      }%
    \fi%
  }%
  \endgroup%
}
\def\mk@transform{%
  \pgfgettransformentries{\mxx}{\mxy}{\myx}{\myy}{\ptdx}{\ptdy}
  \wg@pt@to@cm{\ptdx}\edef\dx{\pgfmathresult}
  \wg@pt@to@cm{\ptdy}\edef\dy{\pgfmathresult}
  \mk@w{ \mk@i "xx": \mxx,}
  \mk@w{ \mk@i "xy": \mxy,}
  \mk@w{ \mk@i "yx": \myx,}
  \mk@w{ \mk@i "yy": \myy,}
  \mk@w{ \mk@i "dx": \dx,}
  \mk@w{ \mk@i "dy": \dy,}
}
\def\mk@bb#1{%
  \wg@get@bb{#1}
  \mk@w{ \mk@i "lower left":  [\llx,\lly],}
  \mk@w{ \mk@i "upper right": [\urx,\ury],}
  \begingroup
   \wg@get@global@nchor{#1}{south west}
   \mk@w{ \mk@i "global lower left":  [\tmp@x,\tmp@y],}
   \wg@get@global@nchor{#1}{north east}
   \mk@w{ \mk@i "global upper right": [\tmp@x,\tmp@y]}
 \endgroup
}
\def\mk@pos#1(#2){%
  \wg@dbg{10}{^^JMarking `#2' with `#1' - start}
  \coordinate[transform shape] (tmp) at (#2) {};
  \wg@get@nchor{tmp}{center}
  \wg@dbg{3}{^^JMarking `#2' with `#1' - `\tmp@x',\tmp@y'}
  \tikzset{zone point={#1}{\tmp@x}{\tmp@y}}
}
\pgfdeclaredecoration{record path construction}{initial}{%
  \state{initial}[width=0pt,next state=more]{
    \begingroup
      \pgf@decorate@inputsegment@first
      \ptpoint@to@cm{\the\pgf@x}{\the\pgf@y}
      \xdef\wg@path{[\x,\y]}
    \endgroup
  }%
  \state{more}[width=\pgfdecoratedinputsegmentremainingdistance]{%
    \begingroup
      \pgf@decorate@inputsegment@last
      \ptpoint@to@cm{\the\pgf@x}{\the\pgf@y}
      \xdef\wg@path{\wg@path,[\x,\y]}
    \endgroup
  }
  \state{final}{%
    \begingroup
      \pgf@decorate@inputsegment@last
      \ptpoint@to@cm{\the\pgf@x}{\the\pgf@y}
      \xdef\wg@path{\wg@path,[\x,\y]}
    \endgroup
    \mk@w{ \mk@i "zone path \wg@record@path@name": \@lbchar}
    \mk@w{ \mk@i\space "path": [\wg@path] \@rbchar,}
  }
}%
\newenvironment{boardimage}[3][board]{%
  \def\bd@n{#2}
  \newcount\mk@point
  \mk@point=0
  \let\oomk@i\mk@i%
  \let\markpos\mk@pos%
  \info{dummy}{<<dummy>>}{}%
  %\tikz{}%
  \tikz{\scoped[%
    every hex/.try,every hex node/.try,
    ]{%
      \def\hex@col{0}%
      \def\hex@row{0}%
      \node[hex,inner sep=0,outer sep=0]{%
        %\message{^^JHex label: `\meaning\hex@label'}%
        \global\let\mk@label\hex@label}}}%
  \info*{#2}{#1}{#3}%
  \mk@w{ \mk@i "zones": \@lbchar}%
  \edef\mk@i{\mk@i\space}
  %% Everything is made into centimeters
  \mk@w{ \mk@i "units": "cm",}
  \hex@dbg{3}{Label: `\meaning\mk@label'}
  \@ifundefined{mk@label}{}{\mk@w{ \mk@i "labels": "\mk@label",}}
  %% Write out coordinate options as "coords" object
  \mk@w{ \mk@i"coords": \@lbchar}%
  \mk@w{ \mk@i "row": \@lbchar}%
  \mk@w{ \mk@i\space "offset": \hex@coords@row@off,}%
  \mk@w{ \mk@i\space "factor": \hex@coords@row@fac \@rbchar,}%
  \mk@w{ \mk@i "column": \@lbchar}%
  \mk@w{ \mk@i\space "offset": \hex@coords@col@off,}%
  \mk@w{ \mk@i\space "factor": \hex@coords@col@fac,}%
  \mk@w{ \mk@i\space "top short": "\hex@top@short@col",}%
  \mk@w{ \mk@i\space "bottom short": "\hex@bot@short@col" \@rbchar}%
  \mk@w{ \mk@i\@rbchar,}%
  %%
  \let\oldbo@rdframe\bo@rdframe%
  \def\bo@rdframe[##1](##2)(##3){%
    \oldbo@rdframe[##1](##2)(##3)%
    \mk@w{ \mk@i"board frame": \@lbchar}
    \mk@w{ \mk@i\space "lower left": [\llx,\lly],}
    \mk@w{ \mk@i\space "upper right": [\urx,\ury],}
    \mk@w{ \mk@i\space "margin": \margin,}
    \mk@w{ \mk@i\space "width": \w,}
    \mk@w{ \mk@i\space "height": \h \@rbchar,}}%
  \tikzset{
    zoned/.code={% Apply to whole picture
      \pgfkeys{%
        % This needs to be done in the picture!
        /tikz/execute at end picture={%
          \mk@w{ \mk@i "zoned": \@lbchar}
          \mk@transform%
          \mk@bb{current bounding box}
          \mk@w{ \mk@i \@rbchar,}
        }
      }
    },
    zone scope/.code={%
      \mk@w{ \mk@i"zone scope ##1": \@lbchar}
      \let\omk@i\mk@i
      \edef\mk@i{\mk@i\space}
      \mk@transform%
      %\bd@w{ \@rbchar,}
      \gdef\wg@export@box{##1}%
      \pgfkeys{%
        /tikz/local bounding box=wg export box,
        /tikz/execute at end scope={
          \mk@bb{wg export box}
          \let\mk@i\omk@i
          \mk@w{ \mk@i\@rbchar,}},
      } % pgfkeys
    }, % zone scope
    zone point/.code n args={3}{
      \pgf@xa=##2 cm
      \pgf@ya=##3 cm
      \pgfpointtransformed{\pgfpoint{\pgf@xa}{\pgf@ya}}
      % \pgfpointtransformed{\pgfpoint{0pt}{0pt}}
      \pgf@xa=\pgf@x
      \pgf@ya=\pgf@y
      \wg@pt@to@cm{\the\pgf@xa}\edef\px{\pgfmathresult}
      \wg@pt@to@cm{\the\pgf@ya}\edef\py{\pgfmathresult}
      \advance\mk@point1
      \global\mk@point=\mk@point
      \mk@w{ \mk@i "point\the\mk@point": \@lbchar "name": "##1", "type": "point", "coords":  [\px,\py]
        \@rbchar, }
      %\message{^^JZone point \the\mk@point\space ##1: ##2,##3 -> \px,\py}
    },
    zone oob point/.code n args={3}{
      \pgf@xa=##2 cm
      \pgf@ya=##3 cm
      \advance\pgf@xa.1cm
      \advance\pgf@ya.1cm
      \pgfpointtransformed{\pgfpoint{\pgf@xa}{\pgf@ya}}
      % \pgfpointtransformed{\pgfpoint{0pt}{0pt}}
      \pgf@xa=\pgf@x
      \pgf@ya=\pgf@y
      \wg@pt@to@cm{\the\pgf@xa}\edef\px{\pgfmathresult}
      \wg@pt@to@cm{\the\pgf@ya}\edef\py{\pgfmathresult}
      \advance\mk@point1
      \global\mk@point=\mk@point
      \mk@w{ \mk@i "point\the\mk@point": \@lbchar "name": "##1",
        "parent": "\wg@export@box", "type": "point", "coords":  [\px,\py]
        \@rbchar, }
      %\message{^^JZone point \the\mk@point\space ##1: ##2,##3 -> \px,\py}
    },
    zone global point/.code n args={3}{
      \advance\mk@point1
      \global\mk@point=\mk@point
      \mk@w{ \mk@i "point\the\mk@point": \@lbchar "name": "##1", "type": "point", "coords":  [\px,\py]
        \@rbchar, }
    },
    /pgf/decoration/record path name/.store in=\wg@record@path@name,
    zone path/.style={%
      postaction={decorate,decoration={
          record path construction,
          record path name=##1}}
    } % zone path
  }% tikzset
}
{%
  \mk@w{ \mk@i "name": "\bd@n" }%
  \let\mk@i\oomk@i%
  \mk@w{ \mk@i\@rbchar}%
  \endinfo%
}
\def\wg@gennumberm@rkers#1#2#3#4{
  \chit@dbg{2}{Numbered markers: Type=`#1' Max=`#2' Category=`#3'}
  \def\markers{}
  \def\keys{}
  \foreach \i in {1,...,#2}{%
    \xdef\keys{/tikz/#1 \i/.style={/tikz/#1=\i},\keys}
    \xdef\markers{\markers,#1 \i}}
  {%
    \nopagecolor\pgfkeysalsofrom{\keys}\chitimages[#3][#4]{\markers}}}%
\tikzset{
  wg hidden unit/.pic={},
  wg hidden unit/.style={
    chit={
      no chit drop,
      frame={draw=none,fill=none},
      full=wg hidden unit}}}
\def\battlemarkers{%
  \@ifnextchar[{\@battlemarkers}{\battlemarkers[]}%]
}%
\def\@battlemarkers[#1]{%
  \@ifnextchar[{\@@battlemarkers[#1]}{\battlemarkers[#1][BattleMarkers]}%]
}%
\def\@@battlemarkers[#1][#2]#3{%
  \wg@gennumberm@rkers{battle marker}{#3}{#2}{#1}%
  \chit@dbg{1}{Make a hidden unit and add to Markers category}
  {%
    \nopagecolor%
    \chitimages[Markers]{{wg hidden unit}}%
    %
    \info{battle-marker-icon}{icon}{}%
    \tikz[scale=.7,transform shape,auto icon more/.try]{%
      \pic{battle marker=0};}%
    \info{clear-battles-icon}{icon}{}
    \tikz[scale=.4,transform shape,auto icon more/.try]{%
      \pic{eliminate icon};
      \pic[scale=.7,transform shape] at (-.3,0) {battle marker=0};}%
  }%
}
\def\wg@gencolorm@rkers#1#2#3#4{%
  \def\markers{}
  \def\keys{}
  \foreach \o/\f/\n [count=\i] in {#2}{%
    \ifx\n\f\def\n{\o}\fi%
    \ifx\o\f\def\f{white}\fi%
    \chit@dbg{3}{Colour no `\i' marker `#1 \n' w/fill `\f' text `\o'}%
    \protected@xdef\keys{/tikz/#1 \n/.style={/tikz/#1={\o,\f}},\keys}
    \xdef\markers{\markers,#1 \n}
  }%
  {%
    \nopagecolor%
    \pgfkeysalsofrom{\keys}%
    \chitimages[#3][#4]{\markers}%
  }%
}%
\def\oddsmarkers{%
  \@ifnextchar[{\@oddsmarkers}{\oddsmarkers[]}%]
}%
\def\@oddsmarkers[#1]{%
  \@ifnextchar[{\@@oddsmarkers[#1]}{\oddsmarkers[#1][OddsMarkers]}%]
}%
\def\@@oddsmarkers[#1][#2]#3{%
  \wg@gencolorm@rkers{odds marker}{#3}{#2}{#1}%
  \info{odds-battles-icon}{icon}{}
  \tikz[scale=.5,transform shape,auto icon more/.try]{%
    \pic{odds marker={?:?,white}}}
  \info{resolve-battles-icon}{icon}{}
  \tikz[scale=.3,transform shape,auto icon more/.try]{%
    \pic{dice};
    \pic[scale=1.2,transform shape] at (-.2,-.2) {battle marker=0};}%
}
\def\resultmarkers{%
  \@ifnextchar[{\@resultmarkers}{\resultmarkers[]}%]
}%
\def\@resultmarkers[#1]{%
  \@ifnextchar[{\@@resultmarkers[#1]}{\resultmarkers[#1][ResultMarkers]}%]
}%
\def\@@resultmarkers[#1][#2]#3{%
  \wg@gencolorm@rkers{result marker}{#3}{#2}{#1}}%
\DeclareRobustCommand\commonicons[3][]{%
  \begingroup%
  \nopagecolor%
  \tikzset{auto icon/.style={scale=.4,transform shape,#1}}%
  %
  \info{pool-icon}{icon}{}
  \tikz[auto icon,auto icon more/.try]{\pic{pool icon};}
  %
  \info{oob-icon}{icon}{}%
  \tikz[auto icon,auto icon more/.try]{\pic{oob icon={#2}{#3}};}%
  %
  \info{flip-icon}{icon}{}%
  \tikz[auto icon,auto icon more/.try]{\pic{flip icon};}%
  %
  \info{eliminate-icon}{icon}{}%
  \tikz[auto icon,auto icon more/.try]{\pic{eliminate icon};}%
  %
  \info{restore-icon}{icon}{}%
  \tikz[auto icon,auto icon more/.try]{\pic{restore icon};}%
  %
  \info{dice-icon}{icon}{}%
  \tikz[auto icon,scale=.9,auto icon more/.try]{\pic{dice};}%
  %
  \info{unit-icon}{icon}{}%
  \tikz[auto icon,scale=.7,auto icon more/.try]{%
    \chit[fill=#2,
    symbol={[
      scale line widths,
      line width=1pt,
      faction=friend,
      command=land,
      main=infantry,
      scale=1.3](0,-.15)}]}%
  %
  \info{layer-icon}{icon}{}%
  \begin{tikzpicture}[scale=.25]
    \foreach \i in {-1,0,1}{
      \scoped[shift={(0,\i*.15)}]{
        \draw[black,fill=white] (-.5,0)
        --(0,.3)--(.5,0)--(0,-.3)--cycle;
      }
    }
    \end{tikzpicture}%
    %
    \info{los-icon}{icon}{}
    \begin{tikzpicture}[scale=.25]
      \draw[scale line widths,line width=2pt,fill=white](-.5,0)
      to[out=70,in=110] (.5,0)
      to[out=-110,in=-70] cycle;
      \begin{scope}[even odd rule]
        \clip circle(.2);
        \fill circle(.2) (125:.18) circle(.1);
      \end{scope}
    \end{tikzpicture}%
  %
  \endgroup%
}
\def\dice{%
  \@ifnextchar[{\wg@dice}{\wg@dice[]}%]
}
\def\wg@dice[#1]{%
  \@ifnextchar[{\wg@@dice{#1}}{\wg@@dice{#1}[]} %]
}
\def\wg@@dice#1[#2]#3#4#5{%
  \foreach \v/\p in {#5}{%
    \info{#3-\v}{die-roll}{#3}
    \tikz[#1]{
      %\node[shape=#4,transform shape,draw=none,fill=black,opacity=.5]
      %at (.05,-.03){};
      \node[shape=#4,#2,transform shape,
      chit drop,
      node contents={\p}
      ]{};\wg@add@drop@margin{}}}}
\tikzset{
  zone turn/.store in=\zone@turn,
  zone mult/.store in=\zone@mult
}
\def\@chit@rep@line#1#2{%
  \@ifundefined{#2}{}{
    \edef\wg@chit@tmp{\csname #2\endcsname}
    {\escapechar=`/
      \xdef\tmp{\detokenize\expandafter{\wg@chit@tmp} \@empty}}
    % \message{^^J\meaning\@tmp -> \meaning\tmp}
    \mk@w{ \mk@i\space "#1": "\tmp",}}}

\def\do@chit@report{%
  \chit@dbg{3}{Start of Chit Report}
  \mk@w{ \mk@i "chit": \@lbchar}
  \chit@dbg{3}{Report - ID}
  \@ifundefined{id}{}         {\mk@w{ \mk@i\space "id":      "\id", }}%
  \chit@dbg{3}{Report - Symbol: `\meaning\chit@symbol'}
  \@ifundefined{chit@symbol}{}{\mk@w{ \mk@i\space "symbol":  "true", }}%
  \chit@dbg{3}{Report - Full: `\meaning\chit@full'}
  \@chit@rep@line{full}{chit@full}
  \chit@dbg{3}{Report - Factors: `\meaning\chit@factors'}
  \@chit@rep@line{factors}{chit@factors}%
  \chit@dbg{3}{Report - Left: `\meaning\chit@left'}
  \@chit@rep@line{left}{chit@left}%
  \chit@dbg{3}{Report - Right: : `\meaning\chit@right'}
  \@chit@rep@line{right}{chit@right}%
  \chit@dbg{3}{Report - Upper left: `\meaning\chit@upper@left'}
  \@chit@rep@line{upper left}{chit@upper@left}%
  \chit@dbg{3}{Report - Lower left: `\meaning\chit@lower@left'}
  \@chit@rep@line{lower left}{chit@lower@left}%
  \chit@dbg{3}{Report - Upper right: `\meaning\chit@upper@right}
  \@chit@rep@line{upper right}{chit@upper@right}%
  \chit@dbg{3}{Report - Lower right: `\meaning\chit@lower@right'}
  \@chit@rep@line{lower right}{chit@lower@right}%
  \chit@dbg{3}{Report - End comma}
  \mk@w{ \mk@i\space "end": 0}
  \@ifundefined{chit@symbol}{
    \mk@w{ \mk@i \@rbchar }
  }{
    \mk@w{ \mk@i \@rbchar, }% NATOAPP6c will follow
  }%
  \chit@dbg{3}{End of Chit Report}
}
\def\do@natoapp@report{%
  \mk@w{ \mk@i "natoapp6c": \@lbchar}
  \@chit@rep@line{id}{\id}
  \@chit@rep@line{faction}{natoapp@fac}
  \@chit@rep@line{command}{natoapp@cmd}
  \@chit@rep@line{echelon}{natoapp@ech}
  \@chit@rep@line{main}{natoapp@main}
  \@chit@rep@line{left}{natoapp@left}
  \@chit@rep@line{right}{natoapp@right}
  \@chit@rep@line{upper}{natoapp@upper}
  \@chit@rep@line{lower}{natoapp@lower}
  \@chit@rep@line{below}{natoapp@below}
  \mk@w{ \mk@i\space "end": 0}
  \mk@w{ \mk@i \@rbchar}
}
\tikzset{
  chit drop margin/.store in=\wg@drop@margin,
  chit drop shadows/.code={
    \pgfkeysalso{%
      /tikz/every chit node/.prefix style={chit drop={#1}},
      /tikz/chit has drop=true}
  },
  chit drop shadows/.default=,
  marker drop shadows/.code={
    \pgfkeysalso{%
      /tikz/every battle marker/.prefix style={chit drop={#1}},
      /tikz/every odds marker/.prefix style={chit drop={#1}},
      /tikz/every result marker/.prefix style={chit drop={#1}},
      /tikz/auto icon more/.prefix style={no chit drop}}},
  marker drop shadows/.default={
    chit has drop=false,
    shadow xshift=0.04cm,
    shadow yshift=-0.04cm,
    shadow blur radius=0.04cm}
}

%% Local Variables:
%%   mode: LaTeX
%% End:
%%
%% End of file `wgexport.cls'.
