//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_SKEL_IMAGING_BLEND_SHAPE_SCHEMA_H
#define PXR_USD_IMAGING_USD_SKEL_IMAGING_BLEND_SHAPE_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdSkelImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/imaging/hd/containerSchema.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
using UsdSkelImagingInbetweenShapeContainerSchema =
    HdSchemaBasedContainerSchema<class UsdSkelImagingInbetweenShapeSchema>;
// --(END CUSTOM CODE: Declares)--

#define USD_SKEL_IMAGING_BLEND_SHAPE_SCHEMA_TOKENS \
    (skelBlendShape) \
    (offsets) \
    (normalOffsets) \
    (pointIndices) \
    (inbetweenShapes) \

TF_DECLARE_PUBLIC_TOKENS(UsdSkelImagingBlendShapeSchemaTokens, USDSKELIMAGING_API,
    USD_SKEL_IMAGING_BLEND_SHAPE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class UsdSkelImagingBlendShapeSchema
///
/// Corresponds to UsdSkelBlendShape.
///
class UsdSkelImagingBlendShapeSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdSkelImagingBlendShapeSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "skelBlendShape" from the parent container and constructs a
    /// UsdSkelImagingBlendShapeSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDSKELIMAGING_API
    static UsdSkelImagingBlendShapeSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    USDSKELIMAGING_API
    HdVec3fArrayDataSourceHandle GetOffsets() const;

    USDSKELIMAGING_API
    HdVec3fArrayDataSourceHandle GetNormalOffsets() const;

    USDSKELIMAGING_API
    HdIntArrayDataSourceHandle GetPointIndices() const;

    USDSKELIMAGING_API
    UsdSkelImagingInbetweenShapeContainerSchema GetInbetweenShapes() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDSKELIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate offsets.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetOffsetsLocator();

    /// Prim-level relative data source locator to locate normalOffsets.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetNormalOffsetsLocator();

    /// Prim-level relative data source locator to locate pointIndices.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetPointIndicesLocator();

    /// Prim-level relative data source locator to locate inbetweenShapes.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetInbetweenShapesLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDSKELIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdVec3fArrayDataSourceHandle &offsets,
        const HdVec3fArrayDataSourceHandle &normalOffsets,
        const HdIntArrayDataSourceHandle &pointIndices,
        const HdContainerDataSourceHandle &inbetweenShapes
    );

    /// \class UsdSkelImagingBlendShapeSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDSKELIMAGING_API
        Builder &SetOffsets(
            const HdVec3fArrayDataSourceHandle &offsets);
        USDSKELIMAGING_API
        Builder &SetNormalOffsets(
            const HdVec3fArrayDataSourceHandle &normalOffsets);
        USDSKELIMAGING_API
        Builder &SetPointIndices(
            const HdIntArrayDataSourceHandle &pointIndices);
        USDSKELIMAGING_API
        Builder &SetInbetweenShapes(
            const HdContainerDataSourceHandle &inbetweenShapes);

        /// Returns a container data source containing the members set thus far.
        USDSKELIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdVec3fArrayDataSourceHandle _offsets;
        HdVec3fArrayDataSourceHandle _normalOffsets;
        HdIntArrayDataSourceHandle _pointIndices;
        HdContainerDataSourceHandle _inbetweenShapes;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif
