/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schema.extractor.SchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.extractor.impl.ResourceMap;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.core.api.partition.PartitionWriteTxn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaLdifToPartitionExtractor
implements SchemaLdifExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaLdifToPartitionExtractor.class);
    private static final Pattern EXTRACT_PATTERN = Pattern.compile(".*schema[/\\Q\\\\E]ou=schema.*\\.ldif");
    private final CsnFactory csnFactory = new CsnFactory(0);
    private boolean extracted;
    private final SchemaManager schemaManager;
    private final Partition partition;

    public SchemaLdifToPartitionExtractor(SchemaManager schemaManager, Partition partition) throws LdapException {
        this.schemaManager = schemaManager;
        this.partition = partition;
        Dn dn = new Dn(schemaManager, new String[]{"ou=schema"});
        HasEntryOperationContext hasEntryContext = new HasEntryOperationContext(null, dn);
        hasEntryContext.setPartition(partition);
        try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
            hasEntryContext.setTransaction((PartitionTxn)partitionTxn);
            if (partition.hasEntry(hasEntryContext)) {
                LOG.info("Schema entry 'ou=schema' exists: extracted state set to true.");
                this.extracted = true;
            } else {
                LOG.info("Schema entry 'ou=schema' does NOT exist: extracted state set to false.");
                this.extracted = false;
            }
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public boolean isExtracted() {
        return this.extracted;
    }

    public void extractOrCopy(boolean overwrite) throws IOException {
        TreeMap resources = ResourceMap.getResources((Pattern)EXTRACT_PATTERN);
        resources = new TreeMap(resources);
        if (!this.extracted || overwrite) {
            for (Map.Entry entry : resources.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    this.addFromClassLoader((String)entry.getKey());
                    continue;
                }
                File resource = new File((String)entry.getKey());
                this.addLdifFile(resource);
            }
            this.extracted = true;
        }
    }

    public void extractOrCopy() throws IOException {
        this.extractOrCopy(false);
    }

    private void addLdifFile(File source) throws IOException {
        LOG.debug("copyFile(): source = {}", (Object)source);
        if (!source.getParentFile().exists()) {
            throw new FileNotFoundException(I18n.err((I18n)I18n.ERR_16002_MORE_THAN_ONE_ENTRY, (Object[])new Object[]{source.getAbsolutePath()}));
        }
        InputStream in = Files.newInputStream(source.toPath(), new OpenOption[0]);
        this.addFromStream(in, source.getAbsolutePath());
    }

    private void addFromClassLoader(String resource) throws IOException {
        InputStream in = DefaultSchemaLdifExtractor.getUniqueResourceAsStream((String)resource, (String)"LDIF file in schema repository");
        this.addFromStream(in, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFromStream(InputStream in, String source) throws IOException {
        block18: {
            try {
                LdifReader ldifReader = new LdifReader(in);
                boolean first = true;
                LdifEntry ldifEntry = null;
                try {
                    while (ldifReader.hasNext()) {
                        if (first) {
                            ldifEntry = ldifReader.next();
                            if (ldifEntry.get("entryUUID") == null) {
                                UUID entryUuid = UUID.randomUUID();
                                ldifEntry.addAttribute("entryUUID", new Object[]{entryUuid.toString()});
                            }
                            if (ldifEntry.get("entryCSN") == null) {
                                Csn csn = this.csnFactory.newInstance();
                                ldifEntry.addAttribute("entryCSN", new Object[]{csn.toString()});
                            }
                            first = false;
                            continue;
                        }
                        String msg = I18n.err((I18n)I18n.ERR_16002_MORE_THAN_ONE_ENTRY, (Object[])new Object[]{source});
                        LOG.error(msg);
                        throw new InvalidObjectException(msg);
                    }
                }
                finally {
                    ldifReader.close();
                }
                if (ldifEntry == null) break block18;
                DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
                AddOperationContext addContext = new AddOperationContext(null, (Entry)entry);
                addContext.setPartition(this.partition);
                PartitionWriteTxn partitionTxn = null;
                try {
                    partitionTxn = this.partition.beginWriteTransaction();
                    addContext.setTransaction((PartitionTxn)partitionTxn);
                    this.partition.add(addContext);
                    partitionTxn.commit();
                }
                catch (LdapException le) {
                    if (partitionTxn != null) {
                        try {
                            partitionTxn.abort();
                        }
                        catch (IOException ioe) {
                            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                    throw le;
                }
                catch (IOException ioe) {
                    try {
                        partitionTxn.abort();
                    }
                    catch (IOException ioe2) {
                        throw new LdapOtherException(ioe2.getMessage(), (Throwable)ioe2);
                    }
                    throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
                }
            }
            catch (LdapException ne) {
                String msg = I18n.err((I18n)I18n.ERR_16003_ERROR_PARSING_LDIF, (Object[])new Object[]{source, ne.getLocalizedMessage()});
                LOG.error(msg);
                throw new InvalidObjectException(msg);
            }
        }
    }
}

