/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.dialogs;

import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroup;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetActionGroupWithAttribute;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetUniversalListener;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.dialogs.Messages;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class LdifEntryEditorDialog
extends Dialog {
    public static final String DIALOG_TITLE = Messages.getString("LdifEntryEditorDialog.LDIFRecordEditor");
    public static final int MAX_WIDTH = 450;
    public static final int MAX_HEIGHT = 250;
    private IBrowserConnection browserConnection;
    private boolean originalReadOnlyFlag;
    private LdifRecord ldifRecord;
    private IEntry entry;
    private EntryEditorWidgetConfiguration configuration;
    private EntryEditorWidgetActionGroup actionGroup;
    private EntryEditorWidget mainWidget;
    private EntryEditorWidgetUniversalListener universalListener;
    private IContextActivation contextActivation;

    public LdifEntryEditorDialog(Shell parentShell, IBrowserConnection browserConnection, LdifContentRecord ldifRecord) {
        this(parentShell, browserConnection, (LdifRecord)ldifRecord, null);
    }

    public LdifEntryEditorDialog(Shell parentShell, IBrowserConnection browserConnection, LdifChangeAddRecord ldifRecord) {
        this(parentShell, browserConnection, (LdifRecord)ldifRecord, null);
    }

    private LdifEntryEditorDialog(Shell parentShell, IBrowserConnection browserConnection, LdifRecord ldifRecord, String s) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.ldifRecord = ldifRecord;
        this.browserConnection = browserConnection != null ? browserConnection : new DummyConnection(Schema.DEFAULT_SCHEMA);
        try {
            if (ldifRecord instanceof LdifContentRecord) {
                this.entry = ModelConverter.ldifContentRecordToEntry((LdifContentRecord)((LdifContentRecord)this.ldifRecord), (IBrowserConnection)this.browserConnection);
            } else if (ldifRecord instanceof LdifChangeAddRecord) {
                this.entry = ModelConverter.ldifChangeAddRecordToEntry((LdifChangeAddRecord)((LdifChangeAddRecord)this.ldifRecord), (IBrowserConnection)this.browserConnection);
            }
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            this.entry = null;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setImage(LdifEditorActivator.getDefault().getImage("resources/icons/ldifeditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        if (this.entry != null) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
        this.getShell().update();
        this.getShell().layout(true, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.entry != null) {
            if (this.ldifRecord instanceof LdifContentRecord) {
                this.ldifRecord = ModelConverter.entryToLdifContentRecord((IEntry)this.entry);
            } else if (this.ldifRecord instanceof LdifChangeAddRecord) {
                this.ldifRecord = ModelConverter.entryToLdifChangeAddRecord((IEntry)this.entry);
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        if (this.browserConnection.getConnection() != null) {
            this.originalReadOnlyFlag = this.browserConnection.getConnection().isReadOnly();
            this.browserConnection.getConnection().setReadOnly(true);
        }
    }

    public boolean close() {
        boolean returnValue = super.close();
        if (returnValue) {
            this.dispose();
            if (this.browserConnection.getConnection() != null) {
                this.browserConnection.getConnection().setReadOnly(this.originalReadOnlyFlag);
            }
        }
        return returnValue;
    }

    public void dispose() {
        if (this.configuration != null) {
            this.universalListener.dispose();
            this.universalListener = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
            this.actionGroup.deactivateGlobalActionHandlers();
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.configuration.dispose();
            this.configuration = null;
            if (this.contextActivation != null) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                contextService.deactivateContext(this.contextActivation);
                this.contextActivation = null;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.entry == null) {
            String message = Messages.getString("LdifEntryEditorDialog.InvalidDnCantEditEntry");
            BaseWidgetUtils.createLabel((Composite)composite, (String)message, (int)1);
        } else {
            this.configuration = new EntryEditorWidgetConfiguration();
            this.mainWidget = new EntryEditorWidget(this.configuration);
            this.mainWidget.createWidget(composite);
            this.mainWidget.getViewer().getTree().setFocus();
            this.actionGroup = new EntryEditorWidgetActionGroupWithAttribute(this.mainWidget, this.configuration);
            this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
            this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
            this.actionGroup.fillContextMenu(this.mainWidget.getContextMenuManager());
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
            this.contextActivation = contextService.activateContext(BrowserCommonConstants.CONTEXT_DIALOGS);
            this.actionGroup.activateGlobalActionHandlers();
            this.mainWidget.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    LdifEntryEditorDialog.this.actionGroup.deactivateGlobalActionHandlers();
                    LdifEntryEditorDialog.this.actionGroup.activateGlobalActionHandlers();
                }
            });
            this.universalListener = new EntryEditorWidgetUniversalListener(this.mainWidget.getViewer(), this.configuration, this.actionGroup, this.actionGroup.getOpenDefaultEditorAction());
            this.universalListener.setInput(this.entry);
        }
        LdifEntryEditorDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public LdifRecord getLdifRecord() {
        return this.ldifRecord;
    }
}

