/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import org.apache.directory.studio.ldifparser.model.LdifEOFPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;

public abstract class LdifRecord
extends LdifContainer {
    protected LdifRecord(LdifDnLine dn) {
        super(dn);
    }

    public void addComment(LdifCommentLine comment) {
        if (comment == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(comment);
    }

    public void finish(LdifSepLine sep) {
        if (sep == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(sep);
    }

    public void finish(LdifEOFPart eof) {
        if (eof == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(eof);
    }

    public LdifDnLine getDnLine() {
        return (LdifDnLine)this.ldifParts.get(0);
    }

    public LdifSepLine getSepLine() {
        for (LdifPart ldifPart : this.ldifParts) {
            if (!(ldifPart instanceof LdifSepLine)) continue;
            return (LdifSepLine)ldifPart;
        }
        return null;
    }

    @Override
    public String getInvalidString() {
        LdifDnLine dnLine = this.getDnLine();
        LdifSepLine sepLine = this.getSepLine();
        if (dnLine == null) {
            return "Record must start with Dn";
        }
        if (!dnLine.isValid()) {
            return dnLine.getInvalidString();
        }
        if (sepLine == null) {
            return "Record must end with an empty line";
        }
        if (!sepLine.isValid()) {
            return sepLine.getInvalidString();
        }
        return super.getInvalidString();
    }

    @Override
    protected boolean isAbstractValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        LdifPart lastPart = this.getLastPart();
        return this.getDnLine().isValid() && (lastPart instanceof LdifSepLine || lastPart instanceof LdifEOFPart) && lastPart.isValid();
    }
}

