/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.protocal;

import java.io.Serializable;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.extract.base.StandardRpcRequest;
import org.apache.dolphinscheduler.extract.base.StandardRpcResponse;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterHeader;
import org.apache.dolphinscheduler.extract.base.serialize.JsonSerializer;

public class Transporter
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final byte MAGIC = -66;
    public static final byte VERSION = 0;
    private TransporterHeader header;
    private byte[] body;

    public static Transporter of(@NonNull TransporterHeader header, StandardRpcResponse iRpcResponse) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        return Transporter.of(header, JsonSerializer.serialize(iRpcResponse));
    }

    public static Transporter of(@NonNull TransporterHeader header, StandardRpcRequest iRpcRequest) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        return Transporter.of(header, JsonSerializer.serialize(iRpcRequest));
    }

    public static Transporter of(@NonNull TransporterHeader header, byte[] body) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        Transporter transporter = new Transporter();
        transporter.setHeader(header);
        transporter.setBody(body);
        return transporter;
    }

    @Generated
    public Transporter() {
    }

    @Generated
    public TransporterHeader getHeader() {
        return this.header;
    }

    @Generated
    public byte[] getBody() {
        return this.body;
    }

    @Generated
    public void setHeader(TransporterHeader header) {
        this.header = header;
    }

    @Generated
    public void setBody(byte[] body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transporter)) {
            return false;
        }
        Transporter other = (Transporter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransporterHeader this$header = this.getHeader();
        TransporterHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transporter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransporterHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    @Generated
    public String toString() {
        return "Transporter(header=" + this.getHeader() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }
}

