/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.HasPublicIpAddress;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.PointToSiteConfiguration;
import com.azure.resourcemanager.network.models.UpdatableWithTags;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnection;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnections;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayIpConfiguration;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySku;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySkuName;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayType;
import com.azure.resourcemanager.network.models.VpnClientConfiguration;
import com.azure.resourcemanager.network.models.VpnType;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.Collection;
import reactor.core.publisher.Mono;

public interface VirtualNetworkGateway
extends GroupableResource<NetworkManager, VirtualNetworkGatewayInner>,
Refreshable<VirtualNetworkGateway>,
Updatable<Update>,
UpdatableWithTags<VirtualNetworkGateway> {
    public void reset();

    public Mono<Void> resetAsync();

    public PagedIterable<VirtualNetworkGatewayConnection> listConnections();

    public PagedFlux<VirtualNetworkGatewayConnection> listConnectionsAsync();

    public String generateVpnProfile();

    public Mono<String> generateVpnProfileAsync();

    public VirtualNetworkGatewayConnections connections();

    public VirtualNetworkGatewayType gatewayType();

    public VpnType vpnType();

    public boolean isBgpEnabled();

    public boolean activeActive();

    public String gatewayDefaultSiteResourceId();

    public VirtualNetworkGatewaySku sku();

    public VpnClientConfiguration vpnClientConfiguration();

    public BgpSettings bgpSettings();

    public Collection<VirtualNetworkGatewayIpConfiguration> ipConfigurations();

    public static interface Update
    extends Appliable<VirtualNetworkGateway>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithBgp,
    UpdateStages.WithPointToSiteConfiguration {
    }

    public static interface UpdateStages {

        public static interface WithPointToSiteConfiguration {
            public PointToSiteConfiguration.DefinitionStages.Blank<Update> definePointToSiteConfiguration();

            public PointToSiteConfiguration.Update updatePointToSiteConfiguration();
        }

        public static interface WithBgp {
            public Update withBgp(long var1, String var3);

            public Update withoutBgp();
        }

        public static interface WithSku {
            public Update withSku(VirtualNetworkGatewaySkuName var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<VirtualNetworkGateway>,
        Resource.DefinitionWithTags<WithCreate>,
        WithPublicIPAddress,
        WithBgp {
        }

        public static interface WithBgp {
            public WithCreate withBgp(long var1, String var3);
        }

        public static interface WithPublicIPAddress
        extends HasPublicIpAddress.DefinitionStages.WithPublicIPAddressNoDnsLabel<WithCreate> {
        }

        public static interface WithSku {
            public WithCreate withSku(VirtualNetworkGatewaySkuName var1);
        }

        public static interface WithNetwork {
            public WithGatewayType withNewNetwork(Creatable<Network> var1);

            public WithGatewayType withNewNetwork(String var1, String var2, String var3);

            public WithGatewayType withNewNetwork(String var1, String var2);

            public WithGatewayType withExistingNetwork(Network var1);
        }

        public static interface WithGatewayType {
            public WithSku withExpressRoute();

            public WithSku withRouteBasedVpn();

            public WithCreate withPolicyBasedVpn();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithNetwork> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithGatewayType,
    DefinitionStages.WithSku,
    DefinitionStages.WithNetwork,
    DefinitionStages.WithBgp,
    DefinitionStages.WithCreate {
    }
}

