/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryDataChangeListenerAdapter;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryThreadFactory;
import org.apache.dolphinscheduler.plugin.registry.jdbc.client.JdbcRegistryClient;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.DataType;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.ConnectionStateListener;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IJdbcRegistryServer;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcRegistry
implements Registry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistry.class);
    private final JdbcRegistryProperties jdbcRegistryProperties;
    private final JdbcRegistryClient jdbcRegistryClient;
    private final IJdbcRegistryServer jdbcRegistryServer;

    JdbcRegistry(JdbcRegistryProperties jdbcRegistryProperties, IJdbcRegistryServer jdbcRegistryServer) {
        this.jdbcRegistryProperties = jdbcRegistryProperties;
        this.jdbcRegistryServer = jdbcRegistryServer;
        this.jdbcRegistryClient = new JdbcRegistryClient(jdbcRegistryServer);
        log.info("Initialized Jdbc Registry...");
    }

    public void start() {
        log.info("Starting Jdbc Registry...");
        this.jdbcRegistryServer.start();
        this.jdbcRegistryClient.start();
        log.info("Started Jdbc Registry...");
    }

    public boolean isConnected() {
        return this.jdbcRegistryClient.isConnectivity();
    }

    public void connectUntilTimeout(@NonNull Duration timeout) throws RegistryException {
        long endTimeMills;
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        long beginTimeMillis = System.currentTimeMillis();
        long l = endTimeMills = timeout.getSeconds() <= 0L ? Long.MAX_VALUE : beginTimeMillis + timeout.toMillis();
        while (true) {
            if (System.currentTimeMillis() > endTimeMills) {
                throw new RegistryException(String.format("Cannot connect to jdbc registry in %s s", timeout.getSeconds()));
            }
            if (this.jdbcRegistryClient.isConnectivity()) {
                return;
            }
            try {
                Thread.sleep(this.jdbcRegistryProperties.getHeartbeatRefreshInterval().toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RegistryException("Cannot connect to jdbc registry due to interrupted exception", (Throwable)e);
            }
        }
    }

    public void subscribe(String watchedPath, SubscribeListener listener) {
        Preconditions.checkNotNull((Object)watchedPath);
        Preconditions.checkNotNull((Object)listener);
        this.jdbcRegistryClient.subscribeJdbcRegistryDataChange(new JdbcRegistryDataChangeListenerAdapter(watchedPath, listener));
    }

    public void addConnectionStateListener(final ConnectionListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.jdbcRegistryClient.subscribeConnectionStateChange(new ConnectionStateListener(){

            @Override
            public void onConnected() {
                listener.onUpdate(ConnectionState.CONNECTED);
            }

            @Override
            public void onDisConnected() {
                listener.onUpdate(ConnectionState.DISCONNECTED);
            }

            @Override
            public void onReconnected() {
                listener.onUpdate(ConnectionState.RECONNECTED);
            }
        });
    }

    public String get(String key) {
        try {
            Optional<JdbcRegistryDataDTO> jdbcRegistryDataOptional = this.jdbcRegistryClient.getJdbcRegistryDataByKey(key);
            if (!jdbcRegistryDataOptional.isPresent()) {
                throw new RegistryException("key: " + key + " not exist");
            }
            return jdbcRegistryDataOptional.get().getDataValue();
        }
        catch (RegistryException registryException) {
            throw registryException;
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Get key: %s error", key), (Throwable)e);
        }
    }

    public void put(String key, String value, boolean deleteOnDisconnect) {
        try {
            DataType dataType = deleteOnDisconnect ? DataType.EPHEMERAL : DataType.PERSISTENT;
            this.jdbcRegistryClient.putJdbcRegistryData(key, value, dataType);
        }
        catch (Exception ex) {
            throw new RegistryException(String.format("put key:%s, value:%s error", key, value), (Throwable)ex);
        }
    }

    public void delete(String key) {
        try {
            this.jdbcRegistryClient.deleteJdbcRegistryDataByKey(key);
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Delete key: %s error", key), (Throwable)e);
        }
    }

    public Collection<String> children(String key) {
        try {
            List<JdbcRegistryDataDTO> children = this.jdbcRegistryClient.listJdbcRegistryDataChildren(key);
            return children.stream().map(JdbcRegistryDataDTO::getDataKey).map(fullPath -> StringUtils.substringBefore((String)fullPath.substring(key.length() + 1), (String)"/")).distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Get key: %s children error", key), (Throwable)e);
        }
    }

    public boolean exists(String key) {
        try {
            return this.jdbcRegistryClient.existJdbcRegistryDataKey(key);
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Check key: %s exist error", key), (Throwable)e);
        }
    }

    public boolean acquireLock(String key) {
        try {
            this.jdbcRegistryClient.acquireJdbcRegistryLock(key);
            return true;
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Acquire lock: %s error", key), (Throwable)e);
        }
    }

    public boolean acquireLock(String key, long timeout) {
        try {
            return this.jdbcRegistryClient.acquireJdbcRegistryLock(key, timeout);
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryException(String.format("Acquire lock: %s error", key), (Throwable)e);
        }
    }

    public boolean releaseLock(String key) {
        this.jdbcRegistryClient.releaseJdbcRegistryLock(key);
        return true;
    }

    public void close() {
        log.info("Closing JdbcRegistry...");
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().shutdownNow();
        try {
            JdbcRegistryClient closed1 = this.jdbcRegistryClient;
            Throwable throwable = null;
            if (closed1 != null) {
                if (throwable != null) {
                    try {
                        closed1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    closed1.close();
                }
            }
        }
        catch (Exception e) {
            log.error("Close JdbcRegistry error", (Throwable)e);
        }
        log.info("Closed JdbcRegistry...");
    }
}

