/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.enums.ExecuteType;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuditModelType;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperatorUtils.class);

    public static boolean resultFail(Result<?> result) {
        return result != null && result.isFailed();
    }

    public static List<AuditLog> buildAuditLogList(String apiDescription, AuditType auditType, User user) {
        ArrayList<AuditLog> auditLogList = new ArrayList<AuditLog>();
        AuditLog auditLog = new AuditLog();
        auditLog.setUserId(user.getId());
        auditLog.setModelType(auditType.getAuditModelType().getName());
        auditLog.setOperationType(auditType.getAuditOperationType().getName());
        auditLog.setDescription(apiDescription);
        auditLog.setCreateTime(new Date());
        auditLogList.add(auditLog);
        return auditLogList;
    }

    public static User getUser(Map<String, Object> paramsMap) {
        for (Object object : paramsMap.values()) {
            if (!(object instanceof User)) continue;
            return (User)object;
        }
        return null;
    }

    public static Map<String, Object> getParamsMap(JoinPoint point, MethodSignature signature) {
        Object[] args = point.getArgs();
        String[] strings = signature.getParameterNames();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        for (int i = 0; i < strings.length; ++i) {
            paramsMap.put(strings[i], args[i]);
        }
        return paramsMap;
    }

    public static AuditOperationType modifyReleaseOperationType(AuditType auditType, Map<String, Object> paramsMap) {
        switch (auditType.getAuditOperationType()) {
            case RELEASE: {
                ReleaseState releaseState = (ReleaseState)paramsMap.get("releaseState");
                if (releaseState == null) break;
                switch (releaseState) {
                    case ONLINE: {
                        return AuditOperationType.ONLINE;
                    }
                    case OFFLINE: {
                        return AuditOperationType.OFFLINE;
                    }
                }
                break;
            }
            case EXECUTE: {
                ExecuteType executeType = (ExecuteType)((Object)paramsMap.get("executeType"));
                if (executeType == null) break;
                switch (executeType) {
                    case REPEAT_RUNNING: {
                        return AuditOperationType.RERUN;
                    }
                    case RECOVER_SUSPENDED_PROCESS: {
                        return AuditOperationType.RESUME_PAUSE;
                    }
                    case START_FAILURE_TASK_PROCESS: {
                        return AuditOperationType.RESUME_FAILURE;
                    }
                    case STOP: {
                        return AuditOperationType.STOP;
                    }
                    case PAUSE: {
                        return AuditOperationType.PAUSE;
                    }
                    case EXECUTE_TASK: {
                        return AuditOperationType.EXECUTE;
                    }
                }
                break;
            }
        }
        return auditType.getAuditOperationType();
    }

    public static long getObjectIdentityByParam(String[] paramNameArr, Map<String, Object> paramsMap) {
        for (String name : paramNameArr) {
            if (!(paramsMap.get(name) instanceof String)) continue;
            String param = (String)paramsMap.get(name);
            try {
                if (!param.matches("\\d+")) continue;
                return Long.parseLong(param);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public static Map<String, Object> getObjectIfFromReturnObject(Object obj, String[] params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Class<?> clazz = obj.getClass();
            if (clazz.equals(Long.class)) {
                map.put(params[0], obj);
            }
            while (clazz != null) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!field.getName().equals(params[0])) continue;
                    map.put(params[0], field.get(obj));
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            log.error("get object if from return object error", (Throwable)e);
        }
        return map;
    }

    public static boolean isFolder(String name) {
        return name != null && name.endsWith("/");
    }

    public static String getFileAuditObject(AuditType auditType, Map<String, Object> paramsMap, String name) {
        boolean isFolder = auditType == AuditType.FOLDER_CREATE || OperatorUtils.isFolder(name);
        return isFolder ? AuditModelType.FOLDER.getName() : AuditModelType.FILE.getName();
    }
}

