/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit.operator.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.audit.operator.BaseAuditOperator;
import org.apache.dolphinscheduler.dao.entity.AccessToken;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AccessTokenMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenAuditOperatorImpl
extends BaseAuditOperator {
    @Autowired
    private AccessTokenMapper accessTokenMapper;
    @Autowired
    private UserMapper userMapper;

    @Override
    public void modifyAuditOperationType(AuditType auditType, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        if (paramsMap.get("userId") != null) {
            User user = (User)this.userMapper.selectById((Serializable)((Object)paramsMap.get("userId").toString()));
            auditLogList.forEach(auditLog -> {
                auditLog.setModelName(user.getUserName());
                auditLog.setModelId(Long.valueOf(user.getId().intValue()));
            });
        }
    }

    @Override
    public String getObjectNameFromIdentity(Object identity) {
        Long objId = this.toLong(identity);
        if (objId == -1L) {
            return "";
        }
        AccessToken obj = (AccessToken)this.accessTokenMapper.selectById((Serializable)objId);
        return obj == null ? "" : obj.getUserName();
    }
}

