/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.api.dto.AuditDto;
import org.apache.dolphinscheduler.api.service.AuditService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.AuditModelType;
import org.apache.dolphinscheduler.common.enums.AuditOperationType;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.mapper.AuditLogMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditServiceImpl
extends BaseServiceImpl
implements AuditService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditServiceImpl.class);
    @Autowired
    private AuditLogMapper auditLogMapper;

    @Override
    public void addAudit(AuditLog auditLog) {
        if (auditLog.getModelId() == null || auditLog.getModelName() == null) {
            return;
        }
        this.auditLogMapper.insert((Object)auditLog);
    }

    @Override
    public PageInfo<AuditDto> queryLogListPaging(String modelTypes, String operationTypes, String startDate, String endDate, String userName, String modelName, Integer pageNo, Integer pageSize) {
        List<String> objectTypeCodeList = this.convertStringToList(modelTypes);
        List<String> operationTypeCodeList = this.convertStringToList(operationTypes);
        Date start = this.checkAndParseDateParameters(startDate);
        Date end = this.checkAndParseDateParameters(endDate);
        IPage logIPage = this.auditLogMapper.queryAuditLog((IPage)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), objectTypeCodeList, operationTypeCodeList, userName, modelName, start, end);
        List auditDtos = logIPage.getRecords().stream().map(this::transformAuditLog).collect(Collectors.toList());
        PageInfo<AuditDto> pageInfo = new PageInfo<AuditDto>(pageNo, pageSize);
        pageInfo.setTotal((int)logIPage.getTotal());
        pageInfo.setTotalList(auditDtos);
        return pageInfo;
    }

    private List<String> convertStringToList(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return new ArrayList<String>();
        }
        return Arrays.stream(string.split(",")).collect(Collectors.toList());
    }

    private AuditDto transformAuditLog(AuditLog auditLog) {
        AuditDto auditDto = new AuditDto();
        AuditModelType objectType = AuditModelType.of((String)auditLog.getModelType());
        auditDto.setModelType(objectType.getName());
        auditDto.setModelName(auditLog.getModelName());
        auditDto.setOperation(AuditOperationType.of((String)auditLog.getOperationType()).getName());
        auditDto.setUserName(auditLog.getUserName());
        auditDto.setLatency(String.valueOf(auditLog.getLatency()));
        auditDto.setDetail(auditLog.getDetail());
        auditDto.setDescription(auditLog.getDescription());
        auditDto.setCreateTime(auditLog.getCreateTime());
        return auditDto;
    }
}

