/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.implementation.VirtualMachineScaleSetNicIpConfigurationImpl;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.VirtualMachineScaleSetNetworkInterface;
import com.azure.resourcemanager.network.models.VirtualMachineScaleSetNicIpConfiguration;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class VirtualMachineScaleSetNetworkInterfaceImpl
extends ResourceImpl<VirtualMachineScaleSetNetworkInterface, NetworkInterfaceInner, VirtualMachineScaleSetNetworkInterfaceImpl>
implements VirtualMachineScaleSetNetworkInterface {
    private final NetworkManager networkManager;
    private final String scaleSetName;
    private final String resourceGroupName;
    private final ClientLogger logger = new ClientLogger(this.getClass());

    VirtualMachineScaleSetNetworkInterfaceImpl(String name, String scaleSetName, String resourceGroupName, NetworkInterfaceInner innerObject, NetworkManager networkManager) {
        super(name, (Resource)innerObject);
        this.scaleSetName = scaleSetName;
        this.resourceGroupName = resourceGroupName;
        this.networkManager = networkManager;
    }

    @Override
    public boolean isIPForwardingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.innerModel())).enableIpForwarding());
    }

    @Override
    public String macAddress() {
        return ((NetworkInterfaceInner)((Object)this.innerModel())).macAddress();
    }

    @Override
    public String internalDnsNameLabel() {
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().internalDnsNameLabel();
    }

    @Override
    public String internalFqdn() {
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().internalFqdn();
    }

    @Override
    public String internalDomainNameSuffix() {
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().internalDomainNameSuffix();
    }

    @Override
    public List<String> dnsServers() {
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() == null || ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().dnsServers() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().dnsServers());
    }

    @Override
    public List<String> appliedDnsServers() {
        ArrayList dnsServers = new ArrayList();
        if (((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings() == null || ((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().appliedDnsServers() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.innerModel())).dnsSettings().appliedDnsServers());
    }

    @Override
    public String primaryPrivateIP() {
        VirtualMachineScaleSetNicIpConfiguration primaryIPConfig = this.primaryIPConfiguration();
        if (primaryIPConfig == null) {
            return null;
        }
        return primaryIPConfig.privateIpAddress();
    }

    @Override
    public IpAllocationMethod primaryPrivateIpAllocationMethod() {
        VirtualMachineScaleSetNicIpConfiguration primaryIPConfig = this.primaryIPConfiguration();
        if (primaryIPConfig == null) {
            return null;
        }
        return primaryIPConfig.privateIpAllocationMethod();
    }

    @Override
    public Map<String, VirtualMachineScaleSetNicIpConfiguration> ipConfigurations() {
        List<NetworkInterfaceIpConfigurationInner> inners = ((NetworkInterfaceInner)((Object)this.innerModel())).ipConfigurations();
        if (inners == null || inners.size() == 0) {
            return Collections.unmodifiableMap(new TreeMap());
        }
        TreeMap<String, VirtualMachineScaleSetNicIpConfigurationImpl> nicIPConfigurations = new TreeMap<String, VirtualMachineScaleSetNicIpConfigurationImpl>();
        for (NetworkInterfaceIpConfigurationInner inner : inners) {
            VirtualMachineScaleSetNicIpConfigurationImpl nicIPConfiguration = new VirtualMachineScaleSetNicIpConfigurationImpl(inner, this, this.networkManager);
            nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
        }
        return Collections.unmodifiableMap(nicIPConfigurations);
    }

    @Override
    public VirtualMachineScaleSetNicIpConfiguration primaryIPConfiguration() {
        for (VirtualMachineScaleSetNicIpConfiguration ipConfiguration : this.ipConfigurations().values()) {
            if (!ipConfiguration.isPrimary()) continue;
            return ipConfiguration;
        }
        return null;
    }

    @Override
    public String networkSecurityGroupId() {
        if (((NetworkInterfaceInner)((Object)this.innerModel())).networkSecurityGroup() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.innerModel())).networkSecurityGroup().id();
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        String nsgId = this.networkSecurityGroupId();
        if (nsgId == null) {
            return null;
        }
        return (NetworkSecurityGroup)this.manager().networkSecurityGroups().getByResourceGroup(ResourceUtils.groupFromResourceId((String)nsgId), ResourceUtils.nameFromResourceId((String)nsgId));
    }

    @Override
    public String virtualMachineId() {
        if (((NetworkInterfaceInner)((Object)this.innerModel())).virtualMachine() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.innerModel())).virtualMachine().id();
    }

    public Mono<VirtualMachineScaleSetNetworkInterface> createResourceAsync() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException());
    }

    protected Mono<NetworkInterfaceInner> getInnerAsync() {
        return ((NetworkManagementClient)this.manager().serviceClient()).getNetworkInterfaces().getVirtualMachineScaleSetNetworkInterfaceAsync(this.resourceGroupName, this.scaleSetName, ResourceUtils.nameFromResourceId((String)this.virtualMachineId()), this.name());
    }

    public NetworkManager manager() {
        return this.networkManager;
    }

    @Override
    public boolean isAcceleratedNetworkingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.innerModel())).enableAcceleratedNetworking());
    }
}

