/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectivityDestination;
import com.azure.resourcemanager.network.models.ConnectivitySource;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.Protocol;
import com.azure.resourcemanager.network.models.ProtocolConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ConnectivityParameters {
    @JsonProperty(value="source", required=true)
    private ConnectivitySource source;
    @JsonProperty(value="destination", required=true)
    private ConnectivityDestination destination;
    @JsonProperty(value="protocol")
    private Protocol protocol;
    @JsonProperty(value="protocolConfiguration")
    private ProtocolConfiguration protocolConfiguration;
    @JsonProperty(value="preferredIPVersion")
    private IpVersion preferredIpVersion;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityParameters.class);

    public ConnectivitySource source() {
        return this.source;
    }

    public ConnectivityParameters withSource(ConnectivitySource source) {
        this.source = source;
        return this;
    }

    public ConnectivityDestination destination() {
        return this.destination;
    }

    public ConnectivityParameters withDestination(ConnectivityDestination destination) {
        this.destination = destination;
        return this;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public ConnectivityParameters withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public ConnectivityParameters withProtocolConfiguration(ProtocolConfiguration protocolConfiguration) {
        this.protocolConfiguration = protocolConfiguration;
        return this;
    }

    public IpVersion preferredIpVersion() {
        return this.preferredIpVersion;
    }

    public ConnectivityParameters withPreferredIpVersion(IpVersion preferredIpVersion) {
        this.preferredIpVersion = preferredIpVersion;
        return this;
    }

    public void validate() {
        if (this.source() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property source in model ConnectivityParameters"));
        }
        this.source().validate();
        if (this.destination() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property destination in model ConnectivityParameters"));
        }
        this.destination().validate();
        if (this.protocolConfiguration() != null) {
            this.protocolConfiguration().validate();
        }
    }
}

