/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.runnable;

import com.google.common.base.Preconditions;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowPauseLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.lifecycle.event.WorkflowStopLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.workflow.listener.IWorkflowLifecycleListener;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.WorkflowExecutionRunnableBuilder;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecutionRunnable
implements IWorkflowExecutionRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecutionRunnable.class);
    private final IWorkflowExecuteContext workflowExecuteContext;
    private final List<IWorkflowLifecycleListener> workflowInstanceLifecycleListeners;

    public WorkflowExecutionRunnable(WorkflowExecutionRunnableBuilder workflowExecutionRunnableBuilder) {
        this.workflowExecuteContext = workflowExecutionRunnableBuilder.getWorkflowExecuteContextBuilder().build();
        this.workflowInstanceLifecycleListeners = this.workflowExecuteContext.getWorkflowInstanceLifecycleListeners();
    }

    @Override
    public void pause() {
        this.getWorkflowEventBus().publish(WorkflowPauseLifecycleEvent.of(this));
    }

    @Override
    public void stop() {
        this.getWorkflowEventBus().publish(WorkflowStopLifecycleEvent.of(this));
    }

    @Override
    public List<IWorkflowLifecycleListener> getWorkflowLifecycleListeners() {
        return this.workflowInstanceLifecycleListeners;
    }

    @Override
    public void registerWorkflowInstanceLifecycleListener(IWorkflowLifecycleListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"listener cannot be null");
        this.workflowInstanceLifecycleListeners.add(listener);
    }

    public String toString() {
        WorkflowInstance workflowInstance = this.workflowExecuteContext.getWorkflowInstance();
        return "WorkflowExecutionRunnable{name=" + workflowInstance.getName() + ", state=" + workflowInstance.getState().name() + '}';
    }

    @Override
    @Generated
    public IWorkflowExecuteContext getWorkflowExecuteContext() {
        return this.workflowExecuteContext;
    }

    @Generated
    public List<IWorkflowLifecycleListener> getWorkflowInstanceLifecycleListeners() {
        return this.workflowInstanceLifecycleListeners;
    }
}

