/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.ComparisonOperationType;
import com.azure.resourcemanager.monitor.models.MetricStatisticType;
import com.azure.resourcemanager.monitor.models.ScaleRuleMetricDimension;
import com.azure.resourcemanager.monitor.models.TimeAggregationType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

public final class MetricTrigger {
    @JsonProperty(value="metricName", required=true)
    private String metricName;
    @JsonProperty(value="metricNamespace")
    private String metricNamespace;
    @JsonProperty(value="metricResourceUri", required=true)
    private String metricResourceUri;
    @JsonProperty(value="metricResourceLocation")
    private String metricResourceLocation;
    @JsonProperty(value="timeGrain", required=true)
    private Duration timeGrain;
    @JsonProperty(value="statistic", required=true)
    private MetricStatisticType statistic;
    @JsonProperty(value="timeWindow", required=true)
    private Duration timeWindow;
    @JsonProperty(value="timeAggregation", required=true)
    private TimeAggregationType timeAggregation;
    @JsonProperty(value="operator", required=true)
    private ComparisonOperationType operator;
    @JsonProperty(value="threshold", required=true)
    private double threshold;
    @JsonProperty(value="dimensions")
    private List<ScaleRuleMetricDimension> dimensions;
    @JsonProperty(value="dividePerInstance")
    private Boolean dividePerInstance;
    private static final ClientLogger LOGGER = new ClientLogger(MetricTrigger.class);

    public String metricName() {
        return this.metricName;
    }

    public MetricTrigger withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public MetricTrigger withMetricNamespace(String metricNamespace) {
        this.metricNamespace = metricNamespace;
        return this;
    }

    public String metricResourceUri() {
        return this.metricResourceUri;
    }

    public MetricTrigger withMetricResourceUri(String metricResourceUri) {
        this.metricResourceUri = metricResourceUri;
        return this;
    }

    public String metricResourceLocation() {
        return this.metricResourceLocation;
    }

    public MetricTrigger withMetricResourceLocation(String metricResourceLocation) {
        this.metricResourceLocation = metricResourceLocation;
        return this;
    }

    public Duration timeGrain() {
        return this.timeGrain;
    }

    public MetricTrigger withTimeGrain(Duration timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    public MetricStatisticType statistic() {
        return this.statistic;
    }

    public MetricTrigger withStatistic(MetricStatisticType statistic) {
        this.statistic = statistic;
        return this;
    }

    public Duration timeWindow() {
        return this.timeWindow;
    }

    public MetricTrigger withTimeWindow(Duration timeWindow) {
        this.timeWindow = timeWindow;
        return this;
    }

    public TimeAggregationType timeAggregation() {
        return this.timeAggregation;
    }

    public MetricTrigger withTimeAggregation(TimeAggregationType timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    public ComparisonOperationType operator() {
        return this.operator;
    }

    public MetricTrigger withOperator(ComparisonOperationType operator) {
        this.operator = operator;
        return this;
    }

    public double threshold() {
        return this.threshold;
    }

    public MetricTrigger withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public List<ScaleRuleMetricDimension> dimensions() {
        return this.dimensions;
    }

    public MetricTrigger withDimensions(List<ScaleRuleMetricDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Boolean dividePerInstance() {
        return this.dividePerInstance;
    }

    public MetricTrigger withDividePerInstance(Boolean dividePerInstance) {
        this.dividePerInstance = dividePerInstance;
        return this;
    }

    public void validate() {
        if (this.metricName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property metricName in model MetricTrigger"));
        }
        if (this.metricResourceUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property metricResourceUri in model MetricTrigger"));
        }
        if (this.timeGrain() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timeGrain in model MetricTrigger"));
        }
        if (this.statistic() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property statistic in model MetricTrigger"));
        }
        if (this.timeWindow() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timeWindow in model MetricTrigger"));
        }
        if (this.timeAggregation() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property timeAggregation in model MetricTrigger"));
        }
        if (this.operator() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operator in model MetricTrigger"));
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }
}

