/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.sql.fluent.models.DatabaseProperties;
import com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.azure.resourcemanager.sql.models.CreateMode;
import com.azure.resourcemanager.sql.models.DatabaseLicenseType;
import com.azure.resourcemanager.sql.models.DatabaseReadScale;
import com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.azure.resourcemanager.sql.models.SampleName;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class DatabaseInner
extends Resource {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private String kind;
    @JsonProperty(value="managedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String managedBy;
    @JsonProperty(value="properties")
    private DatabaseProperties innerProperties;

    public Sku sku() {
        return this.sku;
    }

    public DatabaseInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public String managedBy() {
        return this.managedBy;
    }

    private DatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    public DatabaseInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DatabaseInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public DatabaseInner withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    public DatabaseInner withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    public DatabaseInner withMaxSizeBytes(Long maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public SampleName sampleName() {
        return this.innerProperties() == null ? null : this.innerProperties().sampleName();
    }

    public DatabaseInner withSampleName(SampleName sampleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSampleName(sampleName);
        return this;
    }

    public String elasticPoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolId();
    }

    public DatabaseInner withElasticPoolId(String elasticPoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withElasticPoolId(elasticPoolId);
        return this;
    }

    public String sourceDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseId();
    }

    public DatabaseInner withSourceDatabaseId(String sourceDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    public DatabaseStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public UUID databaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseId();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public String currentServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().currentServiceObjectiveName();
    }

    public String requestedServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedServiceObjectiveName();
    }

    public String defaultSecondaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecondaryLocation();
    }

    public String failoverGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().failoverGroupId();
    }

    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    public DatabaseInner withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseDeletionDate();
    }

    public DatabaseInner withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withSourceDatabaseDeletionDate(sourceDatabaseDeletionDate);
        return this;
    }

    public String recoveryServicesRecoveryPointId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoveryServicesRecoveryPointId();
    }

    public DatabaseInner withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRecoveryServicesRecoveryPointId(recoveryServicesRecoveryPointId);
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().longTermRetentionBackupResourceId();
    }

    public DatabaseInner withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withLongTermRetentionBackupResourceId(longTermRetentionBackupResourceId);
        return this;
    }

    public String recoverableDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverableDatabaseId();
    }

    public DatabaseInner withRecoverableDatabaseId(String recoverableDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRecoverableDatabaseId(recoverableDatabaseId);
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableDroppedDatabaseId();
    }

    public DatabaseInner withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withRestorableDroppedDatabaseId(restorableDroppedDatabaseId);
        return this;
    }

    public CatalogCollationType catalogCollation() {
        return this.innerProperties() == null ? null : this.innerProperties().catalogCollation();
    }

    public DatabaseInner withCatalogCollation(CatalogCollationType catalogCollation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withCatalogCollation(catalogCollation);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public DatabaseInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public DatabaseLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public DatabaseInner withLicenseType(DatabaseLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public Long maxLogSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxLogSizeBytes();
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    public DatabaseReadScale readScale() {
        return this.innerProperties() == null ? null : this.innerProperties().readScale();
    }

    public DatabaseInner withReadScale(DatabaseReadScale readScale) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withReadScale(readScale);
        return this;
    }

    public Integer readReplicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().readReplicaCount();
    }

    public DatabaseInner withReadReplicaCount(Integer readReplicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withReadReplicaCount(readReplicaCount);
        return this;
    }

    public Sku currentSku() {
        return this.innerProperties() == null ? null : this.innerProperties().currentSku();
    }

    public Integer autoPauseDelay() {
        return this.innerProperties() == null ? null : this.innerProperties().autoPauseDelay();
    }

    public DatabaseInner withAutoPauseDelay(Integer autoPauseDelay) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withAutoPauseDelay(autoPauseDelay);
        return this;
    }

    public Double minCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().minCapacity();
    }

    public DatabaseInner withMinCapacity(Double minCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseProperties();
        }
        this.innerProperties().withMinCapacity(minCapacity);
        return this;
    }

    public OffsetDateTime pausedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().pausedDate();
    }

    public OffsetDateTime resumedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().resumedDate();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

