/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerinstance.fluent.ContainersClient;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerAttachResponseInner;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerExecResponseInner;
import com.azure.resourcemanager.containerinstance.fluent.models.LogsInner;
import com.azure.resourcemanager.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.azure.resourcemanager.containerinstance.models.ContainerExecRequest;
import reactor.core.publisher.Mono;

public final class ContainersClientImpl
implements ContainersClient {
    private final ContainersService service;
    private final ContainerInstanceManagementClientImpl client;

    ContainersClientImpl(ContainerInstanceManagementClientImpl client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LogsInner>> listLogsWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLogs(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, tail, timestamps, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LogsInner>> listLogsWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listLogs(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, tail, timestamps, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps) {
        return this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LogsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName) {
        Integer tail = null;
        Boolean timestamps = null;
        return this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LogsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogsInner listLogs(String resourceGroupName, String containerGroupName, String containerName) {
        Integer tail = null;
        Boolean timestamps = null;
        return (LogsInner)this.listLogsAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogsInner> listLogsWithResponse(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps, Context context) {
        return (Response)this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        }
        containerExecRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, containerExecRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        }
        containerExecRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, containerExecRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerExecResponseInner> executeCommandAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return this.executeCommandWithResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ContainerExecResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerExecResponseInner executeCommand(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return (ContainerExecResponseInner)this.executeCommandAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerExecResponseInner> executeCommandWithResponse(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest, Context context) {
        return (Response)this.executeCommandWithResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContainerAttachResponseInner>> attachWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.attach(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ContainerAttachResponseInner>> attachWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.attach(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainerAttachResponseInner> attachAsync(String resourceGroupName, String containerGroupName, String containerName) {
        return this.attachWithResponseAsync(resourceGroupName, containerGroupName, containerName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ContainerAttachResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContainerAttachResponseInner attach(String resourceGroupName, String containerGroupName, String containerName) {
        return (ContainerAttachResponseInner)this.attachAsync(resourceGroupName, containerGroupName, containerName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContainerAttachResponseInner> attachWithResponse(String resourceGroupName, String containerGroupName, String containerName, Context context) {
        return (Response)this.attachWithResponseAsync(resourceGroupName, containerGroupName, containerName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerInstanceMan")
    private static interface ContainersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/logs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogsInner>> listLogs(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="tail") Integer var7, @QueryParam(value="timestamps") Boolean var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ContainerExecResponseInner>> executeCommand(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @BodyParam(value="application/json") ContainerExecRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/attach")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ContainerAttachResponseInner>> attach(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

