/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HdfsAuthenticationType {
    SIMPLE("SIMPLE"),
    KERBEROS("KERBEROS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HdfsAuthenticationType> VALUE_MAP;
    private final String value;

    private HdfsAuthenticationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HdfsAuthenticationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HdfsAuthenticationType> knownValues() {
        EnumSet<HdfsAuthenticationType> knownValues = EnumSet.allOf(HdfsAuthenticationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HdfsAuthenticationType.class, HdfsAuthenticationType::toString);
    }
}

