/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.DocHtmlRequest;
import com.qcloud.cos.model.ciModel.job.DocJobDetail;
import com.qcloud.cos.model.ciModel.job.DocJobListRequest;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobObject;
import com.qcloud.cos.model.ciModel.job.DocJobRequest;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.DocProcessObject;
import java.net.URISyntaxException;

public class DocJobDemo {
    public static void main(String[] args) {
        COSClient client = ClientUtils.getTestClient();
        DocJobDemo.createDocJobs(client);
    }

    public static void createDocJobs(COSClient client) {
        DocJobRequest request = new DocJobRequest();
        request.setBucketName("examplebucket-1250000000");
        DocJobObject docJobObject = request.getDocJobObject();
        docJobObject.setTag("DocProcess");
        docJobObject.getInput().setObject("demo.docx");
        DocProcessObject docProcessObject = docJobObject.getOperation().getDocProcessObject();
        docProcessObject.setQuality("100");
        docProcessObject.setZoom("100");
        docProcessObject.setStartPage("1");
        docProcessObject.setEndPage("3");
        docProcessObject.setTgtType("png");
        docProcessObject.setDocPassword("123");
        MediaOutputObject output = docJobObject.getOperation().getOutput();
        output.setRegion("ap-chongqing");
        output.setBucket("examplebucket-1250000000");
        output.setObject("mark/pic-${Page}.jpg");
        DocJobResponse docProcessJobs = client.createDocProcessJobs(request);
        System.out.println(docProcessJobs);
    }

    public static void describeDocProcessJob(COSClient client) {
        DocJobRequest request = new DocJobRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setJobId("d75b6ea083df711eb8d09476dfb8*****");
        DocJobResponse docJobResponse = client.describeDocProcessJob(request);
        System.out.println(docJobResponse);
    }

    public static void describeDocProcessJobs(COSClient client) {
        DocJobListRequest request = new DocJobListRequest();
        request.setBucketName("examplebucket-1250000000");
        request.setTag("DocProcess");
        request.setStartCreationTime("2020-12-10T16:20:07+0800");
        DocJobListResponse docJobResponse = client.describeDocProcessJobs(request);
        for (DocJobDetail jobDetail : docJobResponse.getDocJobDetailList()) {
            System.out.println(jobDetail);
        }
    }

    public static void generateDocPreviewUrl(COSClient client) throws URISyntaxException {
        DocHtmlRequest request = new DocHtmlRequest();
        request.setBucketName("demo-123456789");
        request.setDstType(DocHtmlRequest.DocType.html);
        request.setObjectKey("1.pptx");
        String previewUrl = client.generateDocPreviewUrl(request);
        System.out.println(previewUrl);
    }

    public static void processDocJob(COSClient client) throws InterruptedException {
        DocJobResponse docJobResponse;
        String bucketName = "demo-123456789";
        DocJobRequest request = new DocJobRequest();
        request.setBucketName(bucketName);
        DocJobObject docJobObject = request.getDocJobObject();
        docJobObject.setTag("DocProcess");
        docJobObject.getInput().setObject("1.pdf");
        DocProcessObject docProcessObject = docJobObject.getOperation().getDocProcessObject();
        docProcessObject.setQuality("100");
        docProcessObject.setZoom("100");
        docProcessObject.setEndPage("-1");
        docProcessObject.setTgtType("jpg");
        MediaOutputObject output = docJobObject.getOperation().getOutput();
        output.setRegion(client.getClientConfig().getRegion().getRegionName());
        output.setBucket(bucketName);
        output.setObject("demo/pic-${Number}.jpg");
        DocJobResponse docProcessJobs = client.createDocProcessJobs(request);
        DocJobRequest docJobRequest = new DocJobRequest();
        docJobRequest.setBucketName(bucketName);
        String jobId = docProcessJobs.getJobsDetail().getJobId();
        docJobRequest.setJobId(jobId);
        while (true) {
            String state;
            if ("Success".equalsIgnoreCase(state = (docJobResponse = client.describeDocProcessJob(docJobRequest)).getJobsDetail().getState()) || "Failed".equalsIgnoreCase(state)) break;
            Thread.sleep(500L);
        }
        System.out.println(docJobResponse);
    }
}

