/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.models.CaptureDescription;
import com.azure.resourcemanager.eventhubs.models.EntityStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class EventhubProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EventhubProperties.class);
    @JsonProperty(value="partitionIds", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> partitionIds;
    @JsonProperty(value="createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="messageRetentionInDays")
    private Long messageRetentionInDays;
    @JsonProperty(value="partitionCount")
    private Long partitionCount;
    @JsonProperty(value="status")
    private EntityStatus status;
    @JsonProperty(value="captureDescription")
    private CaptureDescription captureDescription;

    public List<String> partitionIds() {
        return this.partitionIds;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public Long messageRetentionInDays() {
        return this.messageRetentionInDays;
    }

    public EventhubProperties withMessageRetentionInDays(Long messageRetentionInDays) {
        this.messageRetentionInDays = messageRetentionInDays;
        return this;
    }

    public Long partitionCount() {
        return this.partitionCount;
    }

    public EventhubProperties withPartitionCount(Long partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public EventhubProperties withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public CaptureDescription captureDescription() {
        return this.captureDescription;
    }

    public EventhubProperties withCaptureDescription(CaptureDescription captureDescription) {
        this.captureDescription = captureDescription;
        return this;
    }

    public void validate() {
        if (this.captureDescription() != null) {
            this.captureDescription().validate();
        }
    }
}

