/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.ServiceRegistryResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.implementation.Utils;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.SpringServiceRegistry;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class SpringServiceRegistryImpl
extends ExternalChildResourceImpl<SpringServiceRegistry, ServiceRegistryResourceInner, SpringServiceImpl, SpringService>
implements SpringServiceRegistry {
    protected SpringServiceRegistryImpl(String name, SpringServiceImpl parent, ServiceRegistryResourceInner innerObject) {
        super(name, (Object)parent, (Object)innerObject);
    }

    @Override
    public Double cpu() {
        return Utils.fromCpuString(((ServiceRegistryResourceInner)((Object)this.innerModel())).properties().resourceRequests().cpu());
    }

    @Override
    public Double memory() {
        return Utils.fromMemoryString(((ServiceRegistryResourceInner)((Object)this.innerModel())).properties().resourceRequests().memory());
    }

    @Override
    public List<SpringApp> getAppBindings() {
        return ((SpringServiceImpl)this.parent()).apps().list().stream().filter(SpringApp::hasServiceRegistryBinding).collect(Collectors.toList());
    }

    public String id() {
        return ((ServiceRegistryResourceInner)((Object)this.innerModel())).id();
    }

    public Mono<SpringServiceRegistry> createResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getServiceRegistries().createOrUpdateAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name()).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public Mono<SpringServiceRegistry> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getServiceRegistries().deleteAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    protected Mono<ServiceRegistryResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getServiceRegistries().getAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    private AppPlatformManager manager() {
        return (AppPlatformManager)((SpringServiceImpl)this.parent()).manager();
    }
}

