/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.PortForward;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.KubectlExec;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class KubectlPortForward
extends Kubectl.ResourceAndContainerBuilder<V1Pod, KubectlPortForward>
implements Kubectl.Executable<Boolean> {
    List<Integer> localPorts = new ArrayList<Integer>();
    List<Integer> targetPorts = new ArrayList<Integer>();
    boolean running;

    KubectlPortForward() {
        super(V1Pod.class);
    }

    public KubectlPortForward ports(int localPort, int targetPort) {
        this.localPorts.add(localPort);
        this.targetPorts.add(targetPort);
        return this;
    }

    @Override
    public Boolean execute() throws KubectlException {
        this.running = true;
        try {
            this.executeInternal();
            return true;
        }
        catch (ApiException | IOException | InterruptedException ex) {
            throw new KubectlException(ex);
        }
    }

    public void shutdown() {
        this.running = false;
    }

    private void executeInternal() throws ApiException, KubectlException, IOException, InterruptedException {
        PortForward pf = new PortForward(this.apiClient);
        PortForward.PortForwardResult result = pf.forward(this.namespace, this.name, this.targetPorts);
        if (result == null) {
            throw new KubectlException("PortForward failed!");
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < this.localPorts.size(); ++i) {
            int targetPort = this.targetPorts.get(i);
            threads.add(this.portForward(new ServerSocket(this.localPorts.get(i)), result.getInputStream(targetPort), result.getOutboundStream(targetPort)));
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    private Thread portForward(final ServerSocket server, final InputStream in, final OutputStream out) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (KubectlPortForward.this.running) {
                    try {
                        Socket sock = server.accept();
                        Thread t1 = KubectlExec.copyAsync(sock.getInputStream(), out);
                        Thread t2 = KubectlExec.copyAsync(in, sock.getOutputStream());
                        t1.join();
                        t2.join();
                    }
                    catch (IOException | InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        t.start();
        return t;
    }
}

