/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CommunityGalleryImageVersionsClient;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryImageVersionInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.CommunityGalleryImageVersionList;
import reactor.core.publisher.Mono;

public final class CommunityGalleryImageVersionsClientImpl
implements CommunityGalleryImageVersionsClient {
    private final CommunityGalleryImageVersionsService service;
    private final ComputeManagementClientImpl client;

    CommunityGalleryImageVersionsClientImpl(ComputeManagementClientImpl client) {
        this.service = (CommunityGalleryImageVersionsService)RestProxy.create(CommunityGalleryImageVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunityGalleryImageVersionInner>> getWithResponseAsync(String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publicGalleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicGalleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        String apiVersion = "2022-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2022-03-03", publicGalleryName, galleryImageName, galleryImageVersionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CommunityGalleryImageVersionInner>> getWithResponseAsync(String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publicGalleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicGalleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        if (galleryImageVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null."));
        }
        String apiVersion = "2022-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2022-03-03", publicGalleryName, galleryImageName, galleryImageVersionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunityGalleryImageVersionInner> getAsync(String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName) {
        return this.getWithResponseAsync(location, publicGalleryName, galleryImageName, galleryImageVersionName).flatMap(res -> Mono.justOrEmpty((Object)((CommunityGalleryImageVersionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunityGalleryImageVersionInner> getWithResponse(String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName, Context context) {
        return (Response)this.getWithResponseAsync(location, publicGalleryName, galleryImageName, galleryImageVersionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunityGalleryImageVersionInner get(String location, String publicGalleryName, String galleryImageName, String galleryImageVersionName) {
        return (CommunityGalleryImageVersionInner)this.getWithResponse(location, publicGalleryName, galleryImageName, galleryImageVersionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CommunityGalleryImageVersionInner>> listSinglePageAsync(String location, String publicGalleryName, String galleryImageName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publicGalleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicGalleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        String apiVersion = "2022-03-03";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2022-03-03", publicGalleryName, galleryImageName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CommunityGalleryImageVersionList)res.getValue()).value(), ((CommunityGalleryImageVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CommunityGalleryImageVersionInner>> listSinglePageAsync(String location, String publicGalleryName, String galleryImageName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publicGalleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicGalleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        String apiVersion = "2022-03-03";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2022-03-03", publicGalleryName, galleryImageName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CommunityGalleryImageVersionList)res.getValue()).value(), ((CommunityGalleryImageVersionList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CommunityGalleryImageVersionInner> listAsync(String location, String publicGalleryName, String galleryImageName) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, publicGalleryName, galleryImageName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CommunityGalleryImageVersionInner> listAsync(String location, String publicGalleryName, String galleryImageName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, publicGalleryName, galleryImageName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CommunityGalleryImageVersionInner> list(String location, String publicGalleryName, String galleryImageName) {
        return new PagedIterable(this.listAsync(location, publicGalleryName, galleryImageName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CommunityGalleryImageVersionInner> list(String location, String publicGalleryName, String galleryImageName, Context context) {
        return new PagedIterable(this.listAsync(location, publicGalleryName, galleryImageName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CommunityGalleryImageVersionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CommunityGalleryImageVersionList)res.getValue()).value(), ((CommunityGalleryImageVersionList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CommunityGalleryImageVersionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CommunityGalleryImageVersionList)res.getValue()).value(), ((CommunityGalleryImageVersionList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface CommunityGalleryImageVersionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/communityGalleries/{publicGalleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CommunityGalleryImageVersionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="publicGalleryName") String var5, @PathParam(value="galleryImageName") String var6, @PathParam(value="galleryImageVersionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/communityGalleries/{publicGalleryName}/images/{galleryImageName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CommunityGalleryImageVersionList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="publicGalleryName") String var5, @PathParam(value="galleryImageName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CommunityGalleryImageVersionList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

