/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr4.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class FastQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int p = 0;
    protected int range = -1;

    public void reset() {
        this.clear();
    }

    public void clear() {
        this.p = 0;
        this.data.clear();
    }

    public T remove() {
        T o = this.elementAt(0);
        ++this.p;
        if (this.p == this.data.size()) {
            this.clear();
        }
        return o;
    }

    public void add(T o) {
        this.data.add(o);
    }

    public int size() {
        return this.data.size() - this.p;
    }

    public int range() {
        return this.range;
    }

    public T head() {
        return this.elementAt(0);
    }

    public T elementAt(int i2) {
        int absIndex = this.p + i2;
        if (absIndex >= this.data.size()) {
            throw new NoSuchElementException("queue index " + absIndex + " > last index " + (this.data.size() - 1));
        }
        if (absIndex < 0) {
            throw new NoSuchElementException("queue index " + absIndex + " < 0");
        }
        if (absIndex > this.range) {
            this.range = absIndex;
        }
        return this.data.get(absIndex);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            buf.append(this.elementAt(i2));
            if (i2 + 1 >= n) continue;
            buf.append(" ");
        }
        return buf.toString();
    }
}

