/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.database.DatabaseDriverFeature;
import org.grails.forge.feature.database.HibernateGorm;
import org.grails.forge.feature.database.TestContainers;

@Singleton
public class PostgreSQL
extends DatabaseDriverFeature {
    public PostgreSQL(HibernateGorm hibernateGorm, TestContainers testContainers) {
        super(hibernateGorm, testContainers);
    }

    @Override
    @NonNull
    public String getName() {
        return "postgres";
    }

    @Override
    public String getTitle() {
        return "PostgresSQL";
    }

    @Override
    public String getDescription() {
        return "Add PostgresSQL driver and default configuration.";
    }

    @Override
    public String getJdbcDevUrl() {
        return "jdbc:postgresql://localhost:5432/devDb?tcpKeepAlive=true";
    }

    @Override
    public String getJdbcTestUrl() {
        return "jdbc:postgresql://localhost:5432/testDb?tcpKeepAlive=true";
    }

    @Override
    public String getJdbcProdUrl() {
        return "jdbc:postgresql://localhost:5432/postgres?tcpKeepAlive=true";
    }

    @Override
    public String getDriverClass() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getDefaultUser() {
        return "postgres";
    }

    @Override
    public String getDefaultPassword() {
        return "";
    }

    @Override
    public String getDataDialect() {
        return "POSTGRES";
    }

    @Override
    public boolean embedded() {
        return false;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(Dependency.builder().groupId("org.postgresql").artifactId("postgresql").runtimeOnly());
    }
}

