/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class Bindable<T> {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final EnumSet<BindRestriction> NO_BIND_RESTRICTIONS = EnumSet.noneOf(BindRestriction.class);
    private final ResolvableType type;
    private final ResolvableType boxedType;
    private final Supplier<T> value;
    private final Annotation[] annotations;
    private final EnumSet<BindRestriction> bindRestrictions;
    private final BindMethod bindMethod;

    private Bindable(ResolvableType type, ResolvableType boxedType, Supplier<T> value, Annotation[] annotations, EnumSet<BindRestriction> bindRestrictions, BindMethod bindMethod) {
        this.type = type;
        this.boxedType = boxedType;
        this.value = value;
        this.annotations = annotations;
        this.bindRestrictions = bindRestrictions;
        this.bindMethod = bindMethod;
    }

    public ResolvableType getType() {
        return this.type;
    }

    public ResolvableType getBoxedType() {
        return this.boxedType;
    }

    public Supplier<T> getValue() {
        return this.value;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        for (Annotation annotation : this.annotations) {
            if (!type.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    public boolean hasBindRestriction(BindRestriction bindRestriction) {
        return this.bindRestrictions.contains((Object)bindRestriction);
    }

    public BindMethod getBindMethod() {
        return this.bindMethod;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Bindable other = (Bindable)obj;
        boolean result = true;
        result = result && this.nullSafeEquals(this.type.resolve(), other.type.resolve());
        result = result && this.nullSafeEquals(this.annotations, other.annotations);
        result = result && this.nullSafeEquals(this.bindRestrictions, other.bindRestrictions);
        result = result && this.nullSafeEquals((Object)this.bindMethod, (Object)other.bindMethod);
        return result;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(new Object[]{this.type, this.annotations, this.bindRestrictions, this.bindMethod});
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator(this);
        creator.append("type", this.type);
        creator.append("value", this.value != null ? "provided" : "none");
        creator.append("annotations", this.annotations);
        creator.append("bindMethod", (Object)this.bindMethod);
        return creator.toString();
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        return ObjectUtils.nullSafeEquals(o1, o2);
    }

    public Bindable<T> withAnnotations(Annotation ... annotations) {
        return new Bindable<T>(this.type, this.boxedType, this.value, annotations != null ? annotations : NO_ANNOTATIONS, NO_BIND_RESTRICTIONS, this.bindMethod);
    }

    public Bindable<T> withExistingValue(T existingValue) {
        Assert.isTrue(existingValue == null || this.type.isArray() || this.boxedType.resolve().isInstance(existingValue), () -> "'existingValue' must be an instance of " + String.valueOf(this.type));
        Assert.state(this.bindMethod != BindMethod.VALUE_OBJECT, () -> "An existing value cannot be provided when binding as a value object");
        Supplier<Object> value = existingValue != null ? () -> existingValue : null;
        return new Bindable<Object>(this.type, this.boxedType, value, this.annotations, this.bindRestrictions, BindMethod.JAVA_BEAN);
    }

    public Bindable<T> withSuppliedValue(Supplier<T> suppliedValue) {
        return new Bindable<T>(this.type, this.boxedType, suppliedValue, this.annotations, this.bindRestrictions, this.bindMethod);
    }

    public Bindable<T> withBindRestrictions(BindRestriction ... additionalRestrictions) {
        EnumSet<BindRestriction> bindRestrictions = EnumSet.copyOf(this.bindRestrictions);
        bindRestrictions.addAll(Arrays.asList(additionalRestrictions));
        return new Bindable<T>(this.type, this.boxedType, this.value, this.annotations, bindRestrictions, this.bindMethod);
    }

    public Bindable<T> withBindMethod(BindMethod bindMethod) {
        Assert.state(bindMethod != BindMethod.VALUE_OBJECT || this.value == null, () -> "Value object binding cannot be used with an existing or supplied value");
        return new Bindable<T>(this.type, this.boxedType, this.value, this.annotations, this.bindRestrictions, bindMethod);
    }

    public static <T> Bindable<T> ofInstance(T instance) {
        Assert.notNull(instance, "'instance' must not be null");
        Class<?> type = instance.getClass();
        return Bindable.of(type).withExistingValue(instance);
    }

    public static <T> Bindable<T> of(Class<T> type) {
        Assert.notNull(type, "'type' must not be null");
        return Bindable.of(ResolvableType.forClass(type));
    }

    public static <E> Bindable<List<E>> listOf(Class<E> elementType) {
        return Bindable.of(ResolvableType.forClassWithGenerics(List.class, elementType));
    }

    public static <E> Bindable<Set<E>> setOf(Class<E> elementType) {
        return Bindable.of(ResolvableType.forClassWithGenerics(Set.class, elementType));
    }

    public static <K, V> Bindable<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return Bindable.of(ResolvableType.forClassWithGenerics(Map.class, keyType, valueType));
    }

    public static <T> Bindable<T> of(ResolvableType type) {
        Assert.notNull((Object)type, "'type' must not be null");
        ResolvableType boxedType = Bindable.box(type);
        return new Bindable<T>(type, boxedType, null, NO_ANNOTATIONS, NO_BIND_RESTRICTIONS, null);
    }

    private static ResolvableType box(ResolvableType type) {
        Class<?> resolved = type.resolve();
        if (resolved != null && resolved.isPrimitive()) {
            Object array = Array.newInstance(resolved, 1);
            Class<?> wrapperType = Array.get(array, 0).getClass();
            return ResolvableType.forClass(wrapperType);
        }
        if (resolved != null && resolved.isArray()) {
            return ResolvableType.forArrayComponent(Bindable.box(type.getComponentType()));
        }
        return type;
    }

    public static enum BindRestriction {
        NO_DIRECT_PROPERTY;

    }
}

