/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestMultiVersionConcurrencyControl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiVersionConcurrencyControl.class);

    @Test
    public void testParallelism() throws Exception {
        int i;
        final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        final AtomicBoolean finished = new AtomicBoolean(false);
        final AtomicBoolean readerFailed = new AtomicBoolean(false);
        final AtomicLong failedAt = new AtomicLong();
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                long prev = mvcc.getReadPoint();
                while (!finished.get()) {
                    long newPrev = mvcc.getReadPoint();
                    if (newPrev >= prev) continue;
                    System.out.println("Reader got out of order, prev: " + prev + " next was: " + newPrev);
                    readerFailed.set(true);
                    failedAt.set(newPrev);
                    return;
                }
            }
        };
        int n = 20;
        Thread[] writers = new Thread[n];
        AtomicBoolean[] statuses = new AtomicBoolean[n];
        Thread readThread = new Thread(reader);
        for (int i2 = 0; i2 < n; ++i2) {
            statuses[i2] = new AtomicBoolean(true);
            writers[i2] = new Thread(new Writer(finished, mvcc, statuses[i2]));
            writers[i2].start();
        }
        readThread.start();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        finished.set(true);
        readThread.join();
        for (i = 0; i < n; ++i) {
            writers[i].join();
        }
        Assert.assertFalse((boolean)readerFailed.get());
        for (i = 0; i < n; ++i) {
            Assert.assertTrue((boolean)statuses[i].get());
        }
    }

    static class Writer
    implements Runnable {
        final AtomicBoolean finished;
        final MultiVersionConcurrencyControl mvcc;
        final AtomicBoolean status;
        public boolean failed = false;

        Writer(AtomicBoolean finished, MultiVersionConcurrencyControl mvcc, AtomicBoolean status) {
            this.finished = finished;
            this.mvcc = mvcc;
            this.status = status;
        }

        @Override
        public void run() {
            while (!this.finished.get()) {
                MultiVersionConcurrencyControl.WriteEntry e = this.mvcc.begin();
                int sleepTime = ThreadLocalRandom.current().nextInt(500);
                try {
                    if (sleepTime > 0) {
                        Thread.sleep(0L, sleepTime * 1000);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.mvcc.completeAndWait(e);
                }
                catch (RuntimeException ex) {
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                    this.status.set(false);
                    return;
                }
            }
        }
    }
}

