/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParticipantStateCache<T>
extends AbstractDataCache {
    private static Logger LOG = LoggerFactory.getLogger(ParticipantStateCache.class);
    protected Map<String, Map<String, Map<String, T>>> _participantStateMap;
    protected Map<PropertyKey, T> _participantStateCache = Maps.newHashMap();

    public ParticipantStateCache(ControlContextProvider controlContextProvider) {
        super(controlContextProvider);
        this._participantStateMap = new HashMap<String, Map<String, Map<String, T>>>();
    }

    public boolean refresh(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        long startTime = System.currentTimeMillis();
        this.refreshParticipantStatesCacheFromZk(accessor, liveInstanceMap);
        HashMap<String, Map> allParticipantStateMap = new HashMap<String, Map>();
        for (PropertyKey key : this._participantStateCache.keySet()) {
            T participantState = this._participantStateCache.get(key);
            String[] params = key.getParams();
            if (participantState != null && params.length >= 4) {
                Map customizedMap;
                String instanceName = params[1];
                String customizedName = params[2];
                String resourceName = params[3];
                Map instanceMap = (Map)allParticipantStateMap.get(instanceName);
                if (instanceMap == null) {
                    instanceMap = Maps.newHashMap();
                    allParticipantStateMap.put(instanceName, instanceMap);
                }
                if ((customizedMap = (Map)instanceMap.get(customizedName)) == null) {
                    customizedMap = Maps.newHashMap();
                    instanceMap.put(customizedName, customizedMap);
                }
                customizedMap.put(resourceName, participantState);
                continue;
            }
            LogUtil.logError(LOG, this.genEventInfo(), "Invalid key found in the participant state cache" + key);
        }
        this._participantStateMap = Collections.unmodifiableMap(allParticipantStateMap);
        long endTime = System.currentTimeMillis();
        LogUtil.logInfo(LOG, this.genEventInfo(), "END: participantStateCache.refresh() for cluster " + this._controlContextProvider.getClusterName() + ", started at : " + startTime + ", took " + (endTime - startTime) + " ms");
        if (LOG.isDebugEnabled()) {
            LogUtil.logDebug(LOG, this.genEventInfo(), String.format("Participant State refreshed : %s", this._participantStateMap.toString()));
        }
        return true;
    }

    private void refreshParticipantStatesCacheFromZk(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        long start = System.currentTimeMillis();
        Set<PropertyKey> participantStateKeys = this.PopulateParticipantKeys(accessor, liveInstanceMap);
        HashSet<PropertyKey> reloadKeys = new HashSet<PropertyKey>(participantStateKeys);
        reloadKeys.removeAll(this._participantStateCache.keySet());
        HashSet<PropertyKey> cachedKeys = new HashSet<PropertyKey>(this._participantStateCache.keySet());
        cachedKeys.retainAll(participantStateKeys);
        HashSet<PropertyKey> reloadedKeys = new HashSet<PropertyKey>();
        Map<PropertyKey, T> newStateCache = Collections.unmodifiableMap(this.refreshProperties(accessor, reloadKeys, new ArrayList<PropertyKey>(cachedKeys), this._participantStateCache, reloadedKeys));
        this.refreshSnapshot(newStateCache, this._participantStateCache, reloadedKeys);
        this._participantStateCache = newStateCache;
        if (LOG.isDebugEnabled()) {
            LogUtil.logDebug(LOG, this.genEventInfo(), "# of participant state reload: " + reloadKeys.size() + ", skipped:" + (participantStateKeys.size() - reloadKeys.size()) + ". took " + (System.currentTimeMillis() - start) + " ms to reload new participant states for cluster: " + this._controlContextProvider.getClusterName() + "and state: " + this.getClass().getName());
        }
    }

    protected abstract Set<PropertyKey> PopulateParticipantKeys(HelixDataAccessor var1, Map<String, LiveInstance> var2);

    protected void refreshSnapshot(Map<PropertyKey, T> newStateCache, Map<PropertyKey, T> participantStateCache, Set<PropertyKey> reloadedKeys) {
    }

    public Map<String, Map<String, Map<String, T>>> getParticipantStatesMap() {
        return Collections.unmodifiableMap(this._participantStateMap);
    }

    public Map<String, Map<String, T>> getParticipantStates(String instanceName) {
        if (!this._participantStateMap.containsKey(instanceName)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._participantStateMap.get(instanceName));
    }

    public Map<String, T> getParticipantState(String instanceName, String customizedKey) {
        if (!this._participantStateMap.containsKey(instanceName) || !this._participantStateMap.get(instanceName).containsKey(customizedKey)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._participantStateMap.get(instanceName).get(customizedKey));
    }
}

