/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage.serialization;

import org.apache.ignite3.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogMarshallerException;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.UpdateLogMarshaller;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.jetbrains.annotations.TestOnly;

public class UpdateLogMarshallerImpl
implements UpdateLogMarshaller {
    private static final int PROTOCOL_VERSION = 2;
    private final CatalogEntrySerializerProvider serializers;
    private final int protocolVersion;

    @TestOnly
    public UpdateLogMarshallerImpl(CatalogEntrySerializerProvider serializers) {
        this(serializers, 2);
    }

    public UpdateLogMarshallerImpl(int protocolVersion) {
        this(CatalogEntrySerializerProvider.DEFAULT_PROVIDER, protocolVersion);
    }

    public UpdateLogMarshallerImpl(CatalogEntrySerializerProvider serializers, int protocolVersion) {
        this.serializers = serializers;
        this.protocolVersion = protocolVersion;
    }

    @Override
    public byte[] marshall(UpdateLogEvent update) {
        byte[] byArray;
        CatalogObjectDataOutput output = new CatalogObjectDataOutput(this.serializers);
        try {
            output.writeShort(this.protocolVersion);
            if (this.protocolVersion == 1) {
                output.writeShort(update.typeId());
                this.serializers.get(1, update.typeId()).writeTo(update, output);
            } else {
                output.writeEntry(update);
            }
            byArray = output.array();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new CatalogMarshallerException(t);
            }
        }
        output.close();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UpdateLogEvent unmarshall(byte[] bytes) {
        try (CatalogObjectDataInput input = new CatalogObjectDataInput(this.serializers, bytes);){
            short protoVersion = input.readShort();
            switch (protoVersion) {
                case 1: {
                    short typeId = input.readShort();
                    UpdateLogEvent updateLogEvent = (UpdateLogEvent)this.serializers.get(1, typeId).readFrom(input);
                    return updateLogEvent;
                }
                case 2: {
                    UpdateLogEvent updateLogEvent = (UpdateLogEvent)input.readEntry();
                    return updateLogEvent;
                }
            }
            throw new IllegalStateException(IgniteStringFormatter.format("An object could not be deserialized because it was using a newer version of the serialization protocol [supported={}, actual={}].", this.protocolVersion, protoVersion));
        }
        catch (Throwable t) {
            throw new CatalogMarshallerException(t);
        }
    }
}

