/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ams;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.RejectedSchedulingRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;

public final class ApplicationMasterServiceUtils {
    private ApplicationMasterServiceUtils() {
    }

    public static void addToUpdateContainerErrors(AllocateResponse allocateResponse, List<UpdateContainerError> updateContainerErrors) {
        if (!updateContainerErrors.isEmpty()) {
            if (allocateResponse.getUpdateErrors() != null && !allocateResponse.getUpdateErrors().isEmpty()) {
                updateContainerErrors.addAll(allocateResponse.getUpdateErrors());
            }
            allocateResponse.setUpdateErrors(updateContainerErrors);
        }
    }

    public static void addToUpdatedContainers(AllocateResponse allocateResponse, ContainerUpdateType updateType, List<Container> updatedContainers) {
        if (updatedContainers != null && updatedContainers.size() > 0) {
            ArrayList<UpdatedContainer> containersToSet = new ArrayList<UpdatedContainer>();
            if (allocateResponse.getUpdatedContainers() != null && !allocateResponse.getUpdatedContainers().isEmpty()) {
                containersToSet.addAll(allocateResponse.getUpdatedContainers());
            }
            for (Container updatedContainer : updatedContainers) {
                containersToSet.add(UpdatedContainer.newInstance(updateType, updatedContainer));
            }
            allocateResponse.setUpdatedContainers(containersToSet);
        }
    }

    public static void addToAllocatedContainers(AllocateResponse allocateResponse, List<Container> allocatedContainers) {
        if (allocateResponse.getAllocatedContainers() != null && !allocateResponse.getAllocatedContainers().isEmpty()) {
            allocatedContainers.addAll(allocateResponse.getAllocatedContainers());
        }
        allocateResponse.setAllocatedContainers(allocatedContainers);
    }

    public static void addToRejectedSchedulingRequests(AllocateResponse allocateResponse, List<RejectedSchedulingRequest> rejectedRequests) {
        if (allocateResponse.getRejectedSchedulingRequests() != null && !allocateResponse.getRejectedSchedulingRequests().isEmpty()) {
            rejectedRequests.addAll(allocateResponse.getRejectedSchedulingRequests());
        }
        allocateResponse.setRejectedSchedulingRequests(rejectedRequests);
    }
}

