/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.policybuilder.iam.IamValue;
import software.amazon.awssdk.policybuilder.iam.internal.DefaultIamConditionOperator;

@SdkPublicApi
@ThreadSafe
public interface IamConditionOperator
extends IamValue {
    public static final IamConditionOperator STRING_EQUALS = IamConditionOperator.create("StringEquals");
    public static final IamConditionOperator STRING_NOT_EQUALS = IamConditionOperator.create("StringNotEquals");
    public static final IamConditionOperator STRING_EQUALS_IGNORE_CASE = IamConditionOperator.create("StringEqualsIgnoreCase");
    public static final IamConditionOperator STRING_NOT_EQUALS_IGNORE_CASE = IamConditionOperator.create("StringNotEqualsIgnoreCase");
    public static final IamConditionOperator STRING_LIKE = IamConditionOperator.create("StringLike");
    public static final IamConditionOperator STRING_NOT_LIKE = IamConditionOperator.create("StringNotLike");
    public static final IamConditionOperator NUMERIC_EQUALS = IamConditionOperator.create("NumericEquals");
    public static final IamConditionOperator NUMERIC_NOT_EQUALS = IamConditionOperator.create("NumericNotEquals");
    public static final IamConditionOperator NUMERIC_LESS_THAN = IamConditionOperator.create("NumericLessThan");
    public static final IamConditionOperator NUMERIC_LESS_THAN_EQUALS = IamConditionOperator.create("NumericLessThanEquals");
    public static final IamConditionOperator NUMERIC_GREATER_THAN = IamConditionOperator.create("NumericGreaterThan");
    public static final IamConditionOperator NUMERIC_GREATER_THAN_EQUALS = IamConditionOperator.create("NumericGreaterThanEquals");
    public static final IamConditionOperator DATE_EQUALS = IamConditionOperator.create("DateEquals");
    public static final IamConditionOperator DATE_NOT_EQUALS = IamConditionOperator.create("DateNotEquals");
    public static final IamConditionOperator DATE_LESS_THAN = IamConditionOperator.create("DateLessThan");
    public static final IamConditionOperator DATE_LESS_THAN_EQUALS = IamConditionOperator.create("DateLessThanEquals");
    public static final IamConditionOperator DATE_GREATER_THAN = IamConditionOperator.create("DateGreaterThan");
    public static final IamConditionOperator DATE_GREATER_THAN_EQUALS = IamConditionOperator.create("DateGreaterThanEquals");
    public static final IamConditionOperator BOOL = IamConditionOperator.create("Bool");
    public static final IamConditionOperator BINARY_EQUALS = IamConditionOperator.create("BinaryEquals");
    public static final IamConditionOperator IP_ADDRESS = IamConditionOperator.create("IpAddress");
    public static final IamConditionOperator NOT_IP_ADDRESS = IamConditionOperator.create("NotIpAddress");
    public static final IamConditionOperator ARN_EQUALS = IamConditionOperator.create("ArnEquals");
    public static final IamConditionOperator ARN_NOT_EQUALS = IamConditionOperator.create("ArnNotEquals");
    public static final IamConditionOperator ARN_LIKE = IamConditionOperator.create("ArnLike");
    public static final IamConditionOperator ARN_NOT_LIKE = IamConditionOperator.create("ArnNotLike");
    public static final IamConditionOperator NULL = IamConditionOperator.create("Null");

    public IamConditionOperator addPrefix(String var1);

    public IamConditionOperator addSuffix(String var1);

    public static IamConditionOperator create(String value) {
        return new DefaultIamConditionOperator(value);
    }
}

