/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.enums.TSDataType;

public class DataTypeFilter
extends SchemaFilter {
    private final TSDataType dataType;

    public DataTypeFilter(TSDataType dataType) {
        this.dataType = dataType;
    }

    public DataTypeFilter(ByteBuffer byteBuffer) {
        this.dataType = TSDataType.deserializeFrom((ByteBuffer)byteBuffer);
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public <C> boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitDataTypeFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.DATA_TYPE;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.dataType.serializeTo(byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.dataType.serializeTo(stream);
    }
}

