/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.InMultiColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class InBinaryMultiColumnTransformer
extends InMultiColumnTransformer {
    private final Set<Binary> constantSet;

    public InBinaryMultiColumnTransformer(Set<Binary> constantSet, List<ColumnTransformer> columnTransformerList) {
        super(columnTransformerList);
        this.constantSet = constantSet;
    }

    @Override
    protected boolean satisfy(List<Column> childrenColumns, int index) {
        Binary value = childrenColumns.get(0).getBinary(index);
        if (this.constantSet.contains(value)) {
            return true;
        }
        int size = childrenColumns.size();
        for (int i = 1; i < size; ++i) {
            Type valueType;
            Column valueColumn = childrenColumns.get(i);
            if (valueColumn.isNull(i) || !value.equals((Object)(valueType = ((ColumnTransformer)this.columnTransformerList.get(i)).getType()).getBinary(valueColumn, index))) continue;
            return true;
        }
        return false;
    }
}

