/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.TypeCompilerFactoryImpl;
import org.apache.derby.shared.common.error.StandardException;

abstract class BaseTypeCompiler
implements TypeCompiler {
    private TypeId correspondingTypeId;

    BaseTypeCompiler() {
    }

    @Override
    public String getPrimitiveMethodName() {
        return null;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2, String string) throws StandardException {
        throw StandardException.newException((String)"42Y95", (Object[])new Object[]{string, dataTypeDescriptor.getTypeId().getSQLTypeName(), dataTypeDescriptor2.getTypeId().getSQLTypeName()});
    }

    @Override
    public void generateNull(MethodBuilder methodBuilder, int n) {
        int n2;
        if (this.pushCollationForDataValue(n)) {
            methodBuilder.push(n);
            n2 = 2;
        } else {
            n2 = 1;
        }
        methodBuilder.callMethod((short)185, null, this.nullMethodName(), this.interfaceName(), n2);
    }

    @Override
    public void generateDataValue(MethodBuilder methodBuilder, int n, LocalField localField) {
        int n2;
        String string = this.interfaceName();
        if (localField == null) {
            methodBuilder.pushNull(string);
        } else {
            methodBuilder.getField(localField);
        }
        if (this.pushCollationForDataValue(n)) {
            methodBuilder.push(n);
            n2 = 3;
        } else {
            n2 = 2;
        }
        methodBuilder.callMethod((short)185, null, this.dataValueMethodName(), string, n2);
        if (localField != null) {
            methodBuilder.putField(localField);
        }
    }

    abstract String nullMethodName();

    String dataValueMethodName() {
        return "getDataValue";
    }

    boolean pushCollationForDataValue(int n) {
        return false;
    }

    protected boolean userTypeStorable(TypeId typeId, TypeId typeId2, ClassFactory classFactory) {
        if (typeId2.userType()) {
            return classFactory.getClassInspector().assignableTo(typeId.getCorrespondingJavaTypeName(), typeId2.getCorrespondingJavaTypeName());
        }
        return false;
    }

    boolean numberConvertible(TypeId typeId, boolean bl) {
        boolean bl2;
        if (typeId.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        if (typeId.isLongConcatableTypeId()) {
            return false;
        }
        boolean bl3 = bl2 = typeId.isNumericTypeId() || typeId.userType();
        if (bl) {
            bl2 = bl2 || typeId.isFixedStringTypeId() && this.getTypeId().isFloatingPointTypeId();
        }
        bl2 = bl2 || typeId.isFixedStringTypeId() && !this.getTypeId().isFloatingPointTypeId();
        return bl2;
    }

    boolean numberStorable(TypeId typeId, TypeId typeId2, ClassFactory classFactory) {
        if (typeId2.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        if (typeId2.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(typeId, typeId2, classFactory);
    }

    protected TypeId getTypeId() {
        return this.correspondingTypeId;
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return TypeCompilerFactoryImpl.staticGetTypeCompiler(typeId);
    }

    void setTypeId(TypeId typeId) {
        this.correspondingTypeId = typeId;
    }

    protected int getStoredFormatIdFromTypeId() {
        return this.getTypeId().getTypeFormatId();
    }
}

